/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.parts;

import ch.dvbern.tax.common.engine.wizarddisplay.DisplayItemUniqueID;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Item;
import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.items.IValueItem;
import ch.dvbern.tax.common.presentation.cd.util.ControlReuseUtil;
import ch.dvbern.tax.common.presentation.cd.util.ScrollingFocusListener;
import ch.dvbern.tax.common.presentation.cd.widgets.BorderedLabel;
import ch.dvbern.tax.common.presentation.cd.widgets.TaxmeButton;
import ch.dvbern.tax.common.presentation.cd.widgets.TaxmeCompositeValue;
import ch.dvbern.tax.common.transfer.dto.OptionItemDTO;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class RadioGroupPart
extends TaxmeCompositeValue {
    private static ScrollingFocusListener focusListener = new ScrollingFocusListener();
    private BorderedLabel text;
    private IValueItem item;
    private final ControlReuseUtil controlReuseUtil = new ControlReuseUtil();
    private final List<FocusListener> focusListeners = new ArrayList<FocusListener>();
    private final List<MouseListener> mouseListeners = new ArrayList<MouseListener>();
    private final List<TaxmeButton> buttons = new ArrayList<TaxmeButton>();

    public RadioGroupPart(@NonNull Composite parent, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Item.Layout layout) {
        super(parent, 0);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        this.setLayoutData(gd);
        this.setLayout((Layout)new RowLayout(layout == Item.Layout.HORIZONTAL ? 256 : 512));
    }

    public void addFocusListener(FocusListener arg0) {
        this.focusListeners.add(arg0);
        for (TaxmeButton b : this.buttons) {
            b.addFocusListener(arg0);
        }
    }

    public void removeFocusListener(FocusListener arg0) {
        this.focusListeners.remove(arg0);
        for (TaxmeButton b : this.buttons) {
            b.removeFocusListener(arg0);
        }
    }

    public void addMouseListener(MouseListener arg0) {
        super.addMouseListener(arg0);
        this.mouseListeners.add(arg0);
        for (TaxmeButton b : this.buttons) {
            b.addMouseListener(arg0);
        }
    }

    public void removeMouseListener(MouseListener arg0) {
        super.addMouseListener(arg0);
        this.mouseListeners.remove(arg0);
        if (this.text != null) {
            this.text.removeMouseListener(arg0);
        }
        for (TaxmeButton b : this.buttons) {
            b.removeMouseListener(arg0);
        }
    }

    @Override
    public void init(IValueItem item) {
        this.item = item;
        GridData gd = (GridData)this.getLayoutData();
        gd.horizontalSpan = item.getColspan();
        this.setBackground(item.getBackgroundColor());
        this.buttons.clear();
        if (item.getStyle() == 1 || item.getStyle() == 3) {
            this.controlReuseUtil.start();
            this.controlReuseUtil.end();
            if (this.text == null) {
                this.text = new BorderedLabel(this, 0);
                this.text.addFocusListener(focusListener);
            }
            this.text.setFont(item.getFont());
            this.text.setText(item.getRenderedValue());
            this.text.setBackground(item.getBackgroundColor());
            this.text.setForeground(item.getForegroundColor());
        } else {
            if (this.text != null) {
                this.text.dispose();
                this.text = null;
            }
            Locale locale = TaxmeController.getInstance().getLocale();
            LinkedHashMap options = item.getOptionItems().getOptionItemsForLocale(locale);
            this.controlReuseUtil.start();
            for (OptionItemDTO optionItemDTO : options.values()) {
                DisplayItemUniqueID optionId = new DisplayItemUniqueID(OptionItemDTO.class.getSimpleName(), String.valueOf(optionItemDTO.getValue()));
                TaxmeButton button = (TaxmeButton)this.controlReuseUtil.getControl(optionId);
                if (button == null) {
                    button = new TaxmeButton(this, 16);
                    this.controlReuseUtil.addControl(optionId, (Control)button);
                    RadioButtonListener li = new RadioButtonListener(button);
                    button.addSelectionListener(li);
                    button.addFocusListener(focusListener);
                    for (FocusListener fli : this.focusListeners) {
                        button.addFocusListener(fli);
                    }
                    for (MouseListener mli : this.mouseListeners) {
                        button.addMouseListener(mli);
                    }
                }
                String translated = null;
                translated = optionItemDTO.isResourceKey() ? Messages.configurableTranslate(optionItemDTO.getText().toString(), (Control)button, new Object[0]) : optionItemDTO.getText().toString();
                button.setText(translated);
                button.setSelection(optionItemDTO.getValue().equals(item.getValue()));
                button.setEnabled(item.getStyle() != 2);
                button.setData(optionItemDTO);
                button.setBackground(item.getBackgroundColor());
                button.setForeground(item.getForegroundColor());
                button.setFont(item.getFont());
                this.buttons.add(button);
            }
            this.controlReuseUtil.end();
        }
    }

    public boolean setFocus() {
        WizardDisplayInfoDTO.ItemItemDTO item = (WizardDisplayInfoDTO.ItemItemDTO)this.getData();
        if (item != null && item.getValue() != null) {
            return super.setFocus();
        }
        return false;
    }

    @Override
    public void makeGuiEditable() {
    }

    private class RadioButtonListener
    implements SelectionListener {
        private final TaxmeButton button;

        public RadioButtonListener(TaxmeButton button) {
            this.button = button;
        }

        public void widgetSelected(SelectionEvent ev) {
            OptionItemDTO value = (OptionItemDTO)this.button.getData();
            if (value.getValue() != null) {
                if (!value.getValue().equals(RadioGroupPart.this.item.getValue())) {
                    RadioGroupPart.this.item.update(value.getValue().toString());
                }
            } else if (RadioGroupPart.this.item.getValue() != null) {
                RadioGroupPart.this.item.update(null);
            }
        }

        public void widgetDefaultSelected(SelectionEvent ev) {
        }
    }
}

