/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.items.expert;

import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.action.ValidateAction;
import ch.dvbern.tax.common.presentation.cd.items.IValueItem;
import ch.dvbern.tax.common.presentation.cd.items.expert.ETableCell;
import ch.dvbern.tax.common.presentation.cd.util.OsSupport;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.MessageItemDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.swt.graphics.Color;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EValueCell
extends ETableCell<ExpertDisplayInfoDTO.TableDTO.ValueCellDTO>
implements IValueItem {
    private static final Logger LOG = LoggerFactory.getLogger(EValueCell.class);
    private final ExpertDisplayInfoDTO.TableDTO.ValueCellDTO cell;
    private final ExpertDisplayInfoDTO.TableDTO.ColumnDTO col;
    private int style;
    private int state;

    public EValueCell(ExpertDisplayInfoDTO.TableDTO.ValueCellDTO cell, ExpertDisplayInfoDTO.TableDTO.ColumnDTO col, float zoom, ExpertDisplayInfoDTO.TableDTO.RowDTO row) {
        super(cell, col, zoom, row);
        this.cell = cell;
        this.col = col;
        ModelItemDTO mi = cell.getModelItem();
        this.style = 0;
        if (col.isReadonly()) {
            this.style = 1;
        } else if (mi != null) {
            if (mi.getState() == 11) {
                this.style = 2;
            } else if (mi.getState() == 12) {
                this.style = 1;
            }
        }
        this.state = 3;
        if (mi != null) {
            this.state = mi.getState();
        }
    }

    @Override
    public @Nullable Object getValue() {
        ModelItemDTO mi = this.cell.getModelItem();
        if (mi != null) {
            return mi.getValue();
        }
        return null;
    }

    @Override
    public String getRenderedValue() {
        return EValueCell.render(this.getColumn(), this.cell);
    }

    @Override
    public AbstractConverter<?> getRendererAndInputValidator() {
        return this.getColumn().getRendererAndInputValidator();
    }

    @Override
    public int getStyle() {
        return this.style;
    }

    @Override
    public int getState() {
        if (this.cell.getModelItem() != null) {
            return this.cell.getModelItem().getState();
        }
        return 3;
    }

    @Override
    public @Nullable OptionItemsDTO getOptionItems() {
        return this.cell.getOptionItems();
    }

    @Override
    public void setDefaultValue(String value) {
        try {
            Object convertedValue;
            AbstractConverter conv = this.col.getRendererAndInputValidator();
            if (conv != null) {
                TaxmeController ctrl = TaxmeController.getInstance();
                AbstractConverter.ConverterContext ctx = new AbstractConverter.ConverterContext(ctrl.getLocalizationHelper(), ctrl.getTmoCdSession().getDataModel(), this.cell.getDataModelKey());
                convertedValue = conv.getObject(value, this.cell.getOptionItems(), ctx);
            } else {
                convertedValue = value;
            }
            if (this.cell.getModelItem() != null) {
                this.cell.setModelItem(this.cell.getModelItem().clone(convertedValue));
            } else {
                this.cell.setModelItem(new ModelItemDTO(convertedValue));
            }
        }
        catch (AbstractConverter.ConvertException e) {
            LOG.error("Error setting default value: ", (Throwable)e);
        }
    }

    @Override
    public @Nullable Color getBackgroundColor() {
        switch (this.getStyle()) {
            case 1: {
                return this.getColor(this.getColumn().getBackground());
            }
            case 2: {
                return this.getColor(this.getColumn().getBackground());
            }
        }
        switch (this.state) {
            case 4: {
                return RED;
            }
            case 2: {
                return YELLOW;
            }
        }
        return this.getColor(this.getColumn().getBackground());
    }

    @Override
    public void update(String newValue) {
        ValidateAction validateAction = new ValidateAction();
        validateAction.execute(newValue, this.cell, this.getRow(), this.getColumn());
    }

    @Override
    public Collection<MessageItemDTO> getMessages() {
        if (this.cell.getModelItem() != null) {
            return this.cell.getModelItem().getMessages();
        }
        return Collections.emptyList();
    }

    @Override
    public boolean hasBorder() {
        return OsSupport.isLinuxOs() || OsSupport.isMacOs();
    }

    @Override
    public @Nullable String getShortHelpKey() {
        return this.getColumn().getShortHelpKey();
    }

    @Override
    public boolean isDynamicWidth() {
        return true;
    }

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Item.Layout getLayout() {
        return null;
    }

    @Override
    public @NonNull String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append((Object)this.col.getTitle()).append(this.col.getType()).append(this.col.isReadonly()).append((Object)this.cell.getDataModelKey()).append((Object)this.cell.getModelItem()).build();
    }
}

