/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.help.model;

import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.help.event.IModelChangedListener;
import ch.dvbern.tax.common.presentation.cd.help.model.IHelpTopic;
import java.util.ArrayList;
import java.util.List;

public class HelpItem
implements IHelpTopic {
    private String id = null;
    private String nameFR = "";
    private String nameDE = "";
    private String topic = "";
    private final List<HelpItem> items = new ArrayList<HelpItem>();
    private IHelpTopic parent;
    private final ArrayList<IModelChangedListener> listeners = new ArrayList();
    private static final String HELP_DIRECTORY = "webapps/be/tmo-static.war/mainHelp/fr/";

    public HelpItem() {
    }

    public HelpItem(String nameDe, String nameFr, String topic) {
        this();
        this.setNameDE(nameDe);
        this.setNameFR(nameFr);
        this.setTopic(topic);
    }

    public HelpItem(String id, String nameDe, String nameFr, String topic) {
        this();
        this.setId(id);
        this.setNameDE(nameDe);
        this.setNameFR(nameFr);
        this.setTopic(topic);
    }

    public String getNameDE() {
        return this.nameDE;
    }

    public void setNameDE(String nameDE) {
        this.nameDE = nameDE;
    }

    public String getNameFR() {
        return this.nameFR;
    }

    public void setNameFR(String nameFR) {
        this.nameFR = nameFR;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String pTopic) {
        if (pTopic == null) {
            throw new NullPointerException("topic field cannot be null");
        }
        String oldTopic = this.topic;
        this.topic = pTopic;
        this.fireModelChanged("topic", oldTopic, pTopic);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getHTMLPath() {
        return HELP_DIRECTORY + this.topic;
    }

    public void addItem(HelpItem item) {
        this.items.add(item);
        this.fireModelChanged("add");
    }

    @Override
    public List<HelpItem> getItems() {
        return this.items;
    }

    public String getName() {
        String name = TaxmeController.getInstance().getLanguage().equals("fr") ? this.getNameFR() : this.getNameDE();
        return name != null ? name : "";
    }

    public void setName(String name) {
        String oldName = this.getName();
        if (TaxmeController.getInstance().getLanguage().equals("fr")) {
            this.setNameFR(name);
        } else {
            this.setNameDE(name);
        }
        this.fireModelChanged("name", oldName, this.getName());
    }

    public String getHelpDirectory() {
        return HELP_DIRECTORY;
    }

    public void addModelChangedListener(IModelChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeModelChangedListener(IModelChangedListener listener) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            if (this.listeners.get(i) != listener) continue;
            this.listeners.remove(listener);
        }
    }

    private void fireModelChanged(String property, String oldValue, String newValue) {
        if (!(oldValue == newValue || oldValue != null && oldValue.equals(newValue))) {
            for (IModelChangedListener listener : this.listeners) {
                listener.refreshView(this, property);
            }
        }
    }

    private void fireModelChanged(String action) {
        for (IModelChangedListener listener : this.listeners) {
            listener.refreshView(this, action);
        }
    }

    @Override
    public IHelpTopic getParent() {
        return this.parent;
    }

    public void setParent(IHelpTopic parent) {
        this.parent = parent;
    }

    public void moveUp() {
        List<HelpItem> itemsCommonToParent = this.getParent().getItems();
        for (int i = 0; i < itemsCommonToParent.size(); ++i) {
            if (!itemsCommonToParent.get(i).equals(this) || i <= 0) continue;
            itemsCommonToParent.add(i - 1, itemsCommonToParent.get(i));
            itemsCommonToParent.remove(i + 1);
            this.fireModelChanged("move");
            return;
        }
    }

    public void moveDown() {
        List<HelpItem> itemsCommonToParent = this.getParent().getItems();
        for (int i = 0; i < itemsCommonToParent.size(); ++i) {
            if (!itemsCommonToParent.get(i).equals(this) || itemsCommonToParent.size() - i <= 1) continue;
            HelpItem itemToMoveDown = itemsCommonToParent.get(i);
            itemsCommonToParent.remove(i);
            itemsCommonToParent.add(i + 1, itemToMoveDown);
            this.fireModelChanged("move");
            return;
        }
    }

    public void delete() {
        List<HelpItem> itemsCommonToParent = this.getParent().getItems();
        for (int i = 0; i < itemsCommonToParent.size(); ++i) {
            if (!itemsCommonToParent.get(i).equals(this)) continue;
            itemsCommonToParent.remove(i);
            this.fireModelChanged("delete");
            return;
        }
    }

    public void newSubRoot(HelpItem item) {
        this.addItem(item);
    }
}

