/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.dialog;

import ch.dvbern.lib.update.OsUtil;
import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.dialog.TaxmeTitleAreaDialog;
import ch.dvbern.tax.common.presentation.cd.util.DialogUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SetApplicationPathDialog
extends TaxmeTitleAreaDialog {
    public static final String TITLE_KEY = "label.dialog.setapplicationpath.title";
    public static final String CUSTOM_APPLICATION_KEY = "label.dialog.setapplicationpath.custom";
    public static final String DEFAULT_APPLICATION_KEY = "label.dialog.setapplicationpath.default";
    public static final String MESSAGE_KEY = "label.dialog.setapplicationpath.msg";
    private final String applicationTitle;
    private volatile String path;
    private volatile boolean useCustomApplication;
    private Button customApplicationRadio;
    private Button browseBtn;
    private Text fileNameTxt;

    public SetApplicationPathDialog(Shell shell, String applicationTitle, boolean useCustomApplication, String path) {
        super(shell);
        if (applicationTitle == null) {
            throw new NullPointerException("Application title cannot be null");
        }
        if (path == null) {
            path = "";
        }
        this.applicationTitle = applicationTitle;
        this.path = path;
        this.useCustomApplication = useCustomApplication;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isUseCustomApplication() {
        return this.useCustomApplication;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setSize(600, 300);
        newShell.setText(Messages.configurableTranslate(TITLE_KEY, new Object[0]));
        if (TaxmeConfig.getBoolean("centerPopups")) {
            newShell.setBounds(0, 0, 600, 300);
            DialogUtil.centerInCurrentMonitor(newShell);
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(this.applicationTitle);
        this.setMessage(Messages.configurableTranslate(MESSAGE_KEY, new Object[0]));
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        GridData gridData = new GridData(1808);
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)gridData);
        Group selGroup = new Group(panel, 4);
        selGroup.setLayoutData((Object)gridData);
        selGroup.setLayout((Layout)new GridLayout(2, false));
        selGroup.setText(this.applicationTitle);
        Button defaultApplicationRadio = new Button((Composite)selGroup, 16);
        defaultApplicationRadio.setText(Messages.configurableTranslate(DEFAULT_APPLICATION_KEY, new Object[0]));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        defaultApplicationRadio.setLayoutData((Object)gridData);
        defaultApplicationRadio.setSelection(!this.useCustomApplication);
        defaultApplicationRadio.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent evt) {
                SetApplicationPathDialog.this.refreshContentState();
                SetApplicationPathDialog.this.refreshButtonBarState();
            }

            public void widgetDefaultSelected(SelectionEvent evt) {
                this.widgetSelected(evt);
            }
        });
        this.customApplicationRadio = new Button((Composite)selGroup, 16);
        this.customApplicationRadio.setText(Messages.configurableTranslate(CUSTOM_APPLICATION_KEY, new Object[0]));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.customApplicationRadio.setLayoutData((Object)gridData);
        this.customApplicationRadio.setSelection(this.useCustomApplication);
        this.fileNameTxt = new Text((Composite)selGroup, 2056);
        this.fileNameTxt.setText(this.path);
        gridData = new GridData();
        gridData.widthHint = 400;
        this.fileNameTxt.setLayoutData((Object)gridData);
        this.browseBtn = new Button((Composite)selGroup, 8);
        this.browseBtn.setText(Messages.configurableTranslate("label.button.browse", new Object[0]));
        this.browseBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent evt) {
                SetApplicationPathDialog.this.showBrowseDialog();
            }

            public void widgetDefaultSelected(SelectionEvent evt) {
                this.widgetSelected(evt);
            }
        });
        this.refreshContentState();
        return panel;
    }

    private void refreshContentState() {
        boolean customControlsEnabled = this.customApplicationRadio != null && this.customApplicationRadio.getSelection();
        this.browseBtn.setEnabled(customControlsEnabled);
        this.fileNameTxt.setEnabled(customControlsEnabled);
        this.useCustomApplication = customControlsEnabled;
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, Messages.configurableTranslate("label.button.ok", new Object[0]), true);
        this.createButton(parent, 1, Messages.configurableTranslate("label.button.cancel", new Object[0]), false);
        this.refreshButtonBarState();
    }

    private void refreshButtonBarState() {
        boolean okBtnEnabled = !this.useCustomApplication || !this.fileNameTxt.getText().isEmpty();
        Button okBtn = this.getButton(0);
        if (okBtn != null) {
            okBtn.setEnabled(okBtnEnabled);
        }
    }

    private void showBrowseDialog() {
        String[] stringArray;
        FileDialog dlg = new FileDialog(this.getShell());
        dlg.setText(this.applicationTitle);
        if (OsUtil.isOsWindows()) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "*.exe";
            stringArray = stringArray2;
            stringArray2[1] = "*.*";
        } else {
            stringArray = null;
        }
        String[] filterExt = stringArray;
        dlg.setFilterExtensions(filterExt);
        String newPath = dlg.open();
        if (newPath != null) {
            this.fileNameTxt.setText(newPath);
            this.path = newPath;
        }
        this.refreshButtonBarState();
    }
}

