/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.dialog;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.dialog.TaxmeTitleAreaDialog;
import ch.dvbern.tax.common.presentation.cd.util.DialogUtil;
import ch.dvbern.tax.common.presentation.cd.widgets.TaxmeButton;
import ch.dvbern.tax.common.presentation.common.util.TaxFile;
import ch.dvbern.tax.common.presentation.common.util.TaxFileAttachment;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DossierDialog
extends TaxmeTitleAreaDialog {
    private static final Logger LOG = LoggerFactory.getLogger(DossierDialog.class);
    private TaxFile taxFile;

    public DossierDialog(Shell parentShell) {
        super(parentShell);
    }

    public void setTaxFile(TaxFile taxFile) {
        this.taxFile = taxFile;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.configurableTranslate("title.dialog.dossier", new Object[0]));
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.configurableTranslate("title.dialog.dossier", new Object[0]));
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        this.getShell().setLayout((Layout)layout);
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(1808));
        GridData data = new GridData(32);
        data.widthHint = 500;
        data.heightHint = 100;
        final TableViewer tbv = new TableViewer(panel, 67600);
        tbv.getTable().setLayoutData((Object)data);
        tbv.setContentProvider((IContentProvider)new MyContentProvider());
        tbv.setLabelProvider((IBaseLabelProvider)new MyLabelProvider());
        TableColumn column = new TableColumn(tbv.getTable(), 16384);
        column.setText(Messages.configurableTranslate("table.dialog.dossier.name", new Object[0]));
        column.setWidth(200);
        column = new TableColumn(tbv.getTable(), 131072);
        column.setText(Messages.configurableTranslate("table.dialog.dossier.size", new Object[0]));
        column.setWidth(100);
        column = new TableColumn(tbv.getTable(), 16384);
        column.setText(Messages.configurableTranslate("table.dialog.dossier.comment", new Object[0]));
        column.setWidth(200);
        tbv.setInput(this.retrieveAttachments());
        tbv.getTable().setHeaderVisible(true);
        Composite composite = new Composite((Composite)this.getShell(), 0);
        data = new GridData(32);
        composite.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.numColumns = 5;
        layout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)layout);
        data = new GridData(1808);
        final TaxmeButton buttonOpen = new TaxmeButton(composite, 0);
        buttonOpen.setLayoutData(data);
        data = new GridData(1808);
        TaxmeButton buttonInsert = new TaxmeButton(composite, 0);
        buttonInsert.setLayoutData(data);
        data = new GridData(1808);
        final TaxmeButton buttonDelete = new TaxmeButton(composite, 0);
        buttonDelete.setLayoutData(data);
        data = new GridData(1808);
        final TaxmeButton buttonComment = new TaxmeButton(composite, 0);
        buttonComment.setLayoutData(data);
        data = new GridData(1808);
        TaxmeButton buttonClose = new TaxmeButton(composite, 0);
        buttonClose.setLayoutData(data);
        tbv.getTable().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                buttonDelete.setEnabled(true);
                buttonOpen.setEnabled(true);
                buttonComment.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        buttonOpen.setText(Messages.configurableTranslate("button.dialog.dossier.open", new Object[0]));
        buttonOpen.setEnabled(false);
        buttonOpen.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                String selectedFilePath;
                try {
                    selectedFilePath = DossierDialog.this.taxFile.getAttachmentFile(((TaxFileAttachment)tbv.getElementAt(tbv.getTable().getSelectionIndex())).getFileName()).getAbsolutePath();
                }
                catch (IOException e) {
                    LOG.error("Cannot retrieve path to selected file", (Throwable)e);
                    return;
                }
                Program.launch((String)selectedFilePath);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        buttonInsert.setText(Messages.configurableTranslate("button.dialog.dossier.insert", new Object[0]));
        buttonInsert.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog dialogInsert = new FileDialog(DossierDialog.this.getShell(), 4096);
                String fileName = dialogInsert.open();
                if (fileName != null) {
                    try {
                        DossierDialog.this.taxFile.putAttachmentFile(new File(fileName), "");
                    }
                    catch (IOException e) {
                        LOG.error("Failed to put attachment in tax file", (Throwable)e);
                    }
                    tbv.setInput(DossierDialog.this.retrieveAttachments());
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        buttonDelete.setText(Messages.configurableTranslate("button.dialog.dossier.delete", new Object[0]));
        buttonDelete.setEnabled(false);
        buttonDelete.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                int answer = DialogUtil.showYesNoCancelDialog("message.dialog.dossier.delete", new Object[0]);
                if (answer == 0) {
                    try {
                        DossierDialog.this.taxFile.removeAttachment(((TaxFileAttachment)tbv.getElementAt(tbv.getTable().getSelectionIndex())).getFileName());
                    }
                    catch (IOException e) {
                        LOG.error("Failed to delete attachment from tax file", (Throwable)e);
                    }
                    buttonDelete.setEnabled(false);
                    buttonOpen.setEnabled(false);
                    buttonComment.setEnabled(false);
                    tbv.setInput(DossierDialog.this.retrieveAttachments());
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        buttonComment.setText(Messages.configurableTranslate("button.dialog.dossier.add", new Object[0]));
        buttonComment.setEnabled(false);
        buttonComment.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                final Shell commentDialog = new Shell(DossierDialog.this.getShell(), 112);
                DossierDialog.this.configureShell(commentDialog);
                commentDialog.setLayout((Layout)new GridLayout(1, true));
                commentDialog.setSize(500, 160);
                commentDialog.setText(Messages.configurableTranslate("title.dialog.dossier.comment", new Object[0]));
                Label title = new Label((Composite)commentDialog, 0);
                title.setText(Messages.configurableTranslate("title.dialog.dossier.comment", new Object[0]));
                final Text comment = new Text((Composite)commentDialog, 2064);
                final TaxFileAttachment fileToOpen = (TaxFileAttachment)tbv.getElementAt(tbv.getTable().getSelectionIndex());
                Composite composite = new Composite((Composite)commentDialog, 0);
                GridData data = new GridData(32);
                data.heightHint = 50;
                data.widthHint = 450;
                composite.setLayoutData((Object)data);
                if (fileToOpen.getComment() != null) {
                    comment.setText(fileToOpen.getComment());
                } else {
                    comment.setText(Messages.configurableTranslate("text.dialog.dossier.comment", new Object[0]));
                }
                comment.setLayoutData((Object)data);
                GridLayout layout = new GridLayout(2, true);
                composite.setLayout((Layout)layout);
                data = new GridData(32);
                TaxmeButton buttonYes = new TaxmeButton(composite, 0);
                buttonYes.setLayoutData(data);
                data = new GridData(32);
                TaxmeButton buttonNo = new TaxmeButton(composite, 0);
                buttonNo.setLayoutData(data);
                buttonYes.setText(Messages.configurableTranslate("button.dialog.dossier.yes", new Object[0]));
                buttonNo.setText(Messages.configurableTranslate("button.dialog.dossier.no", new Object[0]));
                commentDialog.open();
                buttonYes.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent event) {
                        try {
                            DossierDialog.this.taxFile.setComment(fileToOpen.getFileName(), comment.getText());
                        }
                        catch (IOException e) {
                            LOG.error("Failed to set comment on tax file", (Throwable)e);
                        }
                        commentDialog.close();
                        buttonOpen.setEnabled(false);
                        buttonComment.setEnabled(false);
                        buttonDelete.setEnabled(false);
                        tbv.setInput(DossierDialog.this.retrieveAttachments());
                    }

                    public void widgetDefaultSelected(SelectionEvent event) {
                    }
                });
                buttonNo.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent event) {
                        buttonOpen.setEnabled(false);
                        buttonComment.setEnabled(false);
                        buttonDelete.setEnabled(false);
                        commentDialog.close();
                    }

                    public void widgetDefaultSelected(SelectionEvent event) {
                    }
                });
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        buttonClose.setText(Messages.configurableTranslate("button.dialog.dossier.close", new Object[0]));
        buttonClose.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                DossierDialog.this.getShell().close();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        return panel;
    }

    private List<TaxFileAttachment> retrieveAttachments() {
        List attachments;
        try {
            attachments = this.taxFile.getAttachments();
        }
        catch (IOException e) {
            LOG.error("Failed to read tax file attachment assume empty", (Throwable)e);
            attachments = Collections.emptyList();
        }
        return attachments;
    }

    protected Control createButtonBar(Composite control) {
        return null;
    }

    public static class MyLabelProvider
    implements ITableLabelProvider {
        public String getColumnText(Object element, int columnIndex) {
            TaxFileAttachment myFile = (TaxFileAttachment)element;
            if (columnIndex == 0) {
                return myFile.getFileName();
            }
            if (columnIndex == 1) {
                return myFile.getSize() / 1024L + " KB";
            }
            if (columnIndex == 2) {
                return myFile.getComment();
            }
            return "";
        }

        public void addListener(ILabelProviderListener ilabelproviderlistener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object obj, String s) {
            return false;
        }

        public void removeListener(ILabelProviderListener ilabelproviderlistener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }

    public static class FileTableContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object element) {
            File[] kids = null;
            kids = ((File)element).listFiles();
            return kids == null ? new Object[]{} : kids;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldObject, Object newObject) {
        }
    }

    public static class MyContentProvider
    implements IStructuredContentProvider {
        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object file) {
            return ((List)file).toArray();
        }
    }
}

