/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.dialog;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.dialog.TaxmeTitleAreaDialog;
import ch.dvbern.tax.common.presentation.cd.widgets.TaxmeButton;
import java.net.PasswordAuthentication;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AuthenticationDialog
extends TaxmeTitleAreaDialog {
    private Text textUsername;
    private Text textPassword;
    private TaxmeButton buttonSave;
    private boolean saveSelected;
    private PasswordAuthentication auth;

    public AuthenticationDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.configurableTranslate("title.proxy.auth", new Object[0]));
    }

    public void create() {
        super.create();
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.configurableTranslate("title.proxy.auth", new Object[0]));
        this.setMessage(Messages.configurableTranslate("label.proxy.auth.message", new Object[0]));
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(1808));
        panel.setFont(parent.getFont());
        Label labelUsername = new Label(panel, 0);
        labelUsername.setText(Messages.configurableTranslate("label.proxy.auth.user", (Control)labelUsername, new Object[0]));
        this.textUsername = new Text(panel, 2048);
        this.textUsername.setLayoutData((Object)new GridData(768));
        this.textUsername.setFocus();
        if (this.auth != null) {
            this.textUsername.setText(this.auth.getUserName());
        }
        Label labelPassword = new Label(panel, 0);
        labelPassword.setText(Messages.configurableTranslate("label.proxy.auth.password", (Control)labelPassword, new Object[0]));
        this.textPassword = new Text(panel, 2048);
        this.textPassword.setEchoChar('*');
        this.textPassword.setLayoutData((Object)new GridData(768));
        if (this.auth != null) {
            this.textPassword.setText(new String(this.auth.getPassword()));
        }
        this.buttonSave = new TaxmeButton(panel, 32);
        this.buttonSave.setText(Messages.configurableTranslate("label.proxy.auth.save", (Control)this.buttonSave, new Object[0]));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.buttonSave.setLayoutData(gd);
        this.buttonSave.setSelection(this.saveSelected);
        return panel;
    }

    protected void okPressed() {
        this.auth = new PasswordAuthentication(this.textUsername.getText(), this.textPassword.getText().toCharArray());
        this.saveSelected = this.buttonSave.getSelection();
        this.close();
    }

    public PasswordAuthentication getAuthentication() {
        return this.auth;
    }

    public void setAuthentication(PasswordAuthentication auth) {
        this.auth = auth;
    }

    public boolean isSaveSelected() {
        return this.saveSelected;
    }

    public void setSaveSelected(boolean saveSelected) {
        this.saveSelected = saveSelected;
    }
}

