/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.action.menu;

import ch.dvbern.tax.common.presentation.cd.LayoutMode;
import ch.dvbern.tax.common.presentation.cd.Taxme;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.action.ActionBase;
import ch.dvbern.tax.common.presentation.cd.widgets.TaxmeCompositeManager;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ChangeLayoutAction
extends ActionBase {
    private final TaxmeCompositeManager compositeManager;
    private @NonNull LayoutMode mode;

    public ChangeLayoutAction(@NonNull String name, @Nullable String iconName, @NonNull TaxmeCompositeManager compositeManager, @NonNull LayoutMode mode) {
        super(name, null, iconName, 8);
        if (compositeManager == null) {
            throw new NullPointerException("Composite manager cannot be null.");
        }
        this.compositeManager = compositeManager;
        this.mode = mode;
    }

    public void run() {
        TaxmeController ctrl = TaxmeController.getInstance();
        if (!this.isChecked() || ctrl.getApp().getCompositeManager() == this.compositeManager) {
            return;
        }
        Taxme taxme = ctrl.getApp();
        taxme.saveConfiguration();
        taxme.setCompositeManager(this.compositeManager);
        taxme.rebuild();
        ctrl.refresh(true);
        TaxmeConfig.setValue("use.layout.horizontal", this.mode.isHorizontalLayout());
    }
}

