/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.action;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.action.ActionBase;
import ch.dvbern.tax.common.presentation.cd.items.IButtonItem;
import ch.dvbern.tax.common.presentation.cd.util.ButtonCommand;
import org.eclipse.swt.program.Program;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ButtonOpenLinkAction
extends ActionBase
implements ButtonCommand {
    private static final Logger LOG = LoggerFactory.getLogger(ButtonOpenLinkAction.class);
    private final String url;
    private boolean translate = false;

    public ButtonOpenLinkAction(String url) {
        super("button.open.link", null, "icon.link.www");
        this.url = url;
    }

    public ButtonOpenLinkAction(String url, boolean translate) {
        super("button.open.link", null, "icon.link.www");
        this.translate = translate;
        this.url = url;
    }

    public ButtonOpenLinkAction(String name, String url, String icon, boolean translate) {
        super(name, null, icon);
        this.translate = translate;
        this.url = url;
    }

    public void run() {
        this.doAction();
    }

    @Override
    public void execute(IButtonItem buttonDTO) {
        this.doAction();
    }

    @Override
    public void init(IButtonItem buttonDTO) {
    }

    public void doAction() {
        try {
            Program.launch((String)this.getUrl());
        }
        catch (Exception e) {
            LOG.error("Error on launching URL " + this.getUrl() + ": ", (Throwable)e);
        }
    }

    private String getUrl() {
        if (this.translate) {
            return Messages.configurableTranslate(this.url, new Object[0]);
        }
        return this.url;
    }
}

