/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.action;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import ch.dvbern.tax.common.presentation.cd.util.OsSupport;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;

public abstract class ActionBase
extends Action {
    private static final Pattern CTRL_PATTERN = Pattern.compile("Ctrl");
    private final @NonNull String name;

    protected ActionBase(String name) {
        this(name, null, null);
    }

    protected ActionBase(@NonNull String name, @Nullable String shortcut, @Nullable String iconName) {
        this(name, shortcut, iconName, 0);
    }

    protected ActionBase(@NonNull String name, @Nullable String shortcut, @Nullable String iconName, int style) {
        super(null, style);
        this.name = name;
        if (shortcut != null && !shortcut.isEmpty()) {
            if (OsSupport.isMacOs()) {
                shortcut = CTRL_PATTERN.matcher(shortcut).replaceAll("Command");
            }
            this.setAccelerator(ActionBase.convertAccelerator((String)shortcut));
        }
        if (iconName != null) {
            ImageRegistry imReg = GuiUtil.getImageRegistry();
            this.setImageDescriptor(imReg.getDescriptor(iconName));
            ImageDescriptor disabled = imReg.getDescriptor(iconName + ".disabled");
            if (disabled != null) {
                this.setDisabledImageDescriptor(disabled);
            }
        }
    }

    public String getNlsKey() {
        return this.name;
    }

    public String getText() {
        return Messages.configurableTranslate(this.name, new Object[0]);
    }

    public String getToolTipText() {
        return this.getText();
    }

    public void run(Object sourceData) {
        this.run();
    }

    public @NonNull String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

