/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd;

import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.util.BrowserNotSupportedException;
import ch.dvbern.tax.common.presentation.cd.util.BrowserUtil;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import ch.dvbern.tax.common.presentation.cd.util.OsSupport;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaxmeAboutWindow
extends Window {
    private static final Logger LOG = LoggerFactory.getLogger(TaxmeAboutWindow.class);

    public TaxmeAboutWindow() {
        super(Display.getCurrent().getActiveShell());
        if (!OsSupport.isMacOs()) {
            TaxmeAboutWindow.setDefaultImage((Image)GuiUtil.getImageRegistry().get("icon.window.about"));
        }
        this.setShellStyle(64);
    }

    protected void initializeBounds() {
        this.getShell().setText(this.readVersionFromVersionfile());
        this.getShell().setBounds(TaxmeConfig.getInt("window.about.bounds.x"), TaxmeConfig.getInt("window.about.bounds.y"), TaxmeConfig.getInt("window.about.bounds.width"), TaxmeConfig.getInt("window.about.bounds.height"));
    }

    private String readVersionFromVersionfile() {
        return TaxmeConfig.getApplicationVersion();
    }

    protected Control createContents(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        try {
            Browser browser = BrowserUtil.createBrowser(parent);
            browser.setUrl(TaxmeConfig.getAboutFilePath());
        }
        catch (BrowserNotSupportedException e) {
            LOG.error("Error creating contents: ", (Throwable)e);
        }
        return parent;
    }
}

