/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd;

import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.presentation.bd.cd.UndoRedoSnapshot;
import ch.dvbern.tax.common.presentation.cd.LayoutMode;
import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.action.ActionRegistry;
import ch.dvbern.tax.common.presentation.cd.action.DocumentAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.ChangeLayoutAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.FileExitAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.FileHistoryOpenAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.FontSizeContributionItem;
import ch.dvbern.tax.common.presentation.cd.action.menu.HelpAboutAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.HelpShorthelpAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.UtilSelectLanguageAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.UtilSetFontSizeAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.ViewSelectModeAction;
import ch.dvbern.tax.common.presentation.cd.help.model.HelpItem;
import ch.dvbern.tax.common.presentation.cd.help.model.HelpRoot;
import ch.dvbern.tax.common.presentation.cd.parts.HelpPart;
import ch.dvbern.tax.common.presentation.cd.resourcetools.IToolCommunicationGui;
import ch.dvbern.tax.common.presentation.cd.resourcetools.action.ToolEditOnMainHelpAction;
import ch.dvbern.tax.common.presentation.cd.resourcetools.action.ToolEditOnShortHelpAction;
import ch.dvbern.tax.common.presentation.cd.resourcetools.action.ToolHelpMappingAction;
import ch.dvbern.tax.common.presentation.cd.resourcetools.action.ToolHtmlEditorSetAction;
import ch.dvbern.tax.common.presentation.cd.util.BrowserNotSupportedException;
import ch.dvbern.tax.common.presentation.cd.util.BrowserUtil;
import ch.dvbern.tax.common.presentation.cd.util.DialogUtil;
import ch.dvbern.tax.common.presentation.cd.util.FileHistory;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import ch.dvbern.tax.common.presentation.cd.util.OsSupport;
import ch.dvbern.tax.common.presentation.cd.widgets.ClassicCompositeManager;
import ch.dvbern.tax.common.presentation.cd.widgets.HorizontalCompositeManager;
import ch.dvbern.tax.common.presentation.cd.widgets.TaxmeCompositeManager;
import ch.dvbern.tax.common.presentation.common.Mode;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.ServiceLoader;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.CoolBarManager;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Taxme
extends ApplicationWindow
implements IToolCommunicationGui,
UndoRedoSnapshot.UndoRedoStateListener {
    private static final Logger LOG = LoggerFactory.getLogger(Taxme.class);
    public static final String SYSPROP_MODELRELOAD_ENABLED = "model.reload.enabled";
    public static final String SYSPROP_MODELRELOAD_BASEDIR = "model.reload.basedir";
    public static final String SYSPROP_MODELRELOAD_XMLCONF_PATHRELATIVE = "model.reload.xmlconf.pathrelative";
    public static final String BROWSER_ACTION_KEY = "menu.browser.path";
    public static final String BROWSER_PATH_KEY = "browser.path";
    public static final String USE_BROWSER_PATH_KEY = "browser.path.use";
    public static final String SET_BROWSER_TITLE = "label.dialog.setapplicationpath.browser";
    public static final String PDF_READER_ACTION_KEY = "menu.acroread.path";
    public static final String PDF_READER_PATH_KEY = "acroread.path";
    public static final String USE_PDF_READER_PATH_KEY = "acroread.path.use";
    public static final String APPLICATION_ICON_PATH_KEY = "app.icon.path";
    private static final int APPPLICATION_ICON_MIN_DEPTH = 24;
    public static final String SET_PDF_READER_TITLE = "label.dialog.setapplicationpath.acroread";
    public static final String ENABLE_LAYOUT_CHANGE = "window.enable.layout.change";
    private final boolean enableLayoutChange = TaxmeConfig.getBoolean("window.enable.layout.change");
    public static final String USE_LAYOUT_HORIZONTAL = "use.layout.horizontal";
    public static final String WINDOW_BOUNDS = "window.bounds.";
    public static final String SHORTHELP_SHOW = "shorthelp.show.";
    private final boolean useHorizontalLayout = TaxmeConfig.getBoolean("use.layout.horizontal");
    private Mode mode = null;
    private boolean modeSelectionEnabled = false;
    private Browser welcome = null;
    private final Action fileNewAction = ActionRegistry.getInstance().getAction("new");
    private final Action fileOpenAction = ActionRegistry.getInstance().getAction("open");
    private final Action fileImportAction = ActionRegistry.getInstance().getAction("import");
    private final Action fileCloseAction = ActionRegistry.getInstance().getAction("close");
    private final Action fileSaveAction = ActionRegistry.getInstance().getAction("save");
    private final Action fileSaveAsAction = ActionRegistry.getInstance().getAction("save.as");
    private final Action filePrintAction = ActionRegistry.getInstance().getAction("print");
    private final Action fileChangePasswordAction = ActionRegistry.getInstance().getAction("change.pwd");
    private final Action fileDossierAction = ActionRegistry.getInstance().getAction("change.dossier");
    private final Action editUndoAction = ActionRegistry.getInstance().getAction("edit.undo");
    private final Action editRedoAction = ActionRegistry.getInstance().getAction("edit.redo");
    private final ViewSelectModeAction viewExpertModeAction = (ViewSelectModeAction)ActionRegistry.getInstance().getAction("view.expert");
    private final ViewSelectModeAction viewWizardModeAction = (ViewSelectModeAction)ActionRegistry.getInstance().getAction("view.wizard");
    private final Action utilWindowResizeAction = ActionRegistry.getInstance().getAction("windows.resize");
    private final Action utilUpdateAction = ActionRegistry.getInstance().getAction("util.update");
    private final Action utilValorAction = ActionRegistry.getInstance().getAction("util.valor");
    private final Action utilSetAcroreadPathAction = ActionRegistry.getInstance().getAction("util.acroread.path");
    private final Action utilsetBrowserPathAction = ActionRegistry.getInstance().getAction("util.browser.path");
    private final UtilSetFontSizeAction largeFontsAction = (UtilSetFontSizeAction)ActionRegistry.getInstance().getAction("large.fonts");
    private final UtilSetFontSizeAction smallFontsAction = (UtilSetFontSizeAction)ActionRegistry.getInstance().getAction("small.fonts");
    private final Action utilProxySettingsAction = ActionRegistry.getInstance().getAction("proxy.settings");
    private final HelpShorthelpAction helpShorthelpAction = (HelpShorthelpAction)ActionRegistry.getInstance().getAction("help.shorthelp");
    private final Action helpMainhelpAction = ActionRegistry.getInstance().getAction("help.mainhelp");
    private final HelpAboutAction helpAboutAction = (HelpAboutAction)ActionRegistry.getInstance().getAction("help.about");
    private final Action reloadModelAction = ActionRegistry.getInstance().getAction("reload.model");
    private final Action saveGuiEditAction = ActionRegistry.getInstance().getAction("save.gui.edit");
    private final Action uploadAction = ActionRegistry.getInstance().getAction("upload");
    private final ChangeLayoutAction classicLayoutAction = new ChangeLayoutAction("menu.layout.classic", "icon.menu.layout.classic", new ClassicCompositeManager(), LayoutMode.VERTICAL);
    private final ChangeLayoutAction horizontalLayoutAction = new ChangeLayoutAction("menu.layout.horizontal", "icon.menu.layout.horizontal", new HorizontalCompositeManager(), LayoutMode.HORIZONTAL);
    private final MenuManager menuFile = new MenuManager(Messages.configurableTranslate("menu.file", new Object[0]), "menu.file");
    private final MenuManager menuEdit = new MenuManager(Messages.configurableTranslate("menu.edit", new Object[0]), "menu.edit");
    private final MenuManager menuView = new MenuManager(Messages.configurableTranslate("menu.view", new Object[0]), "menu.view");
    private final MenuManager menuViewMode = new MenuManager(Messages.configurableTranslate("menu.view.mode", new Object[0]), "menu.view.mode");
    private final MenuManager menuUtil = new MenuManager(Messages.configurableTranslate("menu.util", new Object[0]), "menu.util");
    private final MenuManager menuLanguage = new MenuManager(Messages.configurableTranslate("menu.util.language", new Object[0]), "menu.util.language");
    private final MenuManager menuFontSize = new MenuManager(Messages.configurableTranslate("menu.util.fontsize", new Object[0]), "menu.util.fontsize");
    private final MenuManager menuHelp = new MenuManager(Messages.configurableTranslate("menu.help", new Object[0]), "menu.help");
    private final MenuManager menuDocuments = new MenuManager(Messages.configurableTranslate("label.menu.documents", new Object[0]), "label.menu.documents");
    private final MenuManager menuLaws = new MenuManager(Messages.configurableTranslate("label.menu.law", new Object[0]), "label.menu.law");
    private final LinkedHashMap<String, MenuManager> menuCustom = new LinkedHashMap();
    private final List<ActionContributionItem> fileHistoryItems = new LinkedList<ActionContributionItem>();
    private final Separator fileExitSepartor = new Separator();
    private final ActionContributionItem fileExitItem = new ActionContributionItem((IAction)new FileExitAction());
    private final List<UtilSelectLanguageAction> languageActions = new ArrayList<UtilSelectLanguageAction>();
    private static Constructor<? extends Taxme> defaultImplConstr;
    private TaxmeCompositeManager compositeManager = this.useHorizontalLayout ? new HorizontalCompositeManager() : new ClassicCompositeManager();

    protected Taxme() {
        super(null);
    }

    public static synchronized Taxme newInstance() {
        Taxme taxmeWindow = null;
        Throwable error = null;
        try {
            ServiceLoader<Taxme> load = ServiceLoader.load(Taxme.class);
            Iterator<Taxme> iter = load.iterator();
            taxmeWindow = iter.hasNext() ? iter.next() : defaultImplConstr.newInstance(new Object[0]);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            error = cause;
        }
        catch (IllegalAccessException | InstantiationException e) {
            error = e;
        }
        if (error != null) {
            throw new IllegalStateException("Instantiation of the application window failed.", error);
        }
        assert (taxmeWindow != null);
        taxmeWindow.init();
        return taxmeWindow;
    }

    public static synchronized void setImplementation(Class<? extends Taxme> impl) {
        if (impl == null) {
            throw new NullPointerException("Default implementation cannot be null");
        }
        if (Modifier.isAbstract(impl.getModifiers())) {
            throw new IllegalArgumentException("Implementation require a concrete class");
        }
        try {
            defaultImplConstr = impl.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Implementation must have a zero-arg constructor", e);
        }
    }

    protected void init() {
        this.mode = TaxmeController.getInstance().getMode();
        this.modeSelectionEnabled = TaxmeConfig.isExpertModeEnabled() && TaxmeConfig.isWizardModeEnabled();
        this.addMenuBar();
        this.addCoolBar(0);
        this.addStatusLine();
        if (!OsSupport.isMacOs()) {
            Image[] imgs;
            block11: {
                imgs = null;
                ImageRegistry imgRegistry = GuiUtil.getImageRegistry();
                String appIconPath = TaxmeConfig.getString(APPLICATION_ICON_PATH_KEY);
                if (appIconPath != null && !appIconPath.isEmpty()) {
                    ImageLoader loader = new ImageLoader();
                    Display display = Display.getCurrent();
                    try {
                        ImageData[] imgsData = loader.load(appIconPath);
                        ArrayList<Image> imgsList = new ArrayList<Image>();
                        int imgIndex = 0;
                        for (ImageData imgData : imgsData) {
                            if (imgData.depth < 24) {
                                LOG.debug("Ignoring icon with insufficient depth {}x{}x{}", new Object[]{imgData.width, imgData.height, imgData.depth});
                                continue;
                            }
                            LOG.debug("Loaded icon {}x{}x{}", new Object[]{imgData.width, imgData.height, imgData.depth});
                            Image img = new Image((Device)display, imgData);
                            imgRegistry.put("icon.window.app." + imgIndex++, img);
                            imgsList.add(img);
                        }
                        if (!imgsList.isEmpty()) {
                            imgs = imgsList.toArray(new Image[imgsList.size()]);
                            break block11;
                        }
                        LOG.warn("No image loaded from location {}", (Object)appIconPath);
                    }
                    catch (SWTException e) {
                        LOG.error("Failed to load application icon at location {}", (Object)appIconPath, (Object)e);
                    }
                } else {
                    LOG.debug("No custom application icon path defined");
                }
            }
            if (imgs != null) {
                assert (imgs.length > 0);
                LOG.info("Using provided application icons ({})", (Object)imgs.length);
                Window.setDefaultImages(imgs);
            } else {
                LOG.info("Using default application icon source");
                Window.setDefaultImage((Image)GuiUtil.getImageRegistry().get("icon.window.app"));
            }
        }
    }

    protected void initializeBounds() {
        Rectangle bounds = this.getWindowBounds();
        if (bounds == null) {
            this.getShell().setMaximized(true);
        } else {
            this.getShell().setBounds(bounds);
        }
    }

    public TaxmeCompositeManager getCompositeManager() {
        return this.compositeManager;
    }

    public void setCompositeManager(TaxmeCompositeManager compositeManager) {
        if (compositeManager == null) {
            throw new NullPointerException("Composite manager cannot be null.");
        }
        this.compositeManager.disposeComposites();
        this.compositeManager = compositeManager;
    }

    public int open() {
        this.getMenuBarManager().updateAll(true);
        this.getShell().forceFocus();
        return super.open();
    }

    public void setMenuState() {
        this.viewExpertModeAction.updateChecked();
        this.viewWizardModeAction.updateChecked();
        this.smallFontsAction.updateChecked();
        this.largeFontsAction.updateChecked();
        Iterator<UtilSelectLanguageAction> iterator = this.languageActions.iterator();
        while (iterator.hasNext()) {
            UtilSelectLanguageAction element;
            UtilSelectLanguageAction action = element = iterator.next();
            action.updateChecked();
        }
        boolean hasContent = TaxmeController.getInstance().isDeclarationOpen();
        this.fileCloseAction.setEnabled(hasContent);
        this.filePrintAction.setEnabled(hasContent);
        this.fileSaveAction.setEnabled(hasContent);
        this.fileSaveAsAction.setEnabled(hasContent);
        this.fileChangePasswordAction.setEnabled(hasContent);
        this.setModeActionsState();
        this.editRedoAction.setEnabled(hasContent);
        this.editUndoAction.setEnabled(hasContent);
        this.helpShorthelpAction.setEnabled(hasContent);
        this.classicLayoutAction.setEnabled(hasContent && this.helpShorthelpAction.isChecked());
        this.horizontalLayoutAction.setEnabled(hasContent && this.helpShorthelpAction.isChecked());
        if (this.fileDossierAction != null) {
            this.fileDossierAction.setEnabled(hasContent);
        }
        if (this.uploadAction != null) {
            this.uploadAction.setEnabled(hasContent);
        }
    }

    public void setModeActionsState() {
        boolean hasContent = TaxmeController.getInstance().isDeclarationOpen();
        boolean inWizardLink = TaxmeController.getInstance().isInWizardLink();
        boolean expertEnabled = TaxmeController.getInstance().isExpertModeEnabled();
        this.viewExpertModeAction.setEnabled(hasContent && !inWizardLink && expertEnabled);
        this.viewWizardModeAction.setEnabled(hasContent && !inWizardLink);
    }

    protected Control createContents(Composite parent) {
        if (TaxmeController.getInstance().isDeclarationOpen()) {
            this.compositeManager.setupContent(parent);
            this.compositeManager.setExtraPanelVisible(this.helpShorthelpAction.isChecked());
        } else {
            this.createWelcomeContent(parent);
        }
        return parent;
    }

    private void createWelcomeContent(Composite parent) {
        try {
            this.compositeManager.disposeComposites();
            this.welcome = BrowserUtil.createBrowser(parent);
            this.welcome.setUrl(TaxmeConfig.getWelcomeFilePath());
        }
        catch (BrowserNotSupportedException e) {
            LOG.error("Could not create browser: ", (Throwable)e);
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    String msg = OsSupport.isLinuxOs() ? Messages.configurableTranslate("error.browser.linux", new Object[0]) : (OsSupport.isMacOs() ? Messages.configurableTranslate("error.browser.mac", new Object[0]) : Messages.configurableTranslate("error.browser.general", new Object[0]));
                    DialogUtil.showWarningDialog(msg, new Object[0]);
                }
            });
        }
    }

    protected MenuManager createMenuManager() {
        DocumentAction documentAction;
        ActionRegistry actionRegistry;
        int langCnt;
        boolean proxyEnabled;
        this.setMenuState();
        MenuManager menuBar = new MenuManager();
        this.createFileMenu(menuBar);
        menuBar.add((IContributionItem)this.menuEdit);
        this.menuEdit.add((IAction)this.editUndoAction);
        this.menuEdit.add((IAction)this.editRedoAction);
        if (this.modeSelectionEnabled) {
            menuBar.add((IContributionItem)this.menuView);
            this.menuView.add((IContributionItem)this.menuViewMode);
            this.menuViewMode.add((IAction)this.viewWizardModeAction);
            this.menuViewMode.add((IAction)this.viewExpertModeAction);
        }
        this.menuUtil.add((IContributionItem)new GroupMarker("utils.main"));
        boolean standardResize = true;
        if (TaxmeConfig.getString("windows.show.resize.standard") != null) {
            standardResize = TaxmeConfig.getBoolean("windows.show.resize.standard");
        }
        if (standardResize) {
            this.menuUtil.add((IAction)this.utilWindowResizeAction);
        }
        boolean updateEnabled = TaxmeConfig.getString("update.server") != null;
        boolean bl = proxyEnabled = updateEnabled || TaxmeConfig.getBoolean("proxy.enabled");
        if (updateEnabled) {
            this.menuUtil.add((IAction)this.utilUpdateAction);
            if (TaxmeConfig.getBoolean("window.show.update.valor.menu")) {
                this.menuUtil.add((IAction)this.utilValorAction);
            }
        }
        this.menuUtil.add((IContributionItem)new GroupMarker("utils.config"));
        if (!this.menuUtil.isEmpty()) {
            this.menuUtil.add((IContributionItem)new Separator());
        }
        this.menuUtil.add((IAction)this.utilSetAcroreadPathAction);
        if (OsSupport.isLinuxOs() && !TaxmeConfig.getBoolean("window.show.fontsize.menu")) {
            this.menuUtil.add((IContributionItem)new Separator());
            this.menuFontSize.add((IAction)this.smallFontsAction);
            this.menuFontSize.add((IAction)this.largeFontsAction);
            this.menuUtil.add((IContributionItem)this.menuFontSize);
            this.menuUtil.add((IContributionItem)new Separator());
        }
        if (TaxmeConfig.getBoolean("window.show.setbrowserpath.menu")) {
            this.menuUtil.add((IAction)this.utilsetBrowserPathAction);
        }
        if ((langCnt = TaxmeConfig.getInt("language.count")) > 1) {
            this.menuUtil.add((IContributionItem)this.menuLanguage);
            for (int i = 0; i < langCnt; ++i) {
                Iterator<Object> lang = new Locale(TaxmeConfig.getString("language." + i));
                String key = "menu.util.language." + ((Locale)((Object)lang)).getLanguage().toLowerCase();
                UtilSelectLanguageAction selAction = new UtilSelectLanguageAction(key, (Locale)((Object)lang));
                this.languageActions.add(selAction);
                this.menuLanguage.add((IAction)selAction);
            }
        }
        if (proxyEnabled) {
            this.menuUtil.add((IAction)this.utilProxySettingsAction);
        }
        if ((actionRegistry = ActionRegistry.getInstance()).getAction("treuhand") != null) {
            this.menuUtil.add((IContributionItem)new Separator());
            this.menuUtil.add((IAction)actionRegistry.getAction("treuhand"));
        }
        if (this.menuUtil.getItems() != null && this.menuUtil.getItems().length > 0) {
            menuBar.add((IContributionItem)this.menuUtil);
        }
        for (Action action : actionRegistry.getLawActions()) {
            documentAction = (DocumentAction)action;
            this.menuLaws.add((IAction)documentAction);
        }
        if (this.menuLaws.getItems() != null && this.menuLaws.getItems().length > 0) {
            menuBar.add((IContributionItem)this.menuLaws);
        }
        for (Action action : actionRegistry.getDocumentActions()) {
            documentAction = (DocumentAction)action;
            this.menuDocuments.add((IAction)documentAction);
        }
        if (this.menuDocuments.getItems() != null && this.menuDocuments.getItems().length > 0) {
            menuBar.add((IContributionItem)this.menuDocuments);
        }
        for (String customMenuId : actionRegistry.getCustomMenus()) {
            MenuManager menu = new MenuManager(Messages.configurableTranslate(customMenuId, new Object[0]), customMenuId);
            for (Action action : actionRegistry.getCustomMenuActions(customMenuId)) {
                menu.add((IAction)action);
            }
            this.menuCustom.put(customMenuId, menu);
            if (menu.getItems() == null || menu.getItems().length <= 0) continue;
            menuBar.add((IContributionItem)menu);
        }
        this.createHelpMenu(menuBar);
        String sToolsEnabled = TaxmeConfig.getString("ToolsEnabled");
        if ("true".equals(sToolsEnabled)) {
            MenuManager menuTools = new MenuManager(Messages.configurableTranslate("menu.tools", new Object[0]), "menu.tools");
            menuBar.add((IContributionItem)menuTools);
            menuTools.add((IAction)new ToolHelpMappingAction(this));
            menuTools.add((IAction)new ToolEditOnMainHelpAction(this));
            menuTools.add((IAction)new ToolEditOnShortHelpAction(this));
            menuTools.add((IAction)new ToolHtmlEditorSetAction(this));
        }
        return menuBar;
    }

    private void createFileMenu(MenuManager menuBar) {
        menuBar.add((IContributionItem)this.menuFile);
        this.menuFile.add((IAction)this.fileNewAction);
        this.menuFile.add((IAction)this.fileOpenAction);
        if (TaxmeConfig.getBoolean("window.show.import.menu")) {
            this.menuFile.add((IAction)this.fileImportAction);
        }
        this.menuFile.add((IAction)this.fileCloseAction);
        this.menuFile.add((IContributionItem)new Separator());
        this.menuFile.add((IAction)this.fileSaveAction);
        this.menuFile.add((IAction)this.fileSaveAsAction);
        this.menuFile.add((IContributionItem)new Separator());
        if (TaxmeConfig.getBoolean("window.show.print")) {
            this.menuFile.add((IAction)this.filePrintAction);
        }
        this.menuFile.add((IContributionItem)new Separator());
        this.menuFile.add((IContributionItem)new Separator());
        if (TaxmeConfig.getBoolean("window.show.dossier.menu")) {
            this.menuFile.add((IAction)this.fileDossierAction);
            this.menuFile.add((IContributionItem)new Separator());
        }
        this.menuFile.add((IContributionItem)this.fileExitSepartor);
        this.menuFile.add((IContributionItem)this.fileExitItem);
    }

    protected void createHelpMenu(MenuManager menuBar) {
        menuBar.add((IContributionItem)this.menuHelp);
        this.helpShorthelpAction.setChecked(true);
        this.menuHelp.add((IAction)this.helpShorthelpAction);
        if (this.helpMainhelpAction != null) {
            this.menuHelp.add((IContributionItem)new Separator());
            this.menuHelp.add((IAction)this.helpMainhelpAction);
        }
        this.menuHelp.add((IContributionItem)new Separator());
        this.menuHelp.add((IAction)this.helpAboutAction);
    }

    public void setFileHistory(FileHistory history) {
        this.refreshFileHistory(history);
        history.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                if (o instanceof FileHistory) {
                    Taxme.this.refreshFileHistory((FileHistory)o);
                }
            }
        });
    }

    public void rebuild() {
        this.saveConfiguration();
        this.mode = TaxmeController.getInstance().getMode();
        if (this.welcome != null) {
            this.welcome.dispose();
            this.welcome = null;
        }
        Shell parent = this.getShell();
        this.createContents((Composite)parent);
        parent.layout();
        this.initializeBounds();
        this.setMenuState();
    }

    void refreshFileHistory(FileHistory history) {
        for (ActionContributionItem element : this.fileHistoryItems) {
            this.menuFile.remove((IContributionItem)element);
        }
        this.menuFile.remove((IContributionItem)this.fileExitSepartor);
        this.menuFile.remove((IContributionItem)this.fileExitItem);
        this.fileHistoryItems.clear();
        Iterator<File> it = history.entries();
        while (it.hasNext()) {
            File file = it.next();
            FileHistoryOpenAction action = new FileHistoryOpenAction(file);
            ActionContributionItem item = new ActionContributionItem((IAction)action);
            this.menuFile.add((IContributionItem)item);
            this.fileHistoryItems.add(item);
        }
        this.menuFile.add((IContributionItem)this.fileExitSepartor);
        this.menuFile.add((IContributionItem)this.fileExitItem);
    }

    protected StatusLineManager createStatusLineManager() {
        return new StatusLineManager();
    }

    protected CoolBarManager createCoolBarManager(int style) {
        CoolBarManager coolBarManager = new CoolBarManager(style);
        coolBarManager.add((IToolBarManager)this.createToolBarManager(0x800040));
        return coolBarManager;
    }

    protected ToolBarManager createToolBarManager(int style) {
        ToolBarManager tbm = new ToolBarManager(style);
        ActionRegistry actionRegistry = ActionRegistry.getInstance();
        tbm.add((IAction)this.fileNewAction);
        tbm.add((IAction)this.fileOpenAction);
        if (TaxmeConfig.getBoolean("window.show.import")) {
            tbm.add((IAction)this.fileImportAction);
        }
        tbm.add((IAction)this.fileSaveAction);
        tbm.add((IAction)this.fileCloseAction);
        tbm.add((IContributionItem)new Separator());
        if (TaxmeConfig.getBoolean("window.show.print")) {
            tbm.add((IAction)this.filePrintAction);
        }
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this.editUndoAction);
        tbm.add((IAction)this.editRedoAction);
        if (this.modeSelectionEnabled) {
            tbm.add((IContributionItem)new Separator());
            tbm.add((IAction)this.viewWizardModeAction);
            tbm.add((IAction)this.viewExpertModeAction);
        }
        tbm.add((IContributionItem)new Separator());
        if (TaxmeConfig.getBoolean("window.show.dossier")) {
            tbm.add((IAction)this.fileDossierAction);
            tbm.add((IContributionItem)new Separator());
        }
        tbm.add((IAction)this.helpShorthelpAction);
        if (this.enableLayoutChange) {
            tbm.add((IContributionItem)new GroupMarker("start"));
            tbm.add((IAction)this.horizontalLayoutAction);
            tbm.add((IAction)this.classicLayoutAction);
            tbm.add((IContributionItem)new GroupMarker("end"));
            actionRegistry.addChangeLayoutAction(this.classicLayoutAction);
            actionRegistry.addChangeLayoutAction(this.horizontalLayoutAction);
            if (this.useHorizontalLayout) {
                this.horizontalLayoutAction.setChecked(true);
            } else {
                this.classicLayoutAction.setChecked(true);
            }
        }
        if (this.reloadModelAction != null) {
            tbm.add((IAction)this.reloadModelAction);
        }
        if (this.saveGuiEditAction != null) {
            tbm.add((IAction)this.saveGuiEditAction);
        }
        if (TaxmeConfig.getBoolean("window.show.fontsize.menu")) {
            tbm.add((IContributionItem)new Separator());
            tbm.add((IContributionItem)new FontSizeContributionItem());
        }
        if (actionRegistry.getAction("link.www") != null) {
            tbm.add((IAction)actionRegistry.getAction("link.www"));
        }
        if (actionRegistry.getAction("upload") != null) {
            tbm.add((IContributionItem)new Separator());
            tbm.add((IAction)actionRegistry.getAction("upload"));
        }
        return tbm;
    }

    protected boolean canHandleShellCloseEvent() {
        return false;
    }

    public void saveConfiguration() {
        if (this.getShell() != null && !this.getShell().isDisposed()) {
            if (this.getShell().getMaximized()) {
                this.saveWindowBounds(null);
            } else {
                this.saveWindowBounds(this.getShell().getBounds());
            }
        }
        this.compositeManager.saveConfiguration();
        TaxmeConfig.setValue(SHORTHELP_SHOW + String.valueOf(this.mode), Boolean.toString(this.helpShorthelpAction.isChecked()));
    }

    @Override
    public @Nullable Map<?, ?> toolGetAllNlsErrorMessages() {
        return null;
    }

    @Override
    public @Nullable List<?> toolGetAvailableLanguages() {
        return null;
    }

    @Override
    public @Nullable String toolGetCurrentFullHTMLFileName() {
        HelpPart hp = this.getCompositeManager().getHelpPart();
        if (hp != null) {
            return hp.getHtmlUrl();
        }
        return null;
    }

    @Override
    public String toolGetCurrentLanguage() {
        return TaxmeController.getInstance().getLanguage();
    }

    @Override
    public @Nullable String toolGetCurrentMainHelpDirectory() {
        return TaxmeConfig.getMainhelpDir();
    }

    @Override
    public String toolGetCurrentMainHelpFileName() {
        String value;
        if (!TaxmeConfig.isWizardModeEnabled()) {
            return "";
        }
        WizardDisplayInfoDTO wizardDisplayInfoDTO = TaxmeController.getInstance().getWizardDisplayInfoDTO();
        List children = wizardDisplayInfoDTO.getFormItemDTO().getChildren();
        Iterator it = children.iterator();
        boolean hasSection = false;
        while (it.hasNext()) {
            String value2;
            Object obj = it.next();
            if (!(obj instanceof WizardDisplayInfoDTO.SectionItemDTO)) continue;
            hasSection = true;
            WizardDisplayInfoDTO.HelpItemDTO helpItemDTO = ((WizardDisplayInfoDTO.SectionItemDTO)obj).getHelp();
            if (helpItemDTO == null || (value2 = Messages.configurableTranslate(helpItemDTO.getId(), new Object[0])).substring(1, value2.length() - 1).equals(helpItemDTO.getId())) continue;
            return Messages.configurableTranslate(helpItemDTO.getId(), new Object[0]);
        }
        if (hasSection) {
            return "";
        }
        String mainHelpName = this.toolGetCurrentMainHelpName();
        if (!mainHelpName.isEmpty() && !(value = Messages.configurableTranslate(mainHelpName, new Object[0])).substring(1, value.length() - 1).equals(mainHelpName)) {
            return value;
        }
        return "";
    }

    @Override
    public String toolGetCurrentMainHelpName() {
        if (!TaxmeConfig.isWizardModeEnabled()) {
            return "";
        }
        WizardDisplayInfoDTO wizardDisplayInfoDTO = TaxmeController.getInstance().getWizardDisplayInfoDTO();
        return "manual." + EngineUtil.removeTableIndices((String)wizardDisplayInfoDTO.getThisKey());
    }

    @Override
    public @Nullable List<?> toolGetCurrentScreenErrorIds() {
        return null;
    }

    @Override
    public String toolGetCurrentScreenName() {
        Mode configuredMode = TaxmeController.getInstance().getMode();
        String key = "";
        if (configuredMode == Mode.WIZARD) {
            LOG.debug("Selected Navigation DTO = {}", (Object)TaxmeController.getInstance().getWizardDisplayInfoDTO().getNavigationDTO().getThisKey());
            key = TaxmeController.getInstance().getWizardDisplayInfoDTO().getFormItemDTO().getName();
        } else if (configuredMode == Mode.EXPERT) {
            key = TaxmeController.getInstance().getExpertDisplayInfoDTO().getName();
        }
        return key;
    }

    @Override
    public String toolGetCurrentShortHelpDirectory() {
        return TaxmeConfig.getShorthelpDir();
    }

    @Override
    public String toolGetCurrentShortHelpFileName() {
        TaxmeController ctrl = TaxmeController.getInstance();
        Mode configuredMode = ctrl.getMode();
        String key = "";
        if (configuredMode == Mode.WIZARD) {
            WizardDisplayInfoDTO wizardDisplayInfoDTO = ctrl.getWizardDisplayInfoDTO();
            key = wizardDisplayInfoDTO.getFormItemDTO().getName();
        } else if (configuredMode == Mode.EXPERT) {
            ExpertDisplayInfoDTO expertDisplayInfoDTO = ctrl.getExpertDisplayInfoDTO();
            key = expertDisplayInfoDTO.getName();
        }
        String helpPath = ctrl.getShortHelpMapping().get(key);
        return helpPath != null ? helpPath : "";
    }

    @Override
    public String toolGetCurrentShortHelpFileNameOnField(String sKey) {
        String helpPath = TaxmeController.getInstance().getShortHelpMapping().get(sKey);
        return helpPath != null ? helpPath : "";
    }

    @Override
    public String toolGetFullHtmlEditorName() {
        return TaxmeConfig.getString("ToolHtmlEditorName");
    }

    @Override
    public @Nullable List<?> toolGetGuiModelAsVector(String sFileName) {
        return null;
    }

    @Override
    public @Nullable HashMap<?, ?> toolGetGuiModelConfigEntries() {
        return null;
    }

    @Override
    public @Nullable HelpRoot toolGetMainHelpIndexModel() {
        return null;
    }

    @Override
    public @Nullable HelpRoot toolGetMainHelpModel() {
        return null;
    }

    @Override
    public @Nullable List<?> toolGetNavigationFromFile() {
        return null;
    }

    @Override
    public @Nullable HashMap<?, ?> toolGetNavigationNls() {
        return null;
    }

    @Override
    public boolean toolIsErrorsWarningsEnabled() {
        return false;
    }

    @Override
    public boolean toolIsGuiModelsEnabled() {
        return false;
    }

    @Override
    public boolean toolIsHelpIndexEnabled() {
        return false;
    }

    @Override
    public boolean toolIsHelpMappingEnabled() {
        String sShortHelpEnabled = TaxmeConfig.getString("ToolEditHelpMappingEnabled");
        return "true".equals(sShortHelpEnabled);
    }

    @Override
    public boolean toolIsHelpTreestructureEnabled() {
        return false;
    }

    @Override
    public boolean toolIsHtmlEditOnMainHelpEnabled() {
        return true;
    }

    @Override
    public boolean toolIsHtmlEditOnMainPanelHelpEnabled() {
        String sMainPanelHelpEnabled = TaxmeConfig.getString("ToolEditMainPanelHelpEnabled");
        return "true".equals(sMainPanelHelpEnabled);
    }

    @Override
    public boolean toolIsHtmlEditOnShortHelpEnabled() {
        String sShortHelpEnabled = TaxmeConfig.getString("ToolEditShortHelpEnabled");
        return "true".equals(sShortHelpEnabled);
    }

    @Override
    public boolean toolIsMainNavigationEnabled() {
        return false;
    }

    @Override
    public void toolRefreshCurrentHTML() {
        HelpPart hp = this.getCompositeManager().getHelpPart();
        if (hp != null) {
            hp.refresh();
        }
        this.getShell().forceFocus();
    }

    @Override
    public void toolRefreshErrorsWarnings() {
    }

    @Override
    public void toolRefreshGuiModels() {
    }

    @Override
    public void toolRefreshHelpMappings() {
        TaxmeController.getInstance().update();
    }

    @Override
    public void toolRefreshNavigation() {
    }

    @Override
    public void toolRefreshTreeSructures() {
    }

    @Override
    public void toolSaveAllNlsErrorMessages(Map allNlsErrorMessages) {
    }

    @Override
    public void toolSaveGuiModelFromVector(List vGuiModel, String sFileName) {
    }

    @Override
    public void toolSaveHelpMapping(String mainHelp, String shortHelp) {
    }

    @Override
    public void toolSaveHtmlEditorName(String sFile) {
        TaxmeConfig.setValue("ToolHtmlEditorName", sFile);
        TaxmeConfig.store();
    }

    @Override
    public void toolSaveMainHelpIndexTree(HelpItem root) {
    }

    @Override
    public void toolSaveMainHelpTrees(HelpItem root) {
    }

    @Override
    public void toolSaveNavigationNls(HashMap navigationNls) {
    }

    @Override
    public Shell getCallBackShell() {
        return this.getShell();
    }

    public @Nullable Browser getWelcome() {
        return this.welcome;
    }

    public MenuManager getMenuHelp() {
        return this.menuHelp;
    }

    public HelpShorthelpAction getHelpShorthelpAction() {
        return this.helpShorthelpAction;
    }

    public HelpAboutAction getHelpAboutAction() {
        return this.helpAboutAction;
    }

    private void saveWindowBounds(@Nullable Rectangle windowBounds) {
        if (windowBounds == null) {
            windowBounds = new Rectangle(0, 0, 0, 0);
        }
        TaxmeConfig.setValue(WINDOW_BOUNDS + String.valueOf(this.mode) + ".x", windowBounds.x);
        TaxmeConfig.setValue(WINDOW_BOUNDS + String.valueOf(this.mode) + ".y", windowBounds.y);
        TaxmeConfig.setValue(WINDOW_BOUNDS + String.valueOf(this.mode) + ".width", windowBounds.width);
        TaxmeConfig.setValue(WINDOW_BOUNDS + String.valueOf(this.mode) + ".height", windowBounds.height);
    }

    private @Nullable Rectangle getWindowBounds() {
        if (TaxmeConfig.getInt(WINDOW_BOUNDS + String.valueOf(this.mode) + ".width") == 0) {
            return null;
        }
        Rectangle rect = new Rectangle(TaxmeConfig.getInt(WINDOW_BOUNDS + String.valueOf(this.mode) + ".x"), TaxmeConfig.getInt(WINDOW_BOUNDS + String.valueOf(this.mode) + ".y"), TaxmeConfig.getInt(WINDOW_BOUNDS + String.valueOf(this.mode) + ".width"), TaxmeConfig.getInt(WINDOW_BOUNDS + String.valueOf(this.mode) + ".height"));
        if (OsSupport.isMacOs()) {
            rect.y = rect.y < 22 ? 22 : rect.y;
        }
        return rect;
    }

    public void resizeToDefault() {
        TaxmeConfig.remove(WINDOW_BOUNDS + String.valueOf(this.mode) + ".x");
        TaxmeConfig.remove(WINDOW_BOUNDS + String.valueOf(this.mode) + ".y");
        TaxmeConfig.remove(WINDOW_BOUNDS + String.valueOf(this.mode) + ".width");
        TaxmeConfig.remove(WINDOW_BOUNDS + String.valueOf(this.mode) + ".height");
        TaxmeConfig.remove(SHORTHELP_SHOW + String.valueOf(this.mode));
        this.initializeBounds();
        this.compositeManager.resizeToDefault();
        if (TaxmeController.getInstance().isDeclarationOpen()) {
            this.helpShorthelpAction.setChecked(true);
        }
    }

    @Override
    public void undoRedoStateChanged(boolean isUndoable, boolean isRedoable) {
        this.editUndoAction.setEnabled(isUndoable);
        this.editRedoAction.setEnabled(isRedoable);
    }

    static {
        try {
            Taxme.setImplementation(Taxme.class);
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError("Failed to register default application window implementation.", e);
        }
    }
}

