/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jboss.classfilewriter.ClassFile;
import org.jboss.classfilewriter.ClassMethod;
import org.jboss.classfilewriter.DuplicateMemberException;
import org.jboss.classfilewriter.code.CodeAttribute;
import org.jboss.classfilewriter.util.Boxing;
import org.jboss.classfilewriter.util.DescriptorUtils;
import org.jboss.weld.annotated.enhanced.MethodSignature;
import org.jboss.weld.annotated.enhanced.jlr.MethodSignatureImpl;
import org.jboss.weld.bean.proxy.CommonProxiedMethodFilters;
import org.jboss.weld.bean.proxy.InterceptedSubclassFactory;
import org.jboss.weld.bean.proxy.InterceptionDecorationContext;
import org.jboss.weld.bean.proxy.MethodHandler;
import org.jboss.weld.bean.proxy.ProxyFactory;
import org.jboss.weld.bean.proxy.StackAwareMethodHandler;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.security.GetDeclaredMethodsAction;
import org.jboss.weld.util.bytecode.BytecodeUtils;
import org.jboss.weld.util.bytecode.MethodInformation;
import org.jboss.weld.util.bytecode.RuntimeMethodInformation;
import org.jboss.weld.util.reflection.Reflections;

public class InterceptedProxyFactory<T>
extends ProxyFactory<T> {
    public static final String PROXY_SUFFIX = "InterceptedProxy";
    private static final String JAVA_LANG_OBJECT = "java.lang.Object";
    private final Set<MethodSignature> enhancedMethodSignatures;
    private final Set<MethodSignature> interceptedMethodSignatures;
    private final String suffix;
    private final boolean builtFromInterface;
    private Set<Class<?>> interfacesToInspect;

    public InterceptedProxyFactory(String contextId, Class<?> proxiedBeanType, Set<? extends Type> typeClosure, Set<MethodSignature> enhancedMethodSignatures, Set<MethodSignature> interceptedMethodSignatures, String suffix) {
        super(contextId, proxiedBeanType, typeClosure, null);
        this.enhancedMethodSignatures = enhancedMethodSignatures;
        this.interceptedMethodSignatures = interceptedMethodSignatures;
        this.suffix = suffix;
        this.builtFromInterface = proxiedBeanType.isInterface();
    }

    @Override
    protected String getProxyNameSuffix() {
        return PROXY_SUFFIX + this.suffix;
    }

    @Override
    protected void addMethodsFromClass(ClassFile proxyClassType, ClassMethod staticConstructor) {
        block15: {
            try {
                HashSet<MethodSignatureImpl> finalMethods = new HashSet<MethodSignatureImpl>();
                HashSet processedBridgeMethods = new HashSet();
                LinkedHashSet classes = new LinkedHashSet();
                for (Class<?> cls = this.getBeanType(); cls != null; cls = cls.getSuperclass()) {
                    classes.add(cls);
                }
                classes.add(this.getProxiedBeanType());
                for (Class clazz : classes) {
                    HashSet<MethodSignatureImpl> declaredBridgeMethods = new HashSet<MethodSignatureImpl>();
                    Method[] methodArray = AccessController.doPrivileged(new GetDeclaredMethodsAction(clazz));
                    int n = methodArray.length;
                    for (int i = 0; i < n; ++i) {
                        Method method = methodArray[i];
                        MethodSignatureImpl methodSignature = new MethodSignatureImpl(method);
                        if (this.isMethodAccepted(method, this.getProxySuperclass()) && this.enhancedMethodSignatures.contains(methodSignature) && !finalMethods.contains(methodSignature) && !processedBridgeMethods.contains(methodSignature)) {
                            try {
                                RuntimeMethodInformation methodInfo = new RuntimeMethodInformation(method);
                                ClassMethod classMethod = proxyClassType.addMethod(method);
                                if (this.interceptedMethodSignatures.contains(methodSignature)) {
                                    this.createInterceptedMethod(classMethod, methodInfo, method, staticConstructor);
                                    BeanLogger.LOG.addingMethodToProxy(method);
                                    continue;
                                }
                                this.createNotInterceptedMethod(classMethod, methodInfo, method, staticConstructor);
                            }
                            catch (DuplicateMemberException methodInfo) {}
                            continue;
                        }
                        if (Modifier.isFinal(method.getModifiers())) {
                            finalMethods.add(methodSignature);
                        }
                        if (!method.isBridge()) continue;
                        declaredBridgeMethods.add(methodSignature);
                    }
                    processedBridgeMethods.addAll(declaredBridgeMethods);
                }
                if (!this.builtFromInterface) break block15;
                for (Class clazz : this.interfacesToInspect) {
                    for (Method method : clazz.getMethods()) {
                        MethodSignatureImpl signature = new MethodSignatureImpl(method);
                        try {
                            if (this.isMethodAccepted(method, this.getProxySuperclass()) && !processedBridgeMethods.contains(signature)) {
                                RuntimeMethodInformation methodInfo = new RuntimeMethodInformation(method);
                                ClassMethod classMethod = proxyClassType.addMethod(method);
                                this.createNotInterceptedMethod(classMethod, methodInfo, method, staticConstructor);
                                BeanLogger.LOG.addingMethodToProxy(method);
                            }
                        }
                        catch (DuplicateMemberException duplicateMemberException) {
                            // empty catch block
                        }
                        if (!method.isBridge()) continue;
                        processedBridgeMethods.add(signature);
                    }
                }
            }
            catch (Exception e) {
                throw new WeldException(e);
            }
        }
    }

    @Override
    public void addInterfacesFromTypeClosure(Set<? extends Type> typeClosure, Class<?> proxiedBeanType) {
        for (Type type : typeClosure) {
            Class c = Reflections.getRawType(type);
            if (!c.isInterface()) continue;
            this.addInterfaceToInspect(c);
        }
    }

    @Override
    protected boolean isMethodAccepted(Method method, Class<?> proxySuperclass) {
        return super.isMethodAccepted(method, proxySuperclass) && CommonProxiedMethodFilters.NON_PRIVATE.accept(method, proxySuperclass) && !method.isBridge();
    }

    private void createNotInterceptedMethod(ClassMethod classMethod, MethodInformation methodInfo, Method method, ClassMethod staticConstructor) {
        CodeAttribute b = classMethod.getCodeAttribute();
        b.aload(0);
        this.getMethodHandlerField(classMethod.getClassFile(), b);
        b.aload(0);
        DEFAULT_METHOD_RESOLVER.getDeclaredMethod(classMethod, methodInfo.getDeclaringClass(), method.getName(), methodInfo.getParameterTypes(), staticConstructor);
        b.aconstNull();
        b.iconst(method.getParameterTypes().length);
        b.anewarray(JAVA_LANG_OBJECT);
        int localVariableCount = 1;
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            String typeString = methodInfo.getParameterTypes()[i];
            b.dup();
            b.iconst(i);
            BytecodeUtils.addLoadInstruction(b, typeString, localVariableCount);
            Boxing.boxIfNessesary((CodeAttribute)b, (String)typeString);
            b.aastore();
            if (DescriptorUtils.isWide((String)typeString)) {
                localVariableCount += 2;
                continue;
            }
            ++localVariableCount;
        }
        b.invokeinterface(MethodHandler.class.getName(), "invoke", "Ljava/lang/Object;", new String[]{"Ljava/lang/Object;", "Ljava/lang/reflect/Method;", "Ljava/lang/reflect/Method;", "[Ljava/lang/Object;"});
        if (methodInfo.getReturnType().equals("V")) {
            b.returnInstruction();
        } else if (DescriptorUtils.isPrimitive((String)methodInfo.getReturnType())) {
            Boxing.unbox((CodeAttribute)b, (String)classMethod.getReturnType());
            b.returnInstruction();
        } else {
            b.checkcast(BytecodeUtils.getName(methodInfo.getReturnType()));
            b.returnInstruction();
        }
    }

    private void createInterceptedMethod(ClassMethod classMethod, MethodInformation methodInfo, Method method, ClassMethod staticConstructor) {
        CodeAttribute b = classMethod.getCodeAttribute();
        b.aload(0);
        this.getMethodHandlerField(classMethod.getClassFile(), b);
        b.invokestatic(InterceptionDecorationContext.class.getName(), "getStack", "()" + DescriptorUtils.makeDescriptor(InterceptionDecorationContext.Stack.class));
        b.aload(0);
        DEFAULT_METHOD_RESOLVER.getDeclaredMethod(classMethod, methodInfo.getDeclaringClass(), method.getName(), methodInfo.getParameterTypes(), staticConstructor);
        b.dup();
        b.iconst(method.getParameterTypes().length);
        b.anewarray(JAVA_LANG_OBJECT);
        int localVariableCount = 1;
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            String typeString = methodInfo.getParameterTypes()[i];
            b.dup();
            b.iconst(i);
            BytecodeUtils.addLoadInstruction(b, typeString, localVariableCount);
            Boxing.boxIfNessesary((CodeAttribute)b, (String)typeString);
            b.aastore();
            if (DescriptorUtils.isWide((String)typeString)) {
                localVariableCount += 2;
                continue;
            }
            ++localVariableCount;
        }
        b.invokeinterface(StackAwareMethodHandler.class.getName(), "invoke", "Ljava/lang/Object;", InterceptedSubclassFactory.INVOKE_METHOD_PARAMETERS);
        if (methodInfo.getReturnType().equals("V")) {
            b.returnInstruction();
        } else if (DescriptorUtils.isPrimitive((String)methodInfo.getReturnType())) {
            Boxing.unbox((CodeAttribute)b, (String)classMethod.getReturnType());
            b.returnInstruction();
        } else {
            b.checkcast(BytecodeUtils.getName(methodInfo.getReturnType()));
            b.returnInstruction();
        }
    }

    private void addInterfaceToInspect(Class<?> iface) {
        if (this.interfacesToInspect == null) {
            this.interfacesToInspect = new HashSet();
        }
        this.interfacesToInspect.add(iface);
    }
}

