/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.report.ssk;

import ch.ewv.taxstatement.report.TaxStatementReportFormula;
import ch.ewv.taxstatement.report.TaxStatementReportResult;
import ch.ewv.taxstatement.report.TaxStatementReportResultCase;
import ch.ewv.taxstatement.report.TaxStatementReportResultList;
import ch.ewv.taxstatement.report.TaxStatementReportUtil;
import ch.ewv.taxstatement.report.ssk.TaxStatementReportSSKEntity;
import ch.ewv.taxstatement.report.ssk.TaxStatementReportSSKSummaryDetail;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ConditionalFormattingRule;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.PageMargin;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFConditionalFormattingRule;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFSheetConditionalFormatting;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class TaxStatementReportSSKSummary {
    public static final String OF = "OF";
    public static final String PAGE = "PAGE";
    public static final String RESULT_SHEET = "RESULT_SHEET";
    public static final String RESULT_OK = "RESULT_OK";
    public static final String RESULT_ERROR = "RESULT_ERROR";
    public static final String RESULT_SELECT = "RESULT_SELECT";
    public static final String RESULT_TOTAL = "RESULT_TOTAL";
    public static final String RESULT_OVERALL = "RESULT_OVERALL";
    public static final String RESULT_APPROVED = "RESULT_APPROVED";
    public static final String RESULT_NOTAPPROVED = "RESULT_NOTAPPROVED";
    public static final String RESULT_COMMENT = "RESULT_COMMENT";
    public static final String RESULT_DELEGATE = "RESULT_DELEGATE";
    public static final String RESULT_TESTING = "RESULT_TESTING";
    public static final String RESULT_SSK = "RESULT_SSK";
    public static final String RESULT_CASE_BANK_ACCOUNT = "RESULT_CASE_BANK_ACCOUNT";
    public static final String RESULT_CASE_LIABILITY_ACCOUNT = "RESULT_CASE_LIABILITY_ACCOUNT";
    public static final String RESULT_CASE_EXPENSE = "RESULT_CASE_EXPENSE";
    public static final String RESULT_CASE_SHARE = "RESULT_CASE_SHARE";
    public static final String RESULT_CASE_BOND = "RESULT_CASE_BOND";
    public static final String RESULT_CASE_FUND = "RESULT_CASE_FUND";
    public static final String RESULT_CASE_DEVT = "RESULT_CASE_DEVT";
    public static final String RESULT_CASE_MONEY = "RESULT_CASE_MONEY";
    public static final String RESULT_CASE_COINBULL = "RESULT_CASE_COINBULL";
    public static final String RESULT_CASE_SPECIAL = "RESULT_CASE_SPECIAL";
    public static final String SHEET = "SHEET_OVERVIEW";
    public static final String SHEET_SCHEMA = "SHEET_SCHEMA";
    public static final String SHEET_TAX_STATEMENT = "SHEET_TAX_STATEMENT";
    public static final String SHEET_INSTITUTION = "SHEET_INSTITUTION";
    public static final String SHEET_CLIENT = "SHEET_CLIENT";
    public static final String SHEET_BANK_ACCOUNT = "SHEET_BANK_ACCOUNT";
    public static final String SHEET_LIABILITY_ACCOUNT = "SHEET_LIABILITY_ACCOUNT";
    public static final String SHEET_EXPENSE = "SHEET_EXPENSE";
    public static final String SHEET_SECURITY = "SHEET_SECURITY";
    private Font fth;
    private Font fth24;
    private Font fts;
    private Font fts16;
    private Font ftw;
    private CellStyle cshl;
    private CellStyle cshc;
    private CellStyle csh24l;
    private CellStyle csh24c;
    private CellStyle css;
    private CellStyle cssb;
    private CellStyle csswbg;
    private CellStyle csn;
    private CellStyle csnbb;
    private CellStyle csw;

    protected void addResult(Workbook wb, Properties lang, Cell[] cells, String name, int column, List<TaxStatementReportResultCase> cases) {
        int resultOK = 0;
        int resultERROR = 0;
        int resultSELECT = 0;
        if (cases != null) {
            new TaxStatementReportSSKEntity(column).translate(wb, name, lang, cases);
            for (TaxStatementReportResultCase cs : cases) {
                if (cs.getResult() == TaxStatementReportResult.OK) {
                    ++resultOK;
                    continue;
                }
                if (cs.getResult() == TaxStatementReportResult.ERROR || cs.getResult() == TaxStatementReportResult.FATAL || cs.getResult() == TaxStatementReportResult.WARNING) {
                    ++resultERROR;
                    continue;
                }
                if (cs.getResult() != TaxStatementReportResult.SELECT && cs.getResult() != TaxStatementReportResult.IGNORE) continue;
                ++resultSELECT;
            }
            if (cells != null && cells[1] != null) {
                cells[1].setCellValue((double)resultOK);
            }
            if (cells != null && cells[2] != null) {
                cells[2].setCellValue((double)resultERROR);
            }
            if (cells != null && cells[3] != null) {
                cells[3].setCellValue((double)resultSELECT);
            }
        }
    }

    protected void addRowEmpty(Workbook wb) {
        TaxStatementReportUtil.addRow(wb);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
    }

    protected void addRowContentHeader(Workbook wb, Properties lang, String key) {
        TaxStatementReportUtil.addRow(wb);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.cshl, TaxStatementReportUtil.getText(lang, key));
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.getSheet(wb).addMergedRegion(new CellRangeAddress(TaxStatementReportUtil.getNumberOfRows(wb) - 1, TaxStatementReportUtil.getNumberOfRows(wb) - 1, 2, 10));
    }

    protected void addRowContent(Workbook wb, Properties lang, TaxStatementReportResultList result, String key1) {
        this.addRowContent(wb, lang, result, key1, null);
    }

    protected void addRowContent(Workbook wb, Properties lang, TaxStatementReportResultList result, String key1, String key2) {
        if (result != null) {
            TaxStatementReportUtil.addRow(wb);
            TaxStatementReportUtil.addCell(wb, this.css);
            TaxStatementReportUtil.addCell(wb, this.css);
            TaxStatementReportUtil.addCell(wb, this.css, key1 != null ? TaxStatementReportUtil.getText(lang, key1) : (String)null);
            TaxStatementReportUtil.addCell(wb, this.css);
            TaxStatementReportUtil.addCell(wb, this.css);
            TaxStatementReportUtil.addCell(wb, this.csw, key1 != null ? result.getContent(key1) : (String)null);
            TaxStatementReportUtil.addCell(wb, this.css, key2 != null ? TaxStatementReportUtil.getText(lang, key2) : (String)null);
            TaxStatementReportUtil.addCell(wb, this.css);
            TaxStatementReportUtil.addCell(wb, this.css);
            TaxStatementReportUtil.addCell(wb, this.css);
            TaxStatementReportUtil.addCell(wb, this.csw, key2 != null ? result.getContent(key2) : (String)null);
            TaxStatementReportUtil.addCell(wb, this.css);
            TaxStatementReportUtil.addCell(wb, this.css);
            TaxStatementReportUtil.getSheet(wb).addMergedRegion(new CellRangeAddress(TaxStatementReportUtil.getNumberOfRows(wb) - 1, TaxStatementReportUtil.getNumberOfRows(wb) - 1, 2, 4));
            TaxStatementReportUtil.getSheet(wb).addMergedRegion(new CellRangeAddress(TaxStatementReportUtil.getNumberOfRows(wb) - 1, TaxStatementReportUtil.getNumberOfRows(wb) - 1, 6, 9));
        }
    }

    protected void initFont(Workbook wb) {
        this.fth = wb.createFont();
        this.fth24 = wb.createFont();
        this.fts = wb.createFont();
        this.fts16 = wb.createFont();
        this.ftw = wb.createFont();
        this.fth.setFontName("Calibri");
        this.fth.setFontHeightInPoints((short)11);
        this.fth.setBold(true);
        this.fth24.setFontName("Calibri");
        this.fth24.setFontHeightInPoints((short)24);
        this.fth24.setBold(true);
        this.fts.setFontName("Calibri");
        this.fts.setFontHeightInPoints((short)11);
        this.fts16.setFontName("Calibri");
        this.fts16.setFontHeightInPoints((short)16);
        this.ftw.setFontName("Wingdings");
        this.ftw.setFontHeightInPoints((short)11);
    }

    protected void initStyle(Workbook wb) {
        this.cshl = wb.createCellStyle();
        this.cshc = wb.createCellStyle();
        this.csh24l = wb.createCellStyle();
        this.csh24c = wb.createCellStyle();
        this.css = wb.createCellStyle();
        this.cssb = wb.createCellStyle();
        this.csswbg = wb.createCellStyle();
        this.csn = wb.createCellStyle();
        this.csnbb = wb.createCellStyle();
        this.csw = wb.createCellStyle();
        this.cshl.setFont(this.fth);
        this.cshl.setAlignment(HorizontalAlignment.LEFT);
        this.cshl.setVerticalAlignment(VerticalAlignment.TOP);
        this.csh24l.setFont(this.fth24);
        this.csh24l.setAlignment(HorizontalAlignment.LEFT);
        this.csh24l.setVerticalAlignment(VerticalAlignment.TOP);
        this.cshc.setFont(this.fth);
        this.cshc.setAlignment(HorizontalAlignment.CENTER);
        this.cshc.setVerticalAlignment(VerticalAlignment.TOP);
        this.cshc.setWrapText(true);
        this.csh24c.setFont(this.fth24);
        this.csh24c.setAlignment(HorizontalAlignment.CENTER);
        this.csh24c.setVerticalAlignment(VerticalAlignment.TOP);
        this.css.setFont(this.fts);
        this.css.setAlignment(HorizontalAlignment.LEFT);
        this.css.setVerticalAlignment(VerticalAlignment.TOP);
        this.cssb.setFont(this.fts);
        this.cssb.setAlignment(HorizontalAlignment.LEFT);
        this.cssb.setVerticalAlignment(VerticalAlignment.TOP);
        this.cssb.setBorderBottom(BorderStyle.THIN);
        this.csswbg.setFont(this.fts);
        this.csswbg.setAlignment(HorizontalAlignment.LEFT);
        this.csswbg.setVerticalAlignment(VerticalAlignment.TOP);
        this.csswbg.setWrapText(true);
        this.csswbg.setBorderTop(BorderStyle.THIN);
        this.csswbg.setBorderBottom(BorderStyle.THIN);
        this.csswbg.setBorderLeft(BorderStyle.THIN);
        this.csswbg.setBorderRight(BorderStyle.THIN);
        this.csswbg.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        this.csn.setFont(this.fts);
        this.csn.setAlignment(HorizontalAlignment.RIGHT);
        this.csn.setVerticalAlignment(VerticalAlignment.TOP);
        this.csn.setDataFormat(wb.createDataFormat().getFormat("#############0"));
        this.csnbb.setFont(this.fth);
        this.csnbb.setAlignment(HorizontalAlignment.RIGHT);
        this.csnbb.setVerticalAlignment(VerticalAlignment.TOP);
        this.csnbb.setDataFormat(wb.createDataFormat().getFormat("#############0"));
        this.csnbb.setBorderTop(BorderStyle.THIN);
        this.csnbb.setBorderBottom(BorderStyle.DOUBLE);
        this.csw.setFont(this.ftw);
        this.csw.setAlignment(HorizontalAlignment.CENTER);
        this.csw.setVerticalAlignment(VerticalAlignment.CENTER);
        ((XSSFCellStyle)this.csswbg).setFillForegroundColor(IndexedColors.GREY_25_PERCENT.index);
    }

    protected void initSheet(Workbook wb, Properties lang, String sheet) throws IOException {
        TaxStatementReportUtil.addSheet(wb, TaxStatementReportUtil.getText(lang, sheet));
        TaxStatementReportUtil.addRow(wb);
        TaxStatementReportUtil.setHeight(wb, 4);
        TaxStatementReportUtil.addCell(wb, this.csh24c);
        TaxStatementReportUtil.setWidth(wb, 1);
        TaxStatementReportUtil.addCell(wb, this.csh24c);
        TaxStatementReportUtil.addImage(wb, "ssk.jpg", 2, 1);
        TaxStatementReportUtil.setWidth(wb, 5);
        TaxStatementReportUtil.addCell(wb, this.csh24c);
        TaxStatementReportUtil.setWidth(wb, 15);
        TaxStatementReportUtil.addCell(wb, this.csh24c, TaxStatementReportUtil.getText(lang, sheet));
        TaxStatementReportUtil.setWidth(wb, 10);
        TaxStatementReportUtil.addCell(wb, this.csh24c);
        TaxStatementReportUtil.setWidth(wb, 10);
        TaxStatementReportUtil.addCell(wb, this.csh24c);
        TaxStatementReportUtil.setWidth(wb, 10);
        TaxStatementReportUtil.addCell(wb, this.csh24c);
        TaxStatementReportUtil.setWidth(wb, 10);
        TaxStatementReportUtil.addCell(wb, this.csh24c);
        TaxStatementReportUtil.setWidth(wb, 10);
        TaxStatementReportUtil.addCell(wb, this.csh24c);
        TaxStatementReportUtil.setWidth(wb, 10);
        TaxStatementReportUtil.addCell(wb, this.csh24c);
        TaxStatementReportUtil.setWidth(wb, 5);
        TaxStatementReportUtil.addCell(wb, this.csh24c);
        TaxStatementReportUtil.addImage(wb, "ewv.jpg", 2, 1);
        TaxStatementReportUtil.setWidth(wb, 10);
        TaxStatementReportUtil.addCell(wb, this.csh24c);
        TaxStatementReportUtil.setWidth(wb, 5);
        TaxStatementReportUtil.addCell(wb, this.csh24c);
        TaxStatementReportUtil.setWidth(wb, 1);
        TaxStatementReportUtil.getSheet(wb).addMergedRegion(new CellRangeAddress(TaxStatementReportUtil.getNumberOfRows(wb) - 1, TaxStatementReportUtil.getNumberOfRows(wb) - 1, 1, 2));
        TaxStatementReportUtil.getSheet(wb).addMergedRegion(new CellRangeAddress(TaxStatementReportUtil.getNumberOfRows(wb) - 1, TaxStatementReportUtil.getNumberOfRows(wb) - 1, 3, 8));
        TaxStatementReportUtil.getSheet(wb).addMergedRegion(new CellRangeAddress(TaxStatementReportUtil.getNumberOfRows(wb) - 1, TaxStatementReportUtil.getNumberOfRows(wb) - 1, 10, 11));
        TaxStatementReportUtil.getSheet(wb).setFitToPage(true);
        TaxStatementReportUtil.getSheet(wb).setDisplayGridlines(true);
        TaxStatementReportUtil.getSheet(wb).setMargin(PageMargin.TOP, 0.5);
        TaxStatementReportUtil.getSheet(wb).setMargin(PageMargin.BOTTOM, 0.5);
        TaxStatementReportUtil.getSheet(wb).setMargin(PageMargin.LEFT, 0.3);
        TaxStatementReportUtil.getSheet(wb).setMargin(PageMargin.RIGHT, 0.3);
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        TaxStatementReportUtil.getSheet(wb).getFooter().setLeft(sdf.format(new Date()));
        TaxStatementReportUtil.getSheet(wb).getFooter().setRight(TaxStatementReportUtil.getVersion());
        TaxStatementReportUtil.getSheet(wb).getPrintSetup().setPaperSize((short)9);
        TaxStatementReportUtil.getSheet(wb).getPrintSetup().setLandscape(false);
        TaxStatementReportUtil.getSheet(wb).getPrintSetup().setFitWidth((short)1);
        TaxStatementReportUtil.getSheet(wb).getPrintSetup().setFitHeight((short)2);
        TaxStatementReportUtil.getSheet(wb).getPrintSetup().setHeaderMargin(0.2);
        TaxStatementReportUtil.getSheet(wb).getPrintSetup().setFooterMargin(0.3);
    }

    protected void initResult(Workbook wb, Properties lang, TaxStatementReportFormula formula, ArrayList<Cell[]> cs) throws IOException {
        for (int i = 0; i < 1; ++i) {
            this.addRowEmpty(wb);
        }
        TaxStatementReportUtil.addRow(wb);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.cshl, TaxStatementReportUtil.getText(lang, RESULT_SHEET));
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.cshc, TaxStatementReportUtil.getText(lang, RESULT_OK));
        TaxStatementReportUtil.addCell(wb, this.cshc, TaxStatementReportUtil.getText(lang, RESULT_ERROR));
        TaxStatementReportUtil.addCell(wb, this.cshc, TaxStatementReportUtil.getText(lang, RESULT_SELECT));
        TaxStatementReportUtil.addCell(wb, this.cshc, TaxStatementReportUtil.getText(lang, RESULT_TOTAL));
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.getSheet(wb).addMergedRegion(new CellRangeAddress(TaxStatementReportUtil.getNumberOfRows(wb) - 1, TaxStatementReportUtil.getNumberOfRows(wb) - 1, 3, 4));
        List<String> sheets = Arrays.asList(TaxStatementReportUtil.getText(lang, SHEET_SCHEMA), TaxStatementReportUtil.getText(lang, SHEET_TAX_STATEMENT), TaxStatementReportUtil.getText(lang, SHEET_INSTITUTION), TaxStatementReportUtil.getText(lang, SHEET_CLIENT), TaxStatementReportUtil.getText(lang, SHEET_BANK_ACCOUNT), TaxStatementReportUtil.getText(lang, SHEET_LIABILITY_ACCOUNT), TaxStatementReportUtil.getText(lang, SHEET_EXPENSE), TaxStatementReportUtil.getText(lang, SHEET_SECURITY));
        for (String sheet : sheets) {
            Cell[] cells = new Cell[4];
            TaxStatementReportUtil.addRow(wb);
            TaxStatementReportUtil.addCell(wb, this.css);
            TaxStatementReportUtil.addCell(wb, this.css);
            TaxStatementReportUtil.addCell(wb, this.css);
            TaxStatementReportUtil.addCell(wb, this.css, sheet);
            cells[0] = TaxStatementReportUtil.getCell(wb);
            TaxStatementReportUtil.addCell(wb, this.css);
            TaxStatementReportUtil.addCell(wb, this.csn);
            cells[1] = TaxStatementReportUtil.getCell(wb);
            TaxStatementReportUtil.addCell(wb, this.csn);
            cells[2] = TaxStatementReportUtil.getCell(wb);
            TaxStatementReportUtil.addCell(wb, this.csn);
            cells[3] = TaxStatementReportUtil.getCell(wb);
            TaxStatementReportUtil.addCell(wb, this.csn);
            TaxStatementReportUtil.getCell(wb).setCellFormula("SUM(F" + TaxStatementReportUtil.getNumberOfRows(wb) + ":H" + TaxStatementReportUtil.getNumberOfRows(wb) + ")");
            TaxStatementReportUtil.addCell(wb, this.css);
            TaxStatementReportUtil.addCell(wb, this.css);
            TaxStatementReportUtil.addCell(wb, this.css);
            TaxStatementReportUtil.addCell(wb, this.css);
            TaxStatementReportUtil.getSheet(wb).addMergedRegion(new CellRangeAddress(TaxStatementReportUtil.getNumberOfRows(wb) - 1, TaxStatementReportUtil.getNumberOfRows(wb) - 1, 3, 4));
            XSSFSheetConditionalFormatting condition = ((XSSFSheet)TaxStatementReportUtil.getSheet(wb)).getSheetConditionalFormatting();
            XSSFConditionalFormattingRule ruleOK = condition.createConditionalFormattingRule("G" + TaxStatementReportUtil.getNumberOfRows(wb) + "=0");
            XSSFConditionalFormattingRule ruleERROR = condition.createConditionalFormattingRule("G" + TaxStatementReportUtil.getNumberOfRows(wb) + ">0");
            XSSFConditionalFormattingRule[] rules = new XSSFConditionalFormattingRule[]{ruleOK, ruleERROR};
            CellRangeAddress[] range = new CellRangeAddress[]{CellRangeAddress.valueOf((String)("G" + TaxStatementReportUtil.getNumberOfRows(wb) + ":G" + TaxStatementReportUtil.getNumberOfRows(wb)))};
            ruleOK.createFontFormatting().setFontColorIndex(IndexedColors.BLACK.index);
            ruleERROR.createFontFormatting().setFontColorIndex(IndexedColors.RED.index);
            condition.addConditionalFormatting(range, (ConditionalFormattingRule[])rules);
            cs.add(cells);
        }
        TaxStatementReportUtil.addRow(wb);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.csnbb);
        TaxStatementReportUtil.getCell(wb).setCellFormula("SUM(F" + (TaxStatementReportUtil.getNumberOfRows(wb) - sheets.size()) + ":F" + (TaxStatementReportUtil.getNumberOfRows(wb) - 1) + ")");
        TaxStatementReportUtil.addCell(wb, this.csnbb);
        TaxStatementReportUtil.getCell(wb).setCellFormula("SUM(G" + (TaxStatementReportUtil.getNumberOfRows(wb) - sheets.size()) + ":G" + (TaxStatementReportUtil.getNumberOfRows(wb) - 1) + ")");
        TaxStatementReportUtil.addCell(wb, this.csnbb);
        TaxStatementReportUtil.getCell(wb).setCellFormula("SUM(H" + (TaxStatementReportUtil.getNumberOfRows(wb) - sheets.size()) + ":H" + (TaxStatementReportUtil.getNumberOfRows(wb) - 1) + ")");
        TaxStatementReportUtil.addCell(wb, this.csnbb);
        TaxStatementReportUtil.getCell(wb).setCellFormula("SUM(I" + (TaxStatementReportUtil.getNumberOfRows(wb) - sheets.size()) + ":I" + (TaxStatementReportUtil.getNumberOfRows(wb) - 1) + ")");
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        XSSFSheetConditionalFormatting condition = ((XSSFSheet)TaxStatementReportUtil.getSheet(wb)).getSheetConditionalFormatting();
        XSSFConditionalFormattingRule ruleOK = condition.createConditionalFormattingRule("G" + TaxStatementReportUtil.getNumberOfRows(wb) + "=0");
        XSSFConditionalFormattingRule ruleERROR = condition.createConditionalFormattingRule("G" + TaxStatementReportUtil.getNumberOfRows(wb) + ">0");
        XSSFConditionalFormattingRule[] rules = new XSSFConditionalFormattingRule[]{ruleOK, ruleERROR};
        CellRangeAddress[] range = new CellRangeAddress[]{CellRangeAddress.valueOf((String)("G" + TaxStatementReportUtil.getNumberOfRows(wb) + ":G" + TaxStatementReportUtil.getNumberOfRows(wb)))};
        ruleOK.createFontFormatting().setFontColorIndex(IndexedColors.BLACK.index);
        ruleERROR.createFontFormatting().setFontColorIndex(IndexedColors.RED.index);
        condition.addConditionalFormatting(range, (ConditionalFormattingRule[])rules);
        for (int i = 0; i < 1; ++i) {
            this.addRowEmpty(wb);
        }
        TaxStatementReportUtil.addRow(wb);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.csh24c);
        TaxStatementReportUtil.getCell(wb).setCellFormula("IF(G" + (TaxStatementReportUtil.getNumberOfRows(wb) - 2) + ">0,\"" + TaxStatementReportUtil.getText(lang, RESULT_NOTAPPROVED) + "\",\"" + TaxStatementReportUtil.getText(lang, RESULT_APPROVED) + "\")");
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.getSheet(wb).addMergedRegion(new CellRangeAddress(TaxStatementReportUtil.getNumberOfRows(wb) - 1, TaxStatementReportUtil.getNumberOfRows(wb) - 1, 3, 9));
        condition = ((XSSFSheet)TaxStatementReportUtil.getSheet(wb)).getSheetConditionalFormatting();
        ruleOK = condition.createConditionalFormattingRule("D" + TaxStatementReportUtil.getNumberOfRows(wb) + "=\"" + TaxStatementReportUtil.getText(lang, RESULT_APPROVED) + "\"");
        ruleERROR = condition.createConditionalFormattingRule("D" + TaxStatementReportUtil.getNumberOfRows(wb) + "=\"" + TaxStatementReportUtil.getText(lang, RESULT_NOTAPPROVED) + "\"");
        rules = new XSSFConditionalFormattingRule[]{ruleOK, ruleERROR};
        range = new CellRangeAddress[]{CellRangeAddress.valueOf((String)("D" + TaxStatementReportUtil.getNumberOfRows(wb) + ":E" + TaxStatementReportUtil.getNumberOfRows(wb)))};
        ruleOK.createFontFormatting().setFontColorIndex(IndexedColors.BLACK.index);
        ruleERROR.createFontFormatting().setFontColorIndex(IndexedColors.RED.index);
        condition.addConditionalFormatting(range, (ConditionalFormattingRule[])rules);
    }

    protected void initResultCase(Workbook wb, Properties lang, TaxStatementReportResultList result) {
        for (int i = 0; i < 1; ++i) {
            this.addRowEmpty(wb);
        }
        this.addRowContentHeader(wb, lang, RESULT_CASE_BANK_ACCOUNT);
        this.addRowContent(wb, lang, result, "RESULT_CASE_BANK_ACCOUNT_INTEREST_A", "RESULT_CASE_BANK_ACCOUNT_INTEREST_B");
        this.addRowContent(wb, lang, result, "RESULT_CASE_BANK_ACCOUNT_INTEREST_DEBIT", "RESULT_CASE_BANK_ACCOUNT_OPENING");
        this.addRowContent(wb, lang, result, "RESULT_CASE_BANK_ACCOUNT_CLOSURE", "RESULT_CASE_BANK_ACCOUNT_FOREIGN");
        this.addRowContent(wb, lang, result, "RESULT_CASE_BANK_ACCOUNT_METAL", "RESULT_CASE_BANK_ACCOUNT_FIXED");
        this.addRowContentHeader(wb, lang, RESULT_CASE_LIABILITY_ACCOUNT);
        this.addRowContent(wb, lang, result, "RESULT_CASE_LIABILITY_ACCOUNT_DEBT", "RESULT_CASE_LIABILITY_ACCOUNT_BORROWING");
        this.addRowContent(wb, lang, result, "RESULT_CASE_LIABILITY_ACCOUNT_REPAYMENT", "RESULT_CASE_LIABILITY_ACCOUNT_CHF");
        this.addRowContent(wb, lang, result, "RESULT_CASE_LIABILITY_ACCOUNT_FOREIGN");
        this.addRowContentHeader(wb, lang, RESULT_CASE_EXPENSE);
        this.addRowContent(wb, lang, result, "RESULT_CASE_EXPENSE_MULTIPLE", "RESULT_CASE_EXPENSE_DEPOSIT");
        this.addRowContent(wb, lang, result, "RESULT_CASE_EXPENSE_ACCOUNT_MANAGEMENT", "RESULT_CASE_EXPENSE_NEGATIVE_INTEREST");
        this.addRowContent(wb, lang, result, "RESULT_CASE_EXPENSE_ASSET_MANAGEMENT", "RESULT_CASE_EXPENSE_ADMINISTRATIVE_ACTION");
        this.addRowContent(wb, lang, result, "RESULT_CASE_EXPENSE_TAX_STATEMENT", "RESULT_CASE_EXPENSE_REFUND");
        this.addRowContentHeader(wb, lang, RESULT_CASE_SHARE);
        this.addRowContent(wb, lang, result, "RESULT_CASE_SHARE_CHF", "RESULT_CASE_SHARE_FOREIGN");
        this.addRowContent(wb, lang, result, "RESULT_CASE_SHARE_REVENUE_A", "RESULT_CASE_SHARE_REVENUE_B");
        this.addRowContent(wb, lang, result, "RESULT_CASE_SHARE_REVENUE_DA1", "RESULT_CASE_SHARE_REVENUE_USA");
        this.addRowContent(wb, lang, result, "RESULT_CASE_SHARE_PURCHASE", "RESULT_CASE_SHARE_DISPOSITION");
        this.addRowContentHeader(wb, lang, RESULT_CASE_BOND);
        this.addRowContent(wb, lang, result, "RESULT_CASE_BOND_CHF", "RESULT_CASE_BOND_FOREIGN");
        this.addRowContent(wb, lang, result, "RESULT_CASE_BOND_REVENUE_A", "RESULT_CASE_BOND_REVENUE_B");
        this.addRowContent(wb, lang, result, "RESULT_CASE_BOND_PURCHASE", "RESULT_CASE_BOND_DISPOSITION");
        this.addRowContentHeader(wb, lang, RESULT_CASE_FUND);
        this.addRowContent(wb, lang, result, "RESULT_CASE_FUND_CHF", "RESULT_CASE_FUND_FOREIGN");
        this.addRowContent(wb, lang, result, "RESULT_CASE_FUND_REVENUE_A", "RESULT_CASE_FUND_REVENUE_B");
        this.addRowContent(wb, lang, result, "RESULT_CASE_FUND_ACCUMULATION", "RESULT_CASE_FUND_PURCHASE");
        this.addRowContent(wb, lang, result, "RESULT_CASE_FUND_DISPOSITION");
        this.addRowContentHeader(wb, lang, RESULT_CASE_DEVT);
        this.addRowContent(wb, lang, result, "RESULT_CASE_DEVT_CHF", "RESULT_CASE_DEVT_FOREIGN");
        this.addRowContent(wb, lang, result, "RESULT_CASE_DEVT_REVENUE_A", "RESULT_CASE_DEVT_REVENUE_B");
        this.addRowContent(wb, lang, result, "RESULT_CASE_DEVT_PURCHASE", "RESULT_CASE_DEVT_DISPOSITION");
        this.addRowContent(wb, lang, result, "RESULT_CASE_DEVT_IUP_PURE", "RESULT_CASE_DEVT_IUP_MODIFIED");
        this.addRowContent(wb, lang, result, "RESULT_CASE_OPTION_FUTURE");
        this.addRowContentHeader(wb, lang, RESULT_CASE_MONEY);
        this.addRowContent(wb, lang, result, "RESULT_CASE_MONEY_FIXED_REVENUE_A", "RESULT_CASE_MONEY_FIXED_REVENUE_B");
        this.addRowContent(wb, lang, result, "RESULT_CASE_MONEY_FIDUCIARY_REVENUE_A", "RESULT_CASE_MONEY_FIDUCIARY_REVENUE_B");
        this.addRowContentHeader(wb, lang, RESULT_CASE_COINBULL);
        this.addRowContent(wb, lang, result, "RESULT_CASE_COINBULL_SECURITIZED", "RESULT_CASE_COINBULL_PHYSICAL");
        this.addRowContentHeader(wb, lang, RESULT_CASE_SPECIAL);
        this.addRowContent(wb, lang, result, "RESULT_CASE_SPECIAL_TOKEN", "RESULT_CASE_SPECIAL_LENDING");
        this.addRowContent(wb, lang, result, "RESULT_CASE_SPECIAL_RETROCESSION", "RESULT_CASE_SPECIAL_SHARE_STOCK");
        this.addRowContent(wb, lang, result, "RESULT_CASE_SPECIAL_DURING_THE_YEAR", "RESULT_CASE_SPECIAL_LIGHT");
        this.addRowContent(wb, lang, result, "RESULT_CASE_SPECIAL_SAME_VALOR");
    }

    protected void initComment(Workbook wb, Properties lang) throws IOException {
        int i;
        for (i = 0; i < 1; ++i) {
            this.addRowEmpty(wb);
        }
        TaxStatementReportUtil.addRow(wb);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.cshl, TaxStatementReportUtil.getText(lang, RESULT_COMMENT));
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.getSheet(wb).addMergedRegion(new CellRangeAddress(TaxStatementReportUtil.getNumberOfRows(wb) - 1, TaxStatementReportUtil.getNumberOfRows(wb) - 1, 2, 10));
        for (i = 0; i < 10; ++i) {
            TaxStatementReportUtil.addRow(wb);
            TaxStatementReportUtil.addCell(wb, this.css);
            TaxStatementReportUtil.addCell(wb, this.css);
            TaxStatementReportUtil.addCell(wb, this.csswbg);
            TaxStatementReportUtil.addCell(wb, this.csswbg);
            TaxStatementReportUtil.addCell(wb, this.csswbg);
            TaxStatementReportUtil.addCell(wb, this.csswbg);
            TaxStatementReportUtil.addCell(wb, this.csswbg);
            TaxStatementReportUtil.addCell(wb, this.csswbg);
            TaxStatementReportUtil.addCell(wb, this.csswbg);
            TaxStatementReportUtil.addCell(wb, this.csswbg);
            TaxStatementReportUtil.addCell(wb, this.csswbg);
            TaxStatementReportUtil.addCell(wb, this.css);
            TaxStatementReportUtil.addCell(wb, this.css);
        }
        TaxStatementReportUtil.getSheet(wb).addMergedRegion(new CellRangeAddress(TaxStatementReportUtil.getNumberOfRows(wb) - 10, TaxStatementReportUtil.getNumberOfRows(wb) - 1, 2, 10));
    }

    protected void initSignature(Workbook wb, Properties lang) throws IOException {
        for (int i = 0; i < 3; ++i) {
            TaxStatementReportUtil.addRow(wb);
            TaxStatementReportUtil.addCell(wb, this.css);
            TaxStatementReportUtil.addCell(wb, this.css);
            TaxStatementReportUtil.addCell(wb, i < 2 ? this.css : this.cssb);
            TaxStatementReportUtil.addCell(wb, i < 2 ? this.css : this.cssb);
            TaxStatementReportUtil.addCell(wb, i < 2 ? this.css : this.cssb);
            TaxStatementReportUtil.addCell(wb, this.css);
            TaxStatementReportUtil.addCell(wb, this.css);
            TaxStatementReportUtil.addCell(wb, i < 2 ? this.css : this.cssb);
            TaxStatementReportUtil.addCell(wb, i < 2 ? this.css : this.cssb);
            TaxStatementReportUtil.addCell(wb, i < 2 ? this.css : this.cssb);
            TaxStatementReportUtil.addCell(wb, i < 2 ? this.css : this.cssb);
            TaxStatementReportUtil.addCell(wb, this.css);
            TaxStatementReportUtil.addCell(wb, this.css);
        }
        TaxStatementReportUtil.addRow(wb);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css, TaxStatementReportUtil.getText(lang, RESULT_DELEGATE));
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css, TaxStatementReportUtil.getText(lang, RESULT_TESTING));
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.getSheet(wb).addMergedRegion(new CellRangeAddress(TaxStatementReportUtil.getNumberOfRows(wb) - 1, TaxStatementReportUtil.getNumberOfRows(wb) - 1, 2, 4));
        TaxStatementReportUtil.getSheet(wb).addMergedRegion(new CellRangeAddress(TaxStatementReportUtil.getNumberOfRows(wb) - 1, TaxStatementReportUtil.getNumberOfRows(wb) - 1, 7, 10));
        TaxStatementReportUtil.addRow(wb);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css, TaxStatementReportUtil.getText(lang, RESULT_SSK));
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css, TaxStatementReportUtil.getText(lang, RESULT_SSK));
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.getSheet(wb).addMergedRegion(new CellRangeAddress(TaxStatementReportUtil.getNumberOfRows(wb) - 1, TaxStatementReportUtil.getNumberOfRows(wb) - 1, 2, 4));
        TaxStatementReportUtil.getSheet(wb).addMergedRegion(new CellRangeAddress(TaxStatementReportUtil.getNumberOfRows(wb) - 1, TaxStatementReportUtil.getNumberOfRows(wb) - 1, 7, 10));
    }

    protected ArrayList<Cell[]> summary(Workbook wb, Properties lang, TaxStatementReportFormula formula, TaxStatementReportResultList result) throws IOException, ParseException, XPathExpressionException {
        ArrayList<Cell[]> cs = new ArrayList<Cell[]>();
        this.initFont(wb);
        this.initStyle(wb);
        this.initSheet(wb, lang, SHEET);
        this.initResult(wb, lang, formula, cs);
        this.initResultCase(wb, lang, result);
        this.initComment(wb, lang);
        this.initSignature(wb, lang);
        return cs;
    }

    public Workbook translate(Document doc, byte[] xml, Properties lang, TaxStatementReportFormula formula, TaxStatementReportResultList result) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        XSSFWorkbook wb = new XSSFWorkbook();
        ArrayList<Cell[]> ca = this.summary((Workbook)wb, lang, formula, result);
        TaxStatementReportSSKSummaryDetail sd = new TaxStatementReportSSKSummaryDetail();
        sd.translate((Workbook)wb, lang);
        if (ca != null && result != null) {
            for (Cell[] cells : ca) {
                String name;
                Cell cell;
                if (cells == null || (cell = cells[0]) == null || (name = cell.getStringCellValue()) == null) continue;
                if (name.equals(TaxStatementReportUtil.getText(lang, SHEET_BANK_ACCOUNT))) {
                    this.addResult((Workbook)wb, lang, cells, SHEET_BANK_ACCOUNT, 4, result.extractGroup(name));
                    continue;
                }
                if (name.equals(TaxStatementReportUtil.getText(lang, SHEET_CLIENT))) {
                    this.addResult((Workbook)wb, lang, cells, SHEET_CLIENT, 1, result.extractGroup(name));
                    continue;
                }
                if (name.equals(TaxStatementReportUtil.getText(lang, SHEET_EXPENSE))) {
                    this.addResult((Workbook)wb, lang, cells, SHEET_EXPENSE, 4, result.extractGroup(name));
                    continue;
                }
                if (name.equals(TaxStatementReportUtil.getText(lang, SHEET_INSTITUTION))) {
                    this.addResult((Workbook)wb, lang, cells, SHEET_INSTITUTION, 1, result.extractGroup(name));
                    continue;
                }
                if (name.equals(TaxStatementReportUtil.getText(lang, SHEET_LIABILITY_ACCOUNT))) {
                    this.addResult((Workbook)wb, lang, cells, SHEET_LIABILITY_ACCOUNT, 4, result.extractGroup(name));
                    continue;
                }
                if (name.equals(TaxStatementReportUtil.getText(lang, SHEET_SCHEMA))) {
                    this.addResult((Workbook)wb, lang, cells, SHEET_SCHEMA, 1, result.extractGroup(name));
                    continue;
                }
                if (name.equals(TaxStatementReportUtil.getText(lang, SHEET_SECURITY))) {
                    this.addResult((Workbook)wb, lang, cells, SHEET_SECURITY, 5, result.extractGroup(name));
                    continue;
                }
                if (!name.equals(TaxStatementReportUtil.getText(lang, SHEET_TAX_STATEMENT))) continue;
                this.addResult((Workbook)wb, lang, cells, SHEET_TAX_STATEMENT, 3, result.extractGroup(name));
            }
            sd.translate((Workbook)wb, lang, result.getCases());
        }
        return wb;
    }
}

