/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.report;

import ch.ewv.taxstatement.report.TaxStatementReportCase;
import ch.ewv.taxstatement.report.TaxStatementReportFormula;
import ch.ewv.taxstatement.report.TaxStatementReportOperator;
import ch.ewv.taxstatement.report.TaxStatementReportProperty;
import ch.ewv.taxstatement.report.TaxStatementReportResult;
import ch.ewv.taxstatement.report.TaxStatementReportResultCase;
import ch.ewv.taxstatement.report.TaxStatementReportResultEntity;
import ch.ewv.taxstatement.report.TaxStatementReportResultStep;
import ch.ewv.taxstatement.report.TaxStatementReportSchemaData;
import ch.ewv.taxstatement.report.TaxStatementReportSecurityData;
import ch.ewv.taxstatement.report.TaxStatementReportUtil;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class TaxStatementReportSecurityCase04
extends TaxStatementReportCase {
    protected TaxStatementReportResultStep execute01(Document doc, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeExist(1, this.getStepDescription(lang, 1), this.getStepCondition(lang, 1), false, TaxStatementReportSecurityData.getTotalTaxValue(doc));
    }

    protected TaxStatementReportResultStep execute02(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeCount(2, this.getStepDescription(lang, 2), this.getStepCondition(lang, 2), filter, TaxStatementReportSecurityData.getSecurityCount(doc));
    }

    protected TaxStatementReportResultStep execute03(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        int i;
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(3, this.getStepDescription(lang, 3), this.getStepCondition(lang, 3));
        int stock = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int stocks = TaxStatementReportSecurityData.getStockCount(doc, i, j);
                while (k <= stocks) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getStockReferenceDate(doc, i, j, k));
                    String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                    if (category != null) {
                        if (category.equals("BOND") || category.equals("COINBULL") || category.equals("CURRNOTE") || category.equals("DEVT") || category.equals("FUND") || category.equals("LIBOSWAP") || category.equals("OPTION") || category.equals("SHARE") || category.equals("OTHER")) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + stock + ") " + category);
                        } else {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + stock + ") " + category);
                        }
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++stock;
                }
            }
        }
        int missing = 1;
        int stocks = TaxStatementReportSecurityData.getStockCount(doc);
        int depots2 = TaxStatementReportSecurityData.getDepotCount(doc);
        for (i = 1; i <= depots2; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                if (TaxStatementReportSecurityData.getStockCount(doc, i, j) != 0) continue;
                TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))));
                String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                if (category != null) {
                    if (category.equals("BOND") || category.equals("COINBULL") || category.equals("CURRNOTE") || category.equals("DEVT") || category.equals("FUND") || category.equals("LIBOSWAP") || category.equals("OPTION") || category.equals("SHARE") || category.equals("OTHER")) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + (stocks + missing) + ") " + category);
                    } else {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + (stocks + missing) + ") " + category);
                    }
                } else {
                    entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                }
                step.addEntity(entity);
                ++missing;
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute04(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        int i;
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(4, this.getStepDescription(lang, 4), this.getStepCondition(lang, 4));
        int stock = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int stocks = TaxStatementReportSecurityData.getStockCount(doc, i, j);
                while (k <= stocks) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getStockReferenceDate(doc, i, j, k));
                    entity.setResult(TaxStatementReportResult.OK).setRemark("(" + stock + ") true");
                    step.addEntity(entity);
                    ++k;
                    ++stock;
                }
            }
        }
        int missing = 1;
        int stocks = TaxStatementReportSecurityData.getStockCount(doc);
        int depots2 = TaxStatementReportSecurityData.getDepotCount(doc);
        for (i = 1; i <= depots2; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                Boolean lendingFee = TaxStatementReportSecurityData.getPaymentLendingFee(doc, i, j);
                Boolean retrocession = TaxStatementReportSecurityData.getPaymentRetrocession(doc, i, j);
                if (TaxStatementReportSecurityData.getStockCount(doc, i, j) != 0 || lendingFee.booleanValue() || retrocession.booleanValue()) continue;
                TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))));
                entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + (stocks + missing) + ") false");
                step.addEntity(entity);
                ++missing;
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute05(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(5, this.getStepDescription(lang, 5), this.getStepCondition(lang, 5));
        int stock = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int stocks = TaxStatementReportSecurityData.getStockCount(doc, i, j);
                while (k <= stocks) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getStockReferenceDate(doc, i, j, k));
                    Date referenceDate = TaxStatementReportSecurityData.getStockReferenceDate(doc, i, j, k);
                    if (referenceDate != null) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + stock + ") " + new SimpleDateFormat("dd.MM.yyyy").format(referenceDate));
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++stock;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute06(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(6, this.getStepDescription(lang, 6), this.getStepCondition(lang, 6));
        int stock = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int stocks = TaxStatementReportSecurityData.getStockCount(doc, i, j);
                while (k <= stocks) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getStockReferenceDate(doc, i, j, k));
                    Boolean mutation = TaxStatementReportSecurityData.getStockMutation(doc, i, j, k);
                    entity.setResult(TaxStatementReportResult.OK).setRemark("(" + stock + ") " + mutation);
                    step.addEntity(entity);
                    ++k;
                    ++stock;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute07(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(7, this.getStepDescription(lang, 7), this.getStepCondition(lang, 7));
        int stock = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int stocks = TaxStatementReportSecurityData.getStockCount(doc, i, j);
                while (k <= stocks) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getStockReferenceDate(doc, i, j, k));
                    String name = TaxStatementReportSecurityData.getStockName(doc, i, j, k);
                    if (name != null) {
                        if (name.length() >= 0 && name.length() <= 200) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + stock + ") " + name);
                        } else if (name.length() > 200) {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + stock + ") " + name.length() + " " + (Object)((Object)TaxStatementReportOperator.GREATER) + " 200");
                        } else {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + stock + ") " + name);
                        }
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++stock;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute08(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(8, this.getStepDescription(lang, 8), this.getStepCondition(lang, 8));
        int stock = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int stocks = TaxStatementReportSecurityData.getStockCount(doc, i, j);
                while (k <= stocks) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getStockReferenceDate(doc, i, j, k));
                    String quotationType = TaxStatementReportSecurityData.getStockQuotationType(doc, i, j, k);
                    if (quotationType != null) {
                        if (quotationType.equals("PERCENT") || quotationType.equals("PIECE")) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + stock + ") " + quotationType);
                        } else {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + stock + ") " + quotationType);
                        }
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++stock;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute09(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(9, this.getStepDescription(lang, 9), this.getStepCondition(lang, 9));
        int stock = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int stocks = TaxStatementReportSecurityData.getStockCount(doc, i, j);
                while (k <= stocks) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getStockReferenceDate(doc, i, j, k));
                    String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                    Boolean mutation = TaxStatementReportSecurityData.getStockMutation(doc, i, j, k);
                    Double quantity = TaxStatementReportSecurityData.getStockQuantity(doc, i, j, k);
                    if (quantity != null) {
                        if (quantity >= 0.0) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + stock + ") " + String.format("%1$,.2f", quantity));
                        } else if (quantity < 0.0 && mutation != null && mutation.booleanValue()) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + stock + ") " + String.format("%1$,.2f", quantity));
                        } else if (quantity < 0.0 && category != null && (category.equals("OPTION") || category.equals("OTHER"))) {
                            entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + stock + ") " + String.format("%1$,.2f", quantity));
                        } else if (quantity < 0.0 && category != null && category.equals("SHARE")) {
                            entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + stock + ") " + String.format("%1$,.2f", quantity));
                        } else {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + stock + ") " + String.format("%1$,.2f", quantity));
                        }
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++stock;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute10(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(10, this.getStepDescription(lang, 10), this.getStepCondition(lang, 10));
        int stock = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int stocks = TaxStatementReportSecurityData.getStockCount(doc, i, j);
                while (k <= stocks) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getStockReferenceDate(doc, i, j, k));
                    String currency = TaxStatementReportSecurityData.getStockBalanceCurrency(doc, i, j, k);
                    if (currency != null) {
                        if (currency.length() == 3 && currency.charAt(0) >= 'A' && currency.charAt(0) <= 'Z' && currency.charAt(1) >= 'A' && currency.charAt(1) <= 'Z' && currency.charAt(2) >= 'A' && currency.charAt(2) <= 'Z') {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + stock + ") " + currency);
                        } else {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + stock + ") " + currency);
                        }
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++stock;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute11(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(11, this.getStepDescription(lang, 11), this.getStepCondition(lang, 11));
        int stock = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int stocks = TaxStatementReportSecurityData.getStockCount(doc, i, j);
                while (k <= stocks) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getStockReferenceDate(doc, i, j, k));
                    String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                    String quotationType = TaxStatementReportSecurityData.getStockQuotationType(doc, i, j, k);
                    Double unitPrice = TaxStatementReportSecurityData.getStockUnitPrice(doc, i, j, k);
                    if (unitPrice != null) {
                        if (unitPrice > 0.0) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + stock + ") " + String.format("%1$,.2f", unitPrice) + (quotationType != null && quotationType.equals("PERCENT") ? "%" : ""));
                        } else if (unitPrice == 0.0 && category != null && (category.equals("OPTION") || category.equals("OTHER"))) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + stock + ") " + String.format("%1$,.2f", unitPrice) + (quotationType != null && quotationType.equals("PERCENT") ? "%" : ""));
                        } else {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + stock + ") " + String.format("%1$,.2f", unitPrice) + (quotationType != null && quotationType.equals("PERCENT") ? "%" : ""));
                        }
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++stock;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute12(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(12, this.getStepDescription(lang, 12), this.getStepCondition(lang, 12));
        int stock = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int stocks = TaxStatementReportSecurityData.getStockCount(doc, i, j);
                while (k <= stocks) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getStockReferenceDate(doc, i, j, k));
                    String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                    String currency = TaxStatementReportSecurityData.getStockBalanceCurrency(doc, i, j, k);
                    String name = TaxStatementReportSecurityData.getStockName(doc, i, j, k);
                    Double quantity = TaxStatementReportSecurityData.getStockQuantity(doc, i, j, k);
                    Double balance = TaxStatementReportSecurityData.getStockBalance(doc, i, j, k);
                    if (currency != null && !currency.equals("CHF") && balance != null && balance >= 0.0) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + stock + ") " + String.format("%1$,.2f", balance));
                    } else if (currency != null && !currency.equals("CHF") && balance != null && balance < 0.0 && quantity != null && quantity < 0.0) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + stock + ") " + String.format("%1$,.2f", balance));
                    } else if (currency != null && !currency.equals("CHF") && balance != null && balance < 0.0 && name != null && name.equals("Split")) {
                        entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + stock + ") " + String.format("%1$,.2f", balance));
                    } else if (currency != null && !currency.equals("CHF") && balance != null && balance < 0.0) {
                        entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + stock + ") " + String.format("%1$,.2f", balance));
                    } else if (currency != null && currency.equals("CHF") && balance != null && balance >= 0.0) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + stock + ") " + String.format("%1$,.2f", balance));
                    } else if (currency != null && currency.equals("CHF") && balance != null && balance < 0.0 && quantity != null && quantity < 0.0) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + stock + ") " + String.format("%1$,.2f", balance));
                    } else if (currency != null && currency.equals("CHF") && balance != null && balance < 0.0 && name != null && name.equals("Split")) {
                        entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + stock + ") " + String.format("%1$,.2f", balance));
                    } else if (currency != null && currency.equals("CHF") && balance != null && balance < 0.0) {
                        entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + stock + ") " + String.format("%1$,.2f", balance));
                    } else if (currency != null && currency.equals("CHF") && balance == null) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + stock + ") " + String.format("%1$,.2f", balance));
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++stock;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute13(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(13, this.getStepDescription(lang, 13), this.getStepCondition(lang, 13));
        int stock = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int stocks = TaxStatementReportSecurityData.getStockCount(doc, i, j);
                while (k <= stocks) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getStockReferenceDate(doc, i, j, k));
                    String currency = TaxStatementReportSecurityData.getStockBalanceCurrency(doc, i, j, k);
                    String quotationType = TaxStatementReportSecurityData.getStockQuotationType(doc, i, j, k);
                    Double quantity = TaxStatementReportSecurityData.getStockQuantity(doc, i, j, k);
                    Double unitPrice = TaxStatementReportSecurityData.getStockUnitPrice(doc, i, j, k);
                    Double balance = TaxStatementReportSecurityData.getStockBalance(doc, i, j, k);
                    Double value = TaxStatementReportSecurityData.getStockValue(doc, i, j, k);
                    Double balanceCalc = null;
                    if (quantity != null && unitPrice != null) {
                        balanceCalc = quotationType != null && quotationType.equals("PERCENT") ? Double.valueOf(TaxStatementReportUtil.abs(quantity) * unitPrice / 100.0) : Double.valueOf(TaxStatementReportUtil.abs(quantity) * unitPrice);
                    }
                    if (balance != null && balanceCalc != null) {
                        if (String.format("%1$,.2f", balance).equals(String.format("%1$,.2f", balanceCalc))) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + stock + ") " + String.format("%1$,.2f", balance));
                        } else if (TaxStatementReportUtil.approximately(balance, balanceCalc, 0.0499999999).booleanValue()) {
                            entity.setResult(TaxStatementReportResult.OK).setReason("(" + stock + ") " + String.format("%1$,.2f", balance) + " " + (Object)((Object)TaxStatementReportOperator.APPROXIMATELY) + " " + String.format("%1$,.2f", balanceCalc));
                        } else if (TaxStatementReportUtil.approximately(balance, balanceCalc, 0.4999999999).booleanValue() && currency != null && (currency.equals("JPY") || currency.equals("TRY"))) {
                            entity.setResult(TaxStatementReportResult.OK).setReason("(" + stock + ") " + String.format("%1$,.2f", balance) + " " + (Object)((Object)TaxStatementReportOperator.APPROXIMATELY) + " " + String.format("%1$,.2f", balanceCalc));
                        } else {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + stock + ") " + String.format("%1$,.2f", balance) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", balanceCalc));
                        }
                    } else if (balanceCalc != null) {
                        if (currency != null && !currency.equals("CHF") && balance == null && value == null) {
                            entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + stock + ") " + (Object)((Object)TaxStatementReportOperator.UNDEFINED) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", balanceCalc));
                        } else if (currency != null && !currency.equals("CHF")) {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + stock + ") " + (Object)((Object)TaxStatementReportOperator.UNDEFINED) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", balanceCalc));
                        } else {
                            entity.setResult(TaxStatementReportResult.IGNORE);
                        }
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++stock;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute14(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(14, this.getStepDescription(lang, 14), this.getStepCondition(lang, 14));
        int stock = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int stocks = TaxStatementReportSecurityData.getStockCount(doc, i, j);
                while (k <= stocks) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getStockReferenceDate(doc, i, j, k));
                    Boolean iup = TaxStatementReportSecurityData.getSecurityIUP(doc, i, j);
                    Boolean bfp = TaxStatementReportSecurityData.getSecurityBFP(doc, i, j);
                    Double reductionCost = TaxStatementReportSecurityData.getStockReductionCost(doc, i, j, k);
                    if (reductionCost != null) {
                        if (reductionCost > 0.0 && iup.booleanValue() && !bfp.booleanValue()) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + stock + ") " + String.format("%1$,.2f", reductionCost));
                        } else {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + stock + ") " + String.format("%1$,.2f", reductionCost));
                        }
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++stock;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute15(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(15, this.getStepDescription(lang, 15), this.getStepCondition(lang, 15));
        int stock = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int stocks = TaxStatementReportSecurityData.getStockCount(doc, i, j);
                while (k <= stocks) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getStockReferenceDate(doc, i, j, k));
                    String currency = TaxStatementReportSecurityData.getStockBalanceCurrency(doc, i, j, k);
                    Double quantity = TaxStatementReportSecurityData.getStockQuantity(doc, i, j, k);
                    Double balance = TaxStatementReportSecurityData.getStockBalance(doc, i, j, k);
                    Double exchangeRate = TaxStatementReportSecurityData.getStockExchangeRate(doc, i, j, k);
                    Double value = TaxStatementReportSecurityData.getStockValue(doc, i, j, k);
                    if (quantity != null && quantity == 0.0 && value == null && balance == null) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (currency != null && !currency.equals("CHF") && balance != null && balance == 0.0 && value != null && value == 0.0 && exchangeRate == null) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (currency != null && !currency.equals("CHF") && exchangeRate != null) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + stock + ") " + String.format("%1$,.5f", exchangeRate));
                    } else if (currency != null && !currency.equals("CHF") && balance != null && exchangeRate == null) {
                        if (TaxStatementReportProperty.EXCHANGE_RATE) {
                            entity.setResult(TaxStatementReportResult.ERROR);
                        } else {
                            entity.setResult(TaxStatementReportResult.IGNORE);
                        }
                    } else if (TaxStatementReportProperty.EXCHANGE_RATE) {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    } else {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++stock;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute16(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(16, this.getStepDescription(lang, 16), this.getStepCondition(lang, 16));
        int stock = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int stocks = TaxStatementReportSecurityData.getStockCount(doc, i, j);
                while (k <= stocks) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getStockReferenceDate(doc, i, j, k));
                    String currency = TaxStatementReportSecurityData.getStockBalanceCurrency(doc, i, j, k);
                    Double exchangeRate = TaxStatementReportSecurityData.getStockExchangeRate(doc, i, j, k);
                    if (currency != null && !currency.equals("CHF") && exchangeRate != null) {
                        entity.setResult(TaxStatementReportResult.SELECT);
                    } else if (currency != null && currency.equals("CHF")) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++stock;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute17(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(17, this.getStepDescription(lang, 17), this.getStepCondition(lang, 17));
        int stock = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int stocks = TaxStatementReportSecurityData.getStockCount(doc, i, j);
                while (k <= stocks) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getStockReferenceDate(doc, i, j, k));
                    String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                    String currency = TaxStatementReportSecurityData.getStockBalanceCurrency(doc, i, j, k);
                    Double quantity = TaxStatementReportSecurityData.getStockQuantity(doc, i, j, k);
                    Double balance = TaxStatementReportSecurityData.getStockBalance(doc, i, j, k);
                    Double exchangeRate = TaxStatementReportSecurityData.getStockExchangeRate(doc, i, j, k);
                    Double value = TaxStatementReportSecurityData.getStockValue(doc, i, j, k);
                    if (quantity != null && quantity == 0.0 && value == null && balance == null) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (value != null && balance != null && String.format("%1$,.2f", value).equals(String.format("%1$,.2f", balance))) {
                        entity.setResult(TaxStatementReportResult.OK).setReason("(" + stock + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", balance));
                    } else if (value != null && balance != null && TaxStatementReportUtil.approximately(value, balance).booleanValue()) {
                        entity.setResult(TaxStatementReportResult.OK).setReason("(" + stock + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.APPROXIMATELY) + " " + String.format("%1$,.2f", balance));
                    } else if (value != null && value >= 0.0) {
                        if (currency != null && currency.equals("CHF") && balance != null && !String.format("%1$,.2f", value).equals(String.format("%1$,.2f", balance))) {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + stock + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", balance));
                        } else if (currency != null && !currency.equals("CHF") && balance != null && balance > 0.0 && exchangeRate != null && value == 0.0) {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + stock + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", balance) + " * " + String.format("%1$,.5f", exchangeRate));
                        } else if (currency != null && !currency.equals("CHF") && balance != null && balance > 0.0 && value == 0.0) {
                            if (TaxStatementReportProperty.EXCHANGE_RATE) {
                                entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + stock + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", balance) + " * " + (Object)((Object)TaxStatementReportOperator.UNDEFINED));
                            } else {
                                entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + stock + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", balance) + " * " + (Object)((Object)TaxStatementReportOperator.UNDEFINED));
                            }
                        } else {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + stock + ") " + String.format("%1$,.2f", value));
                        }
                    } else if (value != null && value < 0.0) {
                        if (currency != null && currency.equals("CHF") && balance != null && !String.format("%1$,.2f", value).equals(String.format("%1$,.2f", balance))) {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + stock + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", balance));
                        } else if (currency != null && !currency.equals("CHF") && balance != null && balance < 0.0 && exchangeRate != null && value == 0.0) {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + stock + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", balance) + " * " + String.format("%1$,.5f", exchangeRate));
                        } else if (currency != null && !currency.equals("CHF") && balance != null && balance < 0.0 && value == 0.0) {
                            if (TaxStatementReportProperty.EXCHANGE_RATE) {
                                entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + stock + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", balance) + " * " + (Object)((Object)TaxStatementReportOperator.UNDEFINED));
                            } else {
                                entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + stock + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", balance) + " * " + (Object)((Object)TaxStatementReportOperator.UNDEFINED));
                            }
                        } else {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + stock + ") " + String.format("%1$,.2f", value));
                        }
                    } else if (currency != null && currency.equals("CHF") && balance != null && balance > 0.0) {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + stock + ") " + (Object)((Object)TaxStatementReportOperator.UNDEFINED) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", balance));
                    } else if (currency != null && currency.equals("CHF") && balance != null && balance < 0.0) {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + stock + ") " + (Object)((Object)TaxStatementReportOperator.UNDEFINED) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", balance));
                    } else if (currency != null && !currency.equals("CHF") && balance != null && balance > 0.0 && exchangeRate != null) {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + stock + ") " + (Object)((Object)TaxStatementReportOperator.UNDEFINED) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", balance) + " * " + String.format("%1$,.5f", exchangeRate));
                    } else if (currency != null && !currency.equals("CHF") && balance != null && balance < 0.0 && exchangeRate != null) {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + stock + ") " + (Object)((Object)TaxStatementReportOperator.UNDEFINED) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", balance) + " * " + String.format("%1$,.5f", exchangeRate));
                    } else if (currency != null && !currency.equals("CHF") && balance != null && balance > 0.0) {
                        if (TaxStatementReportProperty.EXCHANGE_RATE) {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + stock + ") " + (Object)((Object)TaxStatementReportOperator.UNDEFINED) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", balance) + " * " + (Object)((Object)TaxStatementReportOperator.UNDEFINED));
                        } else {
                            entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + stock + ") " + (Object)((Object)TaxStatementReportOperator.UNDEFINED) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", balance) + " * " + (Object)((Object)TaxStatementReportOperator.UNDEFINED));
                        }
                    } else if (currency != null && !currency.equals("CHF") && balance != null && balance < 0.0) {
                        if (TaxStatementReportProperty.EXCHANGE_RATE) {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + stock + ") " + (Object)((Object)TaxStatementReportOperator.UNDEFINED) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", balance) + " * " + (Object)((Object)TaxStatementReportOperator.UNDEFINED));
                        } else {
                            entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + stock + ") " + (Object)((Object)TaxStatementReportOperator.UNDEFINED) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", balance) + " * " + (Object)((Object)TaxStatementReportOperator.UNDEFINED));
                        }
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++stock;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute18(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(18, this.getStepDescription(lang, 18), this.getStepCondition(lang, 18));
        int stock = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int stocks = TaxStatementReportSecurityData.getStockCount(doc, i, j);
                while (k <= stocks) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getStockReferenceDate(doc, i, j, k));
                    String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                    String currency = TaxStatementReportSecurityData.getStockBalanceCurrency(doc, i, j, k);
                    Double quantity = TaxStatementReportSecurityData.getStockQuantity(doc, i, j, k);
                    Double balance = TaxStatementReportSecurityData.getStockBalance(doc, i, j, k);
                    Double exchangeRate = TaxStatementReportSecurityData.getStockExchangeRate(doc, i, j, k);
                    Double value = TaxStatementReportSecurityData.getStockValue(doc, i, j, k);
                    Double valueCalc = null;
                    if (currency != null && !currency.equals("CHF") && balance != null && exchangeRate != null) {
                        valueCalc = balance * exchangeRate;
                    }
                    if (quantity != null && quantity == 0.0 && value == null && balance == null) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (currency != null && !currency.equals("CHF")) {
                        if (String.format("%1$,.2f", value).equals(String.format("%1$,.2f", valueCalc))) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + stock + ") " + String.format("%1$,.2f", value));
                        } else if (TaxStatementReportUtil.approximately(value, valueCalc, 0.0499999999).booleanValue()) {
                            entity.setResult(TaxStatementReportResult.OK).setReason("(" + stock + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.APPROXIMATELY) + " " + String.format("%1$,.2f", valueCalc));
                        } else if (TaxStatementReportUtil.approximately(value, valueCalc, 0.9999999999).booleanValue() && currency != null && (currency.equals("JPY") || currency.equals("TRY"))) {
                            entity.setResult(TaxStatementReportResult.OK).setReason("(" + stock + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.APPROXIMATELY) + " " + String.format("%1$,.2f", valueCalc));
                        } else if (value != null && valueCalc != null) {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + stock + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", valueCalc));
                        } else if (balance != null && balance > 0.0) {
                            if (TaxStatementReportProperty.EXCHANGE_RATE) {
                                entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + stock + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", balance) + " * " + (Object)((Object)TaxStatementReportOperator.UNDEFINED));
                            } else {
                                entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + stock + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", balance) + " * " + (Object)((Object)TaxStatementReportOperator.UNDEFINED));
                            }
                        } else if (balance != null && balance < 0.0) {
                            if (TaxStatementReportProperty.EXCHANGE_RATE) {
                                entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + stock + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", balance) + " * " + (Object)((Object)TaxStatementReportOperator.UNDEFINED));
                            } else {
                                entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + stock + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", balance) + " * " + (Object)((Object)TaxStatementReportOperator.UNDEFINED));
                            }
                        } else {
                            entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                        }
                    } else {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++stock;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute19(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(19, this.getStepDescription(lang, 19), this.getStepCondition(lang, 19));
        int stock = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int stocks = TaxStatementReportSecurityData.getStockCount(doc, i, j);
                while (k <= stocks) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getStockReferenceDate(doc, i, j, k));
                    Boolean blocked = TaxStatementReportSecurityData.getStockBlocked(doc, i, j, k);
                    Date blockingTo = TaxStatementReportSecurityData.getStockBlockingTo(doc, i, j, k);
                    if (!blocked.booleanValue() && blockingTo == null) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + stock + ") " + blocked);
                    } else if (blocked.booleanValue() && blockingTo != null) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + stock + ") " + blocked);
                    } else if (blocked.booleanValue() && blockingTo == null) {
                        entity.setResult(TaxStatementReportResult.IGNORE).setRemark("(" + stock + ") " + blocked);
                    } else if (!blocked.booleanValue() && blockingTo != null) {
                        entity.setResult(TaxStatementReportResult.ERROR).setRemark("(" + stock + ") " + blocked + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + (blocked == false));
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++stock;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute20(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(20, this.getStepDescription(lang, 20), this.getStepCondition(lang, 20));
        int stock = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int stocks = TaxStatementReportSecurityData.getStockCount(doc, i, j);
                while (k <= stocks) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getStockReferenceDate(doc, i, j, k));
                    Boolean blocked = TaxStatementReportSecurityData.getStockBlocked(doc, i, j, k);
                    Date blockingTo = TaxStatementReportSecurityData.getStockBlockingTo(doc, i, j, k);
                    if (blockingTo != null) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + stock + ") " + new SimpleDateFormat("dd.MM.yyyy").format(blockingTo));
                    } else if (blocked.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE).setRemark("(" + stock + ") " + (Object)((Object)TaxStatementReportOperator.UNDEFINED));
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++stock;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute21(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(21, this.getStepDescription(lang, 21), this.getStepCondition(lang, 21));
        int stock = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int stocks = TaxStatementReportSecurityData.getStockCount(doc, i, j);
                while (k <= stocks) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getStockReferenceDate(doc, i, j, k));
                    Date periodFrom = TaxStatementReportSchemaData.getPeriodFrom(doc);
                    Date referenceDate = TaxStatementReportSecurityData.getStockReferenceDate(doc, i, j, k);
                    Boolean mutation = TaxStatementReportSecurityData.getStockMutation(doc, i, j, k);
                    if (k == 1) {
                        if (mutation.booleanValue()) {
                            entity.setResult(TaxStatementReportResult.IGNORE).setRemark("(" + stock + ") " + new SimpleDateFormat("dd.MM.yyyy").format(referenceDate));
                        } else if (periodFrom != null && referenceDate != null && periodFrom.equals(referenceDate)) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + stock + ") " + new SimpleDateFormat("dd.MM.yyyy").format(referenceDate));
                        } else if (periodFrom != null && referenceDate != null && periodFrom.after(referenceDate)) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + stock + ") " + new SimpleDateFormat("dd.MM.yyyy").format(referenceDate));
                        } else {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + stock + ") " + new SimpleDateFormat("dd.MM.yyyy").format(referenceDate) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + new SimpleDateFormat("dd.MM.yyyy").format(periodFrom));
                        }
                    } else {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++stock;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute22(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(22, this.getStepDescription(lang, 22), this.getStepCondition(lang, 22));
        int stock = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int f = 0;
                int k = 1;
                int stocks = TaxStatementReportSecurityData.getStockCount(doc, i, j);
                while (k <= stocks) {
                    if (f == 0) {
                        f = k;
                    } else {
                        Date referenceDate = TaxStatementReportSecurityData.getStockReferenceDate(doc, i, j, k);
                        Date firstDate = TaxStatementReportSecurityData.getStockReferenceDate(doc, i, j, f);
                        if (referenceDate != null && firstDate != null && referenceDate.before(firstDate)) {
                            f = k;
                        }
                    }
                    ++k;
                    ++stock;
                }
                k = 1;
                stocks = TaxStatementReportSecurityData.getStockCount(doc, i, j);
                while (k <= stocks) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getStockReferenceDate(doc, i, j, k));
                    String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                    String name = TaxStatementReportSecurityData.getStockName(doc, i, j, k);
                    Double quantity = TaxStatementReportSecurityData.getStockQuantity(doc, i, j, k);
                    Boolean mutation = TaxStatementReportSecurityData.getStockMutation(doc, i, j, k);
                    if (k == f) {
                        if (mutation.booleanValue() && quantity >= 0.0) {
                            entity.setResult(TaxStatementReportResult.IGNORE).setRemark("(" + stock + ") " + String.format("%1$,.2f", quantity));
                        } else if (quantity != null && quantity >= 0.0) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + stock + ") " + String.format("%1$,.2f", quantity));
                        } else if (quantity < 0.0 && category != null && (category.equals("OPTION") || category.equals("OTHER"))) {
                            entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + stock + ") " + String.format("%1$,.2f", quantity) + " " + (Object)((Object)TaxStatementReportOperator.NOTGREATEREQUAL) + " " + String.format("%1$,.2f", 0.0));
                        } else if (quantity < 0.0 && category != null && category.equals("SHARE")) {
                            entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + stock + ") " + String.format("%1$,.2f", quantity) + " " + (Object)((Object)TaxStatementReportOperator.NOTGREATEREQUAL) + " " + String.format("%1$,.2f", 0.0));
                        } else {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + stock + ") " + String.format("%1$,.2f", quantity) + " " + (Object)((Object)TaxStatementReportOperator.NOTGREATEREQUAL) + " " + String.format("%1$,.2f", 0.0));
                        }
                    } else {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++stock;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute23(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(23, this.getStepDescription(lang, 23), this.getStepCondition(lang, 23));
        int stock = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int l = 0;
                int k = 1;
                int stocks = TaxStatementReportSecurityData.getStockCount(doc, i, j);
                while (k <= stocks) {
                    if (l == 0) {
                        l = k;
                    } else {
                        Date referenceDate = TaxStatementReportSecurityData.getStockReferenceDate(doc, i, j, k);
                        Date lastDate = TaxStatementReportSecurityData.getStockReferenceDate(doc, i, j, l);
                        if (referenceDate != null && lastDate != null && referenceDate.after(lastDate)) {
                            l = k;
                        }
                    }
                    ++k;
                    ++stock;
                }
                k = 1;
                stocks = TaxStatementReportSecurityData.getStockCount(doc, i, j);
                while (k <= stocks) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getStockReferenceDate(doc, i, j, k));
                    Date periodTo = TaxStatementReportSchemaData.getPeriodTo(doc);
                    Date referenceDate = TaxStatementReportSecurityData.getStockReferenceDate(doc, i, j, k);
                    Boolean mutation = TaxStatementReportSecurityData.getStockMutation(doc, i, j, k);
                    if (k == l) {
                        if (mutation != null && mutation.booleanValue()) {
                            entity.setResult(TaxStatementReportResult.IGNORE).setRemark("(" + stock + ") " + new SimpleDateFormat("dd.MM.yyyy").format(referenceDate));
                        } else if (periodTo != null && referenceDate != null && periodTo.equals(referenceDate)) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + stock + ") " + new SimpleDateFormat("dd.MM.yyyy").format(referenceDate));
                        } else if (k == 1) {
                            entity.setResult(TaxStatementReportResult.IGNORE).setRemark("(" + stock + ") " + new SimpleDateFormat("dd.MM.yyyy").format(referenceDate));
                        } else {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + stock + ") " + new SimpleDateFormat("dd.MM.yyyy").format(referenceDate) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + new SimpleDateFormat("dd.MM.yyyy").format(periodTo));
                        }
                    } else {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++stock;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute24(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(24, this.getStepDescription(lang, 24), this.getStepCondition(lang, 24));
        int stock = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int stocks = TaxStatementReportSecurityData.getStockCount(doc, i, j);
                while (k <= stocks) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getStockReferenceDate(doc, i, j, k));
                    String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                    Double quantity = TaxStatementReportSecurityData.getStockQuantity(doc, i, j, k);
                    Boolean mutation = TaxStatementReportSecurityData.getStockMutation(doc, i, j, k);
                    if (k == stocks) {
                        if (mutation != null && mutation.booleanValue()) {
                            entity.setResult(TaxStatementReportResult.IGNORE).setRemark("(" + stock + ") " + String.format("%1$,.2f", quantity));
                        } else if (quantity != null && quantity >= 0.0) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + stock + ") " + String.format("%1$,.2f", quantity));
                        } else if (quantity != null && quantity < 0.0 && category != null && (category.equals("OPTION") || category.equals("OTHER"))) {
                            entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + stock + ") " + String.format("%1$,.2f", quantity) + " " + (Object)((Object)TaxStatementReportOperator.NOTGREATEREQUAL) + " " + String.format("%1$,.2f", 0.0));
                        } else if (quantity != null && quantity < 0.0 && category != null && category.equals("SHARE")) {
                            entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + stock + ") " + String.format("%1$,.2f", quantity) + " " + (Object)((Object)TaxStatementReportOperator.NOTGREATEREQUAL) + " " + String.format("%1$,.2f", 0.0));
                        } else {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + stock + ") " + String.format("%1$,.2f", quantity) + " " + (Object)((Object)TaxStatementReportOperator.NOTGREATEREQUAL) + " " + String.format("%1$,.2f", 0.0));
                        }
                    } else {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++stock;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute25(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(25, this.getStepDescription(lang, 25), this.getStepCondition(lang, 25));
        int stock = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                Double quantityCalc = 0.0;
                int k = 1;
                int stocks = TaxStatementReportSecurityData.getStockCount(doc, i, j);
                while (k <= stocks) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getStockReferenceDate(doc, i, j, k));
                    Double quantity = TaxStatementReportSecurityData.getStockQuantity(doc, i, j, k);
                    Boolean mutation = TaxStatementReportSecurityData.getStockMutation(doc, i, j, k);
                    if (quantity != null) {
                        quantityCalc = mutation != null && mutation != false ? Double.valueOf(quantityCalc + quantity) : quantity;
                    }
                    if (k == stocks) {
                        if (mutation != null && mutation.booleanValue()) {
                            entity.setResult(TaxStatementReportResult.IGNORE).setRemark("(" + stock + ") " + String.format("%1$,.2f", quantityCalc));
                        } else if (String.format("%1$,.2f", quantity).equals(String.format("%1$,.2f", quantityCalc))) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + stock + ") " + String.format("%1$,.2f", quantity));
                        } else {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + stock + ") " + String.format("%1$,.2f", quantity) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", quantityCalc));
                        }
                    } else {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++stock;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    @Override
    public TaxStatementReportResultCase execute(Document doc, byte[] xml, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultCase cs = new TaxStatementReportResultCase(this.getCaseGroup(), this.getCaseId(), this.getCaseGroup(lang), this.getCaseName(lang), this.getCaseDescription(lang));
        TaxStatementReportResult[][] ok = new TaxStatementReportResult[][]{new TaxStatementReportResult[0], {TaxStatementReportResult.ERROR, TaxStatementReportResult.OK, TaxStatementReportResult.OK, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, TaxStatementReportResult.ERROR, TaxStatementReportResult.OK, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null, TaxStatementReportResult.OK, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null, TaxStatementReportResult.OK, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null, TaxStatementReportResult.OK, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null, TaxStatementReportResult.OK, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null, null, null, null}, {null, null, TaxStatementReportResult.OK, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null, TaxStatementReportResult.OK, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null, TaxStatementReportResult.OK, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null, null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null, null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null, null, null, TaxStatementReportResult.OK}, {null, null, null, null, null}, {null, null, null, null, TaxStatementReportResult.OK}, {null, null, null, null, null}, {null, null, null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null, null, null, TaxStatementReportResult.OK}, {null, null, null, null, null}, {null, null, null, null, null}, {null, null, null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null, null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null, null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null, null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null, null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}};
        cs.addStepResultOptional(ok[1], this.execute01(doc, lang, formula));
        cs.addStepResultOptional(ok[2], this.execute02(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getSecurityCount(doc) > 0));
        cs.addStepResultMandatory(ok[3], this.execute03(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getSecurityCount(doc) > 0));
        cs.addStepResultMandatory(ok[4], this.execute04(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getSecurityCount(doc) > 0));
        cs.addStepResultMandatory(ok[5], this.execute05(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getStockCount(doc) > 0));
        cs.addStepResultMandatory(ok[6], this.execute06(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getStockCount(doc) > 0));
        cs.addStepResultOptional(ok[7], this.execute07(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getStockCount(doc) > 0 && TaxStatementReportSecurityData.getStockName(doc)));
        cs.addStepResultMandatory(ok[8], this.execute08(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getStockCount(doc) > 0));
        cs.addStepResultMandatory(ok[9], this.execute09(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getStockCount(doc) > 0));
        cs.addStepResultMandatory(ok[10], this.execute10(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getStockCount(doc) > 0));
        cs.addStepResultOptional(ok[11], this.execute11(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getStockCount(doc) > 0 && TaxStatementReportSecurityData.getStockUnitPrice(doc)));
        cs.addStepResultOptional(ok[12], this.execute12(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getStockCount(doc) > 0 && TaxStatementReportSecurityData.getStockBalance(doc)));
        cs.addStepResultOptional(ok[13], this.execute13(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getStockCount(doc) > 0 && TaxStatementReportSecurityData.getStockUnitPrice(doc)));
        cs.addStepResultOptional(ok[14], this.execute14(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getStockCount(doc) > 0 && TaxStatementReportSecurityData.getStockReductionCost(doc)));
        cs.addStepResultOptional(ok[15], this.execute15(doc, lang, formula, TaxStatementReportSecurityData.getStockCount(doc) > 0 && TaxStatementReportSecurityData.getStockBalanceCurrency(doc) && TaxStatementReportSecurityData.getStockBalance(doc)));
        cs.addStepResultOptional(ok[16], this.execute16(doc, lang, formula, TaxStatementReportSecurityData.getStockCount(doc) > 0 && TaxStatementReportSecurityData.getStockExchangeRate(doc)));
        cs.addStepResultOptional(ok[17], this.execute17(doc, lang, formula, TaxStatementReportSecurityData.getStockCount(doc) > 0 && TaxStatementReportSecurityData.getStockValue(doc)));
        cs.addStepResultOptional(ok[18], this.execute18(doc, lang, formula, TaxStatementReportSecurityData.getStockCount(doc) > 0 && TaxStatementReportSecurityData.getStockBalance(doc)));
        cs.addStepResultOptional(ok[19], this.execute19(doc, lang, formula, TaxStatementReportSecurityData.getStockCount(doc) > 0));
        cs.addStepResultOptional(ok[20], this.execute20(doc, lang, formula, TaxStatementReportSecurityData.getStockCount(doc) > 0 && TaxStatementReportSecurityData.getStockBlockingTo(doc)));
        cs.addStepResultMandatory(ok[21], this.execute21(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getStockCount(doc) > 0));
        cs.addStepResultMandatory(ok[22], this.execute22(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getStockCount(doc) > 0));
        cs.addStepResultMandatory(ok[23], this.execute23(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getStockCount(doc) > 0));
        cs.addStepResultMandatory(ok[24], this.execute24(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getStockCount(doc) > 0));
        cs.addStepResultMandatory(ok[25], this.execute25(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getStockCount(doc) > 0));
        return cs;
    }

    public TaxStatementReportSecurityCase04() {
        super("SECURITY_CASE", 4);
    }
}

