/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.report;

import ch.ewv.taxstatement.report.TaxStatementReportCase;
import ch.ewv.taxstatement.report.TaxStatementReportFormula;
import ch.ewv.taxstatement.report.TaxStatementReportOperator;
import ch.ewv.taxstatement.report.TaxStatementReportProperty;
import ch.ewv.taxstatement.report.TaxStatementReportResult;
import ch.ewv.taxstatement.report.TaxStatementReportResultCase;
import ch.ewv.taxstatement.report.TaxStatementReportResultEntity;
import ch.ewv.taxstatement.report.TaxStatementReportResultStep;
import ch.ewv.taxstatement.report.TaxStatementReportSecurityData;
import ch.ewv.taxstatement.report.TaxStatementReportUtil;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class TaxStatementReportSecurityCase02
extends TaxStatementReportCase {
    protected TaxStatementReportResultStep execute01(Document doc, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeExist(1, this.getStepDescription(lang, 1), this.getStepCondition(lang, 1), false, TaxStatementReportSecurityData.getTotalTaxValue(doc));
    }

    protected TaxStatementReportResultStep execute02(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeCount(2, this.getStepDescription(lang, 2), this.getStepCondition(lang, 2), filter, TaxStatementReportSecurityData.getSecurityCount(doc));
    }

    protected TaxStatementReportResultStep execute03(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(3, this.getStepDescription(lang, 3), this.getStepCondition(lang, 3));
        int security = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int j = 1;
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            while (j <= securities) {
                int taxValues = TaxStatementReportSecurityData.getTaxValueCount(doc, i, j);
                for (int k = 1; k <= taxValues; ++k) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getTaxValueReferenceDate(doc, i, j, k));
                    String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                    if (category != null) {
                        if (category.equals("BOND") || category.equals("COINBULL") || category.equals("CURRNOTE") || category.equals("DEVT") || category.equals("FUND") || category.equals("LIBOSWAP") || category.equals("OPTION") || category.equals("SHARE") || category.equals("OTHER")) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + category);
                        } else {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + category);
                        }
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                }
                ++j;
                ++security;
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute04(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(4, this.getStepDescription(lang, 4), this.getStepCondition(lang, 4));
        int security = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int j = 1;
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            while (j <= securities) {
                Boolean lendingFee = TaxStatementReportSecurityData.getPaymentLendingFee(doc, i, j);
                Boolean retrocession = TaxStatementReportSecurityData.getPaymentRetrocession(doc, i, j);
                int taxValues = TaxStatementReportSecurityData.getTaxValueCount(doc, i, j);
                if (taxValues == 0 && (lendingFee != null && lendingFee.booleanValue() || retrocession != null && retrocession.booleanValue())) {
                    taxValues = 1;
                }
                for (int k = 1; k <= taxValues; ++k) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getTaxValueReferenceDate(doc, i, j, k));
                    Boolean undefined = TaxStatementReportSecurityData.getTaxValueUndefined(doc, i, j, k);
                    Double quantity = TaxStatementReportSecurityData.getTaxValueQuantity(doc, i, j, k);
                    Double balance = TaxStatementReportSecurityData.getTaxValueBalance(doc, i, j, k);
                    Double value = TaxStatementReportSecurityData.getTaxValueValue(doc, i, j, k);
                    if (lendingFee != null && lendingFee.booleanValue() || retrocession != null && retrocession.booleanValue()) {
                        if (value != null && value >= 0.0) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + (undefined == false));
                        } else {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + (undefined == false));
                        }
                    } else if (!undefined.booleanValue()) {
                        if (value != null || balance != null) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + (undefined == false));
                        } else if (quantity != null && quantity == 0.0 && value == null && balance == null) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + (undefined == false));
                        } else {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + (undefined == false) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", TaxStatementReportUtil.nvl(value, balance)));
                        }
                    } else if (value == null && balance == null) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + (undefined == false));
                    } else if (value != null && value == 0.0 && balance != null && balance == 0.0) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + (undefined == false));
                    } else {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + (undefined == false) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", TaxStatementReportUtil.nvl(value, balance)));
                    }
                    step.addEntity(entity);
                }
                ++j;
                ++security;
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute05(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(5, this.getStepDescription(lang, 5), this.getStepCondition(lang, 5));
        int security = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int j = 1;
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            while (j <= securities) {
                int taxValues = TaxStatementReportSecurityData.getTaxValueCount(doc, i, j);
                for (int k = 1; k <= taxValues; ++k) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getTaxValueReferenceDate(doc, i, j, k));
                    Date referenceDate = TaxStatementReportSecurityData.getTaxValueReferenceDate(doc, i, j, k);
                    if (referenceDate != null) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + new SimpleDateFormat("dd.MM.yyyy").format(referenceDate));
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                }
                ++j;
                ++security;
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute06(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(6, this.getStepDescription(lang, 6), this.getStepCondition(lang, 6));
        int security = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int j = 1;
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            while (j <= securities) {
                int taxValues = TaxStatementReportSecurityData.getTaxValueCount(doc, i, j);
                for (int k = 1; k <= taxValues; ++k) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getTaxValueReferenceDate(doc, i, j, k));
                    String name = TaxStatementReportSecurityData.getTaxValueName(doc, i, j, k);
                    if (name != null) {
                        if (name.length() >= 0 && name.length() <= 200) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + name);
                        } else if (name.length() > 200) {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + name.length() + " " + (Object)((Object)TaxStatementReportOperator.GREATER) + " 200");
                        } else {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + name);
                        }
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                }
                ++j;
                ++security;
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute07(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(7, this.getStepDescription(lang, 7), this.getStepCondition(lang, 7));
        int security = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int j = 1;
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            while (j <= securities) {
                int taxValues = TaxStatementReportSecurityData.getTaxValueCount(doc, i, j);
                for (int k = 1; k <= taxValues; ++k) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getTaxValueReferenceDate(doc, i, j, k));
                    String quotationType = TaxStatementReportSecurityData.getTaxValueQuotationType(doc, i, j, k);
                    if (quotationType != null) {
                        if (quotationType.equals("PERCENT") || quotationType.equals("PIECE")) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + quotationType);
                        } else {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + quotationType);
                        }
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                }
                ++j;
                ++security;
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute08(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(8, this.getStepDescription(lang, 8), this.getStepCondition(lang, 8));
        int security = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int j = 1;
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            while (j <= securities) {
                int taxValues = TaxStatementReportSecurityData.getTaxValueCount(doc, i, j);
                for (int k = 1; k <= taxValues; ++k) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getTaxValueReferenceDate(doc, i, j, k));
                    String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                    Double quantity = TaxStatementReportSecurityData.getTaxValueQuantity(doc, i, j, k);
                    if (quantity != null) {
                        if (quantity >= 0.0) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + String.format("%1$,.2f", quantity));
                        } else if (quantity < 0.0 && category != null && (category.equals("OPTION") || category.equals("OTHER"))) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + String.format("%1$,.2f", quantity));
                        } else if (quantity < 0.0 && category != null && category.equals("SHARE")) {
                            entity.setResult(TaxStatementReportResult.IGNORE).setRemark("(" + security + ") " + String.format("%1$,.2f", quantity));
                        } else {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + String.format("%1$,.2f", quantity));
                        }
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                }
                ++j;
                ++security;
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute09(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(9, this.getStepDescription(lang, 9), this.getStepCondition(lang, 9));
        int security = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int j = 1;
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            while (j <= securities) {
                int taxValues = TaxStatementReportSecurityData.getTaxValueCount(doc, i, j);
                for (int k = 1; k <= taxValues; ++k) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getTaxValueReferenceDate(doc, i, j, k));
                    String currency = TaxStatementReportSecurityData.getTaxValueBalanceCurrency(doc, i, j, k);
                    if (currency != null) {
                        if (currency.length() == 3 && currency.charAt(0) >= 'A' && currency.charAt(0) <= 'Z' && currency.charAt(1) >= 'A' && currency.charAt(1) <= 'Z' && currency.charAt(2) >= 'A' && currency.charAt(2) <= 'Z') {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + currency);
                        } else {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + currency);
                        }
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                }
                ++j;
                ++security;
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute10(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(10, this.getStepDescription(lang, 10), this.getStepCondition(lang, 10));
        int security = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int j = 1;
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            while (j <= securities) {
                int taxValues = TaxStatementReportSecurityData.getTaxValueCount(doc, i, j);
                for (int k = 1; k <= taxValues; ++k) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getTaxValueReferenceDate(doc, i, j, k));
                    String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                    Boolean undefined = TaxStatementReportSecurityData.getTaxValueUndefined(doc, i, j, k);
                    Double quantity = TaxStatementReportSecurityData.getTaxValueQuantity(doc, i, j, k);
                    String quotationType = TaxStatementReportSecurityData.getTaxValueQuotationType(doc, i, j, k);
                    Double unitPrice = TaxStatementReportSecurityData.getTaxValueUnitPrice(doc, i, j, k);
                    Double value = TaxStatementReportSecurityData.getTaxValueValue(doc, i, j, k);
                    if (undefined.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (unitPrice != null) {
                        if (unitPrice > 0.0) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + String.format("%1$,.2f", unitPrice) + (quotationType != null && quotationType.equals("PERCENT") ? "%" : ""));
                        } else if (unitPrice < 0.0 && category != null && (category.equals("OPTION") || category.equals("OTHER"))) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + String.format("%1$,.2f", unitPrice) + (quotationType != null && quotationType.equals("PERCENT") ? "%" : ""));
                        } else if (unitPrice < 0.0 && category != null && category.equals("SHARE")) {
                            entity.setResult(TaxStatementReportResult.IGNORE).setRemark("(" + security + ") " + String.format("%1$,.2f", unitPrice) + (quotationType != null && quotationType.equals("PERCENT") ? "%" : ""));
                        } else if (unitPrice == 0.0 && category != null && (category.equals("BOND") || category.equals("DEVT") || category.equals("OPTION") || category.equals("OTHER"))) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + String.format("%1$,.2f", unitPrice) + (quotationType != null && quotationType.equals("PERCENT") ? "%" : ""));
                        } else if (unitPrice == 0.0 && value != null && value == 0.0 && quantity != null && quantity >= 0.0) {
                            entity.setResult(TaxStatementReportResult.IGNORE).setRemark("(" + security + ") " + String.format("%1$,.2f", unitPrice) + (quotationType != null && quotationType.equals("PERCENT") ? "%" : ""));
                        } else {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + String.format("%1$,.2f", unitPrice) + (quotationType != null && quotationType.equals("PERCENT") ? "%" : ""));
                        }
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                }
                ++j;
                ++security;
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute11(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(11, this.getStepDescription(lang, 11), this.getStepCondition(lang, 11));
        int security = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int j = 1;
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            while (j <= securities) {
                int taxValues = TaxStatementReportSecurityData.getTaxValueCount(doc, i, j);
                for (int k = 1; k <= taxValues; ++k) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getTaxValueReferenceDate(doc, i, j, k));
                    Boolean blocked = TaxStatementReportSecurityData.getTaxValueBlocked(doc, i, j, k);
                    Date blockingTo = TaxStatementReportSecurityData.getTaxValueBlockingTo(doc, i, j, k);
                    if (!blocked.booleanValue() && blockingTo == null) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + blocked);
                    } else if (blocked.booleanValue() && blockingTo != null) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + blocked);
                    } else if (blocked.booleanValue() && blockingTo == null) {
                        entity.setResult(TaxStatementReportResult.IGNORE).setRemark("(" + security + ") " + blocked);
                    } else if (!blocked.booleanValue() && blockingTo != null) {
                        entity.setResult(TaxStatementReportResult.ERROR).setRemark("(" + security + ") " + blocked + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + (blocked == false));
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                }
                ++j;
                ++security;
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute12(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(12, this.getStepDescription(lang, 12), this.getStepCondition(lang, 12));
        int security = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int j = 1;
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            while (j <= securities) {
                int taxValues = TaxStatementReportSecurityData.getTaxValueCount(doc, i, j);
                for (int k = 1; k <= taxValues; ++k) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getTaxValueReferenceDate(doc, i, j, k));
                    Boolean blocked = TaxStatementReportSecurityData.getTaxValueBlocked(doc, i, j, k);
                    Date blockingTo = TaxStatementReportSecurityData.getTaxValueBlockingTo(doc, i, j, k);
                    if (blockingTo != null) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + new SimpleDateFormat("dd.MM.yyyy").format(blockingTo));
                    } else if (blocked.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE).setRemark("(" + security + ") " + (Object)((Object)TaxStatementReportOperator.UNDEFINED));
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                }
                ++j;
                ++security;
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute13(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(13, this.getStepDescription(lang, 13), this.getStepCondition(lang, 13));
        int security = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int j = 1;
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            while (j <= securities) {
                int taxValues = TaxStatementReportSecurityData.getTaxValueCount(doc, i, j);
                for (int k = 1; k <= taxValues; ++k) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getTaxValueReferenceDate(doc, i, j, k));
                    String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                    Boolean undefined = TaxStatementReportSecurityData.getTaxValueUndefined(doc, i, j, k);
                    String currency = TaxStatementReportSecurityData.getTaxValueBalanceCurrency(doc, i, j, k);
                    Double balance = TaxStatementReportSecurityData.getTaxValueBalance(doc, i, j, k);
                    if (undefined.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (currency != null && !currency.equals("CHF") && balance != null && balance >= 0.0) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + String.format("%1$,.2f", balance));
                    } else if (currency != null && !currency.equals("CHF") && balance != null && balance < 0.0 && category != null && (category.equals("OPTION") || category.equals("OTHER"))) {
                        entity.setResult(TaxStatementReportResult.OK).setReason("(" + security + ") " + String.format("%1$,.2f", balance));
                    } else if (currency != null && !currency.equals("CHF") && balance != null && balance < 0.0 && category != null && category.equals("SHARE")) {
                        entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + security + ") " + String.format("%1$,.2f", balance));
                    } else if (currency != null && !currency.equals("CHF") && balance != null && balance < 0.0) {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + String.format("%1$,.2f", balance));
                    } else if (currency != null && currency.equals("CHF") && balance != null && balance >= 0.0) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + String.format("%1$,.2f", balance));
                    } else if (currency != null && currency.equals("CHF") && balance != null && balance < 0.0 && category != null && (category.equals("OPTION") || category.equals("OTHER"))) {
                        entity.setResult(TaxStatementReportResult.OK).setReason("(" + security + ") " + String.format("%1$,.2f", balance));
                    } else if (currency != null && currency.equals("CHF") && balance != null && balance < 0.0 && category != null && category.equals("SHARE")) {
                        entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + security + ") " + String.format("%1$,.2f", balance));
                    } else if (currency != null && currency.equals("CHF") && balance != null && balance < 0.0) {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + String.format("%1$,.2f", balance));
                    } else if (currency != null && currency.equals("CHF") && balance == null) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + String.format("%1$,.2f", balance));
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                }
                ++j;
                ++security;
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute14(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(14, this.getStepDescription(lang, 14), this.getStepCondition(lang, 14));
        int security = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int j = 1;
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            while (j <= securities) {
                int taxValues = TaxStatementReportSecurityData.getTaxValueCount(doc, i, j);
                for (int k = 1; k <= taxValues; ++k) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getTaxValueReferenceDate(doc, i, j, k));
                    String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                    Boolean undefined = TaxStatementReportSecurityData.getTaxValueUndefined(doc, i, j, k);
                    String quotationType = TaxStatementReportSecurityData.getTaxValueQuotationType(doc, i, j, k);
                    Double quantity = TaxStatementReportSecurityData.getTaxValueQuantity(doc, i, j, k);
                    Double unitPrice = TaxStatementReportSecurityData.getTaxValueUnitPrice(doc, i, j, k);
                    String currency = TaxStatementReportSecurityData.getTaxValueBalanceCurrency(doc, i, j, k);
                    Double balance = TaxStatementReportSecurityData.getTaxValueBalance(doc, i, j, k);
                    Double balanceCalc = null;
                    if (quantity != null && unitPrice != null) {
                        balanceCalc = quotationType != null && quotationType.equals("PERCENT") ? Double.valueOf(quantity * unitPrice / 100.0) : Double.valueOf(quantity * unitPrice);
                    }
                    if (undefined.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (balance != null && balanceCalc != null) {
                        if (String.format("%1$,.2f", balance).equals(String.format("%1$,.2f", balanceCalc))) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + String.format("%1$,.2f", balance));
                        } else if (TaxStatementReportUtil.approximately(balance, balanceCalc, 0.0499999999).booleanValue()) {
                            entity.setResult(TaxStatementReportResult.OK).setReason("(" + security + ") " + String.format("%1$,.2f", balance) + " " + (Object)((Object)TaxStatementReportOperator.APPROXIMATELY) + " " + String.format("%1$,.2f", balanceCalc));
                        } else if (TaxStatementReportUtil.approximately(balance, balanceCalc, 0.4999999999).booleanValue() && currency != null && (currency.equals("JPY") || currency.equals("TRY"))) {
                            entity.setResult(TaxStatementReportResult.OK).setReason("(" + security + ") " + String.format("%1$,.2f", balance) + " " + (Object)((Object)TaxStatementReportOperator.APPROXIMATELY) + " " + String.format("%1$,.2f", balanceCalc));
                        } else if (category != null && (category.equals("OPTION") || category.equals("OTHER"))) {
                            entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + security + ") " + String.format("%1$,.2f", balance) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", balanceCalc));
                        } else {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + String.format("%1$,.2f", balance) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", balanceCalc));
                        }
                    } else if (balanceCalc != null) {
                        entity.setResult(TaxStatementReportResult.IGNORE).setRemark("(" + security + ") " + (Object)((Object)TaxStatementReportOperator.UNDEFINED) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", balanceCalc));
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                }
                ++j;
                ++security;
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute15(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(15, this.getStepDescription(lang, 15), this.getStepCondition(lang, 15));
        int security = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int j = 1;
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            while (j <= securities) {
                int taxValues = TaxStatementReportSecurityData.getTaxValueCount(doc, i, j);
                for (int k = 1; k <= taxValues; ++k) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getTaxValueReferenceDate(doc, i, j, k));
                    Boolean undefined = TaxStatementReportSecurityData.getTaxValueUndefined(doc, i, j, k);
                    String currency = TaxStatementReportSecurityData.getTaxValueBalanceCurrency(doc, i, j, k);
                    Double quantity = TaxStatementReportSecurityData.getTaxValueQuantity(doc, i, j, k);
                    Double balance = TaxStatementReportSecurityData.getTaxValueBalance(doc, i, j, k);
                    Double exchangeRate = TaxStatementReportSecurityData.getTaxValueExchangeRate(doc, i, j, k);
                    Double value = TaxStatementReportSecurityData.getTaxValueValue(doc, i, j, k);
                    if (undefined.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (quantity != null && quantity == 0.0 && exchangeRate == null) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (balance != null && balance == 0.0 && exchangeRate == null) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (quantity != null && quantity == 0.0 && value == null && balance == null) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (currency != null && !currency.equals("CHF") && exchangeRate != null) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + String.format("%1$,.5f", exchangeRate));
                    } else if (currency != null && !currency.equals("CHF") && balance != null && exchangeRate == null) {
                        if (TaxStatementReportProperty.EXCHANGE_RATE) {
                            entity.setResult(TaxStatementReportResult.ERROR);
                        } else {
                            entity.setResult(TaxStatementReportResult.IGNORE);
                        }
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                }
                ++j;
                ++security;
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute16(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(16, this.getStepDescription(lang, 16), this.getStepCondition(lang, 16));
        int security = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int j = 1;
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            while (j <= securities) {
                int taxValues = TaxStatementReportSecurityData.getTaxValueCount(doc, i, j);
                for (int k = 1; k <= taxValues; ++k) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getTaxValueReferenceDate(doc, i, j, k));
                    Boolean undefined = TaxStatementReportSecurityData.getTaxValueUndefined(doc, i, j, k);
                    String currency = TaxStatementReportSecurityData.getTaxValueBalanceCurrency(doc, i, j, k);
                    Double exchangeRate = TaxStatementReportSecurityData.getTaxValueExchangeRate(doc, i, j, k);
                    if (undefined.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (currency != null && !currency.equals("CHF") && exchangeRate != null) {
                        entity.setResult(TaxStatementReportResult.SELECT);
                    } else if (currency != null && currency.equals("CHF")) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (TaxStatementReportProperty.EXCHANGE_RATE) {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    } else {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                }
                ++j;
                ++security;
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute17(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(17, this.getStepDescription(lang, 17), this.getStepCondition(lang, 17));
        int security = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int j = 1;
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            while (j <= securities) {
                int taxValues = TaxStatementReportSecurityData.getTaxValueCount(doc, i, j);
                for (int k = 1; k <= taxValues; ++k) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getTaxValueReferenceDate(doc, i, j, k));
                    String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                    Boolean undefined = TaxStatementReportSecurityData.getTaxValueUndefined(doc, i, j, k);
                    String currency = TaxStatementReportSecurityData.getTaxValueBalanceCurrency(doc, i, j, k);
                    Double quantity = TaxStatementReportSecurityData.getTaxValueQuantity(doc, i, j, k);
                    Double balance = TaxStatementReportSecurityData.getTaxValueBalance(doc, i, j, k);
                    Double exchangeRate = TaxStatementReportSecurityData.getTaxValueExchangeRate(doc, i, j, k);
                    Double value = TaxStatementReportSecurityData.getTaxValueValue(doc, i, j, k);
                    if (undefined.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (quantity != null && quantity == 0.0 && value == null && balance == null) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (value != null && value >= 0.0) {
                        if (currency != null && currency.equals("CHF") && balance != null && formula.approximately(value, balance).booleanValue()) {
                            entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + security + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.APPROXIMATELY) + " " + String.format("%1$,.2f", balance));
                        } else if (currency != null && currency.equals("CHF") && balance != null && !String.format("%1$,.2f", value).equals(String.format("%1$,.2f", balance))) {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", balance));
                        } else if (currency != null && !currency.equals("CHF") && balance != null && balance > 0.0 && exchangeRate != null && value == 0.0 && balance * exchangeRate <= 0.01) {
                            entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + security + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.APPROXIMATELY) + " " + String.format("%1$,.2f", balance) + " * " + String.format("%1$,.5f", exchangeRate));
                        } else if (currency != null && !currency.equals("CHF") && balance != null && balance > 0.0 && exchangeRate != null && value == 0.0) {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", balance) + " * " + String.format("%1$,.5f", exchangeRate));
                        } else if (currency != null && !currency.equals("CHF") && balance != null && balance > 0.0 && value == 0.0) {
                            if (TaxStatementReportProperty.EXCHANGE_RATE) {
                                entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", balance) + " * " + (Object)((Object)TaxStatementReportOperator.UNDEFINED));
                            } else {
                                entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + security + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", balance) + " * " + (Object)((Object)TaxStatementReportOperator.UNDEFINED));
                            }
                        } else {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + String.format("%1$,.2f", value));
                        }
                    } else if (value != null && value < 0.0 && category != null && (category.equals("OPTION") || category.equals("OTHER"))) {
                        entity.setResult(TaxStatementReportResult.OK).setReason("(" + security + ") " + String.format("%1$,.2f", value));
                    } else if (value != null && value < 0.0 && category != null && category.equals("SHARE")) {
                        entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + security + ") " + String.format("%1$,.2f", value));
                    } else if (value != null && value < 0.0) {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + String.format("%1$,.2f", value));
                    } else if (currency != null && currency.equals("CHF") && balance != null && balance > 0.0) {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + (Object)((Object)TaxStatementReportOperator.UNDEFINED) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", balance));
                    } else if (currency != null && !currency.equals("CHF") && balance != null && balance > 0.0 && exchangeRate != null) {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + (Object)((Object)TaxStatementReportOperator.UNDEFINED) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", balance) + " * " + String.format("%1$,.5f", exchangeRate));
                    } else if (currency != null && !currency.equals("CHF") && balance != null && balance > 0.0) {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + (Object)((Object)TaxStatementReportOperator.UNDEFINED) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", balance) + " * " + (Object)((Object)TaxStatementReportOperator.UNDEFINED));
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                }
                ++j;
                ++security;
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute18(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(18, this.getStepDescription(lang, 18), this.getStepCondition(lang, 18));
        int security = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int j = 1;
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            while (j <= securities) {
                int taxValues = TaxStatementReportSecurityData.getTaxValueCount(doc, i, j);
                for (int k = 1; k <= taxValues; ++k) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getTaxValueReferenceDate(doc, i, j, k));
                    String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                    Boolean undefined = TaxStatementReportSecurityData.getTaxValueUndefined(doc, i, j, k);
                    String currency = TaxStatementReportSecurityData.getTaxValueBalanceCurrency(doc, i, j, k);
                    Double quantity = TaxStatementReportSecurityData.getTaxValueQuantity(doc, i, j, k);
                    Double balance = TaxStatementReportSecurityData.getTaxValueBalance(doc, i, j, k);
                    Double exchangeRate = TaxStatementReportSecurityData.getTaxValueExchangeRate(doc, i, j, k);
                    Double value = TaxStatementReportSecurityData.getTaxValueValue(doc, i, j, k);
                    Double valueCalc = null;
                    if (currency != null && !currency.equals("CHF") && balance != null && exchangeRate != null) {
                        valueCalc = balance * exchangeRate;
                    }
                    if (undefined.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (quantity != null && quantity == 0.0 && exchangeRate == null) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (balance != null && balance == 0.0 && exchangeRate == null) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (quantity != null && quantity == 0.0 && value == null && balance == null) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (currency != null && !currency.equals("CHF")) {
                        if (String.format("%1$,.2f", value).equals(String.format("%1$,.2f", valueCalc))) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + String.format("%1$,.2f", value));
                        } else if (TaxStatementReportUtil.approximately(value, valueCalc, 0.0499999999).booleanValue()) {
                            entity.setResult(TaxStatementReportResult.OK).setReason("(" + security + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.APPROXIMATELY) + " " + String.format("%1$,.2f", valueCalc));
                        } else if (TaxStatementReportUtil.approximately(value, valueCalc, 0.9999999999).booleanValue() && currency != null && (currency.equals("JPY") || currency.equals("TRY"))) {
                            entity.setResult(TaxStatementReportResult.OK).setReason("(" + security + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.APPROXIMATELY) + " " + String.format("%1$,.2f", valueCalc));
                        } else if (formula.approximately(value, valueCalc).booleanValue()) {
                            entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + security + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.APPROXIMATELY) + " " + String.format("%1$,.2f", valueCalc));
                        } else if (value != null && valueCalc != null) {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", valueCalc));
                        } else if (balance != null && balance > 0.0) {
                            if (TaxStatementReportProperty.EXCHANGE_RATE) {
                                entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", balance) + " * " + (Object)((Object)TaxStatementReportOperator.UNDEFINED));
                            } else {
                                entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + security + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", balance) + " * " + (Object)((Object)TaxStatementReportOperator.UNDEFINED));
                            }
                        } else if (balance != null && balance < 0.0 && category != null && !category.equals("OPTION") && !category.equals("OTHER")) {
                            if (TaxStatementReportProperty.EXCHANGE_RATE) {
                                entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", balance) + " * " + (Object)((Object)TaxStatementReportOperator.UNDEFINED));
                            } else {
                                entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + security + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", balance) + " * " + (Object)((Object)TaxStatementReportOperator.UNDEFINED));
                            }
                        } else {
                            entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                        }
                    } else {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                }
                ++j;
                ++security;
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    @Override
    public TaxStatementReportResultCase execute(Document doc, byte[] xml, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultCase cs = new TaxStatementReportResultCase(this.getCaseGroup(), this.getCaseId(), this.getCaseGroup(lang), this.getCaseName(lang), this.getCaseDescription(lang));
        TaxStatementReportResult[][] ok = new TaxStatementReportResult[][]{new TaxStatementReportResult[0], {TaxStatementReportResult.ERROR, TaxStatementReportResult.OK, TaxStatementReportResult.OK, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, TaxStatementReportResult.ERROR, TaxStatementReportResult.OK, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null, TaxStatementReportResult.OK, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null, TaxStatementReportResult.ERROR, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null, null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null, null, null, null}, {null, null, null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null, null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null, null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null, null, null, null}, {null, null, null, null, null}, {null, null, null, null, null}, {null, null, null, null, TaxStatementReportResult.OK}, {null, null, null, null, null}, {null, null, null, null, TaxStatementReportResult.OK}, {null, null, null, null, null}, {null, null, null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null, null, null, TaxStatementReportResult.OK}};
        cs.addStepResultOptional(ok[1], this.execute01(doc, lang, formula));
        cs.addStepResultOptional(ok[2], this.execute02(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getSecurityCount(doc) > 0));
        cs.addStepResultMandatory(ok[3], this.execute03(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getTaxValueCount(doc) > 0));
        cs.addStepResultOptional(ok[4], this.execute04(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getTaxValueCount(doc) > 0));
        cs.addStepResultMandatory(ok[5], this.execute05(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getTaxValueCount(doc) > 0));
        cs.addStepResultOptional(ok[6], this.execute06(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getTaxValueCount(doc) > 0 && TaxStatementReportSecurityData.getTaxValueName(doc)));
        cs.addStepResultMandatory(ok[7], this.execute07(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getTaxValueCount(doc) > 0));
        cs.addStepResultMandatory(ok[8], this.execute08(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getTaxValueCount(doc) > 0));
        cs.addStepResultMandatory(ok[9], this.execute09(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getTaxValueCount(doc) > 0));
        cs.addStepResultOptional(ok[10], this.execute10(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getTaxValueCount(doc) > 0 && TaxStatementReportSecurityData.getTaxValueUnitPrice(doc)));
        cs.addStepResultOptional(ok[11], this.execute11(doc, lang, formula, TaxStatementReportSecurityData.getTaxValueCount(doc) > 0));
        cs.addStepResultOptional(ok[12], this.execute12(doc, lang, formula, TaxStatementReportSecurityData.getTaxValueCount(doc) > 0 && TaxStatementReportSecurityData.getTaxValueBlockingTo(doc)));
        cs.addStepResultOptional(ok[13], this.execute13(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getTaxValueCount(doc) > 0 && TaxStatementReportSecurityData.getTaxValueBalance(doc)));
        cs.addStepResultOptional(ok[14], this.execute14(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getTaxValueCount(doc) > 0 && TaxStatementReportSecurityData.getTaxValueUnitPrice(doc)));
        cs.addStepResultMandatory(ok[15], this.execute15(doc, lang, formula, TaxStatementReportSecurityData.getTaxValueCount(doc) > 0 && TaxStatementReportSecurityData.getTaxValueBalanceCurrency(doc) && TaxStatementReportSecurityData.getTaxValueBalance(doc)));
        cs.addStepResultOptional(ok[16], this.execute16(doc, lang, formula, TaxStatementReportSecurityData.getTaxValueCount(doc) > 0 && TaxStatementReportSecurityData.getTaxValueExchangeRate(doc)));
        cs.addStepResultMandatory(ok[17], this.execute17(doc, lang, formula, TaxStatementReportSecurityData.getTaxValueCount(doc) > 0));
        cs.addStepResultMandatory(ok[18], this.execute18(doc, lang, formula, TaxStatementReportSecurityData.getTaxValueCount(doc) > 0 && TaxStatementReportSecurityData.getTaxValueBalance(doc)));
        return cs;
    }

    public TaxStatementReportSecurityCase02() {
        super("SECURITY_CASE", 2);
    }
}

