/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.report;

import ch.ewv.taxstatement.report.TaxStatementReportBankAccountData;
import ch.ewv.taxstatement.report.TaxStatementReportExpenseData;
import ch.ewv.taxstatement.report.TaxStatementReportLiabilityAccountData;
import ch.ewv.taxstatement.report.TaxStatementReportResult;
import ch.ewv.taxstatement.report.TaxStatementReportSchemaData;
import ch.ewv.taxstatement.report.TaxStatementReportSecurityData;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;

public class TaxStatementReportData {
    public static final Integer EXPENSE_TYPE_TAX_STATEMENT = 10;
    public static final Integer EXPENSE_TYPE_ASSET_MANAGEMENT = 15;
    public static final Integer EXPENSE_TYPE_REFUND = 17;
    public static final Integer EXPENSE_TYPE_DEPOSIT = 22;
    public static final Integer EXPENSE_TYPE_ADMINISTRATIVE_ACTION = 23;
    public static final Integer EXPENSE_TYPE_ACCOUNT_MANAGEMENT = 25;
    public static final Integer EXPENSE_TYPE_NEGATIVE_INTEREST = 29;
    public static final String VERSION_22 = "22";

    public static TaxStatementReportResult getResultCaseBankAccountInterestA(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        int accounts = TaxStatementReportBankAccountData.getBankAccountCount(doc);
        for (int i = 1; i <= accounts && !result; ++i) {
            Double totalGrossRevenueA = TaxStatementReportBankAccountData.getTotalGrossRevenueA(doc, i);
            if (totalGrossRevenueA == null || !(totalGrossRevenueA > 0.0)) continue;
            result = true;
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseBankAccountInterestB(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        int accounts = TaxStatementReportBankAccountData.getBankAccountCount(doc);
        for (int i = 1; i <= accounts && !result; ++i) {
            Double totalGrossRevenueB = TaxStatementReportBankAccountData.getTotalGrossRevenueB(doc, i);
            if (totalGrossRevenueB == null || !(totalGrossRevenueB > 0.0)) continue;
            result = true;
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseBankAccountInterestNegative(Document doc) throws ParseException, XPathExpressionException {
        String iban;
        String number;
        String name;
        int i;
        boolean result = false;
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> numbers = new ArrayList<String>();
        ArrayList<String> ibans = new ArrayList<String>();
        int accounts = TaxStatementReportBankAccountData.getBankAccountCount(doc);
        for (i = 1; i <= accounts && !result; ++i) {
            name = TaxStatementReportBankAccountData.getBankAccountName(doc, i);
            number = TaxStatementReportBankAccountData.getBankAccountNumber(doc, i);
            iban = TaxStatementReportBankAccountData.getBankAccountIBAN(doc, i);
            if (name != null && !names.contains(name)) {
                names.add(name);
            }
            if (number != null && !numbers.contains(number)) {
                numbers.add(number);
            }
            if (iban == null || ibans.contains(iban)) continue;
            ibans.add(iban);
        }
        accounts = TaxStatementReportLiabilityAccountData.getLiabilityAccountCount(doc);
        for (i = 1; i <= accounts && !result; ++i) {
            name = TaxStatementReportLiabilityAccountData.getLiabilityAccountName(doc, i);
            number = TaxStatementReportLiabilityAccountData.getLiabilityAccountNumber(doc, i);
            iban = TaxStatementReportLiabilityAccountData.getLiabilityAccountIBAN(doc, i);
            if (!(name != null && names.contains(name) || number != null && numbers.contains(number)) && (iban == null || !ibans.contains(iban))) continue;
            int payments = TaxStatementReportLiabilityAccountData.getPaymentCount(doc, i);
            for (int p = 1; p <= payments && !result; ++p) {
                Double grossRevenueB = TaxStatementReportLiabilityAccountData.getPaymentGrossRevenueB(doc, i, p);
                if (grossRevenueB == null || !(grossRevenueB > 0.0)) continue;
                result = true;
            }
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseBankAccountOpening(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        Date periodFrom = TaxStatementReportSchemaData.getPeriodFrom(doc);
        Date periodTo = TaxStatementReportSchemaData.getPeriodTo(doc);
        int accounts = TaxStatementReportBankAccountData.getBankAccountCount(doc);
        for (int i = 1; i <= accounts && !result; ++i) {
            Date openingDate = TaxStatementReportBankAccountData.getBankAccountOpeningDate(doc, i);
            if (openingDate == null || periodFrom == null || periodFrom.after(openingDate) || periodTo == null || periodTo.before(openingDate)) continue;
            result = true;
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseBankAccountClosing(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        Date periodFrom = TaxStatementReportSchemaData.getPeriodFrom(doc);
        Date periodTo = TaxStatementReportSchemaData.getPeriodTo(doc);
        int accounts = TaxStatementReportBankAccountData.getBankAccountCount(doc);
        for (int i = 1; i <= accounts && !result; ++i) {
            Date closingDate = TaxStatementReportBankAccountData.getBankAccountClosingDate(doc, i);
            if (closingDate == null || periodFrom == null || periodFrom.after(closingDate) || periodTo == null || periodTo.before(closingDate)) continue;
            result = true;
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseBankAccountForeign(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        int accounts = TaxStatementReportBankAccountData.getBankAccountCount(doc);
        for (int i = 1; i <= accounts && !result; ++i) {
            String currency = TaxStatementReportBankAccountData.getBankAccountCurrency(doc, i);
            if (currency == null || currency.equals("CHF")) continue;
            result = true;
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseBankAccountMetal(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        int accounts = TaxStatementReportBankAccountData.getBankAccountCount(doc);
        for (int i = 1; i <= accounts && !result; ++i) {
            String currency = TaxStatementReportBankAccountData.getBankAccountCurrency(doc, i);
            if (currency == null || !currency.equals("XAG") && !currency.equals("XAU") && !currency.equals("XPD") && !currency.equals("XPT")) continue;
            result = true;
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseBankAccountFixed(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        int accounts = TaxStatementReportBankAccountData.getBankAccountCount(doc);
        for (int i = 1; i <= accounts && !result; ++i) {
            long days;
            Date openingDate = TaxStatementReportBankAccountData.getBankAccountOpeningDate(doc, i);
            Date closingDate = TaxStatementReportBankAccountData.getBankAccountClosingDate(doc, i);
            if (openingDate == null || closingDate == null || (days = (closingDate.getTime() - openingDate.getTime()) / 86400000L) < 28L || days > 366L) continue;
            result = true;
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseLiabilityAccountDebt(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        int accounts = TaxStatementReportLiabilityAccountData.getLiabilityAccountCount(doc);
        for (int i = 1; i <= accounts && !result; ++i) {
            Double totalTaxValue = TaxStatementReportLiabilityAccountData.getTotalTaxValue(doc, i);
            Double totalGrossRevenueB = TaxStatementReportLiabilityAccountData.getTotalGrossRevenueB(doc, i);
            if (totalTaxValue == null || !(totalTaxValue > 0.0) || totalGrossRevenueB == null || !(totalGrossRevenueB > 0.0)) continue;
            result = true;
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseLiabilityAccountOpening(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        Date periodFrom = TaxStatementReportSchemaData.getPeriodFrom(doc);
        Date periodTo = TaxStatementReportSchemaData.getPeriodTo(doc);
        int accounts = TaxStatementReportLiabilityAccountData.getLiabilityAccountCount(doc);
        for (int i = 1; i <= accounts && !result; ++i) {
            Date openingDate = TaxStatementReportLiabilityAccountData.getLiabilityAccountOpeningDate(doc, i);
            if (openingDate == null || periodFrom == null || periodFrom.after(openingDate) || periodTo == null || periodTo.before(openingDate)) continue;
            result = true;
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseLiabilityAccountClosing(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        Date periodFrom = TaxStatementReportSchemaData.getPeriodFrom(doc);
        Date periodTo = TaxStatementReportSchemaData.getPeriodTo(doc);
        int accounts = TaxStatementReportLiabilityAccountData.getLiabilityAccountCount(doc);
        for (int i = 1; i <= accounts && !result; ++i) {
            Date closingDate = TaxStatementReportLiabilityAccountData.getLiabilityAccountClosingDate(doc, i);
            if (closingDate == null || periodFrom == null || periodFrom.after(closingDate) || periodTo == null || periodTo.before(closingDate)) continue;
            result = true;
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseLiabilityAccountCHF(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        int accounts = TaxStatementReportLiabilityAccountData.getLiabilityAccountCount(doc);
        for (int i = 1; i <= accounts && !result; ++i) {
            String currency = TaxStatementReportLiabilityAccountData.getLiabilityAccountCurrency(doc, i);
            if (currency == null || !currency.equals("CHF")) continue;
            result = true;
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseLiabilityAccountForeign(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        int accounts = TaxStatementReportLiabilityAccountData.getLiabilityAccountCount(doc);
        for (int i = 1; i <= accounts && !result; ++i) {
            String currency = TaxStatementReportLiabilityAccountData.getLiabilityAccountCurrency(doc, i);
            if (currency == null || currency.equals("CHF")) continue;
            result = true;
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseExpenseMultiple(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        if (TaxStatementReportExpenseData.getExpenseCount(doc) > 1) {
            result = true;
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseExpenseDeposit(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        String version = TaxStatementReportSchemaData.getMinorVersion(doc);
        int expenses = TaxStatementReportExpenseData.getExpenseCount(doc);
        for (int i = 1; i <= expenses && !result; ++i) {
            Integer expenseType = TaxStatementReportExpenseData.getExpenseType(doc, i);
            if (expenseType == null || !expenseType.equals(EXPENSE_TYPE_DEPOSIT)) continue;
            result = true;
        }
        return version != null && version.compareTo(VERSION_22) < 0 ? TaxStatementReportResult.SELECT : (result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR);
    }

    public static TaxStatementReportResult getResultCaseExpenseAccountManagement(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        String version = TaxStatementReportSchemaData.getMinorVersion(doc);
        int expenses = TaxStatementReportExpenseData.getExpenseCount(doc);
        for (int i = 1; i <= expenses && !result; ++i) {
            Integer expenseType = TaxStatementReportExpenseData.getExpenseType(doc, i);
            if (expenseType == null || !expenseType.equals(EXPENSE_TYPE_ACCOUNT_MANAGEMENT)) continue;
            result = true;
        }
        return version != null && version.compareTo(VERSION_22) < 0 ? TaxStatementReportResult.SELECT : (result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR);
    }

    public static TaxStatementReportResult getResultCaseExpenseNegativeInterest(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        String version = TaxStatementReportSchemaData.getMinorVersion(doc);
        int expenses = TaxStatementReportExpenseData.getExpenseCount(doc);
        for (int i = 1; i <= expenses && !result; ++i) {
            Integer expenseType = TaxStatementReportExpenseData.getExpenseType(doc, i);
            if (expenseType == null || !expenseType.equals(EXPENSE_TYPE_NEGATIVE_INTEREST)) continue;
            result = true;
        }
        return version != null && version.compareTo(VERSION_22) < 0 ? TaxStatementReportResult.SELECT : (result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR);
    }

    public static TaxStatementReportResult getResultCaseExpenseAssetManagement(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        String version = TaxStatementReportSchemaData.getMinorVersion(doc);
        int expenses = TaxStatementReportExpenseData.getExpenseCount(doc);
        for (int i = 1; i <= expenses && !result; ++i) {
            Integer expenseType = TaxStatementReportExpenseData.getExpenseType(doc, i);
            if (expenseType == null || !expenseType.equals(EXPENSE_TYPE_ASSET_MANAGEMENT)) continue;
            result = true;
        }
        return version != null && version.compareTo(VERSION_22) < 0 ? TaxStatementReportResult.SELECT : (result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR);
    }

    public static TaxStatementReportResult getResultCaseExpenseAdministrativeAction(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        String version = TaxStatementReportSchemaData.getMinorVersion(doc);
        int expenses = TaxStatementReportExpenseData.getExpenseCount(doc);
        for (int i = 1; i <= expenses && !result; ++i) {
            Integer expenseType = TaxStatementReportExpenseData.getExpenseType(doc, i);
            if (expenseType == null || !expenseType.equals(EXPENSE_TYPE_ADMINISTRATIVE_ACTION)) continue;
            result = true;
        }
        return version != null && version.compareTo(VERSION_22) < 0 ? TaxStatementReportResult.SELECT : (result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR);
    }

    public static TaxStatementReportResult getResultCaseExpenseTaxStatement(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        String version = TaxStatementReportSchemaData.getMinorVersion(doc);
        int expenses = TaxStatementReportExpenseData.getExpenseCount(doc);
        for (int i = 1; i <= expenses && !result; ++i) {
            Integer expenseType = TaxStatementReportExpenseData.getExpenseType(doc, i);
            if (expenseType == null || !expenseType.equals(EXPENSE_TYPE_TAX_STATEMENT)) continue;
            result = true;
        }
        return version != null && version.compareTo(VERSION_22) < 0 ? TaxStatementReportResult.SELECT : (result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR);
    }

    public static TaxStatementReportResult getResultCaseExpenseRefund(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        String version = TaxStatementReportSchemaData.getMinorVersion(doc);
        int expenses = TaxStatementReportExpenseData.getExpenseCount(doc);
        for (int i = 1; i <= expenses && !result; ++i) {
            Integer expenseType = TaxStatementReportExpenseData.getExpenseType(doc, i);
            if (expenseType == null || !expenseType.equals(EXPENSE_TYPE_REFUND)) continue;
            result = true;
        }
        return version != null && version.compareTo(VERSION_22) < 0 ? TaxStatementReportResult.SELECT : (result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR);
    }

    public static TaxStatementReportResult getResultCaseShareCHF(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && !result; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && !result; ++j) {
                String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                int taxValues = TaxStatementReportSecurityData.getTaxValueCount(doc, i, j);
                for (int k = 1; k <= taxValues && !result; ++k) {
                    String currency = TaxStatementReportSecurityData.getTaxValueBalanceCurrency(doc, i, j, k);
                    Double taxValue = TaxStatementReportSecurityData.getTaxValueValue(doc, i, j, k);
                    if (category == null || !category.equals("SHARE") || currency == null || !currency.equals("CHF") || taxValue == null || !(taxValue > 0.0)) continue;
                    result = true;
                }
            }
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseShareForeign(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && !result; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && !result; ++j) {
                String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                int taxValues = TaxStatementReportSecurityData.getTaxValueCount(doc, i, j);
                for (int k = 1; k <= taxValues && !result; ++k) {
                    String currency = TaxStatementReportSecurityData.getTaxValueBalanceCurrency(doc, i, j, k);
                    Double taxValue = TaxStatementReportSecurityData.getTaxValueValue(doc, i, j, k);
                    if (category == null || !category.equals("SHARE") || currency == null || currency.equals("CHF") || taxValue == null || !(taxValue > 0.0)) continue;
                    result = true;
                }
            }
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseShareRevenueA(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && !result; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && !result; ++j) {
                String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                for (int k = 1; k <= payments && !result; ++k) {
                    Double grossRevenueA = TaxStatementReportSecurityData.getPaymentGrossRevenueA(doc, i, j, k);
                    if (category == null || !category.equals("SHARE") || grossRevenueA == null || !(grossRevenueA > 0.0)) continue;
                    result = true;
                }
            }
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseShareRevenueB(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && !result; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && !result; ++j) {
                String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                for (int k = 1; k <= payments && !result; ++k) {
                    Double grossRevenueB = TaxStatementReportSecurityData.getPaymentGrossRevenueB(doc, i, j, k);
                    if (category == null || !category.equals("SHARE") || grossRevenueB == null || !(grossRevenueB > 0.0)) continue;
                    result = true;
                }
            }
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseShareRevenueDA1(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && !result; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && !result; ++j) {
                String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                String country = TaxStatementReportSecurityData.getSecurityCountry(doc, i, j);
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                for (int k = 1; k <= payments && !result; ++k) {
                    Boolean lumpSumTaxCredit = TaxStatementReportSecurityData.getPaymentLumpSumTaxCredit(doc, i, j, k);
                    Double grossRevenueB = TaxStatementReportSecurityData.getPaymentGrossRevenueB(doc, i, j, k);
                    if (category == null || !category.equals("SHARE") || country == null || country.equals("US") || lumpSumTaxCredit == null || !lumpSumTaxCredit.booleanValue() || grossRevenueB == null || !(grossRevenueB > 0.0)) continue;
                    result = true;
                }
            }
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseShareRevenueUSA(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && !result; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && !result; ++j) {
                String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                String country = TaxStatementReportSecurityData.getSecurityCountry(doc, i, j);
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                for (int k = 1; k <= payments && !result; ++k) {
                    Boolean lumpSumTaxCredit = TaxStatementReportSecurityData.getPaymentLumpSumTaxCredit(doc, i, j, k);
                    Double grossRevenueB = TaxStatementReportSecurityData.getPaymentGrossRevenueB(doc, i, j, k);
                    if (category == null || !category.equals("SHARE") || country == null || !country.equals("US") || lumpSumTaxCredit == null || !lumpSumTaxCredit.booleanValue() || grossRevenueB == null || !(grossRevenueB > 0.0)) continue;
                    result = true;
                }
            }
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseSharePurchase(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && !result; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && !result; ++j) {
                String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                int stocks = TaxStatementReportSecurityData.getStockCount(doc, i, j);
                for (int k = 1; k <= stocks && !result; ++k) {
                    Boolean mutation = TaxStatementReportSecurityData.getStockMutation(doc, i, j, k);
                    Double quantity = TaxStatementReportSecurityData.getStockQuantity(doc, i, j, k);
                    if (category == null || !category.equals("SHARE") || mutation == null || !mutation.booleanValue() || quantity == null || !(quantity > 0.0)) continue;
                    result = true;
                }
            }
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseShareDisposition(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && !result; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && !result; ++j) {
                String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                int stocks = TaxStatementReportSecurityData.getStockCount(doc, i, j);
                for (int k = 1; k <= stocks && !result; ++k) {
                    Boolean mutation = TaxStatementReportSecurityData.getStockMutation(doc, i, j, k);
                    Double quantity = TaxStatementReportSecurityData.getStockQuantity(doc, i, j, k);
                    if (category == null || !category.equals("SHARE") || mutation == null || !mutation.booleanValue() || quantity == null || !(quantity < 0.0)) continue;
                    result = true;
                }
            }
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseBondCHF(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && !result; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && !result; ++j) {
                String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                int taxValues = TaxStatementReportSecurityData.getTaxValueCount(doc, i, j);
                for (int k = 1; k <= taxValues && !result; ++k) {
                    String currency = TaxStatementReportSecurityData.getTaxValueBalanceCurrency(doc, i, j, k);
                    Double taxValue = TaxStatementReportSecurityData.getTaxValueValue(doc, i, j, k);
                    if (category == null || !category.equals("BOND") || currency == null || !currency.equals("CHF") || taxValue == null || !(taxValue > 0.0)) continue;
                    result = true;
                }
            }
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseBondForeign(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && !result; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && !result; ++j) {
                String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                int taxValues = TaxStatementReportSecurityData.getTaxValueCount(doc, i, j);
                for (int k = 1; k <= taxValues && !result; ++k) {
                    String currency = TaxStatementReportSecurityData.getTaxValueBalanceCurrency(doc, i, j, k);
                    Double taxValue = TaxStatementReportSecurityData.getTaxValueValue(doc, i, j, k);
                    if (category == null || !category.equals("BOND") || currency == null || currency.equals("CHF") || taxValue == null || !(taxValue > 0.0)) continue;
                    result = true;
                }
            }
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseBondRevenueA(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && !result; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && !result; ++j) {
                String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                for (int k = 1; k <= payments && !result; ++k) {
                    Double grossRevenueA = TaxStatementReportSecurityData.getPaymentGrossRevenueA(doc, i, j, k);
                    if (category == null || !category.equals("BOND") || grossRevenueA == null || !(grossRevenueA > 0.0)) continue;
                    result = true;
                }
            }
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseBondRevenueB(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && !result; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && !result; ++j) {
                String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                for (int k = 1; k <= payments && !result; ++k) {
                    Double grossRevenueB = TaxStatementReportSecurityData.getPaymentGrossRevenueB(doc, i, j, k);
                    if (category == null || !category.equals("BOND") || grossRevenueB == null || !(grossRevenueB > 0.0)) continue;
                    result = true;
                }
            }
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseBondPurchase(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && !result; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && !result; ++j) {
                String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                int stocks = TaxStatementReportSecurityData.getStockCount(doc, i, j);
                for (int k = 1; k <= stocks && !result; ++k) {
                    Boolean mutation = TaxStatementReportSecurityData.getStockMutation(doc, i, j, k);
                    Double quantity = TaxStatementReportSecurityData.getStockQuantity(doc, i, j, k);
                    if (category == null || !category.equals("BOND") || mutation == null || !mutation.booleanValue() || quantity == null || !(quantity > 0.0)) continue;
                    result = true;
                }
            }
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseBondDisposition(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && !result; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && !result; ++j) {
                String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                int stocks = TaxStatementReportSecurityData.getStockCount(doc, i, j);
                for (int k = 1; k <= stocks && !result; ++k) {
                    Boolean mutation = TaxStatementReportSecurityData.getStockMutation(doc, i, j, k);
                    Double quantity = TaxStatementReportSecurityData.getStockQuantity(doc, i, j, k);
                    if (category == null || !category.equals("BOND") || mutation == null || !mutation.booleanValue() || quantity == null || !(quantity < 0.0)) continue;
                    result = true;
                }
            }
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseFundCHF(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && !result; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && !result; ++j) {
                String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                int taxValues = TaxStatementReportSecurityData.getTaxValueCount(doc, i, j);
                for (int k = 1; k <= taxValues && !result; ++k) {
                    String currency = TaxStatementReportSecurityData.getTaxValueBalanceCurrency(doc, i, j, k);
                    Double taxValue = TaxStatementReportSecurityData.getTaxValueValue(doc, i, j, k);
                    if (category == null || !category.equals("FUND") || currency == null || !currency.equals("CHF") || taxValue == null || !(taxValue > 0.0)) continue;
                    result = true;
                }
            }
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseFundForeign(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && !result; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && !result; ++j) {
                String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                int taxValues = TaxStatementReportSecurityData.getTaxValueCount(doc, i, j);
                for (int k = 1; k <= taxValues && !result; ++k) {
                    String currency = TaxStatementReportSecurityData.getTaxValueBalanceCurrency(doc, i, j, k);
                    Double taxValue = TaxStatementReportSecurityData.getTaxValueValue(doc, i, j, k);
                    if (category == null || !category.equals("FUND") || currency == null || currency.equals("CHF") || taxValue == null || !(taxValue > 0.0)) continue;
                    result = true;
                }
            }
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseFundRevenueA(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && !result; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && !result; ++j) {
                String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                for (int k = 1; k <= payments && !result; ++k) {
                    Double grossRevenueA = TaxStatementReportSecurityData.getPaymentGrossRevenueA(doc, i, j, k);
                    if (category == null || !category.equals("FUND") || grossRevenueA == null || !(grossRevenueA > 0.0)) continue;
                    result = true;
                }
            }
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseFundRevenueB(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && !result; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && !result; ++j) {
                String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                for (int k = 1; k <= payments && !result; ++k) {
                    Double grossRevenueB = TaxStatementReportSecurityData.getPaymentGrossRevenueA(doc, i, j, k);
                    if (category == null || !category.equals("FUND") || grossRevenueB == null || !(grossRevenueB > 0.0)) continue;
                    result = true;
                }
            }
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseFundAccumulation(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && !result; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && !result; ++j) {
                String securityType = TaxStatementReportSecurityData.getSecurityType(doc, i, j);
                if (securityType == null || !securityType.equals("FUND.ACCUMULATION")) continue;
                result = true;
            }
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseFundPurchase(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && !result; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && !result; ++j) {
                String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                int stocks = TaxStatementReportSecurityData.getStockCount(doc, i, j);
                for (int k = 1; k <= stocks && !result; ++k) {
                    Boolean mutation = TaxStatementReportSecurityData.getStockMutation(doc, i, j, k);
                    Double quantity = TaxStatementReportSecurityData.getStockQuantity(doc, i, j, k);
                    if (category == null || !category.equals("FUND") || mutation == null || !mutation.booleanValue() || quantity == null || !(quantity > 0.0)) continue;
                    result = true;
                }
            }
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseFundDisposition(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && !result; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && !result; ++j) {
                String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                int stocks = TaxStatementReportSecurityData.getStockCount(doc, i, j);
                for (int k = 1; k <= stocks && !result; ++k) {
                    Boolean mutation = TaxStatementReportSecurityData.getStockMutation(doc, i, j, k);
                    Double quantity = TaxStatementReportSecurityData.getStockQuantity(doc, i, j, k);
                    if (category == null || !category.equals("FUND") || mutation == null || !mutation.booleanValue() || quantity == null || !(quantity < 0.0)) continue;
                    result = true;
                }
            }
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseDerivativeCHF(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && !result; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && !result; ++j) {
                String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                int taxValues = TaxStatementReportSecurityData.getTaxValueCount(doc, i, j);
                for (int k = 1; k <= taxValues && !result; ++k) {
                    String currency = TaxStatementReportSecurityData.getTaxValueBalanceCurrency(doc, i, j, k);
                    Double taxValue = TaxStatementReportSecurityData.getTaxValueValue(doc, i, j, k);
                    if (category == null || !category.equals("DEVT") || currency == null || !currency.equals("CHF") || taxValue == null || !(taxValue > 0.0)) continue;
                    result = true;
                }
            }
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseDerivativeForeign(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && !result; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && !result; ++j) {
                String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                int taxValues = TaxStatementReportSecurityData.getTaxValueCount(doc, i, j);
                for (int k = 1; k <= taxValues && !result; ++k) {
                    String currency = TaxStatementReportSecurityData.getTaxValueBalanceCurrency(doc, i, j, k);
                    Double taxValue = TaxStatementReportSecurityData.getTaxValueValue(doc, i, j, k);
                    if (category == null || !category.equals("DEVT") || currency == null || currency.equals("CHF") || taxValue == null || !(taxValue > 0.0)) continue;
                    result = true;
                }
            }
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseDerivativeRevenueA(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && !result; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && !result; ++j) {
                String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                for (int k = 1; k <= payments && !result; ++k) {
                    Double grossRevenueA = TaxStatementReportSecurityData.getPaymentGrossRevenueA(doc, i, j, k);
                    if (category == null || !category.equals("DEVT") || grossRevenueA == null || !(grossRevenueA > 0.0)) continue;
                    result = true;
                }
            }
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseDerivativeRevenueB(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && !result; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && !result; ++j) {
                String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                for (int k = 1; k <= payments && !result; ++k) {
                    Double grossRevenueB = TaxStatementReportSecurityData.getPaymentGrossRevenueB(doc, i, j, k);
                    if (category == null || !category.equals("DEVT") || grossRevenueB == null || !(grossRevenueB > 0.0)) continue;
                    result = true;
                }
            }
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseDerivativePurchase(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && !result; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && !result; ++j) {
                String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                int stocks = TaxStatementReportSecurityData.getStockCount(doc, i, j);
                for (int k = 1; k <= stocks && !result; ++k) {
                    Boolean mutation = TaxStatementReportSecurityData.getStockMutation(doc, i, j, k);
                    Double quantity = TaxStatementReportSecurityData.getStockQuantity(doc, i, j, k);
                    if (category == null || !category.equals("DEVT") || mutation == null || !mutation.booleanValue() || quantity == null || !(quantity > 0.0)) continue;
                    result = true;
                }
            }
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseDerivativeDisposition(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && !result; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && !result; ++j) {
                String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                int stocks = TaxStatementReportSecurityData.getStockCount(doc, i, j);
                for (int k = 1; k <= stocks && !result; ++k) {
                    Boolean mutation = TaxStatementReportSecurityData.getStockMutation(doc, i, j, k);
                    Double quantity = TaxStatementReportSecurityData.getStockQuantity(doc, i, j, k);
                    if (category == null || !category.equals("DEVT") || mutation == null || !mutation.booleanValue() || quantity == null || !(quantity < 0.0)) continue;
                    result = true;
                }
            }
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseDerivativeIUPPure(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && !result; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && !result; ++j) {
                Boolean bfp = TaxStatementReportSecurityData.getSecurityBFP(doc, i, j);
                String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                for (int k = 1; k <= payments && !result; ++k) {
                    Boolean iup = TaxStatementReportSecurityData.getPaymentIUP(doc, i, j, k);
                    Double grossRevenueB = TaxStatementReportSecurityData.getPaymentGrossRevenueB(doc, i, j, k);
                    if (category == null || !category.equals("DEVT") || bfp == null || bfp.booleanValue() || iup == null || !iup.booleanValue() || !(grossRevenueB != null && grossRevenueB > 0.0) && (grossRevenueB == null || !(grossRevenueB < 0.0))) continue;
                    result = true;
                }
            }
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseDerivativeIUPModified(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && !result; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && !result; ++j) {
                Boolean bfp = TaxStatementReportSecurityData.getSecurityBFP(doc, i, j);
                String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                for (int k = 1; k <= payments && !result; ++k) {
                    Boolean iup = TaxStatementReportSecurityData.getPaymentIUP(doc, i, j, k);
                    Double grossRevenueB = TaxStatementReportSecurityData.getPaymentGrossRevenueB(doc, i, j, k);
                    if (category == null || !category.equals("DEVT") || bfp == null || !bfp.booleanValue() || iup == null || !iup.booleanValue() || !(grossRevenueB != null && grossRevenueB > 0.0) && (grossRevenueB == null || !(grossRevenueB < 0.0))) continue;
                    result = true;
                }
            }
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseOptionFuture(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && !result; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && !result; ++j) {
                String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                if (category == null || !category.equals("OPTION")) continue;
                result = true;
            }
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseMoneyFixedRevenueA(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && !result; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && !result; ++j) {
                String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                String isin = TaxStatementReportSecurityData.getSecurityISIN(doc, i, j);
                String valorNumber = TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j);
                Date issueDate = TaxStatementReportSecurityData.getSecurityIssueDate(doc, i, j);
                Date redemptionDate = TaxStatementReportSecurityData.getSecurityRedemptionDate(doc, i, j);
                long days = 0L;
                if (issueDate != null && redemptionDate != null) {
                    days = (redemptionDate.getTime() - issueDate.getTime()) / 86400000L;
                }
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                for (int k = 1; k <= payments && !result; ++k) {
                    Double grossRevenueA = TaxStatementReportSecurityData.getPaymentGrossRevenueA(doc, i, j, k);
                    if (category == null || !category.equals("BOND") || isin != null || valorNumber != null || days <= 366L || grossRevenueA == null || !(grossRevenueA > 0.0)) continue;
                    result = true;
                }
            }
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseMoneyFixedRevenueB(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && !result; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && !result; ++j) {
                String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                String isin = TaxStatementReportSecurityData.getSecurityISIN(doc, i, j);
                String valorNumber = TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j);
                Date issueDate = TaxStatementReportSecurityData.getSecurityIssueDate(doc, i, j);
                Date redemptionDate = TaxStatementReportSecurityData.getSecurityRedemptionDate(doc, i, j);
                long days = 0L;
                if (issueDate != null && redemptionDate != null) {
                    days = (redemptionDate.getTime() - issueDate.getTime()) / 86400000L;
                }
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                for (int k = 1; k <= payments && !result; ++k) {
                    Double grossRevenueB = TaxStatementReportSecurityData.getPaymentGrossRevenueB(doc, i, j, k);
                    if (category == null || !category.equals("BOND") || isin != null || valorNumber != null || days <= 366L || grossRevenueB == null || !(grossRevenueB > 0.0)) continue;
                    result = true;
                }
            }
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseMoneyFiduciaryRevenueA(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && !result; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && !result; ++j) {
                String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                String isin = TaxStatementReportSecurityData.getSecurityISIN(doc, i, j);
                String valorNumber = TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j);
                Date issueDate = TaxStatementReportSecurityData.getSecurityIssueDate(doc, i, j);
                Date redemptionDate = TaxStatementReportSecurityData.getSecurityRedemptionDate(doc, i, j);
                long days = 0L;
                if (issueDate != null && redemptionDate != null) {
                    days = (redemptionDate.getTime() - issueDate.getTime()) / 86400000L;
                }
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                for (int k = 1; k <= payments && !result; ++k) {
                    Double grossRevenueA = TaxStatementReportSecurityData.getPaymentGrossRevenueA(doc, i, j, k);
                    if (category == null || !category.equals("BOND") || isin != null || valorNumber != null || days < 28L || days > 366L || grossRevenueA == null || !(grossRevenueA > 0.0)) continue;
                    result = true;
                }
            }
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseMoneyFiduciaryRevenueB(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && !result; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && !result; ++j) {
                String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                String isin = TaxStatementReportSecurityData.getSecurityISIN(doc, i, j);
                String valorNumber = TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j);
                Date issueDate = TaxStatementReportSecurityData.getSecurityIssueDate(doc, i, j);
                Date redemptionDate = TaxStatementReportSecurityData.getSecurityRedemptionDate(doc, i, j);
                long days = 0L;
                if (issueDate != null && redemptionDate != null) {
                    days = (redemptionDate.getTime() - issueDate.getTime()) / 86400000L;
                }
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                for (int k = 1; k <= payments && !result; ++k) {
                    Double grossRevenueB = TaxStatementReportSecurityData.getPaymentGrossRevenueB(doc, i, j, k);
                    if (category == null || !category.equals("BOND") || isin != null || valorNumber != null || days < 28L || days > 366L || grossRevenueB == null || !(grossRevenueB > 0.0)) continue;
                    result = true;
                }
            }
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseCoinBullionPhysical(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && !result; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && !result; ++j) {
                String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                if (category == null || !category.equals("COINBULL")) continue;
                result = true;
            }
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseCoinBullionSecuritized(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && !result; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && !result; ++j) {
                String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                String name = TaxStatementReportSecurityData.getSecurityName(doc, i, j);
                if (category == null || !category.equals("FUND") || name == null || !name.contains("XAG") && !name.contains("XAU") && !name.contains("XPD") && !name.contains("XPT")) continue;
                result = true;
            }
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseSpecialToken(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && !result; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && !result; ++j) {
                String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                if (category == null || !category.equals("CURRNOTE")) continue;
                result = true;
            }
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseSpecialSecurityLending(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && !result; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && !result; ++j) {
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                for (int k = 1; k <= payments && !result; ++k) {
                    Boolean lendingFee = TaxStatementReportSecurityData.getPaymentLendingFee(doc, i, j, k);
                    if (lendingFee == null || !lendingFee.booleanValue()) continue;
                    result = true;
                }
            }
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseSpecialRetrocession(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && !result; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && !result; ++j) {
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                for (int k = 1; k <= payments && !result; ++k) {
                    Boolean retrocession = TaxStatementReportSecurityData.getPaymentRetrocession(doc, i, j, k);
                    if (retrocession == null || !retrocession.booleanValue()) continue;
                    result = true;
                }
            }
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseSpecialShareStock(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && !result; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && !result; ++j) {
                String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                for (int k = 1; k <= payments && !result; ++k) {
                    Date paymentDate = TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k);
                    Double grossRevenueA = TaxStatementReportSecurityData.getPaymentGrossRevenueA(doc, i, j, k);
                    Double grossRevenueB = TaxStatementReportSecurityData.getPaymentGrossRevenueB(doc, i, j, k);
                    if (category == null || !category.equals("SHARE") || paymentDate == null || !(grossRevenueA != null && grossRevenueA > 0.0) && (grossRevenueB == null || !(grossRevenueB > 0.0))) continue;
                    int stocks = TaxStatementReportSecurityData.getStockCount(doc, i, j);
                    for (int l = 1; l <= stocks && !result; ++l) {
                        Boolean mutation = TaxStatementReportSecurityData.getStockMutation(doc, i, j, l);
                        Double quantity = TaxStatementReportSecurityData.getStockQuantity(doc, i, j, l);
                        Date referenceDate = TaxStatementReportSecurityData.getStockReferenceDate(doc, i, j, l);
                        if (mutation == null || !mutation.booleanValue() || quantity == null || !(quantity > 0.0) || referenceDate == null || referenceDate.getTime() != paymentDate.getTime()) continue;
                        result = true;
                    }
                }
            }
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseSpecialDuringTheYear(Document doc) throws ParseException, XPathExpressionException {
        String d;
        boolean result = false;
        Date periodTo = TaxStatementReportSchemaData.getPeriodTo(doc);
        if (periodTo != null && (d = new SimpleDateFormat("MMdd").format(periodTo)) != null && !d.equals("1231")) {
            result = true;
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseSpecialLight(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        if (TaxStatementReportSecurityData.getDepotCount(doc) == 0) {
            result = true;
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }

    public static TaxStatementReportResult getResultCaseSpecialSameValor(Document doc) throws ParseException, XPathExpressionException {
        boolean result = false;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && !result; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && !result; ++j) {
                String isin = TaxStatementReportSecurityData.getSecurityISIN(doc, i, j);
                String valorNumber = TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j);
                if (isin == null && valorNumber == null) continue;
                int securitiex = TaxStatementReportSecurityData.getSecurityCount(doc, i);
                for (int k = 1; k <= securitiex && !result; ++k) {
                    if (j == k) continue;
                    String isix = TaxStatementReportSecurityData.getSecurityISIN(doc, i, k);
                    String valorNumbex = TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, k);
                    if (isin != null && isix != null && isin.equals(isix)) {
                        result = true;
                    }
                    if (valorNumber == null || valorNumbex == null || !valorNumber.equals(valorNumbex)) continue;
                    result = true;
                }
            }
        }
        return result ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR;
    }
}

