/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.report;

import ch.ewv.taxstatement.report.TaxStatementReportCase;
import ch.ewv.taxstatement.report.TaxStatementReportClientData;
import ch.ewv.taxstatement.report.TaxStatementReportFormula;
import ch.ewv.taxstatement.report.TaxStatementReportOperator;
import ch.ewv.taxstatement.report.TaxStatementReportResult;
import ch.ewv.taxstatement.report.TaxStatementReportResultCase;
import ch.ewv.taxstatement.report.TaxStatementReportResultEntity;
import ch.ewv.taxstatement.report.TaxStatementReportResultStep;
import java.io.IOException;
import java.text.ParseException;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class TaxStatementReportClientCase01
extends TaxStatementReportCase {
    protected TaxStatementReportResultStep execute01(Document doc, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeCount(1, this.getStepDescription(lang, 1), this.getStepCondition(lang, 1), true, TaxStatementReportClientData.getClientCount(doc));
    }

    protected TaxStatementReportResultStep execute02(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(2, this.getStepDescription(lang, 2), this.getStepCondition(lang, 2));
        int i = 1;
        int client = 1;
        int clients = TaxStatementReportClientData.getClientCount(doc);
        while (i <= clients) {
            TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportClientData.getClientNumber(doc, i));
            String clientNumber = TaxStatementReportClientData.getClientNumber(doc, i);
            if (clientNumber != null) {
                if (clientNumber.length() >= 1 && clientNumber.length() <= 40) {
                    entity.setResult(TaxStatementReportResult.OK).setRemark("(" + client + ") " + clientNumber);
                } else {
                    entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + client + ") " + clientNumber);
                }
            } else {
                entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
            }
            step.addEntity(entity);
            ++i;
            ++client;
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute03(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(3, this.getStepDescription(lang, 3), this.getStepCondition(lang, 3));
        int i = 1;
        int client = 1;
        int clients = TaxStatementReportClientData.getClientCount(doc);
        while (i <= clients) {
            TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportClientData.getClientNumber(doc, i));
            String tin = TaxStatementReportClientData.getClientTIN(doc, i);
            if (tin != null && tin.length() > 0) {
                if (tin.length() >= 9 && tin.length() <= 11) {
                    entity.setResult(TaxStatementReportResult.OK).setRemark("(" + client + ") " + tin);
                } else {
                    entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + client + ") " + tin);
                }
            } else {
                entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
            }
            step.addEntity(entity);
            ++i;
            ++client;
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute04(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(4, this.getStepDescription(lang, 4), this.getStepCondition(lang, 4));
        int i = 1;
        int client = 1;
        int clients = TaxStatementReportClientData.getClientCount(doc);
        while (i <= clients) {
            TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportClientData.getClientNumber(doc, i));
            String salutation = TaxStatementReportClientData.getClientSalutation(doc, i);
            if (salutation != null && salutation.length() > 0) {
                if (salutation.equals("1") || salutation.equals("2") || salutation.equals("3")) {
                    entity.setResult(TaxStatementReportResult.OK).setRemark("(" + client + ") " + salutation);
                } else {
                    entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + client + ") " + salutation);
                }
            } else {
                entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
            }
            step.addEntity(entity);
            ++i;
            ++client;
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute05(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(5, this.getStepDescription(lang, 5), this.getStepCondition(lang, 5));
        int i = 1;
        int client = 1;
        int clients = TaxStatementReportClientData.getClientCount(doc);
        while (i <= clients) {
            TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportClientData.getClientNumber(doc, i));
            String firstName = TaxStatementReportClientData.getClientFirstName(doc, i);
            if (firstName != null) {
                if (firstName.length() >= 0 && firstName.length() <= 30) {
                    entity.setResult(TaxStatementReportResult.OK).setRemark("(" + client + ") " + firstName);
                } else if (firstName.length() > 30) {
                    entity.setResult(TaxStatementReportResult.ERROR).setRemark("(" + client + ") " + firstName.length() + " " + (Object)((Object)TaxStatementReportOperator.GREATER) + " 30");
                } else {
                    entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + client + ") " + firstName);
                }
            } else {
                entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
            }
            step.addEntity(entity);
            ++i;
            ++client;
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute06(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(6, this.getStepDescription(lang, 6), this.getStepCondition(lang, 6));
        int i = 1;
        int client = 1;
        int clients = TaxStatementReportClientData.getClientCount(doc);
        while (i <= clients) {
            TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportClientData.getClientNumber(doc, i));
            String lastName = TaxStatementReportClientData.getClientLastName(doc, i);
            if (lastName != null) {
                if (lastName.length() >= 0 && lastName.length() <= 30) {
                    entity.setResult(TaxStatementReportResult.OK).setRemark("(" + client + ") " + lastName);
                } else if (lastName.length() > 30) {
                    entity.setResult(TaxStatementReportResult.ERROR).setRemark("(" + client + ") " + lastName.length() + " " + (Object)((Object)TaxStatementReportOperator.GREATER) + " 30");
                } else {
                    entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + client + ") " + lastName);
                }
            } else {
                entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
            }
            step.addEntity(entity);
            ++i;
            ++client;
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    @Override
    public TaxStatementReportResultCase execute(Document doc, byte[] xml, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultCase cs = new TaxStatementReportResultCase(this.getCaseGroup(), this.getCaseId(), this.getCaseGroup(lang), this.getCaseName(lang), this.getCaseDescription(lang));
        TaxStatementReportResult[][] ok = new TaxStatementReportResult[][]{new TaxStatementReportResult[0], {TaxStatementReportResult.OK}, {TaxStatementReportResult.OK}, {TaxStatementReportResult.OK}, {TaxStatementReportResult.OK}, {TaxStatementReportResult.OK}, {TaxStatementReportResult.OK}};
        cs.addStepResultMandatory(ok[1], this.execute01(doc, lang, formula));
        cs.addStepResultMandatory(ok[2], this.execute02(doc, lang, formula, TaxStatementReportClientData.getClientCount(doc) > 0));
        cs.addStepResultOptional(ok[3], this.execute03(doc, lang, formula, TaxStatementReportClientData.getClientCount(doc) > 0 && TaxStatementReportClientData.getClientTIN(doc)));
        cs.addStepResultOptional(ok[4], this.execute04(doc, lang, formula, TaxStatementReportClientData.getClientCount(doc) > 0 && TaxStatementReportClientData.getClientSalutation(doc)));
        cs.addStepResultMandatory(ok[5], this.execute05(doc, lang, formula, TaxStatementReportClientData.getClientCount(doc) > 0));
        cs.addStepResultMandatory(ok[6], this.execute06(doc, lang, formula, TaxStatementReportClientData.getClientCount(doc) > 0));
        return cs;
    }

    public TaxStatementReportClientCase01() {
        super("CLIENT_CASE", 1);
    }
}

