/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.report;

import ch.ewv.taxstatement.report.TaxStatementReportBankAccountData;
import ch.ewv.taxstatement.report.TaxStatementReportCase;
import ch.ewv.taxstatement.report.TaxStatementReportFormula;
import ch.ewv.taxstatement.report.TaxStatementReportOperator;
import ch.ewv.taxstatement.report.TaxStatementReportResult;
import ch.ewv.taxstatement.report.TaxStatementReportResultCase;
import ch.ewv.taxstatement.report.TaxStatementReportResultEntity;
import ch.ewv.taxstatement.report.TaxStatementReportResultStep;
import ch.ewv.taxstatement.report.TaxStatementReportSchemaData;
import ch.ewv.taxstatement.report.TaxStatementReportUtil;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class TaxStatementReportBankAccountCase01
extends TaxStatementReportCase {
    protected TaxStatementReportResultStep execute01(Document doc, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeExist(1, this.getStepDescription(lang, 1), this.getStepCondition(lang, 1), false, TaxStatementReportBankAccountData.getTotalTaxValue(doc));
    }

    protected TaxStatementReportResultStep execute02(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeCount(2, this.getStepDescription(lang, 2), this.getStepCondition(lang, 2), filter, TaxStatementReportBankAccountData.getBankAccountCount(doc));
    }

    protected TaxStatementReportResultStep execute03(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(3, this.getStepDescription(lang, 3), this.getStepCondition(lang, 3));
        String minorVersion = TaxStatementReportSchemaData.getMinorVersion(doc);
        int i = 1;
        int account = 1;
        int accounts = TaxStatementReportBankAccountData.getBankAccountCount(doc);
        while (i <= accounts) {
            TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportBankAccountData.getBankAccountName(doc, i));
            String iban = TaxStatementReportBankAccountData.getBankAccountIBAN(doc, i);
            if (iban != null) {
                if (iban.length() >= 15 && iban.length() <= 30) {
                    entity.setResult(TaxStatementReportResult.OK).setRemark("(" + account + ") " + iban);
                } else {
                    entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + account + ") " + iban);
                }
            } else if (minorVersion != null && minorVersion.equals("22")) {
                entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + account + ") " + iban);
            } else {
                entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
            }
            step.addEntity(entity);
            ++i;
            ++account;
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute04(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(4, this.getStepDescription(lang, 4), this.getStepCondition(lang, 4));
        int i = 1;
        int account = 1;
        int accounts = TaxStatementReportBankAccountData.getBankAccountCount(doc);
        while (i <= accounts) {
            TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportBankAccountData.getBankAccountName(doc, i));
            String number = TaxStatementReportBankAccountData.getBankAccountNumber(doc, i);
            if (number != null) {
                if (number.length() >= 1 && number.length() <= 32) {
                    entity.setResult(TaxStatementReportResult.OK).setRemark("(" + account + ") " + number);
                } else {
                    entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + account + ") " + number);
                }
            } else {
                entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
            }
            step.addEntity(entity);
            ++i;
            ++account;
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute05(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(5, this.getStepDescription(lang, 5), this.getStepCondition(lang, 5));
        int i = 1;
        int account = 1;
        int accounts = TaxStatementReportBankAccountData.getBankAccountCount(doc);
        while (i <= accounts) {
            TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportBankAccountData.getBankAccountName(doc, i));
            String name = TaxStatementReportBankAccountData.getBankAccountName(doc, i);
            if (name != null) {
                if (name.length() >= 1 && name.length() <= 40) {
                    entity.setResult(TaxStatementReportResult.OK).setRemark("(" + account + ") " + name);
                } else {
                    entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + account + ") " + name);
                }
            } else {
                entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
            }
            step.addEntity(entity);
            ++i;
            ++account;
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute06(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(6, this.getStepDescription(lang, 6), this.getStepCondition(lang, 6));
        int i = 1;
        int account = 1;
        int accounts = TaxStatementReportBankAccountData.getBankAccountCount(doc);
        while (i <= accounts) {
            TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportBankAccountData.getBankAccountName(doc, i));
            String country = TaxStatementReportBankAccountData.getBankAccountCountry(doc, i);
            if (country != null) {
                if (country.length() == 2 && country.charAt(0) >= 'A' && country.charAt(0) <= 'Z' && country.charAt(1) >= 'A' && country.charAt(1) <= 'Z') {
                    entity.setResult(TaxStatementReportResult.OK).setRemark("(" + account + ") " + country);
                } else {
                    entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + account + ") " + country);
                }
            } else {
                entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
            }
            step.addEntity(entity);
            ++i;
            ++account;
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute07(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(7, this.getStepDescription(lang, 7), this.getStepCondition(lang, 7));
        int i = 1;
        int account = 1;
        int accounts = TaxStatementReportBankAccountData.getBankAccountCount(doc);
        while (i <= accounts) {
            TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportBankAccountData.getBankAccountName(doc, i));
            String currency = TaxStatementReportBankAccountData.getBankAccountCurrency(doc, i);
            if (currency != null) {
                if (currency.length() == 3 && currency.charAt(0) >= 'A' && currency.charAt(0) <= 'Z' && currency.charAt(1) >= 'A' && currency.charAt(1) <= 'Z' && currency.charAt(2) >= 'A' && currency.charAt(2) <= 'Z') {
                    entity.setResult(TaxStatementReportResult.OK).setRemark("(" + account + ") " + currency);
                } else {
                    entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + account + ") " + currency);
                }
            } else {
                entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
            }
            step.addEntity(entity);
            ++i;
            ++account;
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute08(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(8, this.getStepDescription(lang, 8), this.getStepCondition(lang, 8));
        String taxPeriod = TaxStatementReportSchemaData.getTaxPeriod(doc);
        int i = 1;
        int account = 1;
        int accounts = TaxStatementReportBankAccountData.getBankAccountCount(doc);
        while (i <= accounts) {
            TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportBankAccountData.getBankAccountName(doc, i));
            Date openingDate = TaxStatementReportBankAccountData.getBankAccountOpeningDate(doc, i);
            Date closingDate = TaxStatementReportBankAccountData.getBankAccountClosingDate(doc, i);
            if (openingDate != null) {
                int year = Integer.parseInt(new SimpleDateFormat("yyyy").format(openingDate));
                if (taxPeriod != null && year <= Integer.parseInt(taxPeriod) && (closingDate == null || closingDate != null && !openingDate.after(closingDate))) {
                    entity.setResult(TaxStatementReportResult.OK).setRemark("(" + account + ") " + new SimpleDateFormat("dd.MM.yyyy").format(openingDate));
                } else if (taxPeriod != null && year > Integer.parseInt(taxPeriod)) {
                    entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + account + ") " + new SimpleDateFormat("dd.MM.yyyy").format(openingDate) + " " + (Object)((Object)TaxStatementReportOperator.NOTSMALLEREQUAL) + " 31.12." + taxPeriod);
                } else if (closingDate != null && openingDate.after(closingDate)) {
                    entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + account + ") " + new SimpleDateFormat("dd.MM.yyyy").format(openingDate) + " " + (Object)((Object)TaxStatementReportOperator.NOTSMALLEREQUAL) + " " + new SimpleDateFormat("dd.MM.yyyy").format(closingDate));
                } else {
                    entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + account + ") " + new SimpleDateFormat("dd.MM.yyyy").format(openingDate));
                }
            } else {
                entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
            }
            step.addEntity(entity);
            ++i;
            ++account;
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute09(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(9, this.getStepDescription(lang, 9), this.getStepCondition(lang, 9));
        String taxPeriod = TaxStatementReportSchemaData.getTaxPeriod(doc);
        int i = 1;
        int account = 1;
        int accounts = TaxStatementReportBankAccountData.getBankAccountCount(doc);
        while (i <= accounts) {
            TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportBankAccountData.getBankAccountName(doc, i));
            Date openingDate = TaxStatementReportBankAccountData.getBankAccountOpeningDate(doc, i);
            Date closingDate = TaxStatementReportBankAccountData.getBankAccountClosingDate(doc, i);
            if (closingDate != null) {
                int year = Integer.parseInt(new SimpleDateFormat("yyyy").format(closingDate));
                if (taxPeriod != null && year >= Integer.parseInt(taxPeriod) && (openingDate == null || openingDate != null && !closingDate.before(openingDate))) {
                    entity.setResult(TaxStatementReportResult.OK).setRemark("(" + account + ") " + new SimpleDateFormat("dd.MM.yyyy").format(closingDate));
                } else if (taxPeriod != null && year < Integer.parseInt(taxPeriod)) {
                    entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + account + ") " + new SimpleDateFormat("dd.MM.yyyy").format(closingDate) + " " + (Object)((Object)TaxStatementReportOperator.NOTGREATEREQUAL) + " 01.01." + taxPeriod);
                } else if (openingDate != null && closingDate.before(openingDate)) {
                    entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + account + ") " + new SimpleDateFormat("dd.MM.yyyy").format(closingDate) + " " + (Object)((Object)TaxStatementReportOperator.NOTGREATEREQUAL) + " " + new SimpleDateFormat("dd.MM.yyyy").format(openingDate));
                } else {
                    entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + account + ") " + new SimpleDateFormat("dd.MM.yyyy").format(closingDate));
                }
            } else {
                entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
            }
            step.addEntity(entity);
            ++i;
            ++account;
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute10(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(10, this.getStepDescription(lang, 10), this.getStepCondition(lang, 10));
        int i = 1;
        int account = 1;
        int accounts = TaxStatementReportBankAccountData.getBankAccountCount(doc);
        while (i <= accounts) {
            TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportBankAccountData.getBankAccountName(doc, i));
            Double total = TaxStatementReportBankAccountData.getTotalTaxValue(doc, i);
            if (total != null) {
                if (total >= 0.0) {
                    entity.setResult(TaxStatementReportResult.OK).setRemark("(" + account + ") " + String.format("%1$,.2f", total));
                } else {
                    entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + account + ") " + String.format("%1$,.2f", total));
                }
            } else {
                entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
            }
            step.addEntity(entity);
            ++i;
            ++account;
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute11(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(11, this.getStepDescription(lang, 11), this.getStepCondition(lang, 11));
        int i = 1;
        int account = 1;
        int accounts = TaxStatementReportBankAccountData.getBankAccountCount(doc);
        while (i <= accounts) {
            TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportBankAccountData.getBankAccountName(doc, i));
            Double total = TaxStatementReportBankAccountData.getTotalTaxValue(doc, i);
            Double value = TaxStatementReportBankAccountData.getTaxValueValue(doc, i);
            if (total != null || value != null && value > 0.0 && filter) {
                if (String.format("%1$,.2f", TaxStatementReportUtil.nvl(total, 0.0)).equals(String.format("%1$,.2f", TaxStatementReportUtil.nvl(value, 0.0)))) {
                    entity.setResult(TaxStatementReportResult.OK).setRemark("(" + account + ") " + String.format("%1$,.2f", TaxStatementReportUtil.nvl(total, 0.0)));
                } else if (TaxStatementReportUtil.approximately(total, value).booleanValue()) {
                    entity.setResult(TaxStatementReportResult.OK).setReason("(" + account + ") " + String.format("%1$,.2f", TaxStatementReportUtil.nvl(total, 0.0)) + " " + (Object)((Object)TaxStatementReportOperator.APPROXIMATELY) + " " + String.format("%1$,.2f", TaxStatementReportUtil.nvl(value, 0.0)));
                } else {
                    entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + account + ") " + String.format("%1$,.2f", TaxStatementReportUtil.nvl(total, 0.0)) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", TaxStatementReportUtil.nvl(value, 0.0)));
                }
            } else {
                entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
            }
            step.addEntity(entity);
            ++i;
            ++account;
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute12(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(12, this.getStepDescription(lang, 12), this.getStepCondition(lang, 12));
        int i = 1;
        int account = 1;
        int accounts = TaxStatementReportBankAccountData.getBankAccountCount(doc);
        while (i <= accounts) {
            TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportBankAccountData.getBankAccountName(doc, i));
            Double total = TaxStatementReportBankAccountData.getTotalTaxValue(doc, i);
            if (total != null) {
                if (String.format("%1$,.3f", total).equals(String.format("%1$,.3f", TaxStatementReportUtil.round(total)))) {
                    entity.setResult(TaxStatementReportResult.OK).setRemark("(" + account + ") " + String.format("%1$,.3f", total));
                } else if (String.format("%1$,.2f", total).equals(String.format("%1$,.2f", TaxStatementReportUtil.round(total)))) {
                    entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + account + ") " + String.format("%1$,.3f", total) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", TaxStatementReportUtil.round(total)));
                } else {
                    entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + account + ") " + String.format("%1$,.2f", total) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", TaxStatementReportUtil.round(total)));
                }
            } else {
                entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
            }
            step.addEntity(entity);
            ++i;
            ++account;
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute13(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(13, this.getStepDescription(lang, 13), this.getStepCondition(lang, 13));
        int i = 1;
        int account = 1;
        int accounts = TaxStatementReportBankAccountData.getBankAccountCount(doc);
        while (i <= accounts) {
            TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportBankAccountData.getBankAccountName(doc, i));
            Double total = TaxStatementReportBankAccountData.getTotalGrossRevenueA(doc, i);
            if (total != null) {
                if (total >= 0.0) {
                    entity.setResult(TaxStatementReportResult.OK).setRemark("(" + account + ") " + String.format("%1$,.2f", total));
                } else {
                    entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + account + ") " + String.format("%1$,.2f", total));
                }
            } else {
                entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
            }
            step.addEntity(entity);
            ++i;
            ++account;
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute14(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(14, this.getStepDescription(lang, 14), this.getStepCondition(lang, 14));
        int i = 1;
        int account = 1;
        int accounts = TaxStatementReportBankAccountData.getBankAccountCount(doc);
        while (i <= accounts) {
            TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportBankAccountData.getBankAccountName(doc, i));
            Double total = TaxStatementReportBankAccountData.getTotalGrossRevenueA(doc, i);
            Double calc = null;
            int j = 1;
            int payment = 1;
            int payments = TaxStatementReportBankAccountData.getPaymentCount(doc, i);
            while (j <= payments) {
                Double grossRevenueA = TaxStatementReportBankAccountData.getPaymentGrossRevenueA(doc, i, j);
                if (grossRevenueA != null) {
                    calc = TaxStatementReportUtil.nvl(calc, 0.0) + grossRevenueA;
                }
                ++j;
                ++payment;
            }
            if (total != null || calc != null && calc > 0.0 && filter) {
                if (String.format("%1$,.2f", TaxStatementReportUtil.nvl(total, 0.0)).equals(String.format("%1$,.2f", TaxStatementReportUtil.nvl(calc, 0.0)))) {
                    entity.setResult(TaxStatementReportResult.OK).setRemark("(" + account + ") " + String.format("%1$,.2f", TaxStatementReportUtil.nvl(total, 0.0)));
                } else if (TaxStatementReportUtil.approximately(total, calc).booleanValue()) {
                    entity.setResult(TaxStatementReportResult.OK).setReason("(" + account + ") " + String.format("%1$,.2f", TaxStatementReportUtil.nvl(total, 0.0)) + " " + (Object)((Object)TaxStatementReportOperator.APPROXIMATELY) + " " + String.format("%1$,.2f", TaxStatementReportUtil.nvl(calc, 0.0)));
                } else if (formula.approximately(total, calc).booleanValue()) {
                    entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + account + ") " + String.format("%1$,.2f", TaxStatementReportUtil.nvl(total, 0.0)) + " " + (Object)((Object)TaxStatementReportOperator.APPROXIMATELY) + " " + String.format("%1$,.2f", TaxStatementReportUtil.nvl(calc, 0.0)));
                } else {
                    entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + account + ") " + String.format("%1$,.2f", TaxStatementReportUtil.nvl(total, 0.0)) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", TaxStatementReportUtil.nvl(calc, 0.0)));
                }
            } else {
                entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
            }
            step.addEntity(entity);
            ++i;
            ++account;
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute15(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(15, this.getStepDescription(lang, 15), this.getStepCondition(lang, 15));
        int i = 1;
        int account = 1;
        int accounts = TaxStatementReportBankAccountData.getBankAccountCount(doc);
        while (i <= accounts) {
            TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportBankAccountData.getBankAccountName(doc, i));
            Double total = TaxStatementReportBankAccountData.getTotalGrossRevenueA(doc, i);
            if (total != null) {
                if (String.format("%1$,.3f", total).equals(String.format("%1$,.3f", TaxStatementReportUtil.round(total)))) {
                    entity.setResult(TaxStatementReportResult.OK).setRemark("(" + account + ") " + String.format("%1$,.3f", total));
                } else if (String.format("%1$,.2f", total).equals(String.format("%1$,.2f", TaxStatementReportUtil.round(total)))) {
                    entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + account + ") " + String.format("%1$,.3f", total) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", TaxStatementReportUtil.round(total)));
                } else {
                    entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + account + ") " + String.format("%1$,.2f", total) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", TaxStatementReportUtil.round(total)));
                }
            } else {
                entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
            }
            step.addEntity(entity);
            ++i;
            ++account;
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute16(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(16, this.getStepDescription(lang, 16), this.getStepCondition(lang, 16));
        int i = 1;
        int account = 1;
        int accounts = TaxStatementReportBankAccountData.getBankAccountCount(doc);
        while (i <= accounts) {
            TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportBankAccountData.getBankAccountName(doc, i));
            Double total = TaxStatementReportBankAccountData.getTotalGrossRevenueB(doc, i);
            if (total != null) {
                if (total >= 0.0) {
                    entity.setResult(TaxStatementReportResult.OK).setRemark("(" + account + ") " + String.format("%1$,.2f", total));
                } else {
                    entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + account + ") " + String.format("%1$,.2f", total));
                }
            } else {
                entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
            }
            step.addEntity(entity);
            ++i;
            ++account;
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute17(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(17, this.getStepDescription(lang, 17), this.getStepCondition(lang, 17));
        int i = 1;
        int account = 1;
        int accounts = TaxStatementReportBankAccountData.getBankAccountCount(doc);
        while (i <= accounts) {
            TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportBankAccountData.getBankAccountName(doc, i));
            Double total = TaxStatementReportBankAccountData.getTotalGrossRevenueB(doc, i);
            Double calc = null;
            int j = 1;
            int payment = 1;
            int payments = TaxStatementReportBankAccountData.getPaymentCount(doc, i);
            while (j <= payments) {
                Double grossRevenueB = TaxStatementReportBankAccountData.getPaymentGrossRevenueB(doc, i, j);
                if (grossRevenueB != null) {
                    calc = TaxStatementReportUtil.nvl(calc, 0.0) + grossRevenueB;
                }
                ++j;
                ++payment;
            }
            if (total != null || calc != null && calc > 0.0 && filter) {
                if (String.format("%1$,.2f", TaxStatementReportUtil.nvl(total, 0.0)).equals(String.format("%1$,.2f", TaxStatementReportUtil.nvl(calc, 0.0)))) {
                    entity.setResult(TaxStatementReportResult.OK).setRemark("(" + account + ") " + String.format("%1$,.2f", TaxStatementReportUtil.nvl(total, 0.0)));
                } else if (TaxStatementReportUtil.approximately(total, calc).booleanValue()) {
                    entity.setResult(TaxStatementReportResult.OK).setReason("(" + account + ") " + String.format("%1$,.2f", TaxStatementReportUtil.nvl(total, 0.0)) + " " + (Object)((Object)TaxStatementReportOperator.APPROXIMATELY) + " " + String.format("%1$,.2f", TaxStatementReportUtil.nvl(calc, 0.0)));
                } else if (formula.approximately(total, calc).booleanValue()) {
                    entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + account + ") " + String.format("%1$,.2f", TaxStatementReportUtil.nvl(total, 0.0)) + " " + (Object)((Object)TaxStatementReportOperator.APPROXIMATELY) + " " + String.format("%1$,.2f", TaxStatementReportUtil.nvl(calc, 0.0)));
                } else {
                    entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + account + ") " + String.format("%1$,.2f", TaxStatementReportUtil.nvl(total, 0.0)) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", TaxStatementReportUtil.nvl(calc, 0.0)));
                }
            } else {
                entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
            }
            step.addEntity(entity);
            ++i;
            ++account;
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute18(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(18, this.getStepDescription(lang, 18), this.getStepCondition(lang, 18));
        int i = 1;
        int account = 1;
        int accounts = TaxStatementReportBankAccountData.getBankAccountCount(doc);
        while (i <= accounts) {
            TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportBankAccountData.getBankAccountName(doc, i));
            Double total = TaxStatementReportBankAccountData.getTotalGrossRevenueB(doc, i);
            if (total != null) {
                if (String.format("%1$,.3f", total).equals(String.format("%1$,.3f", TaxStatementReportUtil.round(total)))) {
                    entity.setResult(TaxStatementReportResult.OK).setRemark("(" + account + ") " + String.format("%1$,.3f", total));
                } else if (String.format("%1$,.2f", total).equals(String.format("%1$,.2f", TaxStatementReportUtil.round(total)))) {
                    entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + account + ") " + String.format("%1$,.3f", total) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", TaxStatementReportUtil.round(total)));
                } else {
                    entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + account + ") " + String.format("%1$,.2f", total) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", TaxStatementReportUtil.round(total)));
                }
            } else {
                entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
            }
            step.addEntity(entity);
            ++i;
            ++account;
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute19(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(19, this.getStepDescription(lang, 19), this.getStepCondition(lang, 19));
        int i = 1;
        int account = 1;
        int accounts = TaxStatementReportBankAccountData.getBankAccountCount(doc);
        while (i <= accounts) {
            TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportBankAccountData.getBankAccountName(doc, i));
            Double total = TaxStatementReportBankAccountData.getTotalWithHoldingTaxClaim(doc, i);
            if (total != null) {
                if (total >= 0.0) {
                    entity.setResult(TaxStatementReportResult.OK).setRemark("(" + account + ") " + String.format("%1$,.2f", total));
                } else {
                    entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + account + ") " + String.format("%1$,.2f", total));
                }
            } else {
                entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
            }
            step.addEntity(entity);
            ++i;
            ++account;
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute20(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(20, this.getStepDescription(lang, 20), this.getStepCondition(lang, 20));
        int i = 1;
        int account = 1;
        int accounts = TaxStatementReportBankAccountData.getBankAccountCount(doc);
        while (i <= accounts) {
            TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportBankAccountData.getBankAccountName(doc, i));
            Double total = TaxStatementReportBankAccountData.getTotalWithHoldingTaxClaim(doc, i);
            Double calc = null;
            int j = 1;
            int payment = 1;
            int payments = TaxStatementReportBankAccountData.getPaymentCount(doc, i);
            while (j <= payments) {
                Double withHoldingTaxClaim = TaxStatementReportBankAccountData.getPaymentWithHoldingTaxClaim(doc, i, j);
                if (withHoldingTaxClaim != null) {
                    calc = TaxStatementReportUtil.nvl(calc, 0.0) + withHoldingTaxClaim;
                }
                ++j;
                ++payment;
            }
            if (total != null || calc != null && calc > 0.0 && filter) {
                if (String.format("%1$,.2f", TaxStatementReportUtil.nvl(total, 0.0)).equals(String.format("%1$,.2f", TaxStatementReportUtil.nvl(calc, 0.0)))) {
                    entity.setResult(TaxStatementReportResult.OK).setRemark("(" + account + ") " + String.format("%1$,.2f", TaxStatementReportUtil.nvl(total, 0.0)));
                } else if (TaxStatementReportUtil.approximately(total, calc).booleanValue()) {
                    entity.setResult(TaxStatementReportResult.OK).setReason("(" + account + ") " + String.format("%1$,.2f", TaxStatementReportUtil.nvl(total, 0.0)) + " " + (Object)((Object)TaxStatementReportOperator.APPROXIMATELY) + " " + String.format("%1$,.2f", TaxStatementReportUtil.nvl(calc, 0.0)));
                } else if (formula.approximately(total, calc).booleanValue()) {
                    entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + account + ") " + String.format("%1$,.2f", TaxStatementReportUtil.nvl(total, 0.0)) + " " + (Object)((Object)TaxStatementReportOperator.APPROXIMATELY) + " " + String.format("%1$,.2f", TaxStatementReportUtil.nvl(calc, 0.0)));
                } else {
                    entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + account + ") " + String.format("%1$,.2f", TaxStatementReportUtil.nvl(total, 0.0)) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", TaxStatementReportUtil.nvl(calc, 0.0)));
                }
            } else {
                entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
            }
            step.addEntity(entity);
            ++i;
            ++account;
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute21(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(21, this.getStepDescription(lang, 21), this.getStepCondition(lang, 21));
        int i = 1;
        int account = 1;
        int accounts = TaxStatementReportBankAccountData.getBankAccountCount(doc);
        while (i <= accounts) {
            TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportBankAccountData.getBankAccountName(doc, i));
            Double total = TaxStatementReportBankAccountData.getTotalWithHoldingTaxClaim(doc, i);
            if (total != null) {
                if (String.format("%1$,.3f", total).equals(String.format("%1$,.3f", TaxStatementReportUtil.round(total)))) {
                    entity.setResult(TaxStatementReportResult.OK).setRemark("(" + account + ") " + String.format("%1$,.3f", total));
                } else if (String.format("%1$,.2f", total).equals(String.format("%1$,.2f", TaxStatementReportUtil.round(total)))) {
                    entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + account + ") " + String.format("%1$,.3f", total) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", TaxStatementReportUtil.round(total)));
                } else {
                    entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + account + ") " + String.format("%1$,.2f", total) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", TaxStatementReportUtil.round(total)));
                }
            } else {
                entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
            }
            step.addEntity(entity);
            ++i;
            ++account;
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    @Override
    public TaxStatementReportResultCase execute(Document doc, byte[] xml, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultCase cs = new TaxStatementReportResultCase(this.getCaseGroup(), this.getCaseId(), this.getCaseGroup(lang), this.getCaseName(lang), this.getCaseDescription(lang));
        TaxStatementReportResult[][] ok = new TaxStatementReportResult[][]{new TaxStatementReportResult[0], {TaxStatementReportResult.ERROR, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, TaxStatementReportResult.ERROR, TaxStatementReportResult.OK}, {null, null, TaxStatementReportResult.OK}, {null, null, null}, {null, null, TaxStatementReportResult.OK}, {null, null, TaxStatementReportResult.OK}, {null, null, TaxStatementReportResult.OK}, {null, null, null}, {null, null, null}, {null, null, TaxStatementReportResult.OK}, {null, null, TaxStatementReportResult.OK}, {null, null, TaxStatementReportResult.OK}, {null, null, TaxStatementReportResult.OK}, {null, null, TaxStatementReportResult.OK}, {null, null, TaxStatementReportResult.OK}, {null, null, TaxStatementReportResult.OK}, {null, null, TaxStatementReportResult.OK}, {null, null, TaxStatementReportResult.OK}, {null, null, TaxStatementReportResult.OK}, {null, null, TaxStatementReportResult.OK}, {null, null, TaxStatementReportResult.OK}};
        cs.addStepResultOptional(ok[1], this.execute01(doc, lang, formula));
        cs.addStepResultOptional(ok[2], this.execute02(doc, lang, formula, TaxStatementReportBankAccountData.getTotalTaxValue(doc) != null && TaxStatementReportBankAccountData.getBankAccountCount(doc) > 0));
        cs.addStepResultMandatory(ok[3], this.execute03(doc, lang, formula, TaxStatementReportBankAccountData.getBankAccountCount(doc) > 0));
        cs.addStepResultOptional(ok[4], this.execute04(doc, lang, formula, TaxStatementReportBankAccountData.getBankAccountCount(doc) > 0 && TaxStatementReportBankAccountData.getBankAccountNumber(doc)));
        cs.addStepResultMandatory(ok[5], this.execute05(doc, lang, formula, TaxStatementReportBankAccountData.getBankAccountCount(doc) > 0));
        cs.addStepResultMandatory(ok[6], this.execute06(doc, lang, formula, TaxStatementReportBankAccountData.getBankAccountCount(doc) > 0));
        cs.addStepResultMandatory(ok[7], this.execute07(doc, lang, formula, TaxStatementReportBankAccountData.getBankAccountCount(doc) > 0));
        cs.addStepResultOptional(ok[8], this.execute08(doc, lang, formula, TaxStatementReportBankAccountData.getBankAccountCount(doc) > 0 && TaxStatementReportBankAccountData.getBankAccountOpeningDate(doc)));
        cs.addStepResultOptional(ok[9], this.execute09(doc, lang, formula, TaxStatementReportBankAccountData.getBankAccountCount(doc) > 0 && TaxStatementReportBankAccountData.getBankAccountClosingDate(doc)));
        cs.addStepResultMandatory(ok[10], this.execute10(doc, lang, formula, TaxStatementReportBankAccountData.getBankAccountCount(doc) > 0));
        cs.addStepResultMandatory(ok[11], this.execute11(doc, lang, formula, TaxStatementReportBankAccountData.getBankAccountCount(doc) > 0));
        cs.addStepResultMandatory(ok[12], this.execute12(doc, lang, formula, TaxStatementReportBankAccountData.getBankAccountCount(doc) > 0));
        cs.addStepResultMandatory(ok[13], this.execute13(doc, lang, formula, TaxStatementReportBankAccountData.getBankAccountCount(doc) > 0));
        cs.addStepResultMandatory(ok[14], this.execute14(doc, lang, formula, TaxStatementReportBankAccountData.getBankAccountCount(doc) > 0));
        cs.addStepResultMandatory(ok[15], this.execute15(doc, lang, formula, TaxStatementReportBankAccountData.getBankAccountCount(doc) > 0));
        cs.addStepResultMandatory(ok[16], this.execute16(doc, lang, formula, TaxStatementReportBankAccountData.getBankAccountCount(doc) > 0));
        cs.addStepResultMandatory(ok[17], this.execute17(doc, lang, formula, TaxStatementReportBankAccountData.getBankAccountCount(doc) > 0));
        cs.addStepResultMandatory(ok[18], this.execute18(doc, lang, formula, TaxStatementReportBankAccountData.getBankAccountCount(doc) > 0));
        cs.addStepResultMandatory(ok[19], this.execute19(doc, lang, formula, TaxStatementReportBankAccountData.getBankAccountCount(doc) > 0));
        cs.addStepResultMandatory(ok[20], this.execute20(doc, lang, formula, TaxStatementReportBankAccountData.getBankAccountCount(doc) > 0));
        cs.addStepResultMandatory(ok[21], this.execute21(doc, lang, formula, TaxStatementReportBankAccountData.getBankAccountCount(doc) > 0));
        return cs;
    }

    public TaxStatementReportBankAccountCase01() {
        super("BANK_ACCOUNT_CASE", 1);
    }
}

