/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.pdf.xrwht;

import ch.ewv.taxstatement.pdf.TaxStatementPDFProperty;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKBankAccount;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKLayout;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKOverview;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKSecurity;
import ch.ewv.taxstatement.pdf.xr.TaxStatementXR;
import ch.ewv.taxstatement.pdf.xrwht.TaxStatementXRWHTBankAccount;
import ch.ewv.taxstatement.pdf.xrwht.TaxStatementXRWHTLayout;
import ch.ewv.taxstatement.pdf.xrwht.TaxStatementXRWHTOverview;
import ch.ewv.taxstatement.pdf.xrwht.TaxStatementXRWHTSecurity;

public class TaxStatementXRWHT
extends TaxStatementXR {
    public static final boolean BANK_ACCOUNT = true;
    public static final boolean CRYPTO = false;
    public static final boolean EXPENSE = false;
    public static final boolean LIABILITY = false;
    public static final boolean NON_RECOVERABLE = true;
    public static final boolean OTHER = false;
    public static final boolean SECURITY = true;
    public static final boolean SECURITY_WITH_WITHHOLDING_TAX = true;
    public static final boolean SECURITY_WITHOUT_WITHHOLDING_TAX = false;
    public static final boolean TAX_RECLAIM = true;

    @Override
    protected boolean isBankAccount() {
        return System.getProperty("bankAccount") != null ? TaxStatementPDFProperty.BANK_ACCOUNT : true;
    }

    @Override
    protected boolean isCrypto() {
        return System.getProperty("crypto") != null ? TaxStatementPDFProperty.CRYPTO : false;
    }

    @Override
    protected boolean isExpense() {
        return System.getProperty("expense") != null ? TaxStatementPDFProperty.EXPENSE : false;
    }

    @Override
    protected boolean isLiability() {
        return System.getProperty("liability") != null ? TaxStatementPDFProperty.LIABILITY : false;
    }

    @Override
    protected boolean isNonRecoverable() {
        return System.getProperty("nonRecoverable") != null ? TaxStatementPDFProperty.NON_RECOVERABLE : true;
    }

    @Override
    protected boolean isOther() {
        return System.getProperty("other") != null ? TaxStatementPDFProperty.OTHER : false;
    }

    @Override
    protected boolean isSecurity() {
        return System.getProperty("security") != null ? TaxStatementPDFProperty.SECURITY : true;
    }

    @Override
    protected boolean isSecurityWithHoldingTax() {
        return System.getProperty("securityWithHoldingTax") != null ? TaxStatementPDFProperty.SECURITY_WITH_HOLDING_TAX : true;
    }

    @Override
    protected boolean isSecurityWithOutHoldingTax() {
        return System.getProperty("securityWithoutHoldingTax") != null ? TaxStatementPDFProperty.SECURITY_WITHOUT_HOLDING_TAX : true;
    }

    @Override
    protected boolean isTaxReclaim() {
        return System.getProperty("taxReclaim") != null ? TaxStatementPDFProperty.TAX_RECLAIM : true;
    }

    @Override
    protected TaxStatementSSKBankAccount bankAccount() {
        return this.isBankAccount() ? new TaxStatementXRWHTBankAccount() : null;
    }

    @Override
    protected TaxStatementSSKLayout layout() {
        return this.isLayout() ? new TaxStatementXRWHTLayout() : null;
    }

    @Override
    protected TaxStatementSSKOverview overview() {
        return this.isOverview() ? new TaxStatementXRWHTOverview() : null;
    }

    @Override
    protected TaxStatementSSKSecurity security() {
        return this.isSecurity() ? new TaxStatementXRWHTSecurity() : null;
    }
}

