/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.pdf.trls;

import ch.ewv.taxstatement.pdf.TaxStatementPDFProperty;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKLayout;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKOverview;
import ch.ewv.taxstatement.pdf.tr.TaxStatementTR;
import ch.ewv.taxstatement.pdf.trls.TaxStatementTRLSLayout;
import ch.ewv.taxstatement.pdf.trls.TaxStatementTRLSOverview;

public class TaxStatementTRLS
extends TaxStatementTR {
    public static final boolean BANK_ACCOUNT = true;
    public static final boolean CRYPTO = false;
    public static final boolean EXPENSE = true;
    public static final boolean LIABILITY = true;
    public static final boolean NON_RECOVERABLE = false;
    public static final boolean OTHER = true;
    public static final boolean SECURITY = true;
    public static final boolean SECURITY_WITH_WITHHOLDING_TAX = true;
    public static final boolean SECURITY_WITHOUT_WITHHOLDING_TAX = false;
    public static final boolean TAX_RECLAIM = false;

    @Override
    protected boolean isBankAccount() {
        return System.getProperty("bankAccount") != null ? TaxStatementPDFProperty.BANK_ACCOUNT : true;
    }

    @Override
    protected boolean isCrypto() {
        return System.getProperty("crypto") != null ? TaxStatementPDFProperty.CRYPTO : false;
    }

    @Override
    protected boolean isExpense() {
        return System.getProperty("expense") != null ? TaxStatementPDFProperty.EXPENSE : true;
    }

    @Override
    protected boolean isLiability() {
        return System.getProperty("liability") != null ? TaxStatementPDFProperty.LIABILITY : true;
    }

    @Override
    protected boolean isNonRecoverable() {
        return System.getProperty("nonRecoverable") != null ? TaxStatementPDFProperty.NON_RECOVERABLE : false;
    }

    @Override
    protected boolean isOther() {
        return System.getProperty("other") != null ? TaxStatementPDFProperty.OTHER : true;
    }

    @Override
    protected boolean isSecurity() {
        return System.getProperty("security") != null ? TaxStatementPDFProperty.SECURITY : true;
    }

    @Override
    protected boolean isSecurityWithHoldingTax() {
        return System.getProperty("securityWithHoldingTax") != null ? TaxStatementPDFProperty.SECURITY_WITH_HOLDING_TAX : true;
    }

    @Override
    protected boolean isSecurityWithOutHoldingTax() {
        return System.getProperty("securityWithoutHoldingTax") != null ? TaxStatementPDFProperty.SECURITY_WITHOUT_HOLDING_TAX : true;
    }

    @Override
    protected boolean isTaxReclaim() {
        return System.getProperty("taxReclaim") != null ? TaxStatementPDFProperty.TAX_RECLAIM : false;
    }

    @Override
    protected TaxStatementSSKLayout layout() {
        return this.isLayout() ? new TaxStatementTRLSLayout() : null;
    }

    @Override
    protected TaxStatementSSKOverview overview() {
        return this.isOverview() ? new TaxStatementTRLSOverview() : null;
    }
}

