/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.pdf.trfa;

import ch.ewv.taxstatement.pdf.TaxStatementPDFProperty;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKLayout;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKOverview;
import ch.ewv.taxstatement.pdf.tr.TaxStatementTR;
import ch.ewv.taxstatement.pdf.trfa.TaxStatementTRFALayout;
import ch.ewv.taxstatement.pdf.trfa.TaxStatementTRFAOverview;

public class TaxStatementTRFA
extends TaxStatementTR {
    public static final boolean BANK_ACCOUNT = true;
    public static final boolean CRYPTO = false;
    public static final boolean EXPENSE = true;
    public static final boolean LIABILITY = true;
    public static final boolean NON_RECOVERABLE = true;
    public static final boolean OTHER = false;
    public static final boolean SECURITY = true;
    public static final boolean TAX_RECLAIM = false;

    @Override
    protected boolean isBankAccount() {
        return System.getProperty("bankAccount") != null ? TaxStatementPDFProperty.BANK_ACCOUNT : true;
    }

    @Override
    protected boolean isCrypto() {
        return System.getProperty("crypto") != null ? TaxStatementPDFProperty.CRYPTO : false;
    }

    @Override
    protected boolean isExpense() {
        return System.getProperty("expense") != null ? TaxStatementPDFProperty.EXPENSE : true;
    }

    @Override
    protected boolean isLiability() {
        return System.getProperty("liability") != null ? TaxStatementPDFProperty.LIABILITY : true;
    }

    @Override
    protected boolean isNonRecoverable() {
        return System.getProperty("nonRecoverable") != null ? TaxStatementPDFProperty.NON_RECOVERABLE : true;
    }

    @Override
    protected boolean isOther() {
        return System.getProperty("other") != null ? TaxStatementPDFProperty.OTHER : false;
    }

    @Override
    protected boolean isSecurity() {
        return System.getProperty("security") != null ? TaxStatementPDFProperty.SECURITY : true;
    }

    @Override
    protected boolean isTaxReclaim() {
        return System.getProperty("taxReclaim") != null ? TaxStatementPDFProperty.TAX_RECLAIM : false;
    }

    @Override
    protected TaxStatementSSKLayout layout() {
        return this.isLayout() ? new TaxStatementTRFALayout() : null;
    }

    @Override
    protected TaxStatementSSKOverview overview() {
        return this.isOverview() ? new TaxStatementTRFAOverview() : null;
    }
}

