/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.pdf.ssk;

import ch.ewv.taxstatement.pdf.TaxStatementPDFContext;
import ch.ewv.taxstatement.pdf.TaxStatementPDFFormula;
import ch.ewv.taxstatement.pdf.TaxStatementPDFRenderer;
import ch.ewv.taxstatement.pdf.TaxStatementPDFSchemaData;
import ch.ewv.taxstatement.pdf.TaxStatementPDFSecurityData;
import ch.ewv.taxstatement.pdf.TaxStatementPDFUtil;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Properties;
import javax.xml.xpath.XPathExpressionException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.util.Matrix;
import org.w3c.dom.Document;

public class TaxStatementSSKTaxReclaim
extends TaxStatementPDFRenderer {
    public static final String HEADER = "HEADER_TAX_RECLAIM";
    public static final String HEADER_EXTENDED = "HEADER_TAX_RECLAIM_EXTENDED";
    public static final String TOTAL = "TOTAL";
    public static final String COUNTRY_ = "COUNTRY_";
    public static final String DEPOT = "TAX_RECLAIM_DEPOT";
    public static final String STOCK = "TAX_RECLAIM_STOCK";
    public static final String CURRENCY_LINE1 = "TAX_RECLAIM_CURRENCY_LINE1";
    public static final String CURRENCY_LINE2 = "TAX_RECLAIM_CURRENCY_LINE2";
    public static final String CURRENCY_LINE3 = "TAX_RECLAIM_CURRENCY_LINE3";
    public static final String DESCRIPTION_LINE1 = "TAX_RECLAIM_DESCRIPTION_LINE1";
    public static final String DESCRIPTION_LINE2 = "TAX_RECLAIM_DESCRIPTION_LINE2";
    public static final String DESCRIPTION_LINE3 = "TAX_RECLAIM_DESCRIPTION_LINE3";
    public static final String GROSS_REVENUE_B_LINE1 = "TAX_RECLAIM_GROSS_REVENUE_B_LINE1";
    public static final String GROSS_REVENUE_B_LINE2 = "TAX_RECLAIM_GROSS_REVENUE_B_LINE2";
    public static final String GROSS_REVENUE_B_LINE3 = "TAX_RECLAIM_GROSS_REVENUE_B_LINE3";
    public static final String NUMBER_LINE1 = "TAX_RECLAIM_NUMBER_LINE1";
    public static final String NUMBER_LINE2 = "TAX_RECLAIM_NUMBER_LINE2";
    public static final String NUMBER_LINE3 = "TAX_RECLAIM_NUMBER_LINE3";
    public static final String QUANTITY_LINE1 = "TAX_RECLAIM_QUANTITY_LINE1";
    public static final String QUANTITY_LINE2 = "TAX_RECLAIM_QUANTITY_LINE2";
    public static final String QUANTITY_LINE3 = "TAX_RECLAIM_QUANTITY_LINE3";
    public static final String VALUE_LINE1 = "TAX_RECLAIM_VALUE_LINE1";
    public static final String VALUE_LINE2 = "TAX_RECLAIM_VALUE_LINE2";
    public static final String VALUE_LINE3 = "TAX_RECLAIM_VALUE_LINE3";
    public static final String WITHHOLDING_TAX_CLAIM_AMOUNT_LINE1 = "TAX_RECLAIM_WITHHOLDING_TAX_CLAIM_AMOUNT_LINE1";
    public static final String WITHHOLDING_TAX_CLAIM_AMOUNT_LINE2 = "TAX_RECLAIM_WITHHOLDING_TAX_CLAIM_AMOUNT_LINE2";
    public static final String WITHHOLDING_TAX_CLAIM_AMOUNT_LINE3 = "TAX_RECLAIM_WITHHOLDING_TAX_CLAIM_AMOUNT_LINE3";
    public static final String WITHHOLDING_TAX_CLAIM_PERCENT_LINE1 = "TAX_RECLAIM_WITHHOLDING_TAX_CLAIM_PERCENT_LINE1";
    public static final String WITHHOLDING_TAX_CLAIM_PERCENT_LINE2 = "TAX_RECLAIM_WITHHOLDING_TAX_CLAIM_PERCENT_LINE2";
    public static final String WITHHOLDING_TAX_CLAIM_PERCENT_LINE3 = "TAX_RECLAIM_WITHHOLDING_TAX_CLAIM_PERCENT_LINE3";
    public static final String RELEASE_TAX_AMOUNT_LINE1 = "TAX_RECLAIM_RELEASE_TAX_AMOUNT_LINE1";
    public static final String RELEASE_TAX_AMOUNT_LINE2 = "TAX_RECLAIM_RELEASE_TAX_AMOUNT_LINE2";
    public static final String RELEASE_TAX_AMOUNT_LINE3 = "TAX_RECLAIM_RELEASE_TAX_AMOUNT_LINE3";
    public static final String RELEASE_TAX_PERCENT_LINE1 = "TAX_RECLAIM_RELEASE_TAX_PERCENT_LINE1";
    public static final String RELEASE_TAX_PERCENT_LINE2 = "TAX_RECLAIM_RELEASE_TAX_PERCENT_LINE2";
    public static final String RELEASE_TAX_PERCENT_LINE3 = "TAX_RECLAIM_RELEASE_TAX_PERCENT_LINE3";
    public static final int COL1 = 71;
    public static final int COL2 = 130;
    public static final int COL3 = 370;
    public static final int COL4 = 375;
    public static final int COL5 = 460;
    public static final int COL6 = 535;
    public static final int COL7 = 614;
    public static final int COL8 = 674;
    public static final int COL9 = 744;
    public static final int COL10 = 804;
    public static final int NMAX = 45;

    protected int col1() {
        return 71 + this.offsetX();
    }

    protected int col2() {
        return 130 + this.offsetX();
    }

    protected int col3() {
        return 370 + this.offsetX();
    }

    protected int col4() {
        return 375 + this.offsetX();
    }

    protected int col5() {
        return 460 + this.offsetX();
    }

    protected int col6() {
        return 535 + this.offsetX();
    }

    protected int col7() {
        return 614 + this.offsetX();
    }

    protected int col8() {
        return 674 + this.offsetX();
    }

    protected int col9() {
        return 744 + this.offsetX();
    }

    protected int col10() {
        return 804 + this.offsetX();
    }

    protected int nmax() {
        return 45;
    }

    protected String hash(Document doc, int depot, int security, Properties lang) throws IOException, ParseException, XPathExpressionException {
        Double valorNumber = TaxStatementPDFSecurityData.getSecurityValorNumber(doc, depot, security);
        String category = TaxStatementPDFSecurityData.getSecurityCategory(doc, depot, security);
        String country = TaxStatementPDFSecurityData.getSecurityCountry(doc, depot, security);
        String name = this.securityName(doc, depot, security);
        String hx = "";
        if (country != null) {
            hx = hx + TaxStatementPDFUtil.normalize(TaxStatementPDFUtil.getText(lang, COUNTRY_ + country.toUpperCase()));
        }
        if (category != null && this.category()) {
            if (category.equals("SHARE")) {
                hx = hx + "1";
            }
            if (category.equals("FUND")) {
                hx = hx + "2";
            }
            if (category.equals("DEVT")) {
                hx = hx + "3";
            }
            if (category.equals("BOND")) {
                hx = hx + "4";
            }
            if (category.equals("COINBULL")) {
                hx = hx + "5";
            }
            if (category.equals("CURRNOTE")) {
                hx = hx + "6";
            }
            if (category.equals("LIBOSWAP")) {
                hx = hx + "7";
            }
            if (category.equals("OPTION")) {
                hx = hx + "8";
            }
            if (category.equals("OTHER")) {
                hx = hx + "9";
            }
            if (name != null && name.length() > 0) {
                hx = hx + TaxStatementPDFUtil.normalize(name);
            }
        }
        hx = valorNumber != null ? hx + new DecimalFormat("000000000").format(valorNumber) : hx + "000000000";
        if (name != null && name.length() > 0) {
            hx = hx + TaxStatementPDFUtil.normalize(name);
        }
        if (security > 0) {
            hx = hx + String.format("%04d", security);
        }
        return hx;
    }

    protected String securityName(Document doc, int depot, int security) throws IOException, ParseException, XPathExpressionException {
        String name = TaxStatementPDFSecurityData.getSecurityName(doc, depot, security);
        String ntax = TaxStatementPDFSecurityData.getTaxValueName(doc, depot, security);
        String country = TaxStatementPDFSecurityData.getSecurityCountry(doc, depot, security);
        String category = TaxStatementPDFSecurityData.getSecurityCategory(doc, depot, security);
        if (name != null && name.length() > 0 && ntax != null && ntax.length() > 0) {
            if (name.length() >= 40) {
                if (ntax.startsWith(name.substring(0, 40))) {
                    name = ntax;
                }
            } else if (ntax.startsWith(name)) {
                name = ntax;
            }
        }
        if (category != null && category.equals("BOND")) {
            Boolean variableInterest = TaxStatementPDFSecurityData.getSecurityVariableInterest(doc, depot, security);
            Double interestRate = TaxStatementPDFSecurityData.getSecurityInterestRate(doc, depot, security);
            if (variableInterest != null && variableInterest.booleanValue()) {
                if (name != null && name.length() > 0) {
                    if (!name.contains("VAR,")) {
                        name = "VAR, " + name;
                    }
                } else {
                    name = "VAR";
                }
            } else if (interestRate != null && interestRate >= 0.0) {
                if (name != null && name.length() > 0) {
                    if (!name.contains("%")) {
                        name = Double.toString(interestRate) + "%, " + name;
                    }
                } else {
                    name = Double.toString(interestRate) + "%";
                }
            }
        }
        if (country != null && !country.equals("XX")) {
            if (name != null && name.length() > 0) {
                if (!name.contains(" " + country) || name.contains(" DEUTSCH")) {
                    name = name + ", " + country;
                }
            } else {
                name = country;
            }
        }
        if (category != null && category.equals("BOND")) {
            String issueYear = TaxStatementPDFSecurityData.getSecurityIssueDate(doc, depot, security, "yyyy");
            String redemptionYear = TaxStatementPDFSecurityData.getSecurityRedemptionDate(doc, depot, security, "yyyy");
            String redemptionDate = TaxStatementPDFSecurityData.getSecurityRedemptionDate(doc, depot, security, "dd.MM.yyyy");
            if (issueYear != null && issueYear.length() > 0 && redemptionYear != null && redemptionYear.length() > 0) {
                if (name != null && name.length() > 0) {
                    if (!name.contains(issueYear) && !name.contains(redemptionYear)) {
                        name = name + ", " + issueYear + "-" + redemptionDate;
                    }
                } else {
                    name = issueYear + "-" + redemptionDate;
                }
            } else if (issueYear != null && issueYear.length() > 0) {
                if (name != null && name.length() > 0) {
                    if (!name.contains(issueYear)) {
                        name = name + ", " + issueYear;
                    }
                } else {
                    name = issueYear;
                }
            } else if (redemptionYear != null && redemptionYear.length() > 0) {
                if (name != null && name.length() > 0) {
                    if (!name.contains(redemptionYear)) {
                        name = name + ", " + redemptionDate;
                    }
                } else {
                    name = redemptionDate;
                }
            }
        }
        return name;
    }

    protected PDPage addPage(TaxStatementPDFContext ct, PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content) throws IOException, ParseException, XPathExpressionException {
        this.endPage(ct, pdd, font, bold, doc, lang, data);
        PDPage page = new PDPage();
        page.setMediaBox(PDRectangle.A4);
        page.setRotation(90);
        pdd.addPage(page);
        ct.setPage(page).setRow(0).setQuantityDecimal(null).setUnitPriceDecimal(null);
        if (layout != null) {
            layout.addLayout(pdd, font, bold, logo, size, doc, lang, data, content, page, this.extended() ? HEADER_EXTENDED : HEADER);
            layout.addPageBarCode(pdd, font, bold, doc, page, 197);
        }
        return page;
    }

    protected PDPageContentStream addPage(TaxStatementPDFContext ct, PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content, PDPageContentStream cs, Matrix mx) throws IOException, ParseException, XPathExpressionException {
        cs.transform(mx);
        cs.transform(mx);
        cs.transform(mx);
        cs.close();
        PDPage page = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content);
        cs = new PDPageContentStream(pdd, page, PDPageContentStream.AppendMode.APPEND, true);
        cs.transform(mx);
        return cs;
    }

    protected void endPage(TaxStatementPDFContext ct, PDDocument pdd, PDFont font, PDFont bold, Document doc, Properties lang, Properties data) throws IOException, ParseException, XPathExpressionException {
        if (ct.getPage() != null) {
            this.addHeader(ct, pdd, font, bold, doc, lang, data, ct.getPage());
        }
    }

    protected void addHeader(TaxStatementPDFContext ct, PDDocument pdd, PDFont font, PDFont bold, Document doc, Properties lang, Properties data, PDPage page) throws IOException, ParseException, XPathExpressionException {
        PDPageContentStream cs = new PDPageContentStream(pdd, page, PDPageContentStream.AppendMode.APPEND, true);
        Matrix mx = new Matrix(0.0f, 1.0f, -1.0f, 0.0f, page.getMediaBox().getWidth(), 0.0f);
        Color grey = new Color(211, 211, 211);
        PDFont xxxx = TaxStatementPDFUtil.getText(lang, WITHHOLDING_TAX_CLAIM_AMOUNT_LINE3).length() > 0 ? bold : font;
        cs.transform(mx);
        int yh = this.yh();
        int xa = this.xa();
        int xe = this.xe();
        int col1 = this.col1();
        int col2 = this.col2();
        int col3 = this.col3();
        int col4 = this.col4();
        int col5 = this.col5();
        int col6 = this.col6();
        int col7 = this.col7();
        int col8 = this.col8();
        int col9 = this.col9();
        int col10 = this.col10();
        int row1 = yh + 2 - 10;
        int row2 = yh + 2 - 20;
        int row3 = yh + 2 - 30;
        TaxStatementPDFUtil.drawRectangle(cs, grey, xa, yh, xe, row3 - 4, grey);
        TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col1, row1, TaxStatementPDFUtil.getText(lang, NUMBER_LINE1));
        TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col1, row2, TaxStatementPDFUtil.getText(lang, NUMBER_LINE2));
        TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col1, row3, TaxStatementPDFUtil.getText(lang, NUMBER_LINE3));
        TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col2, row1, TaxStatementPDFUtil.getText(lang, DESCRIPTION_LINE1));
        TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col2, row2, TaxStatementPDFUtil.getText(lang, DESCRIPTION_LINE2));
        TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col2, row3, TaxStatementPDFUtil.getText(lang, DESCRIPTION_LINE3));
        float cox3 = col3;
        if (ct.getQuantityDecimal() < this.quantityDecimalMax()) {
            cox3 = (float)col3 - TaxStatementPDFUtil.width(font, 8, String.format("%0" + (this.quantityDecimalMax() - ct.getQuantityDecimal()) + "d", 0));
        }
        TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, cox3, row1, TaxStatementPDFUtil.getText(lang, QUANTITY_LINE1));
        TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, cox3, row2, TaxStatementPDFUtil.getText(lang, QUANTITY_LINE2));
        TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, cox3, row3, TaxStatementPDFUtil.getText(lang, QUANTITY_LINE3));
        TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col4, row1, TaxStatementPDFUtil.getText(lang, CURRENCY_LINE1));
        TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col4, row2, TaxStatementPDFUtil.getText(lang, CURRENCY_LINE2));
        TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col4, row3, TaxStatementPDFUtil.getText(lang, CURRENCY_LINE3));
        float cox5 = col5;
        if (ct.getUnitPriceDecimal() < this.unitPriceDecimalMax()) {
            cox5 = (float)col5 - TaxStatementPDFUtil.width(font, 8, String.format("%0" + (this.unitPriceDecimalMax() - ct.getUnitPriceDecimal()) + "d", 0));
        }
        TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, cox5, row1, TaxStatementPDFUtil.getText(lang, VALUE_LINE1));
        TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, cox5, row2, TaxStatementPDFUtil.getText(lang, VALUE_LINE2));
        TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, cox5, row3, TaxStatementPDFUtil.getText(lang, VALUE_LINE3));
        TaxStatementPDFUtil.showTextRight(cs, bold, 8, Color.BLACK, col6, row1, TaxStatementPDFUtil.getText(lang, GROSS_REVENUE_B_LINE1));
        TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col6, row2, String.format(TaxStatementPDFUtil.getText(lang, GROSS_REVENUE_B_LINE2), this.headerYear() ? TaxStatementPDFSchemaData.getPeriodTo(doc, "yyyy") : ""));
        TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col6, row3, TaxStatementPDFUtil.getText(lang, GROSS_REVENUE_B_LINE3));
        TaxStatementPDFUtil.showTextRight(cs, bold, 8, Color.BLACK, col7, row1, TaxStatementPDFUtil.getText(lang, WITHHOLDING_TAX_CLAIM_AMOUNT_LINE1));
        TaxStatementPDFUtil.showTextRight(cs, xxxx, 8, Color.BLACK, col7, row2, TaxStatementPDFUtil.getText(lang, WITHHOLDING_TAX_CLAIM_AMOUNT_LINE2));
        TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col7, row3, TaxStatementPDFUtil.getText(lang, WITHHOLDING_TAX_CLAIM_AMOUNT_LINE3));
        TaxStatementPDFUtil.showTextRight(cs, bold, 8, Color.BLACK, col8, row1, TaxStatementPDFUtil.getText(lang, WITHHOLDING_TAX_CLAIM_PERCENT_LINE1));
        TaxStatementPDFUtil.showTextRight(cs, xxxx, 8, Color.BLACK, col8, row2, TaxStatementPDFUtil.getText(lang, WITHHOLDING_TAX_CLAIM_PERCENT_LINE2));
        TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col8, row3, TaxStatementPDFUtil.getText(lang, WITHHOLDING_TAX_CLAIM_PERCENT_LINE3));
        TaxStatementPDFUtil.showTextRight(cs, bold, 8, Color.BLACK, col9, row1, TaxStatementPDFUtil.getText(lang, RELEASE_TAX_AMOUNT_LINE1));
        TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col9, row2, TaxStatementPDFUtil.getText(lang, RELEASE_TAX_AMOUNT_LINE2));
        TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col9, row3, TaxStatementPDFUtil.getText(lang, RELEASE_TAX_AMOUNT_LINE3));
        TaxStatementPDFUtil.showTextRight(cs, bold, 8, Color.BLACK, col10, row1, TaxStatementPDFUtil.getText(lang, RELEASE_TAX_PERCENT_LINE1));
        TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col10, row2, TaxStatementPDFUtil.getText(lang, RELEASE_TAX_PERCENT_LINE2));
        TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col10, row3, TaxStatementPDFUtil.getText(lang, RELEASE_TAX_PERCENT_LINE3));
        cs.transform(mx);
        cs.transform(mx);
        cs.transform(mx);
        cs.close();
    }

    protected PDPageContentStream addDepot(TaxStatementPDFContext ct, PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content, PDPageContentStream cs, Matrix mx, Integer depot) throws IOException, ParseException, XPathExpressionException {
        int row = ct.getRow();
        String depotNumber = TaxStatementPDFSecurityData.getDepotDepotNumber(doc, depot);
        int ya = this.ya();
        int col2 = this.col2();
        if (row > 0 && ++row > this.rows() - 2) {
            cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
            row = 0;
        }
        TaxStatementPDFUtil.showText(cs, bold, 8, Color.BLACK, col2, ya - 10 * row, TaxStatementPDFUtil.getText(lang, DEPOT) + " " + depotNumber);
        ct.setRow(++row);
        return cs;
    }

    protected PDPageContentStream addCountry(TaxStatementPDFContext ct, PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content, PDPageContentStream cs, Matrix mx, String country) throws IOException, ParseException, XPathExpressionException {
        Color grain = new Color(242, 242, 242);
        int row = ct.getRow();
        int ya = this.ya();
        int xa = this.xa();
        int xe = this.xe();
        int col2 = this.col2();
        if (row > 0 && ++row > this.rows() - 2) {
            cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
            row = 0;
        }
        TaxStatementPDFUtil.drawRectangle(cs, grain, xa, ya + 8 - row * 10, xe, ya - 4 - row * 10, grain);
        TaxStatementPDFUtil.showText(cs, bold, 8, Color.BLACK, col2, ya - 10 * row, TaxStatementPDFUtil.getText(lang, COUNTRY_ + country));
        ct.setRow(++row);
        return cs;
    }

    protected PDPageContentStream addSecurity(TaxStatementPDFContext ct, PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content, PDPageContentStream cs, Matrix mx, Integer depot, Integer security) throws IOException, ParseException, XPathExpressionException {
        DecimalFormat dfn = new DecimalFormat("########0");
        int row = ct.getRow();
        Double valorNumber = TaxStatementPDFSecurityData.getSecurityValorNumber(doc, depot, security);
        String isin = TaxStatementPDFSecurityData.getSecurityISIN(doc, depot, security);
        String name = this.securityName(doc, depot, security);
        int ya = this.ya();
        int col1 = this.col1();
        int col2 = this.col2();
        if (row > 0 && ++row > this.rows()) {
            cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
            row = 0;
        }
        if (isin != null && isin.length() > 0 && this.vnisin().equals("true")) {
            name = isin + " - " + name;
        }
        String name1 = TaxStatementPDFUtil.trim(TaxStatementPDFUtil.split(name, this.nmax(), 1));
        String name2 = TaxStatementPDFUtil.trim(TaxStatementPDFUtil.split(name, this.nmax(), 2));
        String name3 = TaxStatementPDFUtil.trim(TaxStatementPDFUtil.split(name, this.nmax(), 3));
        if (valorNumber != null) {
            TaxStatementPDFUtil.showText(cs, bold, 8, Color.BLACK, col1, ya - row * 10, dfn.format(valorNumber));
        }
        if (name1 != null && name1.length() > 0) {
            TaxStatementPDFUtil.showText(cs, bold, 8, Color.BLACK, col2, ya - row * 10, name1);
        }
        if (name2 != null && name2.length() > 0) {
            if (++row > this.rmax()) {
                cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
                row = 0;
            }
            TaxStatementPDFUtil.showText(cs, bold, 8, Color.BLACK, col2, ya - row * 10, name2);
        }
        if (name3 != null && name3.length() > 0) {
            if (++row > this.rmax()) {
                cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
                row = 0;
            }
            TaxStatementPDFUtil.showText(cs, bold, 8, Color.BLACK, col2, ya - row * 10, name3);
        }
        if (isin != null && isin.length() > 0 && (valorNumber == null && !this.vnisin().equals("true") || this.vnisin().equals("strong"))) {
            if (++row > this.rmax()) {
                cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
                row = 0;
            }
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col2, ya - row * 10, isin);
        }
        ct.setRow(++row);
        return cs;
    }

    protected PDPageContentStream addPayment(TaxStatementPDFContext ct, PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content, PDPageContentStream cs, Matrix mx, Integer depot, Integer security, Integer payment) throws IOException, ParseException, XPathExpressionException {
        int digits;
        DecimalFormat dfn = new DecimalFormat("########0");
        DecimalFormat dfd = new DecimalFormat("#,###,###,##0.00");
        DecimalFormat dfx = new DecimalFormat("#,###,###,##0." + String.format("%0" + this.exchangeRateDecimal() + "d", 0));
        DecimalFormat dfq = new DecimalFormat("#,###,###,##0." + String.format("%0" + this.quantityDecimalMax() + "d", 0));
        DecimalFormat dfu = new DecimalFormat("#,###,###,##0." + String.format("%0" + this.unitPriceDecimalMax() + "d", 0));
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
        SimpleDateFormat sdx = new SimpleDateFormat("dd.MM.");
        int row = ct.getRow();
        Date paymentDate = TaxStatementPDFSecurityData.getPaymentPaymentDate(doc, depot, security, payment);
        String quotationType = TaxStatementPDFSecurityData.getPaymentQuotationType(doc, depot, security, payment);
        Double quantity = TaxStatementPDFSecurityData.getPaymentQuantity(doc, depot, security, payment);
        String amountCurrency = TaxStatementPDFSecurityData.getPaymentAmountCurrency(doc, depot, security, payment);
        Double amountPerUnit = TaxStatementPDFSecurityData.getPaymentAmountPerUnit(doc, depot, security, payment);
        Double amount = TaxStatementPDFSecurityData.getPaymentAmount(doc, depot, security, payment);
        Double lumpSumTaxCreditForeign = TaxStatementPDFSecurityData.getPaymentLumpSumTaxCreditForeign(doc, depot, security, payment);
        Double lumpSumTaxCreditPercent = TaxStatementPDFSecurityData.getPaymentLumpSumTaxCreditPercent(doc, depot, security, payment);
        Double releaseTaxForeign = TaxStatementPDFSecurityData.getPaymentReleaseTaxForeign(doc, depot, security, payment);
        Double releaseTaxPercent = TaxStatementPDFSecurityData.getPaymentReleaseTaxPercent(doc, depot, security, payment);
        String sign = TaxStatementPDFSecurityData.getPaymentSign(doc, depot, security, payment);
        String name = TaxStatementPDFSecurityData.getPaymentName(doc, depot, security, payment);
        String name1 = TaxStatementPDFUtil.trim(TaxStatementPDFUtil.split(name, this.nmax(), 1));
        String name2 = TaxStatementPDFUtil.trim(TaxStatementPDFUtil.split(name, this.nmax(), 2));
        String name3 = TaxStatementPDFUtil.trim(TaxStatementPDFUtil.split(name, this.nmax(), 3));
        String name4 = TaxStatementPDFUtil.trim(TaxStatementPDFUtil.split(name, this.nmax(), 4));
        String name5 = TaxStatementPDFUtil.trim(TaxStatementPDFUtil.split(name, this.nmax(), 5));
        int ya = this.ya();
        int col1 = this.col1();
        int col2 = this.col2();
        int col3 = this.col3();
        int col4 = this.col4();
        int col5 = this.col5();
        int col6 = this.col6();
        int col7 = this.col7();
        int col8 = this.col8();
        int col9 = this.col9();
        int col10 = this.col10();
        if (row > this.rmax()) {
            cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
            row = 0;
        }
        TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col1, ya - row * 10, sdf.format(paymentDate));
        if (quantity != null) {
            float cox3 = col3;
            digits = TaxStatementPDFUtil.digits(quantity, this.quantityDecimal(), this.quantityDecimalMax());
            if (digits < this.quantityDecimalMax()) {
                dfq = new DecimalFormat("#,###,###,##0." + String.format("%0" + digits + "d", 0));
                cox3 = (float)col3 - TaxStatementPDFUtil.width(font, 8, String.format("%0" + (this.quantityDecimalMax() - digits) + "d", 0));
            }
            TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, cox3, ya - row * 10, dfq.format(quantity));
            ct.setQuantityDecimal(digits);
        }
        if (amountCurrency != null && amountCurrency.length() > 0) {
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col4, ya - row * 10, amountCurrency);
        }
        if (amountPerUnit != null) {
            float cox5 = col5;
            digits = TaxStatementPDFUtil.digits(amountPerUnit, this.unitPriceDecimal(), this.unitPriceDecimalMax());
            if (digits < this.unitPriceDecimalMax()) {
                dfu = new DecimalFormat("#,###,###,##0." + String.format("%0" + digits + "d", 0));
                cox5 = (float)col5 - TaxStatementPDFUtil.width(font, 8, String.format("%0" + (this.unitPriceDecimalMax() - digits) + "d", 0));
            }
            TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, cox5, ya - row * 10, dfu.format(amountPerUnit));
            if (quotationType != null && quotationType.equals("PERCENT")) {
                TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, cox5 + 1.0f, ya - row * 10, "%");
            }
            ct.setUnitPriceDecimal(digits);
        }
        if (amount != null) {
            TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col6, ya - row * 10, dfd.format(amount));
            if (sign != null && sign.length() > 0) {
                TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col6 + 2, ya - row * 10, sign);
            }
        }
        if (lumpSumTaxCreditForeign != null) {
            TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col7, ya - row * 10, dfd.format(lumpSumTaxCreditForeign));
        }
        if (lumpSumTaxCreditPercent != null) {
            TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col8, ya - row * 10, dfd.format(lumpSumTaxCreditPercent));
        }
        if (releaseTaxForeign != null) {
            TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col9, ya - row * 10, dfd.format(releaseTaxForeign));
        }
        if (releaseTaxPercent != null) {
            TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col10, ya - row * 10, dfd.format(releaseTaxPercent));
        }
        if (name1 != null && name1.length() > 0) {
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col2, ya - row * 10, name1);
        }
        if (name2 != null && name2.length() > 0) {
            if (++row > this.rmax()) {
                cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
                row = 0;
            }
            TaxStatementPDFUtil.showText(cs, bold, 8, Color.BLACK, col2, ya - row * 10, name2);
        }
        if (name3 != null && name3.length() > 0) {
            if (++row > this.rmax()) {
                cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
                row = 0;
            }
            TaxStatementPDFUtil.showText(cs, bold, 8, Color.BLACK, col2, ya - row * 10, name3);
        }
        if (name4 != null && name4.length() > 0) {
            if (++row > this.rmax()) {
                cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
                row = 0;
            }
            TaxStatementPDFUtil.showText(cs, bold, 8, Color.BLACK, col2, ya - row * 10, name4);
        }
        if (name5 != null && name5.length() > 0) {
            if (++row > this.rmax()) {
                cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
                row = 0;
            }
            TaxStatementPDFUtil.showText(cs, bold, 8, Color.BLACK, col2, ya - row * 10, name5);
        }
        ct.setRow(++row);
        return cs;
    }

    protected PDPageContentStream addTaxValue(TaxStatementPDFContext ct, PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content, PDPageContentStream cs, Matrix mx, String currency, Double totalGrossRevenue, Double totalLumpSumTaxCredit, Double totalReleaseTax) throws IOException, ParseException, XPathExpressionException {
        Color grain = new Color(242, 242, 242);
        DecimalFormat dfd = new DecimalFormat("#,###,###,##0.00");
        int row = ct.getRow();
        int ya = this.ya();
        int xa = this.xa();
        int xe = this.xe();
        int col1 = this.col1();
        int col2 = this.col2();
        int col4 = this.col4();
        int col6 = this.col6();
        int col7 = this.col7();
        int col9 = this.col9();
        if (row > this.rmax()) {
            cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
            row = 0;
        }
        TaxStatementPDFUtil.drawRectangle(cs, grain, xa, ya + 8 - row * 10, xe, ya - 4 - row * 10, grain);
        TaxStatementPDFUtil.showText(cs, bold, 8, Color.BLACK, col1, ya - row * 10, TaxStatementPDFSchemaData.getPeriodTo(doc, "dd.MM.yyyy"));
        TaxStatementPDFUtil.showText(cs, bold, 8, Color.BLACK, col2, ya - row * 10, TaxStatementPDFUtil.getText(lang, STOCK));
        if (currency != null && currency.length() > 0) {
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col4, ya - row * 10, currency);
        }
        if (totalGrossRevenue != null && totalGrossRevenue > 0.0) {
            TaxStatementPDFUtil.showTextRight(cs, bold, 8, Color.BLACK, col6, ya - row * 10, dfd.format(totalGrossRevenue));
        }
        if (totalLumpSumTaxCredit != null && totalLumpSumTaxCredit > 0.0) {
            TaxStatementPDFUtil.showTextRight(cs, bold, 8, Color.BLACK, col7, ya - row * 10, dfd.format(totalLumpSumTaxCredit));
        }
        if (totalReleaseTax != null && totalReleaseTax > 0.0) {
            TaxStatementPDFUtil.showTextRight(cs, bold, 8, Color.BLACK, col9, ya - row * 10, dfd.format(totalReleaseTax));
        }
        ct.setRow(++row);
        return cs;
    }

    protected PDPageContentStream addTotalCountry(TaxStatementPDFContext ct, PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content, PDPageContentStream cs, Matrix mx, String country, Double totalGrossRevenue, Double totalLumpSumTaxCredit, Double totalReleaseTax) throws IOException, ParseException, XPathExpressionException {
        Color grey = new Color(211, 211, 211);
        DecimalFormat dfd = new DecimalFormat("#,###,###,##0.00");
        int row = ct.getRow();
        int ya = this.ya();
        int xa = this.xa();
        int xe = this.xe();
        int col2 = this.col2();
        int col6 = this.col6();
        int col7 = this.col7();
        int col9 = this.col9();
        if (row > 0 && ++row > this.rmax()) {
            cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
            row = 0;
        }
        TaxStatementPDFUtil.drawRectangle(cs, grey, xa, ya + 8 - row * 10, xe, ya - 4 - row * 10, grey);
        TaxStatementPDFUtil.showText(cs, bold, 8, Color.BLACK, col2, ya - row * 10, TaxStatementPDFUtil.getText(lang, TOTAL) + " " + TaxStatementPDFUtil.getText(lang, COUNTRY_ + country));
        TaxStatementPDFUtil.showTextRight(cs, bold, 8, Color.BLACK, col6, ya - row * 10, dfd.format(totalGrossRevenue));
        TaxStatementPDFUtil.showTextRight(cs, bold, 8, Color.BLACK, col7, ya - row * 10, dfd.format(totalLumpSumTaxCredit));
        TaxStatementPDFUtil.showTextRight(cs, bold, 8, Color.BLACK, col9, ya - row * 10, dfd.format(totalReleaseTax));
        ct.setRow(++row);
        return cs;
    }

    public void addTaxReclaim(PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content, TaxStatementPDFFormula formula) throws IOException, ParseException, XPathExpressionException {
        Date yearBegin = TaxStatementPDFSchemaData.getPeriodFrom(doc);
        if (formula.isLumpSumTaxCredit(doc) && TaxStatementPDFSecurityData.getSecurityCount(doc) > 0) {
            TaxStatementPDFContext ct = new TaxStatementPDFContext();
            PDPage page = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content);
            PDPageContentStream cs = new PDPageContentStream(pdd, page, PDPageContentStream.AppendMode.APPEND, true);
            Matrix mx = new Matrix(0.0f, 1.0f, -1.0f, 0.0f, page.getMediaBox().getWidth(), 0.0f);
            cs.transform(mx);
            int depots = TaxStatementPDFSecurityData.getDepotCount(doc);
            for (int depot = 1; depot <= depots; ++depot) {
                Double totalGrossRevenue = 0.0;
                Double totalLumpSumTaxCredit = 0.0;
                Double totalReleaseTax = 0.0;
                if (!formula.isLumpSumTaxCredit(doc, depot)) continue;
                if (ct.getRow() > 0) {
                    cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
                }
                cs = this.addDepot(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx, depot);
                ArrayList<String> entries = new ArrayList<String>();
                int securities = TaxStatementPDFSecurityData.getSecurityCount(doc, depot);
                for (int security = 1; security <= securities; ++security) {
                    if (!formula.isLumpSumTaxCredit(doc, depot, security)) continue;
                    String entry = this.hash(doc, depot, security, lang);
                    if (entries == null || entries.contains(entry)) continue;
                    entries.add(entry);
                }
                Collections.sort(entries);
                String before = null;
                String country = null;
                String currency = null;
                for (String entry : entries) {
                    int security = Integer.parseInt(entry.substring(entry.length() - 4));
                    if (!formula.isLumpSumTaxCredit(doc, depot, security)) continue;
                    country = TaxStatementPDFSecurityData.getSecurityCountry(doc, depot, security);
                    if (before != null && country != null && !country.equals(before)) {
                        cs = this.addTotalCountry(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx, before, totalGrossRevenue, totalLumpSumTaxCredit, totalReleaseTax);
                        totalGrossRevenue = 0.0;
                        totalLumpSumTaxCredit = 0.0;
                        totalReleaseTax = 0.0;
                    }
                    if (before == null || country != null && !country.equals(before)) {
                        cs = this.addCountry(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx, country);
                        before = country;
                    }
                    int payments = TaxStatementPDFSecurityData.getPaymentCount(doc, depot, security);
                    cs = this.addSecurity(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx, depot, security);
                    Double securityGrossRevenue = null;
                    Double securityLumpSumTaxCredit = null;
                    Double securityReleaseTax = null;
                    ArrayList<Date> dates = new ArrayList<Date>();
                    for (int payment = 1; payment <= payments; ++payment) {
                        Date exDate = TaxStatementPDFSecurityData.getPaymentExDate(doc, depot, security, payment);
                        Date paymentDate = TaxStatementPDFSecurityData.getPaymentPaymentDate(doc, depot, security, payment);
                        if (exDate != null && !dates.contains(exDate) && !exDate.before(yearBegin)) {
                            dates.add(exDate);
                            continue;
                        }
                        if (paymentDate == null || dates.contains(paymentDate) || exDate != null && !exDate.before(yearBegin)) continue;
                        dates.add(paymentDate);
                    }
                    Collections.sort(dates);
                    for (Date date : dates) {
                        for (int payment = 1; payment <= payments; ++payment) {
                            Date exDate = TaxStatementPDFSecurityData.getPaymentExDate(doc, depot, security, payment);
                            Date paymentDate = TaxStatementPDFSecurityData.getPaymentPaymentDate(doc, depot, security, payment);
                            Boolean lumpSumTaxCredit = TaxStatementPDFSecurityData.getPaymentLumpSumTaxCredit(doc, depot, security, payment);
                            if ((exDate == null || !date.equals(exDate) || exDate.before(yearBegin)) && (paymentDate == null || !date.equals(paymentDate) || exDate != null && !exDate.before(yearBegin)) || !lumpSumTaxCredit.booleanValue()) continue;
                            String amountCurrency = TaxStatementPDFSecurityData.getPaymentAmountCurrency(doc, depot, security, payment);
                            Double amount = TaxStatementPDFSecurityData.getPaymentAmount(doc, depot, security, payment);
                            Double lumpSumTaxCreditForeign = TaxStatementPDFSecurityData.getPaymentLumpSumTaxCreditForeign(doc, depot, security, payment);
                            Double releaseTaxForeign = TaxStatementPDFSecurityData.getPaymentReleaseTaxForeign(doc, depot, security, payment);
                            cs = this.addPayment(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx, depot, security, payment);
                            if (amountCurrency != null && amountCurrency.length() > 0) {
                                currency = amountCurrency;
                            }
                            if (amount != null) {
                                securityGrossRevenue = securityGrossRevenue != null ? Double.valueOf(securityGrossRevenue + amount) : amount;
                            }
                            if (lumpSumTaxCreditForeign != null) {
                                securityLumpSumTaxCredit = securityLumpSumTaxCredit != null ? Double.valueOf(securityLumpSumTaxCredit + lumpSumTaxCreditForeign) : lumpSumTaxCreditForeign;
                            }
                            if (releaseTaxForeign == null) continue;
                            securityReleaseTax = securityReleaseTax != null ? Double.valueOf(securityReleaseTax + releaseTaxForeign) : releaseTaxForeign;
                        }
                    }
                    cs = this.addTaxValue(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx, currency, securityGrossRevenue, securityLumpSumTaxCredit, securityReleaseTax);
                    if (securityGrossRevenue != null && securityGrossRevenue > 0.0) {
                        totalGrossRevenue = totalGrossRevenue + securityGrossRevenue;
                    }
                    if (securityLumpSumTaxCredit != null && securityLumpSumTaxCredit > 0.0) {
                        totalLumpSumTaxCredit = totalLumpSumTaxCredit + securityLumpSumTaxCredit;
                    }
                    if (securityReleaseTax == null || !(securityReleaseTax > 0.0)) continue;
                    totalReleaseTax = totalReleaseTax + securityReleaseTax;
                }
                if (country == null) continue;
                cs = this.addTotalCountry(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx, country, totalGrossRevenue, totalLumpSumTaxCredit, totalReleaseTax);
            }
            cs.transform(mx);
            cs.transform(mx);
            cs.transform(mx);
            cs.close();
            this.endPage(ct, pdd, font, bold, doc, lang, data);
        }
    }
}

