/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.pdf.ssk;

import ch.ewv.taxstatement.pdf.TaxStatementPDFContext;
import ch.ewv.taxstatement.pdf.TaxStatementPDFFormula;
import ch.ewv.taxstatement.pdf.TaxStatementPDFLiabilityAccountData;
import ch.ewv.taxstatement.pdf.TaxStatementPDFRenderer;
import ch.ewv.taxstatement.pdf.TaxStatementPDFSchemaData;
import ch.ewv.taxstatement.pdf.TaxStatementPDFUtil;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Properties;
import javax.xml.xpath.XPathExpressionException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.util.Matrix;
import org.w3c.dom.Document;

public class TaxStatementSSKLiabilityAccount
extends TaxStatementPDFRenderer {
    public static final String HEADER = "HEADER_LIABILITY_ACCOUNT";
    public static final String HEADER_EXTENDED = "HEADER_LIABILITY_ACCOUNT_EXTENDED";
    public static final String TOTAL_ACCOUNT = "TOTAL_LIABILITY_ACCOUNT";
    public static final String OPENING_DATE = "LIABILITY_ACCOUNT_OPENING_DATE";
    public static final String CLOSING_DATE = "LIABILITY_ACCOUNT_CLOSING_DATE";
    public static final String STOCK = "LIABILITY_ACCOUNT_STOCK";
    public static final String CURRENCY_LINE1 = "LIABILITY_ACCOUNT_CURRENCY_LINE1";
    public static final String CURRENCY_LINE2 = "LIABILITY_ACCOUNT_CURRENCY_LINE2";
    public static final String CURRENCY_LINE3 = "LIABILITY_ACCOUNT_CURRENCY_LINE3";
    public static final String DESCRIPTION_LINE1 = "LIABILITY_ACCOUNT_DESCRIPTION_LINE1";
    public static final String DESCRIPTION_LINE2 = "LIABILITY_ACCOUNT_DESCRIPTION_LINE2";
    public static final String DESCRIPTION_LINE3 = "LIABILITY_ACCOUNT_DESCRIPTION_LINE3";
    public static final String EXCHANGE_RATE_LINE1 = "LIABILITY_ACCOUNT_EXCHANGE_RATE_LINE1";
    public static final String EXCHANGE_RATE_LINE2 = "LIABILITY_ACCOUNT_EXCHANGE_RATE_LINE2";
    public static final String EXCHANGE_RATE_LINE3 = "LIABILITY_ACCOUNT_EXCHANGE_RATE_LINE3";
    public static final String GROSS_REVENUE_B_LINE1 = "LIABILITY_ACCOUNT_GROSS_REVENUE_B_LINE1";
    public static final String GROSS_REVENUE_B_LINE2 = "LIABILITY_ACCOUNT_GROSS_REVENUE_B_LINE2";
    public static final String GROSS_REVENUE_B_LINE3 = "LIABILITY_ACCOUNT_GROSS_REVENUE_B_LINE3";
    public static final String GROSS_REVENUE_B_BOLD2 = "LIABILITY_ACCOUNT_GROSS_REVENUE_B_BOLD2";
    public static final String NUMBER_LINE1 = "LIABILITY_ACCOUNT_NUMBER_LINE1";
    public static final String NUMBER_LINE2 = "LIABILITY_ACCOUNT_NUMBER_LINE2";
    public static final String NUMBER_LINE3 = "LIABILITY_ACCOUNT_NUMBER_LINE3";
    public static final String VALUE_LINE1 = "LIABILITY_ACCOUNT_VALUE_LINE1";
    public static final String VALUE_LINE2 = "LIABILITY_ACCOUNT_VALUE_LINE2";
    public static final String VALUE_LINE3 = "LIABILITY_ACCOUNT_VALUE_LINE3";
    public static final String TAX_VALUE_LINE1 = "LIABILITY_ACCOUNT_TAX_VALUE_LINE1";
    public static final String TAX_VALUE_LINE2 = "LIABILITY_ACCOUNT_TAX_VALUE_LINE2";
    public static final String TAX_VALUE_LINE3 = "LIABILITY_ACCOUNT_TAX_VALUE_LINE3";
    public static final int COL1 = 71;
    public static final int COL2 = 150;
    public static final int COL3 = 460;
    public static final int COL4 = 550;
    public static final int COL5 = 600;
    public static final int COL6 = 664;
    public static final int COL7 = 734;
    public static final int COL8 = 804;
    public static final int NMAX = 70;

    protected int col1() {
        return 71 + this.offsetX();
    }

    protected int col2() {
        return 150 + this.offsetX();
    }

    protected int col3() {
        return 460 + this.offsetX();
    }

    protected int col4() {
        return 550 + this.offsetX();
    }

    protected int col5() {
        return 600 + this.offsetX();
    }

    protected int col6() {
        return 664 + this.offsetX();
    }

    protected int col7() {
        return 734 + this.offsetX();
    }

    protected int col8() {
        return 804 + this.offsetX();
    }

    protected int nmax() {
        return 70;
    }

    protected String hash(Document doc, int account) throws IOException, ParseException, XPathExpressionException {
        String accountNumber = TaxStatementPDFLiabilityAccountData.getLiabilityAccountNumber(doc, account);
        String name = TaxStatementPDFLiabilityAccountData.getLiabilityAccountName(doc, account);
        String hx = "";
        hx = accountNumber != null && accountNumber.length() > 0 ? hx + TaxStatementPDFUtil.normalize(accountNumber) : hx + "000000000";
        if (name != null && name.length() > 0) {
            hx = hx + TaxStatementPDFUtil.normalize(name);
        }
        if (account > 0) {
            hx = hx + String.format("%04d", account);
        }
        return hx;
    }

    protected PDPage addPage(TaxStatementPDFContext ct, PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content) throws IOException, ParseException, XPathExpressionException {
        this.endPage(ct, pdd, font, bold, doc, lang, data);
        PDPage page = new PDPage();
        page.setMediaBox(PDRectangle.A4);
        page.setRotation(90);
        pdd.addPage(page);
        ct.setPage(page).setRow(0);
        if (layout != null) {
            layout.addLayout(pdd, font, bold, logo, size, doc, lang, data, content, page, this.extended() ? HEADER_EXTENDED : HEADER);
            layout.addPageBarCode(pdd, font, bold, doc, page, 197);
        }
        return page;
    }

    protected PDPageContentStream addPage(TaxStatementPDFContext ct, PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content, PDPageContentStream cs, Matrix mx) throws IOException, ParseException, XPathExpressionException {
        cs.transform(mx);
        cs.transform(mx);
        cs.transform(mx);
        cs.close();
        PDPage page = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content);
        cs = new PDPageContentStream(pdd, page, PDPageContentStream.AppendMode.APPEND, true);
        cs.transform(mx);
        return cs;
    }

    protected void endPage(TaxStatementPDFContext ct, PDDocument pdd, PDFont font, PDFont bold, Document doc, Properties lang, Properties data) throws IOException, ParseException, XPathExpressionException {
        if (ct.getPage() != null) {
            this.addHeader(ct, pdd, font, bold, doc, lang, data, ct.getPage());
        }
    }

    protected void addHeader(TaxStatementPDFContext ct, PDDocument pdd, PDFont font, PDFont bold, Document doc, Properties lang, Properties data, PDPage page) throws IOException, ParseException, XPathExpressionException {
        PDPageContentStream cs = new PDPageContentStream(pdd, page, PDPageContentStream.AppendMode.APPEND, true);
        Matrix mx = new Matrix(0.0f, 1.0f, -1.0f, 0.0f, page.getMediaBox().getWidth(), 0.0f);
        Color grey = new Color(211, 211, 211);
        cs.transform(mx);
        int yh = this.yh();
        int xa = this.xa();
        int xe = this.xe();
        int col1 = this.col1();
        int col2 = this.col2();
        int col3 = this.col3();
        int col4 = this.col4();
        int col5 = this.col5();
        int col6 = this.col6();
        int col8 = this.col8();
        int row1 = yh + 2 - 10;
        int row2 = yh + 2 - 20;
        int row3 = yh + 2 - 30;
        TaxStatementPDFUtil.drawRectangle(cs, grey, xa, yh, xe, row3 - 4, grey);
        TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col1, row1, TaxStatementPDFUtil.getText(lang, NUMBER_LINE1));
        TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col1, row2, TaxStatementPDFUtil.getText(lang, NUMBER_LINE2));
        TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col1, row3, TaxStatementPDFUtil.getText(lang, NUMBER_LINE3));
        TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col2, row1, TaxStatementPDFUtil.getText(lang, DESCRIPTION_LINE1));
        TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col2, row2, TaxStatementPDFUtil.getText(lang, DESCRIPTION_LINE2));
        TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col2, row3, TaxStatementPDFUtil.getText(lang, DESCRIPTION_LINE3));
        TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col3, row1, TaxStatementPDFUtil.getText(lang, CURRENCY_LINE1));
        TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col3, row2, TaxStatementPDFUtil.getText(lang, CURRENCY_LINE2));
        TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col3, row3, TaxStatementPDFUtil.getText(lang, CURRENCY_LINE3));
        TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col4, row1, TaxStatementPDFUtil.getText(lang, VALUE_LINE1));
        TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col4, row2, TaxStatementPDFUtil.getText(lang, VALUE_LINE2));
        TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col4, row3, TaxStatementPDFUtil.getText(lang, VALUE_LINE3));
        TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col5, row1, TaxStatementPDFUtil.getText(lang, EXCHANGE_RATE_LINE1));
        TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col5, row2, TaxStatementPDFUtil.getText(lang, EXCHANGE_RATE_LINE2));
        TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col5, row3, TaxStatementPDFUtil.getText(lang, EXCHANGE_RATE_LINE3));
        TaxStatementPDFUtil.showTextRight(cs, bold, 8, Color.BLACK, col6, row1, TaxStatementPDFUtil.getText(lang, TAX_VALUE_LINE1));
        TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col6, row2, String.format(TaxStatementPDFUtil.getText(lang, TAX_VALUE_LINE2), TaxStatementPDFSchemaData.getPeriodTo(doc, "dd.MM.yyyy")));
        TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col6, row3, TaxStatementPDFUtil.getText(lang, TAX_VALUE_LINE3));
        TaxStatementPDFUtil.showTextRight(cs, bold, 8, Color.BLACK, col8, row1, TaxStatementPDFUtil.getText(lang, GROSS_REVENUE_B_LINE1));
        TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col8, row2, String.format(TaxStatementPDFUtil.getText(lang, GROSS_REVENUE_B_LINE2), this.headerYear() ? TaxStatementPDFSchemaData.getPeriodTo(doc, "yyyy") : ""), bold, TaxStatementPDFUtil.getText(lang, GROSS_REVENUE_B_BOLD2));
        TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col8, row3, TaxStatementPDFUtil.getText(lang, GROSS_REVENUE_B_LINE3));
        cs.transform(mx);
        cs.transform(mx);
        cs.transform(mx);
        cs.close();
    }

    protected PDPageContentStream addAccount(TaxStatementPDFContext ct, PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content, PDPageContentStream cs, Matrix mx, Integer account) throws IOException, ParseException, XPathExpressionException {
        int row = ct.getRow();
        int ya = this.ya();
        int col1 = this.col1();
        int col2 = this.col2();
        String year = TaxStatementPDFSchemaData.getPeriodTo(doc, "yyyy");
        String accountNumber = TaxStatementPDFLiabilityAccountData.getLiabilityAccountNumber(doc, account);
        String iban = TaxStatementPDFLiabilityAccountData.getLiabilityAccountIBAN(doc, account);
        String country = TaxStatementPDFLiabilityAccountData.getLiabilityAccountCountry(doc, account);
        String currency = TaxStatementPDFLiabilityAccountData.getLiabilityAccountCurrency(doc, account);
        String openingDate = TaxStatementPDFLiabilityAccountData.getLiabilityAccountOpeningDate(doc, account, "dd.MM.yyyy");
        String closingDate = TaxStatementPDFLiabilityAccountData.getLiabilityAccountClosingDate(doc, account, "dd.MM.yyyy");
        String name = TaxStatementPDFLiabilityAccountData.getLiabilityAccountName(doc, account);
        String ntax = TaxStatementPDFLiabilityAccountData.getTaxValueName(doc, account);
        if (name != null && name.length() > 0 && ntax != null && ntax.length() > 0 && ntax.startsWith(name)) {
            name = ntax;
        }
        String name1 = TaxStatementPDFUtil.trim(TaxStatementPDFUtil.split(name, this.nmax(), 1));
        String name2 = TaxStatementPDFUtil.trim(TaxStatementPDFUtil.split(name, this.nmax(), 2));
        String name3 = TaxStatementPDFUtil.trim(TaxStatementPDFUtil.split(name, this.nmax(), 3));
        if (row > 0 && ++row > this.rows()) {
            cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
            row = 0;
        }
        if (accountNumber != null && accountNumber.length() > 0) {
            TaxStatementPDFUtil.showText(cs, bold, 8, Color.BLACK, col1, ya - row * 10, accountNumber);
        }
        if (name1 != null && name1.length() > 0) {
            TaxStatementPDFUtil.showText(cs, bold, 8, Color.BLACK, col2, ya - row * 10, name1);
        }
        if (name2 != null && name2.length() > 0) {
            if (++row > this.rmax()) {
                cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
                row = 0;
            }
            TaxStatementPDFUtil.showText(cs, bold, 8, Color.BLACK, col2, ya - row * 10, name2);
        }
        if (name3 != null && name3.length() > 0) {
            if (++row > this.rmax()) {
                cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
                row = 0;
            }
            TaxStatementPDFUtil.showText(cs, bold, 8, Color.BLACK, col2, ya - row * 10, name3);
        }
        if (iban != null && iban.length() > 0 && (accountNumber == null && this.iban().equals("true") || this.iban().equals("strong"))) {
            if (++row > this.rmax()) {
                cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
                row = 0;
            }
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col2, ya - row * 10, iban);
        }
        if (openingDate != null && openingDate.length() > 0 && openingDate.indexOf(year) >= 0) {
            if (++row > this.rmax()) {
                cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
                row = 0;
            }
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col2, ya - row * 10, String.format(TaxStatementPDFUtil.getText(lang, OPENING_DATE), openingDate));
        }
        if (closingDate != null && closingDate.length() > 0 && closingDate.indexOf(year) >= 0) {
            if (++row > this.rmax()) {
                cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
                row = 0;
            }
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col2, ya - row * 10, String.format(TaxStatementPDFUtil.getText(lang, CLOSING_DATE), closingDate));
        }
        ct.setRow(++row);
        return cs;
    }

    protected PDPageContentStream addPayment(TaxStatementPDFContext ct, PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content, PDPageContentStream cs, Matrix mx, Integer account, Integer payment) throws IOException, ParseException, XPathExpressionException {
        DecimalFormat dfd = new DecimalFormat("#,###,###,##0.00");
        DecimalFormat dfx = new DecimalFormat("#,###,###,##0." + String.format("%0" + this.exchangeRateDecimal() + "d", 0));
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
        int row = ct.getRow();
        Date paymentDate = TaxStatementPDFLiabilityAccountData.getPaymentPaymentDate(doc, account, payment);
        String amountCurrency = TaxStatementPDFLiabilityAccountData.getPaymentAmountCurrency(doc, account, payment);
        Double amount = TaxStatementPDFLiabilityAccountData.getPaymentAmount(doc, account, payment);
        Double exchangeRate = TaxStatementPDFLiabilityAccountData.getPaymentExchangeRate(doc, account, payment);
        Double grossRevenueB = TaxStatementPDFLiabilityAccountData.getPaymentGrossRevenueB(doc, account, payment);
        String name = TaxStatementPDFLiabilityAccountData.getPaymentName(doc, account, payment);
        String name1 = TaxStatementPDFUtil.trim(TaxStatementPDFUtil.split(name, this.nmax(), 1));
        String name2 = TaxStatementPDFUtil.trim(TaxStatementPDFUtil.split(name, this.nmax(), 2));
        String name3 = TaxStatementPDFUtil.trim(TaxStatementPDFUtil.split(name, this.nmax(), 3));
        String name4 = TaxStatementPDFUtil.trim(TaxStatementPDFUtil.split(name, this.nmax(), 4));
        int ya = this.ya();
        int col1 = this.col1();
        int col2 = this.col2();
        int col3 = this.col3();
        int col4 = this.col4();
        int col5 = this.col5();
        int col8 = this.col8();
        if (row > this.rmax()) {
            cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
            row = 0;
        }
        TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col1, ya - row * 10, sdf.format(paymentDate));
        if (amountCurrency != null && amountCurrency.length() > 0) {
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col3, ya - row * 10, amountCurrency);
        }
        if (amount != null) {
            TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col4, ya - row * 10, dfd.format(amount));
        }
        if (exchangeRate != null && amountCurrency != null && !amountCurrency.equals("CHF")) {
            TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col5, ya - row * 10, dfx.format(exchangeRate));
        }
        if (grossRevenueB != null) {
            TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col8, ya - row * 10, dfd.format(grossRevenueB));
        }
        if (name1 != null && name1.length() > 0) {
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col2, ya - row * 10, name1);
        }
        if (name2 != null && name2.length() > 0) {
            if (++row > this.rmax()) {
                cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
                row = 0;
            }
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col2, ya - row * 10, name2);
        }
        if (name3 != null && name3.length() > 0) {
            if (++row > this.rmax()) {
                cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
                row = 0;
            }
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col2, ya - row * 10, name3);
        }
        if (name4 != null && name4.length() > 0) {
            if (++row > this.rmax()) {
                cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
                row = 0;
            }
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col2, ya - row * 10, name4);
        }
        ct.setRow(++row);
        return cs;
    }

    protected PDPageContentStream addTaxValue(TaxStatementPDFContext ct, PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content, PDPageContentStream cs, Matrix mx, Integer account) throws IOException, ParseException, XPathExpressionException {
        Color grain = new Color(242, 242, 242);
        DecimalFormat dfd = new DecimalFormat("#,###,###,##0.00");
        DecimalFormat dfx = new DecimalFormat("#,###,###,##0." + String.format("%0" + this.exchangeRateDecimal() + "d", 0));
        int row = ct.getRow();
        String currency = TaxStatementPDFLiabilityAccountData.getLiabilityAccountCurrency(doc, account);
        Double taxValue = TaxStatementPDFLiabilityAccountData.getTotalTaxValue(doc, account);
        Double grossRevenueB = TaxStatementPDFLiabilityAccountData.getTotalGrossRevenueB(doc, account);
        String balanceCurrency = TaxStatementPDFLiabilityAccountData.getTaxValueBalanceCurrency(doc, account);
        Double balance = TaxStatementPDFLiabilityAccountData.getTaxValueBalance(doc, account);
        Double exchangeRate = TaxStatementPDFLiabilityAccountData.getTaxValueExchangeRate(doc, account);
        Double value = TaxStatementPDFLiabilityAccountData.getTaxValueValue(doc, account);
        int ya = this.ya();
        int xa = this.xa();
        int xe = this.xe();
        int col1 = this.col1();
        int col2 = this.col2();
        int col3 = this.col3();
        int col4 = this.col4();
        int col5 = this.col5();
        int col6 = this.col6();
        int col8 = this.col8();
        if (row > this.rmax()) {
            cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
            row = 0;
        }
        TaxStatementPDFUtil.drawRectangle(cs, grain, xa, ya + 8 - row * 10, xe, ya - 4 - row * 10, grain);
        TaxStatementPDFUtil.showText(cs, bold, 8, Color.BLACK, col1, ya - row * 10, TaxStatementPDFSchemaData.getPeriodTo(doc, "dd.MM.yyyy"));
        TaxStatementPDFUtil.showText(cs, bold, 8, Color.BLACK, col2, ya - row * 10, TaxStatementPDFUtil.getText(lang, STOCK));
        if (balanceCurrency != null && balanceCurrency.length() > 0 && balance != null && balance > 0.0) {
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col3, ya - row * 10, balanceCurrency);
        } else if (currency != null && currency.length() > 0 && balance != null && balance > 0.0) {
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col3, ya - row * 10, balanceCurrency);
        }
        if (balance != null && balance > 0.0) {
            TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col4, ya - row * 10, dfd.format(balance));
        }
        if (exchangeRate != null && balanceCurrency != null && !balanceCurrency.equals("CHF") && balance != null && balance > 0.0) {
            TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col5, ya - row * 10, dfx.format(exchangeRate));
        }
        if (taxValue != null) {
            TaxStatementPDFUtil.showTextRight(cs, bold, 8, Color.BLACK, col6, ya - row * 10, dfd.format(taxValue));
        }
        if (grossRevenueB != null) {
            TaxStatementPDFUtil.showTextRight(cs, bold, 8, Color.BLACK, col8, ya - row * 10, dfd.format(grossRevenueB));
        }
        ct.setRow(++row);
        return cs;
    }

    protected PDPageContentStream addTotal(TaxStatementPDFContext ct, PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content, PDPageContentStream cs, Matrix mx, Double totalTaxValue, Double totalGrossRevenueB) throws IOException, ParseException, XPathExpressionException {
        Color grey = new Color(211, 211, 211);
        DecimalFormat dfd = new DecimalFormat("#,###,###,##0.00");
        int row = ct.getRow();
        int ya = this.ya();
        int xa = this.xa();
        int xe = this.xe();
        int col2 = this.col2();
        int col6 = this.col6();
        int col8 = this.col8();
        if (row > 0 && ++row > this.rmax()) {
            cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
            row = 0;
        }
        TaxStatementPDFUtil.drawRectangle(cs, grey, xa, ya + 8 - row * 10, xe, ya - 4 - row * 10, grey);
        TaxStatementPDFUtil.showText(cs, bold, 8, Color.BLACK, col2, ya - row * 10, TaxStatementPDFUtil.getText(lang, TOTAL_ACCOUNT));
        TaxStatementPDFUtil.showTextRight(cs, bold, 8, Color.BLACK, col6, ya - row * 10, dfd.format(totalTaxValue));
        TaxStatementPDFUtil.showTextRight(cs, bold, 8, Color.BLACK, col8, ya - row * 10, dfd.format(totalGrossRevenueB));
        ct.setRow(++row);
        return cs;
    }

    protected void addLiabilityAccount(PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content, TaxStatementPDFFormula formula) throws IOException, ParseException, XPathExpressionException {
        int accounts = TaxStatementPDFLiabilityAccountData.getLiabilityAccountCount(doc);
        if (accounts > 0) {
            TaxStatementPDFContext ct = new TaxStatementPDFContext();
            PDPage page = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content);
            PDPageContentStream cs = new PDPageContentStream(pdd, page, PDPageContentStream.AppendMode.APPEND, true);
            Matrix mx = new Matrix(0.0f, 1.0f, -1.0f, 0.0f, page.getMediaBox().getWidth(), 0.0f);
            cs.transform(mx);
            Double totalTaxValue = 0.0;
            Double totalGrossRevenueB = 0.0;
            ArrayList<String> entries = new ArrayList<String>();
            for (int account = 1; account <= accounts; ++account) {
                String entry = this.hash(doc, account);
                if (entries == null || entries.contains(entry)) continue;
                entries.add(entry);
            }
            Collections.sort(entries);
            for (String entry : entries) {
                int account = Integer.parseInt(entry.substring(entry.length() - 4));
                int payments = TaxStatementPDFLiabilityAccountData.getPaymentCount(doc, account);
                cs = this.addAccount(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx, account);
                ArrayList<Date> dates = new ArrayList<Date>();
                for (int payment = 1; payment <= payments; ++payment) {
                    Date paymentDate = TaxStatementPDFLiabilityAccountData.getPaymentPaymentDate(doc, account, payment);
                    if (paymentDate == null || dates.contains(paymentDate)) continue;
                    dates.add(paymentDate);
                }
                Collections.sort(dates);
                for (Date date : dates) {
                    for (int payment = 1; payment <= payments; ++payment) {
                        Date paymentDate = TaxStatementPDFLiabilityAccountData.getPaymentPaymentDate(doc, account, payment);
                        if (paymentDate == null || !date.equals(paymentDate)) continue;
                        cs = this.addPayment(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx, account, payment);
                    }
                }
                Double taxValue = TaxStatementPDFLiabilityAccountData.getTotalTaxValue(doc, account);
                Double grossRevenueB = TaxStatementPDFLiabilityAccountData.getTotalGrossRevenueB(doc, account);
                cs = this.addTaxValue(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx, account);
                if (taxValue != null) {
                    totalTaxValue = totalTaxValue + taxValue;
                }
                if (grossRevenueB == null) continue;
                totalGrossRevenueB = totalGrossRevenueB + grossRevenueB;
            }
            cs = this.addTotal(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx, totalTaxValue, totalGrossRevenueB);
            cs.transform(mx);
            cs.transform(mx);
            cs.transform(mx);
            cs.close();
            this.endPage(ct, pdd, font, bold, doc, lang, data);
        }
    }
}

