/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.pdf.ssk;

import ch.ewv.taxstatement.pdf.TaxStatementPDFContext;
import ch.ewv.taxstatement.pdf.TaxStatementPDFExpenseData;
import ch.ewv.taxstatement.pdf.TaxStatementPDFFormula;
import ch.ewv.taxstatement.pdf.TaxStatementPDFRenderer;
import ch.ewv.taxstatement.pdf.TaxStatementPDFSchemaData;
import ch.ewv.taxstatement.pdf.TaxStatementPDFUtil;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import javax.xml.xpath.XPathExpressionException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.util.Matrix;
import org.w3c.dom.Document;

public class TaxStatementSSKExpense
extends TaxStatementPDFRenderer {
    public static final String HEADER = "HEADER_EXPENSE";
    public static final String HEADER_EXTENDED = "HEADER_EXPENSE_EXTENDED";
    public static final String TOTAL_EXPENSE = "TOTAL_EXPENSE";
    public static final String FOOTNOTE_DEDUCTION = "FOOTNOTE_DEDUCTION";
    public static final String CURRENCY_LINE1 = "EXPENSE_CURRENCY_LINE1";
    public static final String CURRENCY_LINE2 = "EXPENSE_CURRENCY_LINE2";
    public static final String CURRENCY_LINE3 = "EXPENSE_CURRENCY_LINE3";
    public static final String DESCRIPTION_LINE1 = "EXPENSE_DESCRIPTION_LINE1";
    public static final String DESCRIPTION_LINE2 = "EXPENSE_DESCRIPTION_LINE2";
    public static final String DESCRIPTION_LINE3 = "EXPENSE_DESCRIPTION_LINE3";
    public static final String EXCHANGE_RATE_LINE1 = "EXPENSE_EXCHANGE_RATE_LINE1";
    public static final String EXCHANGE_RATE_LINE2 = "EXPENSE_EXCHANGE_RATE_LINE2";
    public static final String EXCHANGE_RATE_LINE3 = "EXPENSE_EXCHANGE_RATE_LINE3";
    public static final String NUMBER_LINE1 = "EXPENSE_NUMBER_LINE1";
    public static final String NUMBER_LINE2 = "EXPENSE_NUMBER_LINE2";
    public static final String NUMBER_LINE3 = "EXPENSE_NUMBER_LINE3";
    public static final String TAX_VALUE_LINE1 = "EXPENSE_TAX_VALUE_LINE1";
    public static final String TAX_VALUE_LINE2 = "EXPENSE_TAX_VALUE_LINE2";
    public static final String TAX_VALUE_LINE3 = "EXPENSE_TAX_VALUE_LINE3";
    public static final String TAX_VALUE_DEDUCTIBLE_LINE1 = "EXPENSE_TAX_VALUE_DEDUCTIBLE_LINE1";
    public static final String TAX_VALUE_DEDUCTIBLE_LINE2 = "EXPENSE_TAX_VALUE_DEDUCTIBLE_LINE2";
    public static final String TAX_VALUE_DEDUCTIBLE_LINE3 = "EXPENSE_TAX_VALUE_DEDUCTIBLE_LINE3";
    public static final String VALUE_LINE1 = "EXPENSE_VALUE_LINE1";
    public static final String VALUE_LINE2 = "EXPENSE_VALUE_LINE2";
    public static final String VALUE_LINE3 = "EXPENSE_VALUE_LINE3";
    public static final String EXPENSE_CATEGORY = "EXPENSE_CATEGORY";
    public static final String EXPENSE_CATEGORY_TYPE = "EXPENSE_CATEGORY_TYPE";
    public static final String EXPENSE_TYPE = "EXPENSE_TYPE";
    public static final int COL1 = 71;
    public static final int COL2 = 130;
    public static final int COL3 = 520;
    public static final int COL4 = 605;
    public static final int COL5 = 655;
    public static final int COL6 = 734;
    public static final int COL7 = 804;
    public static final int NMAX = 100;

    protected int col1() {
        return 71 + this.offsetX();
    }

    protected int col2() {
        return 130 + this.offsetX();
    }

    protected int col3() {
        return 520 + this.offsetX();
    }

    protected int col4() {
        return 605 + this.offsetX();
    }

    protected int col5() {
        return 655 + this.offsetX();
    }

    protected int col6() {
        return 734 + this.offsetX();
    }

    protected int col7() {
        return 804 + this.offsetX();
    }

    protected int nmax() {
        return 100;
    }

    protected static String hash(Document doc, int expense, Properties lang) throws IOException, ParseException, XPathExpressionException {
        String referenceDate = TaxStatementPDFExpenseData.getExpenseReferenceDate(doc, expense, "yyyyMMdd");
        String depotNumber = TaxStatementPDFExpenseData.getExpenseDepotNumber(doc, expense);
        String accountNumber = TaxStatementPDFExpenseData.getExpenseAccountNumber(doc, expense);
        String iban = TaxStatementPDFExpenseData.getExpenseIBAN(doc, expense);
        String name = TaxStatementPDFExpenseData.getExpenseName(doc, expense);
        String expenseType = TaxStatementPDFExpenseData.getExpenseType(doc, expense, "00");
        String hx = "";
        if (expenseType != null && expenseType.length() > 0) {
            int i;
            DecimalFormat df = new DecimalFormat("00");
            String categoryType = TaxStatementPDFUtil.getText(lang, "EXPENSE_CATEGORY_TYPE_" + expenseType);
            String type = TaxStatementPDFUtil.getText(lang, "EXPENSE_TYPE_" + expenseType);
            Integer id = null;
            for (int i2 = 1; i2 <= 5 && id == null; ++i2) {
                String ec = TaxStatementPDFUtil.getText(lang, "EXPENSE_CATEGORY_" + df.format(i2));
                if (ec == null || categoryType == null || !ec.equals(categoryType)) continue;
                id = i2;
            }
            if (id != null) {
                hx = hx + df.format(id);
                id = null;
            } else {
                hx = hx + "00";
            }
            ArrayList<String> list = new ArrayList<String>();
            for (i = 1; i < 100; ++i) {
                String et = TaxStatementPDFUtil.getText(lang, "EXPENSE_TYPE_" + df.format(i));
                if (et == null || et.length() <= 0) continue;
                list.add(et);
            }
            Collections.sort(list);
            for (i = 0; i < list.size() && id == null; ++i) {
                if (type == null || !type.equals(list.get(i))) continue;
                id = i;
            }
            if (id != null) {
                hx = hx + df.format(id);
                id = null;
            } else {
                hx = hx + "00";
            }
            hx = hx + expenseType;
        } else {
            hx = hx + "000000";
        }
        hx = referenceDate != null && referenceDate.length() > 0 ? hx + referenceDate : hx + "00000000";
        if (name != null && name.length() > 0) {
            hx = hx + TaxStatementPDFUtil.normalize(name);
        }
        if (depotNumber != null && depotNumber.length() > 0) {
            hx = hx + TaxStatementPDFUtil.normalize(depotNumber);
        } else if (accountNumber != null && accountNumber.length() > 0) {
            hx = hx + TaxStatementPDFUtil.normalize(accountNumber);
        } else if (iban != null && iban.length() > 0) {
            hx = hx + TaxStatementPDFUtil.normalize(iban);
        }
        if (expense > 0) {
            hx = hx + String.format("%04d", expense);
        }
        return hx;
    }

    protected PDPage addPage(TaxStatementPDFContext ct, PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content) throws IOException, ParseException, XPathExpressionException {
        this.endPage(ct, pdd, font, bold, doc, lang, data);
        PDPage page = new PDPage();
        page.setMediaBox(PDRectangle.A4);
        page.setRotation(90);
        pdd.addPage(page);
        ct.setPage(page).setRow(0);
        if (layout != null) {
            layout.addLayout(pdd, font, bold, logo, size, doc, lang, data, content, page, this.extended() ? HEADER_EXTENDED : HEADER);
            layout.addPageBarCode(pdd, font, bold, doc, page, 197);
        }
        return page;
    }

    protected PDPageContentStream addPage(TaxStatementPDFContext ct, PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content, PDPageContentStream cs, Matrix mx) throws IOException, ParseException, XPathExpressionException {
        cs.transform(mx);
        cs.transform(mx);
        cs.transform(mx);
        cs.close();
        PDPage page = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content);
        cs = new PDPageContentStream(pdd, page, PDPageContentStream.AppendMode.APPEND, true);
        cs.transform(mx);
        return cs;
    }

    protected void endPage(TaxStatementPDFContext ct, PDDocument pdd, PDFont font, PDFont bold, Document doc, Properties lang, Properties data) throws IOException, ParseException, XPathExpressionException {
        if (ct.getPage() != null) {
            this.addHeader(ct, pdd, font, bold, doc, lang, data, ct.getPage());
        }
    }

    protected void addHeader(TaxStatementPDFContext ct, PDDocument pdd, PDFont font, PDFont bold, Document doc, Properties lang, Properties data, PDPage page) throws IOException, ParseException, XPathExpressionException {
        PDPageContentStream cs = new PDPageContentStream(pdd, page, PDPageContentStream.AppendMode.APPEND, true);
        Matrix mx = new Matrix(0.0f, 1.0f, -1.0f, 0.0f, page.getMediaBox().getWidth(), 0.0f);
        Color grey = new Color(211, 211, 211);
        cs.transform(mx);
        int yh = this.yh();
        int xa = this.xa();
        int xe = this.xe();
        int col1 = this.col1();
        int col2 = this.col2();
        int col3 = this.col3();
        int col4 = this.col4();
        int col5 = this.col5();
        int col6 = this.col6();
        int col7 = this.col7();
        int row1 = yh + 2 - 10;
        int row2 = yh + 2 - 20;
        int row3 = yh + 2 - 30;
        TaxStatementPDFUtil.drawRectangle(cs, grey, xa, yh, xe, row3 - 4, grey);
        TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col1, row1, TaxStatementPDFUtil.getText(lang, NUMBER_LINE1));
        TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col1, row2, TaxStatementPDFUtil.getText(lang, NUMBER_LINE2));
        TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col1, row3, TaxStatementPDFUtil.getText(lang, NUMBER_LINE3));
        TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col2, row1, TaxStatementPDFUtil.getText(lang, DESCRIPTION_LINE1));
        TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col2, row2, TaxStatementPDFUtil.getText(lang, DESCRIPTION_LINE2));
        TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col2, row3, TaxStatementPDFUtil.getText(lang, DESCRIPTION_LINE3));
        TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col3, row1, TaxStatementPDFUtil.getText(lang, CURRENCY_LINE1));
        TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col3, row2, TaxStatementPDFUtil.getText(lang, CURRENCY_LINE2));
        TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col3, row3, TaxStatementPDFUtil.getText(lang, CURRENCY_LINE3));
        TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col4, row1, TaxStatementPDFUtil.getText(lang, VALUE_LINE1));
        TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col4, row2, TaxStatementPDFUtil.getText(lang, VALUE_LINE2));
        TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col4, row3, TaxStatementPDFUtil.getText(lang, VALUE_LINE3));
        TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col5, row1, TaxStatementPDFUtil.getText(lang, EXCHANGE_RATE_LINE1));
        TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col5, row2, TaxStatementPDFUtil.getText(lang, EXCHANGE_RATE_LINE2));
        TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col5, row3, TaxStatementPDFUtil.getText(lang, EXCHANGE_RATE_LINE3));
        if (this.deductible()) {
            TaxStatementPDFUtil.showTextRight(cs, bold, 8, Color.BLACK, col6, row1, TaxStatementPDFUtil.getText(lang, TAX_VALUE_LINE1));
            TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col6, row2, String.format(TaxStatementPDFUtil.getText(lang, TAX_VALUE_LINE2), TaxStatementPDFSchemaData.getPeriodTo(doc, "dd.MM.yyyy")));
            TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col6, row3, TaxStatementPDFUtil.getText(lang, TAX_VALUE_LINE3));
            TaxStatementPDFUtil.showTextRight(cs, bold, 8, Color.BLACK, col7, row1, TaxStatementPDFUtil.getText(lang, TAX_VALUE_DEDUCTIBLE_LINE1));
            TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col7, row2, String.format(TaxStatementPDFUtil.getText(lang, TAX_VALUE_DEDUCTIBLE_LINE2), TaxStatementPDFSchemaData.getPeriodTo(doc, "dd.MM.yyyy")));
            TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col7, row3, TaxStatementPDFUtil.getText(lang, TAX_VALUE_DEDUCTIBLE_LINE3));
        } else {
            TaxStatementPDFUtil.showTextRight(cs, bold, 8, Color.BLACK, col7, row1, TaxStatementPDFUtil.getText(lang, TAX_VALUE_LINE1));
            TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col7, row2, String.format(TaxStatementPDFUtil.getText(lang, TAX_VALUE_LINE2), TaxStatementPDFSchemaData.getPeriodTo(doc, "dd.MM.yyyy")));
            TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col7, row3, TaxStatementPDFUtil.getText(lang, TAX_VALUE_LINE3));
        }
        cs.transform(mx);
        cs.transform(mx);
        cs.transform(mx);
        cs.close();
    }

    protected PDPageContentStream addExpenseCategory(TaxStatementPDFContext ct, PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content, PDPageContentStream cs, Matrix mx, Integer expense) throws IOException, ParseException, XPathExpressionException {
        String expenseType = TaxStatementPDFExpenseData.getExpenseType(doc, expense, "00");
        if (expenseType != null && expenseType.length() > 0) {
            Color grain = new Color(242, 242, 242);
            int row = ct.getRow();
            int ya = this.ya();
            int xa = this.xa();
            int xe = this.xe();
            int col2 = this.col2();
            if (row > 0 && ++row > this.rows() - 2) {
                cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
                row = 0;
            }
            TaxStatementPDFUtil.drawRectangle(cs, grain, xa, ya + 8 - row * 10, xe, ya - 4 - row * 10, grain);
            TaxStatementPDFUtil.showText(cs, bold, 8, Color.BLACK, col2, ya - 10 * row, TaxStatementPDFUtil.getText(lang, "EXPENSE_CATEGORY_TYPE_" + expenseType));
            ct.setRow(++row);
        }
        return cs;
    }

    protected PDPageContentStream addExpenseType(TaxStatementPDFContext ct, PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content, PDPageContentStream cs, Matrix mx, Integer expense) throws IOException, ParseException, XPathExpressionException {
        String expenseType = TaxStatementPDFExpenseData.getExpenseType(doc, expense, "00");
        if (expenseType != null && expenseType.length() > 0) {
            int row = ct.getRow();
            int ya = this.ya();
            int col2 = this.col2();
            if (row > 0 && ++row > this.rows() - 2) {
                cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
                row = 0;
            }
            TaxStatementPDFUtil.showText(cs, bold, 8, Color.BLACK, col2, ya - 10 * row, TaxStatementPDFUtil.getText(lang, "EXPENSE_TYPE_" + expenseType));
            ct.setRow(++row);
        }
        return cs;
    }

    protected PDPageContentStream addExpense(TaxStatementPDFContext ct, PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content, PDPageContentStream cs, Matrix mx, Integer expense) throws IOException, ParseException, XPathExpressionException {
        DecimalFormat dfd = new DecimalFormat("#,###,###,##0.00");
        DecimalFormat dfx = new DecimalFormat("#,###,###,##0." + String.format("%0" + this.exchangeRateDecimal() + "d", 0));
        int row = ct.getRow();
        String depotNumber = TaxStatementPDFExpenseData.getExpenseDepotNumber(doc, expense);
        String accountNumber = TaxStatementPDFExpenseData.getExpenseAccountNumber(doc, expense);
        String iban = TaxStatementPDFExpenseData.getExpenseIBAN(doc, expense);
        String referenceDate = TaxStatementPDFExpenseData.getExpenseReferenceDate(doc, expense, "dd.MM.yyyy");
        String name = TaxStatementPDFExpenseData.getExpenseName(doc, expense);
        String currency = TaxStatementPDFExpenseData.getExpenseAmountCurrency(doc, expense);
        Double amount = TaxStatementPDFExpenseData.getExpenseAmount(doc, expense);
        Double exchangeRate = TaxStatementPDFExpenseData.getExpenseExchangeRate(doc, expense);
        Double value = TaxStatementPDFExpenseData.getExpenseExpenses(doc, expense);
        Double deductible = TaxStatementPDFExpenseData.getExpenseExpensesDeductible(doc, expense);
        int ya = this.ya();
        int col1 = this.col1();
        int col2 = this.col2();
        int col3 = this.col3();
        int col4 = this.col4();
        int col5 = this.col5();
        int col6 = this.col6();
        int col7 = this.col7();
        if (row > 0 && ++row > this.rows()) {
            cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
            row = 0;
        }
        if (depotNumber != null && depotNumber.length() > 0) {
            if (name != null && name.length() > 0) {
                name = name + " ";
            }
            name = name + depotNumber;
        } else if (accountNumber != null && accountNumber.length() > 0) {
            if (name != null && name.length() > 0) {
                name = name + " ";
            }
            name = name + accountNumber;
        } else if (iban != null && iban.length() > 0) {
            if (name != null && name.length() > 0) {
                name = name + " ";
            }
            name = name + iban;
        }
        String name1 = TaxStatementPDFUtil.trim(TaxStatementPDFUtil.split(name, this.nmax(), 1));
        String name2 = TaxStatementPDFUtil.trim(TaxStatementPDFUtil.split(name, this.nmax(), 2));
        String name3 = TaxStatementPDFUtil.trim(TaxStatementPDFUtil.split(name, this.nmax(), 3));
        TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col1, ya - row * 10, referenceDate);
        TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col3, ya - row * 10, currency);
        if (amount != null) {
            TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col4, ya - row * 10, dfd.format(amount));
        }
        if (exchangeRate != null && currency != null && !currency.equals("CHF")) {
            TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col5, ya - row * 10, dfx.format(exchangeRate));
        }
        if (value != null && this.deductible()) {
            TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col6, ya - row * 10, dfd.format(value));
        }
        if (value != null && !this.deductible()) {
            TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col7, ya - row * 10, dfd.format(value));
        }
        if (deductible != null && this.deductible()) {
            TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col7, ya - row * 10, dfd.format(deductible));
        }
        if (name1 != null && name1.length() > 0) {
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col2, ya - row * 10, name1);
        }
        if (name2 != null && name2.length() > 0) {
            if (++row > this.rmax()) {
                cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
                row = 0;
            }
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col2, ya - row * 10, name2);
        }
        if (name3 != null && name3.length() > 0) {
            if (++row > this.rmax()) {
                cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
                row = 0;
            }
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col2, ya - row * 10, name3);
        }
        ct.setRow(++row);
        return cs;
    }

    protected PDPageContentStream addTotal(TaxStatementPDFContext ct, PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content, PDPageContentStream cs, Matrix mx, Double totalValue, Double totalDeductible) throws IOException, ParseException, XPathExpressionException {
        Color grey = new Color(211, 211, 211);
        DecimalFormat dfd = new DecimalFormat("#,###,###,##0.00");
        int row = ct.getRow();
        int ya = this.ya();
        int xa = this.xa();
        int xe = this.xe();
        int col1 = this.col1();
        int col2 = this.col2();
        int col6 = this.col6();
        int col7 = this.col7();
        int fmax = this.fmax();
        if (row > 0 && ++row > this.rmax()) {
            cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
            row = 0;
        }
        TaxStatementPDFUtil.drawRectangle(cs, grey, xa, ya + 8 - row * 10, xe, ya - 4 - row * 10, grey);
        TaxStatementPDFUtil.showText(cs, bold, 8, Color.BLACK, col2, ya - row * 10, TaxStatementPDFUtil.getText(lang, TOTAL_EXPENSE));
        if (this.deductible()) {
            TaxStatementPDFUtil.showTextRight(cs, bold, 8, Color.BLACK, col6, ya - row * 10, dfd.format(totalValue));
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col6 + 2, ya - row * 10, "*");
            TaxStatementPDFUtil.showTextRight(cs, bold, 8, Color.BLACK, col7, ya - row * 10, dfd.format(totalDeductible));
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col7 + 2, ya - row * 10, "*");
        } else {
            TaxStatementPDFUtil.showTextRight(cs, bold, 8, Color.BLACK, col7, ya - row * 10, dfd.format(totalValue));
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col7 + 2, ya - row * 10, "*");
        }
        TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col1, ya - fmax * 10, "* " + TaxStatementPDFUtil.getText(lang, FOOTNOTE_DEDUCTION));
        ct.setRow(++row);
        return cs;
    }

    protected void addExpense(PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content, TaxStatementPDFFormula formula) throws IOException, ParseException, XPathExpressionException {
        Double totalExpenses = TaxStatementPDFExpenseData.getTotalExpenses(doc);
        int expenses = TaxStatementPDFExpenseData.getExpenseCount(doc);
        if (totalExpenses != null && totalExpenses > 0.0 || expenses > 0) {
            TaxStatementPDFContext ct = new TaxStatementPDFContext();
            PDPage page = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content);
            PDPageContentStream cs = new PDPageContentStream(pdd, page, PDPageContentStream.AppendMode.APPEND, true);
            Matrix mx = new Matrix(0.0f, 1.0f, -1.0f, 0.0f, page.getMediaBox().getWidth(), 0.0f);
            cs.transform(mx);
            Double totalValue = 0.0;
            Double totalDeductible = 0.0;
            ArrayList<String> entries = new ArrayList<String>();
            for (int expense = 1; expense <= expenses; ++expense) {
                String entry = TaxStatementSSKExpense.hash(doc, expense, lang);
                if (entries == null || entries.contains(entry)) continue;
                entries.add(entry);
            }
            Collections.sort(entries);
            int expenseCategoryPrev = 0;
            int expenseTypePrev = 0;
            for (String entry : entries) {
                int expense = Integer.parseInt(entry.substring(entry.length() - 4));
                int expenseCategory = Integer.parseInt(entry.substring(0, 2));
                int expenseType = Integer.parseInt(entry.substring(4, 6));
                if (expenseCategory > 0 && expenseCategory != expenseCategoryPrev) {
                    cs = this.addExpenseCategory(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx, expense);
                    expenseCategoryPrev = expenseCategory;
                }
                if (expenseType > 0 && expenseType != expenseTypePrev) {
                    cs = this.addExpenseType(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx, expense);
                    expenseTypePrev = expenseType;
                }
                cs = this.addExpense(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx, expense);
                Double value = TaxStatementPDFExpenseData.getExpenseExpenses(doc, expense);
                Double deductible = TaxStatementPDFExpenseData.getExpenseExpensesDeductible(doc, expense);
                if (value != null) {
                    totalValue = totalValue + value;
                }
                if (deductible == null) continue;
                totalDeductible = totalDeductible + deductible;
            }
            cs = this.addTotal(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx, totalValue, totalDeductible);
            cs.transform(mx);
            cs.transform(mx);
            cs.transform(mx);
            cs.close();
            this.endPage(ct, pdd, font, bold, doc, lang, data);
        }
    }
}

