/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.pdf.ssk;

import ch.ewv.taxstatement.TaxStatement;
import ch.ewv.taxstatement.pdf.TaxStatementPDFRenderer;
import ch.ewv.taxstatement.pdf.TaxStatementPDFUtil;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKLayout;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.ParseException;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class TaxStatementSSKBarCode
extends TaxStatementPDFRenderer {
    public static final String HEADER = "HEADER_BARCODE";
    public static final String HEADER_EXTENDED = "HEADER_BARCODE_EXTENDED";

    protected void addBarCode(PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, BufferedImage[] bi, Properties lang, Properties data, Properties content) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        if (bi != null && bi.length > 0) {
            for (int i = 0; i < bi.length; i += TaxStatement.BARCODE_SEGMENTS_PER_PAGE) {
                PDPage page = new PDPage();
                page.setMediaBox(PDRectangle.A4);
                page.setRotation(90);
                pdd.addPage(page);
                if (layout != null) {
                    layout.addLayout(pdd, font, bold, logo, size, doc, lang, data, content, page, this.extended() ? HEADER_EXTENDED : HEADER);
                    layout.addPageBarCode(pdd, font, bold, doc, page, 196);
                }
                TaxStatement.addBarCode(pdd, page, bi, i / TaxStatement.BARCODE_SEGMENTS_PER_PAGE + 1);
            }
        }
    }

    protected void addBarCode(PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, byte[] xml, Properties lang, Properties data, Properties content) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        this.addBarCode(pdd, font, bold, layout, logo, size, doc, TaxStatement.barCodeXML(TaxStatementPDFUtil.extractXML(xml)), lang, data, content);
    }
}

