/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.pdf.ssk;

import ch.ewv.taxstatement.pdf.TaxStatementPDF;
import ch.ewv.taxstatement.pdf.TaxStatementPDFFormula;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKBankAccount;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKBarCode;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKContentTable;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKCover;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKCrypto;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKDisclaimer;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKDocument;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKExpense;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKExplanation;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKLayout;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKLegend;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKLetter;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKLiabilityAccount;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKNonRecoverable;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKOther;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKOverview;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKPaging;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKSecurity;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKTaxReclaim;
import java.awt.Dimension;
import java.io.IOException;
import java.text.ParseException;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class TaxStatementSSK
extends TaxStatementPDF {
    protected TaxStatementSSKBankAccount bankAccount() {
        return this.isBankAccount() ? new TaxStatementSSKBankAccount() : null;
    }

    protected TaxStatementSSKBarCode barCode() {
        return this.isBarCode() ? new TaxStatementSSKBarCode() : null;
    }

    protected TaxStatementSSKContentTable contentTable() {
        return this.isContent() ? new TaxStatementSSKContentTable() : null;
    }

    protected TaxStatementSSKCover cover() {
        return this.isCover() ? new TaxStatementSSKCover() : null;
    }

    protected TaxStatementSSKCrypto crypto() {
        return this.isCrypto() ? new TaxStatementSSKCrypto() : null;
    }

    protected TaxStatementSSKDisclaimer disclaimer() {
        return this.isDisclaimer() ? new TaxStatementSSKDisclaimer() : null;
    }

    protected TaxStatementSSKDocument document() {
        return this.isDocument() ? new TaxStatementSSKDocument() : null;
    }

    protected TaxStatementSSKExplanation explanation() {
        return this.isExplanation() ? new TaxStatementSSKExplanation() : null;
    }

    protected TaxStatementSSKExpense expense() {
        return this.isExpense() ? new TaxStatementSSKExpense() : null;
    }

    protected TaxStatementSSKLayout layout() {
        return this.isLayout() ? new TaxStatementSSKLayout() : null;
    }

    protected TaxStatementSSKLegend legend() {
        return this.isLegend() ? new TaxStatementSSKLegend() : null;
    }

    protected TaxStatementSSKLetter letter() {
        return this.isLetter() ? new TaxStatementSSKLetter() : null;
    }

    protected TaxStatementSSKLiabilityAccount liability() {
        return this.isLiability() ? new TaxStatementSSKLiabilityAccount() : null;
    }

    protected TaxStatementSSKNonRecoverable nonRecoverable() {
        return this.isNonRecoverable() ? new TaxStatementSSKNonRecoverable() : null;
    }

    protected TaxStatementSSKOther other() {
        return this.isOther() ? new TaxStatementSSKOther() : null;
    }

    protected TaxStatementSSKOverview overview() {
        return this.isOverview() ? new TaxStatementSSKOverview() : null;
    }

    protected TaxStatementSSKPaging paging() {
        return this.isPaging() ? new TaxStatementSSKPaging() : null;
    }

    protected TaxStatementSSKSecurity security() {
        return this.isSecurity() ? new TaxStatementSSKSecurity() : null;
    }

    protected TaxStatementSSKTaxReclaim taxReclaim() {
        return this.isTaxReclaim() ? new TaxStatementSSKTaxReclaim() : null;
    }

    protected void addBankAccount(PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content, TaxStatementPDFFormula formula) throws IOException, ParseException, XPathExpressionException {
        TaxStatementSSKBankAccount ts = this.bankAccount();
        if (ts != null) {
            ts.addBankAccount(pdd, font, bold, layout, logo, size, doc, lang, data, content, formula);
        }
    }

    protected void addBarCode(PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, byte[] xml, Properties lang, Properties data, Properties content) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementSSKBarCode ts = this.barCode();
        if (ts != null) {
            ts.addBarCode(pdd, font, bold, layout, logo, size, doc, xml, lang, data, content);
        }
    }

    protected void addContentTable(PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content) throws IOException, ParseException, XPathExpressionException {
        TaxStatementSSKContentTable ts = this.contentTable();
        if (ts != null) {
            ts.addContentTable(pdd, font, bold, layout, logo, size, doc, lang, data, content);
        }
    }

    protected void addContentData(PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content) throws IOException, ParseException, XPathExpressionException {
        TaxStatementSSKContentTable ts = this.contentTable();
        if (ts != null) {
            ts.addContentData(pdd, font, bold, layout, logo, size, doc, lang, data, content);
        }
    }

    protected void addCover(PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content, PDDocument cover) throws IOException, ParseException, XPathExpressionException {
        TaxStatementSSKCover ts = this.cover();
        if (ts != null) {
            ts.addCover(pdd, font, bold, layout, logo, size, doc, lang, data, content, cover);
        }
    }

    protected void addCrypto(PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content, TaxStatementPDFFormula formula) throws IOException, ParseException, XPathExpressionException {
        TaxStatementSSKCrypto ts = this.crypto();
        if (ts != null) {
            ts.addCrypto(pdd, font, bold, layout, logo, size, doc, lang, data, content, formula);
        }
    }

    protected void addDisclaimer(PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content, PDDocument disclaimer) throws IOException, ParseException, XPathExpressionException {
        TaxStatementSSKDisclaimer ts = this.disclaimer();
        if (ts != null) {
            ts.addDisclaimer(pdd, font, bold, layout, logo, size, doc, lang, data, content, disclaimer);
        }
    }

    protected void addDocument(PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content, PDDocument document) throws IOException, ParseException, XPathExpressionException {
        TaxStatementSSKDocument ts = this.document();
        if (ts != null) {
            ts.addDocument(pdd, font, bold, layout, logo, size, doc, lang, data, content, document);
        }
    }

    protected void addExplanation(PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content, PDDocument explanation) throws IOException, ParseException, XPathExpressionException {
        TaxStatementSSKExplanation ts = this.explanation();
        if (ts != null) {
            ts.addExplanation(pdd, font, bold, layout, logo, size, doc, lang, data, content, explanation);
        }
    }

    protected void addExpense(PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content, TaxStatementPDFFormula formula) throws IOException, ParseException, XPathExpressionException {
        TaxStatementSSKExpense ts = this.expense();
        if (ts != null) {
            ts.addExpense(pdd, font, bold, layout, logo, size, doc, lang, data, content, formula);
        }
    }

    protected void addLegend(PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content) throws IOException, ParseException, XPathExpressionException {
        TaxStatementSSKLegend ts = this.legend();
        if (ts != null) {
            ts.addLegend(pdd, font, bold, layout, logo, size, doc, lang, data, content);
        }
    }

    protected void addLetter(PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content, PDDocument letter) throws IOException, ParseException, XPathExpressionException {
        TaxStatementSSKLetter ts = this.letter();
        if (ts != null) {
            ts.addLetter(pdd, font, bold, layout, logo, size, doc, lang, data, content, letter);
        }
    }

    protected void addLiabilityAccount(PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content, TaxStatementPDFFormula formula) throws IOException, ParseException, XPathExpressionException {
        TaxStatementSSKLiabilityAccount ts = this.liability();
        if (ts != null) {
            ts.addLiabilityAccount(pdd, font, bold, layout, logo, size, doc, lang, data, content, formula);
        }
    }

    protected void addNonRecoverable(PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content, TaxStatementPDFFormula formula) throws IOException, ParseException, XPathExpressionException {
        TaxStatementSSKNonRecoverable ts = this.nonRecoverable();
        if (ts != null) {
            ts.addNonRecoverable(pdd, font, bold, layout, logo, size, doc, lang, data, content, formula);
        }
    }

    public void addOther(PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content, TaxStatementPDFFormula formula) throws IOException, ParseException, XPathExpressionException {
        TaxStatementSSKOther ts = this.other();
        if (ts != null) {
            ts.addOther(pdd, font, bold, layout, logo, size, doc, lang, data, content, formula);
        }
    }

    public void addOverview(PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content, TaxStatementPDFFormula formula) throws IOException, ParseException, XPathExpressionException {
        TaxStatementSSKOverview ts = this.overview();
        if (ts != null) {
            ts.addOverview(pdd, font, bold, layout, logo, size, doc, lang, data, content, formula);
        }
    }

    protected void addPaging(PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, Document doc, Properties lang, Properties data) throws IOException, ParseException, XPathExpressionException {
        TaxStatementSSKPaging ts = this.paging();
        if (ts != null) {
            ts.addPaging(pdd, font, bold, layout, doc, lang, data);
        }
    }

    protected void addSecurity(PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content, TaxStatementPDFFormula formula, Boolean withHoldingTax) throws IOException, ParseException, XPathExpressionException {
        TaxStatementSSKSecurity ts = this.security();
        if (ts != null && withHoldingTax.booleanValue() && this.isSecurityWithHoldingTax() || !withHoldingTax.booleanValue() && this.isSecurityWithOutHoldingTax()) {
            ts.addSecurity(pdd, font, bold, layout, logo, size, doc, lang, data, content, formula, withHoldingTax);
        }
    }

    public void addTaxReclaim(PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content, TaxStatementPDFFormula formula) throws IOException, ParseException, XPathExpressionException {
        TaxStatementSSKTaxReclaim ts = this.taxReclaim();
        if (ts != null) {
            ts.addTaxReclaim(pdd, font, bold, layout, logo, size, doc, lang, data, content, formula);
        }
    }

    @Override
    protected PDDocument translate(byte[] xml, Document doc, Properties lang, Properties data, Properties content) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementPDFFormula formula = this.formula(doc);
        PDDocument pdd = new PDDocument();
        PDFont font = this.font(pdd);
        PDFont bold = this.bold(pdd);
        PDImageXObject logo = this.logo(pdd);
        Dimension size = this.size();
        TaxStatementSSKLayout layout = this.layout();
        PDDocument cover = this.coverPDF();
        PDDocument disclaimer = this.disclaimerPDF();
        PDDocument document = this.documentPDF();
        PDDocument explanation = this.explanationPDF();
        PDDocument letter = this.letterPDF();
        this.addDocument(pdd, font, bold, layout, logo, size, doc, lang, data, content, document);
        this.addLetter(pdd, font, bold, layout, logo, size, doc, lang, data, content, letter);
        this.addCover(pdd, font, bold, layout, logo, size, doc, lang, data, content, cover);
        this.addContentTable(pdd, font, bold, layout, logo, size, doc, lang, data, content);
        this.addOverview(pdd, font, bold, layout, logo, size, doc, lang, data, content, formula);
        this.addExpense(pdd, font, bold, layout, logo, size, doc, lang, data, content, formula);
        this.addBankAccount(pdd, font, bold, layout, logo, size, doc, lang, data, content, formula);
        this.addSecurity(pdd, font, bold, layout, logo, size, doc, lang, data, content, formula, true);
        this.addSecurity(pdd, font, bold, layout, logo, size, doc, lang, data, content, formula, false);
        this.addNonRecoverable(pdd, font, bold, layout, logo, size, doc, lang, data, content, formula);
        this.addTaxReclaim(pdd, font, bold, layout, logo, size, doc, lang, data, content, formula);
        this.addOther(pdd, font, bold, layout, logo, size, doc, lang, data, content, formula);
        this.addCrypto(pdd, font, bold, layout, logo, size, doc, lang, data, content, formula);
        this.addLiabilityAccount(pdd, font, bold, layout, logo, size, doc, lang, data, content, formula);
        this.addLegend(pdd, font, bold, layout, logo, size, doc, lang, data, content);
        this.addBarCode(pdd, font, bold, layout, logo, size, doc, xml, lang, data, content);
        this.addExplanation(pdd, font, bold, layout, logo, size, doc, lang, data, content, explanation);
        this.addDisclaimer(pdd, font, bold, layout, logo, size, doc, lang, data, content, disclaimer);
        this.addContentData(pdd, font, bold, layout, logo, size, doc, lang, data, content);
        this.addPaging(pdd, font, bold, layout, doc, lang, data);
        return pdd;
    }
}

