/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.pdf.bcv;

import ch.ewv.taxstatement.pdf.TaxStatementPDFProperty;
import ch.ewv.taxstatement.pdf.bcv.TaxStatementBCVLayout;
import ch.ewv.taxstatement.pdf.bcv.TaxStatementBCVOverview;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSK;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKLayout;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKOverview;
import java.io.IOException;
import java.util.Locale;
import java.util.Properties;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;

public class TaxStatementBCV
extends TaxStatementSSK {
    public static final boolean DISCLAIMER = true;
    public static final String MESSAGE = "bcv-messages_";
    public static final String DISCLAIMER_DE = "bcv-disclaimer-de.pdf";
    public static final String DISCLAIMER_FR = "bcv-disclaimer-fr.pdf";
    public static final String LOGO = "bcv-logo.png";
    public static final int LOGO_HEIGHT = 43;
    public static final int LOGO_WIDTH = 443;

    @Override
    protected PDDocument disclaimerPDF(String language) throws IOException {
        String name = TaxStatementPDFProperty.DISCLAIMER != null ? TaxStatementPDFProperty.DISCLAIMER : (Locale.GERMAN.toString().equals(language) ? DISCLAIMER_DE : DISCLAIMER_FR);
        return this.disclaimerPDF(language, name);
    }

    @Override
    protected Properties language(String language) throws IOException {
        return this.language(language, MESSAGE);
    }

    @Override
    protected PDImageXObject logo(PDDocument pdd) throws IOException {
        return this.logo(pdd, TaxStatementPDFProperty.LOGO != null ? TaxStatementPDFProperty.LOGO : LOGO);
    }

    @Override
    protected int logoHeight() {
        return TaxStatementPDFProperty.LOGO != null ? TaxStatementPDFProperty.LOGO_HEIGHT : 43;
    }

    @Override
    protected int logoWidth() {
        return TaxStatementPDFProperty.LOGO != null ? TaxStatementPDFProperty.LOGO_WIDTH : 443;
    }

    @Override
    protected boolean isDisclaimer() {
        return System.getProperty("disclaimer") != null ? TaxStatementPDFProperty.DISCLAIMER != null && !TaxStatementPDFProperty.DISCLAIMER.equals("false") : true;
    }

    @Override
    protected TaxStatementSSKLayout layout() {
        return this.isLayout() ? new TaxStatementBCVLayout() : null;
    }

    @Override
    protected TaxStatementSSKOverview overview() {
        return this.isOverview() ? new TaxStatementBCVOverview() : null;
    }
}

