/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.pdf;

import ch.ewv.taxstatement.TaxStatement;
import ch.ewv.taxstatement.cache.DocumentCache;
import ch.ewv.taxstatement.cache.PDDocumentCache;
import ch.ewv.taxstatement.pdf.TaxStatementPDFFont;
import ch.ewv.taxstatement.pdf.TaxStatementPDFFormula;
import ch.ewv.taxstatement.pdf.TaxStatementPDFProperty;
import ch.ewv.taxstatement.pdf.TaxStatementPDFUtil;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.text.ParseException;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.graphics.image.LosslessFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public abstract class TaxStatementPDF {
    public static final int SCHEMA_INVALID = 1;

    protected String content() {
        return TaxStatementPDFProperty.CONTENT;
    }

    protected Properties data(byte[] xml, Document doc) throws IOException, ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.extractProperty(xml, doc);
    }

    protected PDDocument coverPDF() throws IOException {
        return this.coverPDF(TaxStatementPDFProperty.LANG);
    }

    protected PDDocument coverPDF(String language) throws IOException {
        return this.coverPDF(language, TaxStatementPDFProperty.COVER);
    }

    protected PDDocument coverPDF(String language, String name) throws IOException {
        return PDDocumentCache.get(name);
    }

    protected PDDocument disclaimerPDF() throws IOException {
        return this.disclaimerPDF(TaxStatementPDFProperty.LANG);
    }

    protected PDDocument disclaimerPDF(String language) throws IOException {
        return this.disclaimerPDF(language, TaxStatementPDFProperty.DISCLAIMER);
    }

    protected PDDocument disclaimerPDF(String language, String name) throws IOException {
        return PDDocumentCache.get(name);
    }

    protected PDDocument documentPDF() throws IOException {
        return this.documentPDF(TaxStatementPDFProperty.LANG);
    }

    protected PDDocument documentPDF(String language) throws IOException {
        return this.documentPDF(language, TaxStatementPDFProperty.DOCUMENT);
    }

    protected PDDocument documentPDF(String language, String name) throws IOException {
        return PDDocumentCache.get(name);
    }

    protected PDDocument explanationPDF() throws IOException {
        return this.explanationPDF(TaxStatementPDFProperty.LANG);
    }

    protected PDDocument explanationPDF(String language) throws IOException {
        return this.explanationPDF(language, TaxStatementPDFProperty.EXPLANATION);
    }

    protected PDDocument explanationPDF(String language, String name) throws IOException {
        return PDDocumentCache.get(name);
    }

    protected PDDocument letterPDF() throws IOException {
        return this.letterPDF(TaxStatementPDFProperty.LANG);
    }

    protected PDDocument letterPDF(String language) throws IOException {
        return this.letterPDF(language, TaxStatementPDFProperty.LETTER);
    }

    protected PDDocument letterPDF(String language, String name) throws IOException {
        return PDDocumentCache.get(name);
    }

    protected PDFont bold() {
        return PDType1Font.HELVETICA_BOLD;
    }

    protected PDFont bold(PDDocument pdd) throws IOException {
        return this.bold(pdd, TaxStatementPDFProperty.BOLD);
    }

    protected PDFont bold(PDDocument pdd, String name) throws IOException {
        PDFont bold = this.bold();
        if (name != null && name.length() > 0) {
            bold = TaxStatementPDFFont.load(pdd, name);
        }
        return bold;
    }

    protected PDFont font() {
        return PDType1Font.HELVETICA;
    }

    protected PDFont font(PDDocument pdd) throws IOException {
        return this.font(pdd, TaxStatementPDFProperty.FONT);
    }

    protected PDFont font(PDDocument pdd, String name) throws IOException {
        PDFont font = this.font();
        if (name != null && name.length() > 0) {
            font = TaxStatementPDFFont.load(pdd, name);
        }
        return font;
    }

    protected TaxStatementPDFFormula formula(Document doc) throws ParseException, XPathExpressionException {
        return new TaxStatementPDFFormula(doc);
    }

    protected Properties merge(String language, Properties lang) throws IOException {
        Properties merged = TaxStatementPDFUtil.getLanguage(language);
        if (merged != null && lang != null) {
            for (Map.Entry<Object, Object> entry : lang.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                merged.setProperty(key, value);
            }
        }
        return merged;
    }

    protected Properties language() throws IOException {
        return this.language(TaxStatementPDFProperty.LANG, TaxStatementPDFProperty.LANG_MESSAGE);
    }

    protected Properties language(String language) throws IOException {
        return TaxStatementPDFUtil.getLanguage(language);
    }

    protected Properties language(String language, String name) throws IOException {
        Properties lang = new Properties();
        if (name != null && name.length() > 0) {
            if (lang.isEmpty()) {
                try {
                    lang.load(new FileInputStream(name));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (lang.isEmpty()) {
                try {
                    lang.load(new FileInputStream(name + language + ".properties"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (lang.isEmpty()) {
                try {
                    lang.load(TaxStatementPDF.class.getResourceAsStream("/resources/" + name));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (lang.isEmpty()) {
                try {
                    lang.load(TaxStatementPDF.class.getResourceAsStream("/resources/" + name + language + ".properties"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!lang.isEmpty()) {
                lang = this.merge(language, lang);
            }
        }
        if (lang.isEmpty()) {
            lang = this.language(language);
        }
        return lang;
    }

    protected PDImageXObject logo(PDDocument pdd) throws IOException {
        return this.logo(pdd, TaxStatementPDFProperty.LOGO);
    }

    protected PDImageXObject logo(PDDocument pdd, String name) throws IOException {
        BufferedImage image = null;
        if (name != null && name.length() > 0) {
            if (image == null) {
                try {
                    image = ImageIO.read(new File(name));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (image == null) {
                try {
                    image = ImageIO.read(TaxStatementPDF.class.getResourceAsStream("/resources/" + name));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return image != null ? LosslessFactory.createFromImage((PDDocument)pdd, image) : null;
    }

    protected int logoHeight() {
        return TaxStatementPDFProperty.LOGO_HEIGHT;
    }

    protected int logoWidth() {
        return TaxStatementPDFProperty.LOGO_WIDTH;
    }

    protected Dimension size() {
        return new Dimension(this.logoWidth(), this.logoHeight());
    }

    protected boolean isBankAccount() {
        return TaxStatementPDFProperty.BANK_ACCOUNT;
    }

    protected boolean isBarCode() {
        return TaxStatementPDFProperty.PDF417;
    }

    protected boolean isClient() {
        return TaxStatementPDFProperty.CLIENT;
    }

    protected boolean isContent() {
        return TaxStatementPDFProperty.CONTENT != null && TaxStatementPDFProperty.CONTENT.equals("true");
    }

    protected boolean isCover() {
        return TaxStatementPDFProperty.COVER != null && !TaxStatementPDFProperty.COVER.equals("false");
    }

    protected boolean isCrypto() {
        return TaxStatementPDFProperty.CRYPTO;
    }

    protected boolean isDisclaimer() {
        return TaxStatementPDFProperty.DISCLAIMER != null && !TaxStatementPDFProperty.DISCLAIMER.equals("false");
    }

    protected boolean isDocument() {
        return TaxStatementPDFProperty.DOCUMENT != null && !TaxStatementPDFProperty.DOCUMENT.equals("false");
    }

    protected boolean isExpense() {
        return TaxStatementPDFProperty.EXPENSE;
    }

    protected boolean isExplanation() {
        return TaxStatementPDFProperty.EXPLANATION != null && !TaxStatementPDFProperty.EXPLANATION.equals("false");
    }

    protected boolean isLayout() {
        return TaxStatementPDFProperty.LAYOUT;
    }

    protected boolean isLegend() {
        return TaxStatementPDFProperty.LEGEND;
    }

    protected boolean isLetter() {
        return TaxStatementPDFProperty.LETTER != null && !TaxStatementPDFProperty.LETTER.equals("false");
    }

    protected boolean isLiability() {
        return TaxStatementPDFProperty.LIABILITY;
    }

    protected boolean isNonRecoverable() {
        return TaxStatementPDFProperty.NON_RECOVERABLE;
    }

    protected boolean isOther() {
        return TaxStatementPDFProperty.OTHER;
    }

    protected boolean isOverview() {
        return TaxStatementPDFProperty.OVERVIEW;
    }

    protected boolean isPaging() {
        return TaxStatementPDFProperty.PAGING;
    }

    protected boolean isSecurity() {
        return TaxStatementPDFProperty.SECURITY;
    }

    protected boolean isSecurityWithHoldingTax() {
        return TaxStatementPDFProperty.SECURITY_WITH_HOLDING_TAX;
    }

    protected boolean isSecurityWithOutHoldingTax() {
        return TaxStatementPDFProperty.SECURITY_WITHOUT_HOLDING_TAX;
    }

    protected boolean isTaxReclaim() {
        return TaxStatementPDFProperty.TAX_RECLAIM;
    }

    protected Document document(byte[] xml) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        ByteArrayInputStream bis = new ByteArrayInputStream(xml);
        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        dbf.setXIncludeAware(false);
        dbf.setNamespaceAware(false);
        return dbf.newDocumentBuilder().parse(bis);
    }

    protected byte[] load(String name) throws IOException {
        File file = new File(name);
        if (!file.exists() || file.isDirectory()) {
            System.out.println("File " + name + " not found!");
        }
        FileInputStream fis = new FileInputStream(file);
        byte[] xml = new byte[(int)file.length()];
        fis.read(xml, 0, xml.length);
        fis.close();
        return xml;
    }

    protected int validate(Document doc) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.validate(doc, this.language());
    }

    protected int validate(Document doc, Properties lang) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        int status = 0;
        if (!TaxStatementPDFProperty.FORCE.equals("disabled") && !TaxStatement.validateXML(doc)) {
            status = 1;
            System.out.println(TaxStatementPDFUtil.getText(lang, "SCHEMA_INVALID"));
            System.out.println(TaxStatement.validateXMLMessage(doc));
        }
        return status;
    }

    protected void save(PDDocument pdd, String name) throws IOException {
        pdd.save(name);
        pdd.close();
    }

    protected void save(PDDocument pdd, String[] args) throws IOException {
        String name = new String(args.length > 1 ? (!args[1].endsWith(TaxStatementPDFProperty.FILE_SEPARATOR) ? args[1] : (!args[0].contains(TaxStatementPDFProperty.FILE_SEPARATOR) ? args[1] + args[0] : args[1] + args[0].substring(args[0].lastIndexOf(TaxStatementPDFProperty.FILE_SEPARATOR) + 1))) : args[0]).replace(".XML", ".xml").replace(".xml", ".pdf");
        this.save(pdd, name);
    }

    protected void save(Properties content, String name) throws IOException {
        if (content != null && name != null && name.length() > 0 && this.content() != null && this.content().toLowerCase().equals("csv")) {
            String v;
            Object k;
            BufferedWriter bw = new BufferedWriter(new FileWriter(name.replace(".pdf", ".csv")));
            bw.write("Heading;Page");
            bw.newLine();
            TreeMap<Integer, Object> tree = new TreeMap<Integer, Object>();
            for (Map.Entry<Object, Object> entry : content.entrySet()) {
                k = (String)entry.getKey();
                v = (String)entry.getValue();
                tree.put(Integer.valueOf(v), k);
            }
            for (Map.Entry<Object, Object> entry : tree.entrySet()) {
                k = (Integer)entry.getKey();
                v = (String)entry.getValue();
                bw.write(v + ";" + k);
                bw.newLine();
            }
            bw.flush();
            bw.close();
        }
    }

    protected void save(Properties content, String[] args) throws IOException {
        String name = new String(args.length > 1 ? (!args[1].endsWith(TaxStatementPDFProperty.FILE_SEPARATOR) ? args[1] : (!args[0].contains(TaxStatementPDFProperty.FILE_SEPARATOR) ? args[1] + args[0] : args[1] + args[0].substring(args[0].lastIndexOf(TaxStatementPDFProperty.FILE_SEPARATOR) + 1))) : args[0]).replace(".XML", ".xml").replace(".xml", ".pdf");
        this.save(content, name);
    }

    protected abstract PDDocument translate(byte[] var1, Document var2, Properties var3, Properties var4, Properties var5) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException;

    public PDDocument translate(byte[] xml) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        Document doc = this.document(xml);
        Properties lang = this.language();
        Properties data = this.data(xml, doc);
        Properties content = new Properties();
        PDDocument pdd = null;
        int status = this.validate(doc, lang);
        if (TaxStatementPDFProperty.FORCE.equals("true") || status == 0) {
            pdd = this.translate(xml, doc, lang, data, content);
        }
        DocumentCache.remove(doc);
        return pdd;
    }

    public int translate(String[] args) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        byte[] xml = this.load(args[0]);
        Document doc = this.document(xml);
        Properties lang = this.language();
        Properties data = this.data(xml, doc);
        Properties content = new Properties();
        int status = this.validate(doc, lang);
        if (TaxStatementPDFProperty.FORCE.equals("true") || status == 0) {
            PDDocument pdd = this.translate(xml, doc, lang, data, content);
            this.save(pdd, args);
            this.save(content, args);
        }
        DocumentCache.remove(doc);
        return status;
    }
}

