/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.cache;

import ch.ewv.taxstatement.TaxStatement;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;

public class DocumentCache {
    private static final Map<Document, Map<String, Integer>> count = new ConcurrentHashMap<Document, Map<String, Integer>>();
    private static final Map<Document, Map<String, String>> value = new ConcurrentHashMap<Document, Map<String, String>>();
    private static final String NULL = "N-U-L-L";

    public static int count(Document doc, String exp) throws XPathExpressionException {
        int count = 0;
        if (exp != null && exp.length() > 0) {
            Map<String, Integer> map = DocumentCache.count.get(doc);
            if (map == null && !DocumentCache.count.containsKey(doc)) {
                map = new ConcurrentHashMap<String, Integer>();
                DocumentCache.count.put(doc, map);
            }
            if (map != null) {
                Integer value = map.get(exp);
                if (value != null) {
                    count = value;
                } else if (!map.containsKey(exp)) {
                    XPath xpath = XPathFactory.newInstance().newXPath();
                    count = ((Double)xpath.compile(exp).evaluate(doc, XPathConstants.NUMBER)).intValue();
                    map.put(exp, count);
                }
            }
        }
        return count;
    }

    public static String get(Document doc, String exp) throws XPathExpressionException {
        return DocumentCache.get(doc, exp, false);
    }

    public static String get(Document doc, String exp, boolean empty) throws XPathExpressionException {
        String value = null;
        if (exp != null && exp.length() > 0) {
            Map<String, String> map = DocumentCache.value.get(doc);
            if (map == null && !DocumentCache.value.containsKey(doc)) {
                map = new ConcurrentHashMap<String, String>();
                DocumentCache.value.put(doc, map);
            }
            if (map != null && (value = map.get(exp)) == null && !map.containsKey(exp)) {
                value = exp.indexOf("@") > 0 ? TaxStatement.getAttributeXPath(doc, exp, empty) : TaxStatement.getElementXPath(doc, exp, empty);
                map.put(exp, value != null ? value : NULL);
            }
        }
        return value != null && !value.equals(NULL) ? value : null;
    }

    public static void remove(Document doc) {
        if (count.containsKey(doc)) {
            count.remove(doc);
        }
        if (value.containsKey(doc)) {
            value.remove(doc);
        }
    }

    public static void clear() {
        count.clear();
        value.clear();
    }
}

