/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement;

import ch.ewv.taxstatement.TaxStatement;
import com.java4less.rbarcode.BarCode;
import com.java4less.rbarcode.BarCode2D;
import com.java4less.vision.Barcode1DReader;
import com.java4less.vision.BarcodeData;
import com.java4less.vision.RImage;
import com.java4less.vision.pdf417.PDF417Data;
import com.java4less.vision.pdf417.PDF417Reader;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.ParseException;
import java.util.List;
import java.util.zip.Deflater;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class TaxStatementJ4L {
    private static int BARCODE_READER_MINAREA = 100;
    private static int BARCODE_READER_MAXAREA = 90000;

    protected static void displayBarCodeSegment(PDF417Data[] data) {
        if (data != null && data.length > 0) {
            for (int i = 0; i < data.length; ++i) {
                int v;
                if (data[i].getConfidence() < 0) {
                    System.out.println("\bBarcode found but It CONTAINS ERRORS which could not be corrected");
                } else if (data[i].getConfidence() > 0) {
                    System.out.println("\nBarcode found and errors corrected");
                }
                if (data[i].getMacroPDFField(PDF417Data.MACROPDF_SEGMENT) != null) {
                    System.out.println("Segment index:     " + data[i].getMacroPDFField(PDF417Data.MACROPDF_SEGMENT));
                    System.out.println("Segment file id:   " + data[i].getMacroPDFField(PDF417Data.MACROPDF_FILEID));
                    System.out.println("Segment file name: " + data[i].getMacroPDFField(PDF417Data.MACROPDF_FILENAME));
                    System.out.println("Segment count:     " + data[i].getMacroPDFField(PDF417Data.MACROPDF_SEGMENT_COUNT));
                    System.out.println("Timestamp:         " + data[i].getMacroPDFField(PDF417Data.MACROPDF_TIMESTAMP));
                    System.out.println("Sender:            " + data[i].getMacroPDFField(PDF417Data.MACROPDF_SENDER));
                    System.out.println("Address:           " + data[i].getMacroPDFField(PDF417Data.MACROPDF_ADRESSEE));
                    System.out.println("Filesize:          " + data[i].getMacroPDFField(PDF417Data.MACROPDF_FILESIZE));
                    System.out.println("Checksum:          " + data[i].getMacroPDFField(PDF417Data.MACROPDF_CHECKSUM));
                }
                int[] value = data[i].getValue();
                String line = new String("");
                for (v = 0; v < value.length; ++v) {
                    if (v % 16 == 0) {
                        System.out.print(String.format("%4s:", Integer.toHexString(v)).replace(' ', '0'));
                    }
                    if (v % 8 == 0) {
                        System.out.print(" ");
                    }
                    System.out.print(" " + String.format("%2s", Integer.toHexString(value[v])).replace(' ', '0'));
                    line = value[v] >= 32 && value[v] < 126 ? line + (char)value[v] : line + "~";
                    if (v % 16 != 15) continue;
                    System.out.println("  " + line);
                    line = new String("");
                }
                if (value.length % 16 != 0) {
                    for (v = 0; v < 16 - value.length % 16; ++v) {
                        System.out.print("   ");
                        line = line + " ";
                    }
                }
                if (value.length % 16 < 8) {
                    System.out.print(" ");
                }
                System.out.println("  " + line);
            }
        }
    }

    public static BufferedImage barCode1D(String id, Boolean text) {
        BarCode bc = new BarCode();
        bc.setSize(500, 500);
        bc.barHeightCM = 0.7;
        bc.rotate = 0;
        bc.barType = System.getProperty("pageBarCodeType", "CODE128").equals("EAN128") ? 16 : 13;
        bc.Code128Set = (char)67;
        bc.checkCharacter = true;
        bc.leftMarginCM = 0.0;
        bc.topMarginCM = 0.0;
        bc.guardBars = true;
        bc.code = id;
        bc.textFont = text != null && text != false ? new Font(System.getProperty("pageBarCodeFont", "Helvetica"), 0, Integer.parseInt(System.getProperty("pageBarCodeFontSize", "12"))) : null;
        BufferedImage bi = new BufferedImage(bc.getWidth(), bc.getHeight(), 12);
        bc.paint((Graphics)bi.createGraphics());
        return bi.getSubimage(0, 0, (int)bc.getPaintedArea().getWidth(), (int)bc.getPaintedArea().getHeight());
    }

    public static BufferedImage[] barCode2D(byte[] xml) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        dbf.setXIncludeAware(false);
        dbf.setNamespaceAware(false);
        Document doc = dbf.newDocumentBuilder().parse(new ByteArrayInputStream(xml));
        Deflater deflater = new Deflater(9);
        byte[] deflated = new byte[xml.length + 100];
        deflater.setInput(xml);
        deflater.finish();
        int length = deflater.deflate(deflated);
        byte[] code = new byte[length];
        for (int i = 0; i < length; ++i) {
            code[i] = deflated[i];
        }
        deflater.end();
        BarCode2D bc = new BarCode2D();
        bc.setSize(1000, 1000);
        bc.PDFMode = 0;
        bc.barType = 30;
        bc.PDFECLevel = 4;
        bc.L = TaxStatement.BARCODE_SEGMENT_WIDTH;
        bc.barHeightCM = TaxStatement.BARCODE_SEGMENT_WIDTH;
        bc.PDFMaxRows = 35;
        bc.PDFColumns = 13;
        bc.PDFRows = 35;
        bc.PDFCompact = false;
        bc.leftMarginCM = 0.0;
        bc.topMarginCM = 0.0;
        bc.guardBars = true;
        bc.rotate = 0;
        bc.codeBinary = code;
        bc.PDFMacroFileName = TaxStatement.getAttributeXPath(doc, "/taxStatement/@id");
        bc.PDFMacroFileId = new int[]{Double.valueOf(Math.random() * 255.0).intValue(), Double.valueOf(Math.random() * 255.0).intValue(), Double.valueOf(Math.random() * 255.0).intValue(), Double.valueOf(Math.random() * 255.0).intValue()};
        bc.resetMacroPDF();
        bc.prepareMacroPDF();
        BufferedImage[] bi = null;
        if (bc.PDFMacroSegmentCount > 0) {
            bi = new BufferedImage[bc.PDFMacroSegmentCount];
            for (int i = 0; i < bc.PDFMacroSegmentCount; ++i) {
                bc.PDFMacroSegment = 1 == bc.PDFMacroSegmentCount ? -1 : i;
                BufferedImage img = new BufferedImage(bc.getWidth(), bc.getHeight(), 12);
                bc.paint((Graphics)img.createGraphics());
                bi[i] = img.getSubimage(0, 0, (int)bc.getPaintedArea().getWidth(), (int)bc.getPaintedArea().getHeight());
            }
        }
        return bi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String extractId(BufferedImage image) {
        String id = null;
        if (image != null) {
            String bcValue;
            System.setProperty("com.java4less.vision.minarea", "60");
            System.setProperty("com.java4less.vision.maxarea", "40000");
            BarcodeData[] bcData = null;
            PrintStream stdout = System.out;
            try {
                System.setOut(new PrintStream(new OutputStream(){

                    @Override
                    public void write(int b) {
                    }
                }));
                RImage bcImage = new RImage(image);
                Barcode1DReader bcReader = new Barcode1DReader();
                bcReader.setSymbologies(Barcode1DReader.CODE39 | Barcode1DReader.CODE128);
                bcData = bcReader.scan(bcImage);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                System.setOut(stdout);
            }
            if (bcData != null && bcData.length > 0) {
                for (BarcodeData data : bcData) {
                    bcValue = data.getValue();
                    if (System.getProperty("debug", "false").equals("true")) {
                        System.out.println("bcValue: " + bcValue);
                    }
                    if (bcValue != null && bcValue.startsWith("~d202")) {
                        bcValue = bcValue.substring(5);
                    }
                    if (bcValue == null || !bcValue.startsWith("196") && !bcValue.startsWith("197") || bcValue.length() != 13 && bcValue.length() != 16) continue;
                    id = bcValue;
                }
            }
            if (bcData != null && bcData.length > 0 && id == null) {
                for (BarcodeData data : bcData) {
                    bcValue = data.getValue();
                    if (System.getProperty("debug", "false").equals("true")) {
                        System.out.println("bcValue: " + bcValue);
                    }
                    if (bcValue != null && bcValue.startsWith("~d202")) {
                        bcValue = bcValue.substring(5);
                    }
                    if (bcValue == null || !bcValue.startsWith("196") && !bcValue.startsWith("197")) continue;
                    id = bcValue;
                }
            }
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[][] read(BufferedImage image) {
        Object bytes = null;
        if (image != null) {
            if (System.getProperty("com.java4less.vision.minarea") == null || System.getProperty("com.java4less.vision.minarea") != null && Integer.parseInt(System.getProperty("com.java4less.vision.minarea")) < BARCODE_READER_MINAREA) {
                System.getProperties().setProperty("com.java4less.vision.minarea", String.valueOf(BARCODE_READER_MINAREA));
            }
            if (System.getProperty("com.java4less.vision.maxarea") == null || System.getProperty("com.java4less.vision.maxarea") != null && Integer.parseInt(System.getProperty("com.java4less.vision.maxarea")) < BARCODE_READER_MAXAREA) {
                System.getProperties().setProperty("com.java4less.vision.maxarea", String.valueOf(BARCODE_READER_MAXAREA));
            }
            PDF417Data[] bcData = null;
            PrintStream stdout = System.out;
            try {
                System.setOut(new PrintStream(new OutputStream(){

                    @Override
                    public void write(int b) {
                    }
                }));
                PDF417Reader reader = new PDF417Reader();
                bcData = reader.read(new RImage(image));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                System.setOut(stdout);
            }
            if (System.getProperty("print", "false").equals("true")) {
                TaxStatementJ4L.displayBarCodeSegment(bcData);
            }
            if (bcData != null && bcData.length > 0) {
                for (PDF417Data data : bcData) {
                    if (data.getMacroPDFField(PDF417Data.MACROPDF_SEGMENT) == null || data.getMacroPDFField(PDF417Data.MACROPDF_SEGMENT_COUNT) == null) continue;
                    int[] value = data.getValue();
                    int index = Integer.parseInt(data.getMacroPDFField(PDF417Data.MACROPDF_SEGMENT).toString());
                    int count = Integer.parseInt(data.getMacroPDFField(PDF417Data.MACROPDF_SEGMENT_COUNT).toString());
                    if (index < 0 || index >= count) continue;
                    if (bytes == null) {
                        bytes = new byte[count][];
                    }
                    bytes[index] = new byte[value.length];
                    for (int v = 0; v < value.length; ++v) {
                        bytes[index][v] = (byte)(value[v] & 0xFF);
                    }
                }
            }
        }
        return bytes;
    }

    public static byte[][] read(List<BufferedImage> images) {
        Object bytes = null;
        if (images != null && images.size() > 0) {
            for (BufferedImage image : images) {
                byte[][] data;
                if (image == null || (data = TaxStatementJ4L.read(image)) == null || data.length <= 0) continue;
                for (int i = 0; i < data.length; ++i) {
                    if (bytes == null) {
                        bytes = new byte[data.length][];
                    }
                    if (data[i] == null || data[i].length <= 0) continue;
                    bytes[i] = data[i];
                }
            }
        }
        return bytes;
    }
}

