/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement;

import ch.ewv.taxstatement.PageProgressListenerInterface;
import ch.ewv.taxstatement.TaxStatementJ4L;
import ch.ewv.taxstatement.TaxStatementOKAPI;
import ch.ewv.taxstatement.TaxStatementSignature;
import ch.ewv.taxstatement.TaxStatementZXing;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.Inflater;
import javax.imageio.ImageIO;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.pdfbox.contentstream.PDContentStream;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.pdfparser.PDFStreamParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.LosslessFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDInlineImage;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.pdfbox.util.Matrix;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TaxStatement {
    public static String VERSION_10 = "1.0";
    public static String VERSION_20 = "2.0";
    public static String VERSION_21 = "2.1";
    public static String VERSION_22 = "2.2";
    public static String[] SCHEMAS_10 = new String[]{"eCH-0007-6-0.xsd", "eCH-0008-3-0.xsd", "eCH-0010-6-0.xsd", "eCH-0097-2-0.xsd", "eCH-0196-1-0.xsd"};
    public static String[] SCHEMAS_20 = new String[]{"eCH-0007-6-0.xsd", "eCH-0008-3-0.xsd", "eCH-0010-7-0.xsd", "eCH-0097-4-0.xsd", "eCH-0196-2-0.xsd"};
    public static String[] SCHEMAS_21 = new String[]{"eCH-0007-6-0.xsd", "eCH-0008-3-0.xsd", "eCH-0010-7-0.xsd", "eCH-0097-4-0.xsd", "eCH-0196-2-0.xsd"};
    public static String[] SCHEMAS_22 = new String[]{"eCH-0007-6-0.xsd", "eCH-0008-3-0.xsd", "eCH-0010-7-0.xsd", "eCH-0097-4-0.xsd", "eCH-0196-2-2.xsd"};
    public static int BARCODE_SEGMENTS_PER_PAGE = 6;
    public static double BARCODE_SEGMENT_WIDTH = 0.042;
    public static double BARCODE_SEGMENT_HEIGHT = 0.08;
    private static int BARCODE_SEGMENT_WIDTH_PX = 290;
    private static int BARCODE_SEGMENT_WIDTH_PX_FORCE = 2320;
    private static int BARCODE_SEGMENT_HEIGHT_PX = 35;
    private static int BARCODE_SEGMENT_HEIGHT_PX_FORCE = 560;
    private static int RENDER_WITH_DPI = 300;
    private static int RENDER_WITH_DPI_WIDTH = 3504;
    private static int RENDER_WITH_DPI_HEIGHT = 2480;
    private static int BARCODE_AREA_DPI_XA = 124;
    private static int BARCODE_AREA_DPI_XB = 3380;
    private static int BARCODE_AREA_DPI_YA = 475;
    private static int BARCODE_AREA_DPI_YB = 2385;
    private static int BARCODE_AREA_DPI_LEFT = 360;
    private static int BARCODE_AREA_DPI_RIGHT = 360;
    private static int BARCODE_AREA_DPI_TOP = 360;
    private static int BARCODE_AREA_DPI_BOTTOM = 360;

    public static String getAttributeXPath(Document doc, String expression) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        String value = (String)xpath.compile(expression).evaluate(doc, XPathConstants.STRING);
        if (value != null && value.indexOf("&#") >= 0) {
            for (int i = 128; i < 256; ++i) {
                value = value.replace("&#" + i + ";", Character.toString((char)i));
            }
        }
        if (value != null && value.indexOf("&amp;") >= 0) {
            value = value.replace("&amp;", "&");
        }
        return value != null && value.length() > 0 ? value : null;
    }

    public static String getAttributeXPath(Document doc, String expression, Boolean empty) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        String value = (String)xpath.compile(expression).evaluate(doc, XPathConstants.STRING);
        if (value != null && value.indexOf("&#") >= 0) {
            for (int i = 128; i < 256; ++i) {
                value = value.replace("&#" + i + ";", Character.toString((char)i));
            }
        }
        if (value != null && value.indexOf("&amp;") >= 0) {
            value = value.replace("&amp;", "&");
        }
        return value != null && (value.length() > 0 || empty != false) ? value : null;
    }

    public static Boolean getAttributeXPathBoolean(Document doc, String expression) throws ParseException, XPathExpressionException {
        String value = TaxStatement.getAttributeXPath(doc, expression);
        Boolean b = null;
        if (value != null) {
            if (value.toLowerCase().equals("true") || value.equals("1")) {
                b = Boolean.TRUE;
            } else if (value.toLowerCase().equals("false") || value.equals("0")) {
                b = Boolean.FALSE;
            }
        }
        return b;
    }

    public static Date getAttributeXPathDate(Document doc, String expression) throws ParseException, XPathExpressionException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String value = TaxStatement.getAttributeXPath(doc, expression);
        return value != null && value.length() > 0 ? sdf.parse(value) : null;
    }

    public static Date getAttributeXPathDateTime(Document doc, String expression) throws ParseException, XPathExpressionException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        String value = TaxStatement.getAttributeXPath(doc, expression);
        return value != null && value.length() > 0 ? sdf.parse(value) : null;
    }

    public static Double getAttributeNumber(Document doc, String expression) throws XPathExpressionException {
        String value = TaxStatement.getAttributeXPath(doc, expression);
        return value != null && value.length() > 0 ? Double.valueOf(value) : null;
    }

    public static int getElementCount(Document doc, String expression) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        return ((Double)xpath.compile(expression).evaluate(doc, XPathConstants.NUMBER)).intValue();
    }

    public static String getElementXML(Document doc, String expression) throws XPathExpressionException {
        return TaxStatement.getElementXML(doc, expression, true);
    }

    public static String getElementXML(Document doc, String expression, Boolean children) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        Node node = (Node)xpath.compile(expression).evaluate(doc, XPathConstants.NODE);
        String value = "";
        try {
            DOMImplementationRegistry reg = DOMImplementationRegistry.newInstance();
            DOMImplementationLS ls = (DOMImplementationLS)((Object)reg.getDOMImplementation("LS"));
            LSSerializer lss = ls.createLSSerializer();
            lss.getDomConfig().setParameter("well-formed", true);
            lss.getDomConfig().setParameter("format-pretty-print", false);
            lss.getDomConfig().setParameter("xml-declaration", false);
            value = lss.writeToString(node);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (value != null && value.length() > 0 && !children.booleanValue()) {
            value = value.substring(0, value.indexOf(">") + 1);
        }
        if (value != null && value.indexOf("<taxStatement ") >= 0 && value.indexOf("xmlns=\"") < 0 && value.indexOf("xsi:schemaLocation=\"") > 0 && value.indexOf("http://www.ech.ch/xmlns/eCH-0196/") > 0) {
            value = value.replace("<taxStatement ", "<taxStatement xmlns=\"" + value.substring(value.indexOf("http://www.ech.ch/xmlns/eCH-0196/"), value.indexOf("http://www.ech.ch/xmlns/eCH-0196/") + 34) + "\" ");
        }
        return value != null && value.length() > 0 ? value : null;
    }

    public static String getElementXPath(Document doc, String expression) throws XPathExpressionException {
        return TaxStatement.getElementXPath(doc, expression, false);
    }

    public static String getElementXPath(Document doc, String expression, Boolean empty) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        Node node = (Node)xpath.compile(expression).evaluate(doc, XPathConstants.NODE);
        String value = "";
        if (node != null && node.getTextContent() != null) {
            value = node.getTextContent();
        }
        if (value != null && value.indexOf("&#") >= 0) {
            for (int i = 128; i < 256; ++i) {
                value = value.replace("&#" + i + ";", Character.toString((char)i));
            }
        }
        if (value != null && value.indexOf("&amp;") >= 0) {
            value = value.replace("&amp;", "&");
        }
        return value != null && (value.length() > 0 || empty != false) ? value : null;
    }

    protected static void write(byte[] bytes) {
        try {
            if (bytes != null) {
                File file = new File(System.nanoTime() + ".bin");
                FileOutputStream fos = new FileOutputStream(file);
                fos.write(bytes);
                fos.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void write(BufferedImage image) {
        try {
            if (image != null) {
                File file = new File(System.nanoTime() + "-" + image.getWidth() + "x" + image.getHeight() + ".png");
                ImageIO.write((RenderedImage)image, "png", file);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void write(BufferedImage[] images) {
        if (images != null && images.length > 0) {
            for (int i = 0; i < images.length; ++i) {
                TaxStatement.write(images[i]);
            }
        }
    }

    public static void write(List<BufferedImage> images) {
        if (images != null && images.size() > 0) {
            for (BufferedImage image : images) {
                TaxStatement.write(image);
            }
        }
    }

    public static String getVersion(Document doc) throws XPathExpressionException {
        String value = TaxStatement.getElementXML(doc, "taxStatement", false);
        String version = "";
        if (value != null && value.length() > 0) {
            if (value.indexOf("minorVersion=") > 0) {
                version = value.substring(value.indexOf("minorVersion=") + 14, value.indexOf("minorVersion=") + 15) + "." + value.substring(value.indexOf("minorVersion=") + 15, value.indexOf("minorVersion=") + 16);
                if (version.charAt(0) < '0' || version.charAt(0) > '9' || version.charAt(2) < '0' || version.charAt(2) > '9') {
                    version = "";
                } else if (version.compareTo("2.1") < 0) {
                    version = "";
                }
            }
            if (version == null || version.length() == 0) {
                if (value.indexOf("eCH-0196-1-0") > 0) {
                    version = VERSION_10;
                }
                if (value.indexOf("eCH-0196-2-0") > 0) {
                    version = VERSION_20;
                }
                if (value.indexOf("eCH-0196-2-1") > 0) {
                    version = VERSION_21;
                }
                if (value.indexOf("eCH-0196-2-2") > 0) {
                    version = VERSION_22;
                }
            }
            if (version == null || version.length() == 0) {
                if (value.indexOf("eCH-0196/1") > 0) {
                    version = VERSION_10;
                }
                if (value.indexOf("eCH-0196/2") > 0) {
                    version = VERSION_20;
                }
            }
        }
        return version;
    }

    public static String getVersion(byte[] xml) {
        String value = xml != null && xml.length > 0 ? new String(xml) : null;
        String version = "";
        if (value != null && value.length() > 0) {
            if (value.indexOf("minorVersion=") > 0) {
                version = value.substring(value.indexOf("minorVersion=") + 14, value.indexOf("minorVersion=") + 15) + "." + value.substring(value.indexOf("minorVersion=") + 15, value.indexOf("minorVersion=") + 16);
                if (version.charAt(0) < '0' || version.charAt(0) > '9' || version.charAt(2) < '0' || version.charAt(2) > '9') {
                    version = "";
                } else if (version.compareTo("2.1") < 0) {
                    version = "";
                }
            }
            if (version == null || version.length() == 0) {
                if (value.indexOf("eCH-0196-1-0") > 0) {
                    version = VERSION_10;
                }
                if (value.indexOf("eCH-0196-2-0") > 0) {
                    version = VERSION_20;
                }
                if (value.indexOf("eCH-0196-2-1") > 0) {
                    version = VERSION_21;
                }
                if (value.indexOf("eCH-0196-2-2") > 0) {
                    version = VERSION_22;
                }
            }
            if (version == null || version.length() == 0) {
                if (value.indexOf("eCH-0196/1") > 0) {
                    version = VERSION_10;
                }
                if (value.indexOf("eCH-0196/2") > 0) {
                    version = VERSION_20;
                }
            }
        }
        return version;
    }

    public static byte[][] read(BufferedImage image) {
        return System.getProperty("j4l", "false").equals("true") ? TaxStatementJ4L.read(image) : TaxStatementZXing.read(image);
    }

    public static byte[][] read(List<BufferedImage> images) {
        return System.getProperty("j4l", "false").equals("true") ? TaxStatementJ4L.read(images) : TaxStatementZXing.read(images);
    }

    public static BufferedImage cut(BufferedImage image, int rgb) {
        BufferedImage cutted = TaxStatement.cutBottom(TaxStatement.cutLeft(TaxStatement.cutRight(TaxStatement.cutTop(image, rgb), rgb), rgb), rgb);
        if (System.getProperty("debug", "false").equals("true")) {
            TaxStatement.write(cutted);
        }
        return cutted;
    }

    public static BufferedImage cutBottom(BufferedImage image, int rgb) {
        BufferedImage cutted = null;
        if (image != null && image.getWidth() > 0 && image.getHeight() > 0) {
            boolean color = true;
            int px = 0;
            for (int y = image.getHeight() - px - 1; y >= 0 && color; --y) {
                for (int x = 0; x < image.getWidth() && color; ++x) {
                    color = image.getRGB(x, y) == rgb;
                }
                if (!color) continue;
                ++px;
            }
            cutted = px > 0 && px < image.getHeight() ? image.getSubimage(0, 0, image.getWidth(), image.getHeight() - px) : image;
        }
        return cutted;
    }

    public static BufferedImage cutLeft(BufferedImage image, int rgb) {
        BufferedImage cutted = null;
        if (image != null && image.getWidth() > 0 && image.getHeight() > 0) {
            int px;
            boolean color = true;
            for (int x = px = 0; x < image.getWidth() && color; ++x) {
                for (int y = 0; y < image.getHeight() && color; ++y) {
                    color = image.getRGB(x, y) == rgb;
                }
                if (!color) continue;
                ++px;
            }
            cutted = px > 0 && px < image.getWidth() ? image.getSubimage(px, 0, image.getWidth() - px, image.getHeight()) : image;
        }
        return cutted;
    }

    public static BufferedImage cutRight(BufferedImage image, int rgb) {
        BufferedImage cutted = null;
        if (image != null && image.getWidth() > 0 && image.getHeight() > 0) {
            boolean color = true;
            int px = 0;
            for (int x = image.getWidth() - px - 1; x >= 0 && color; --x) {
                for (int y = 0; y < image.getHeight() && color; ++y) {
                    color = image.getRGB(x, y) == rgb;
                }
                if (!color) continue;
                ++px;
            }
            cutted = px > 0 && px < image.getWidth() ? image.getSubimage(0, 0, image.getWidth() - px, image.getHeight()) : image;
        }
        return cutted;
    }

    public static BufferedImage cutTop(BufferedImage image, int rgb) {
        BufferedImage cutted = null;
        if (image != null && image.getWidth() > 0 && image.getHeight() > 0) {
            int px;
            boolean color = true;
            for (int y = px = 0; y < image.getHeight() && color; ++y) {
                for (int x = 0; x < image.getWidth() && color; ++x) {
                    color = image.getRGB(x, y) == rgb;
                }
                if (!color) continue;
                ++px;
            }
            cutted = px > 0 && px < image.getHeight() ? image.getSubimage(0, px, image.getWidth(), image.getHeight() - px) : image;
        }
        return cutted;
    }

    public static BufferedImage enlarge(BufferedImage image, int multiplyWidth, int multiplyHeight) {
        BufferedImage enlarged = null;
        if (image != null && multiplyWidth > 1 && multiplyHeight > 1 && image.getWidth() > 0 && image.getHeight() > 0) {
            enlarged = new BufferedImage(image.getWidth() * multiplyWidth, image.getHeight() * multiplyHeight, image.getType() != 0 ? image.getType() : 12);
            int x = 0;
            int xm = 0;
            while (x < image.getWidth()) {
                int y = 0;
                int ym = 0;
                while (y < image.getHeight()) {
                    for (int xx = 0; xx < multiplyWidth; ++xx) {
                        for (int yy = 0; yy < multiplyHeight; ++yy) {
                            enlarged.setRGB(xm + xx, ym + yy, image.getRGB(x, y));
                        }
                    }
                    ++y;
                    ym += multiplyHeight;
                }
                ++x;
                xm += multiplyWidth;
            }
        }
        if (System.getProperty("debug", "false").equals("true")) {
            TaxStatement.write(enlarged);
        }
        return enlarged;
    }

    public static BufferedImage shrink(BufferedImage image, int divideWidth, int divideHeight) {
        BufferedImage shrinked = null;
        if (image != null && divideWidth > 1 && divideHeight > 1 && image.getWidth() > 0 && image.getHeight() > 0 && image.getWidth() % divideWidth == 0 && image.getHeight() % divideHeight == 0) {
            shrinked = new BufferedImage(image.getWidth() / divideWidth, image.getHeight() / divideHeight, image.getType() != 0 ? image.getType() : 12);
            int x = 0;
            int xd = 0;
            while (x < image.getWidth()) {
                int y = 0;
                int yd = 0;
                while (y < image.getHeight()) {
                    shrinked.setRGB(xd, yd, image.getRGB(x, y));
                    y += divideHeight;
                    ++yd;
                }
                x += divideWidth;
                ++xd;
            }
        }
        if (System.getProperty("debug", "false").equals("true")) {
            TaxStatement.write(shrinked);
        }
        return shrinked;
    }

    public static BufferedImage shrink(BufferedImage image, int divideWidth, int divideHeight, int multiplyWidth, int multiplyHeight) {
        BufferedImage shrinked = null;
        if (image != null && divideWidth > 1 && divideHeight > 1 && multiplyWidth > 1 && multiplyHeight > 1 && image.getWidth() > 0 && image.getHeight() > 0 && image.getWidth() % divideWidth == 0 && image.getHeight() % divideHeight == 0) {
            shrinked = new BufferedImage(image.getWidth() * multiplyWidth / divideWidth, image.getHeight() * multiplyHeight / divideHeight, image.getType() != 0 ? image.getType() : 12);
            int x = 0;
            int xm = 0;
            while (x < image.getWidth()) {
                int y = 0;
                int ym = 0;
                while (y < image.getHeight()) {
                    for (int xx = 0; xx < multiplyWidth; ++xx) {
                        for (int yy = 0; yy < multiplyHeight; ++yy) {
                            shrinked.setRGB(xm + xx, ym + yy, image.getRGB(x, y));
                        }
                    }
                    y += divideHeight;
                    ym += multiplyHeight;
                }
                x += divideWidth;
                xm += multiplyWidth;
            }
        }
        if (System.getProperty("debug", "false").equals("true")) {
            TaxStatement.write(shrinked);
        }
        return shrinked;
    }

    public static BufferedImage mirror(BufferedImage image) {
        BufferedImage mirrored = null;
        if (image != null) {
            mirrored = new BufferedImage(image.getWidth(), image.getHeight(), image.getType() != 0 ? image.getType() : 12);
            int y = 0;
            int ym = mirrored.getHeight() - 1;
            while (y < mirrored.getHeight()) {
                for (int x = 0; x < mirrored.getWidth(); ++x) {
                    mirrored.setRGB(x, ym, image.getRGB(x, y));
                }
                ++y;
                --ym;
            }
        }
        if (System.getProperty("debug", "false").equals("true")) {
            TaxStatement.write(mirrored);
        }
        return mirrored;
    }

    public static BufferedImage rotate(BufferedImage image) {
        return TaxStatement.rotate(image, false);
    }

    public static BufferedImage rotate(BufferedImage image, boolean clockwise) {
        BufferedImage rotated = null;
        if (image != null) {
            rotated = new BufferedImage(image.getHeight(), image.getWidth(), image.getType() != 0 ? image.getType() : 12);
            for (int x = 0; x < rotated.getWidth(); ++x) {
                for (int y = 0; y < rotated.getHeight(); ++y) {
                    if (clockwise) {
                        rotated.setRGB(x, y, image.getRGB(y, rotated.getWidth() - 1 - x));
                        continue;
                    }
                    rotated.setRGB(x, y, image.getRGB(rotated.getHeight() - 1 - y, x));
                }
            }
        }
        if (System.getProperty("debug", "false").equals("true")) {
            TaxStatement.write(rotated);
        }
        return rotated;
    }

    public static BufferedImage[] rotate(BufferedImage[] images) {
        return TaxStatement.rotate(images, false);
    }

    public static BufferedImage[] rotate(BufferedImage[] images, boolean clockwise) {
        BufferedImage[] rotated = null;
        if (images != null && images.length > 0) {
            rotated = new BufferedImage[images.length];
            for (int i = 0; i < images.length; ++i) {
                rotated[i] = TaxStatement.rotate(images[i], clockwise);
            }
        }
        return rotated;
    }

    public static List<BufferedImage> rotate(List<BufferedImage> images) {
        return TaxStatement.rotate(images, false);
    }

    public static List<BufferedImage> rotate(List<BufferedImage> images, boolean clockwise) {
        ArrayList<BufferedImage> rotated = null;
        if (images != null && images.size() > 0) {
            rotated = new ArrayList<BufferedImage>();
            for (BufferedImage image : images) {
                rotated.add(TaxStatement.rotate(image, clockwise));
            }
        }
        return rotated;
    }

    public static BufferedImage scale(BufferedImage image, int width, int height) {
        BufferedImage scaled = null;
        if (image != null && width > 0 && height > 0 && image.getWidth() > 0 && image.getHeight() > 0) {
            scaled = new BufferedImage(width, height, image.getType() != 0 ? image.getType() : 12);
            Graphics2D g2d = scaled.createGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            g2d.setColor(Color.WHITE);
            g2d.fillRect(0, 0, scaled.getWidth(), scaled.getHeight());
            g2d.drawImage(image, 0, 0, scaled.getWidth(), scaled.getHeight(), null);
            g2d.dispose();
        }
        if (System.getProperty("debug", "false").equals("true")) {
            TaxStatement.write(scaled);
        }
        return scaled;
    }

    public static BufferedImage pageBarCode(String id) {
        return TaxStatement.pageBarCode(id, System.getProperty("pageBarCodeText", "true").equals("true"));
    }

    public static BufferedImage pageBarCode(String id, Boolean text) {
        return System.getProperty("j4l", "false").equals("true") ? TaxStatementJ4L.barCode1D(id, text) : TaxStatementOKAPI.barCode1D(id, text);
    }

    public static BufferedImage[] barCodeXML(byte[] xml) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return System.getProperty("j4l", "false").equals("true") ? TaxStatementJ4L.barCode2D(xml) : TaxStatementOKAPI.barCode2D(xml);
    }

    public static BufferedImage[] barCodeXML(byte[] xml, int width, int height) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        BufferedImage[] bi = TaxStatement.barCodeXML(xml);
        if (bi != null && bi.length > 0) {
            for (int i = 0; i < bi.length; ++i) {
                if (bi[i] == null) continue;
                if (System.getProperty("debug", "false").equals("true")) {
                    TaxStatement.write(bi[i]);
                }
                bi[i] = TaxStatement.scale(bi[i], width, height);
            }
        }
        if (System.getProperty("debug", "false").equals("true") && bi != null && bi.length > 0) {
            ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
            for (int i = 0; i < bi.length; ++i) {
                images.add(bi[i]);
            }
            byte[][] bytes = null;
            byte[] compressed = null;
            byte[] inflated = null;
            try {
                bytes = TaxStatement.read(images);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (bytes != null) {
                for (int i = 0; i < bytes.length; ++i) {
                    if (bytes[i] == null) continue;
                    compressed = compressed != null ? ByteBuffer.allocate(compressed.length + bytes[i].length).put(compressed).put(bytes[i]).array() : bytes[i];
                }
            }
            if (compressed != null && inflated == null) {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(compressed.length);
                    byte[] buf = new byte[4096];
                    Inflater inflater = new Inflater();
                    inflater.setInput(compressed);
                    while (!inflater.finished()) {
                        int len = inflater.inflate(buf);
                        baos.write(buf, 0, len);
                    }
                    baos.close();
                    inflated = baos.toByteArray();
                }
                catch (Exception e) {
                    inflated = null;
                }
            }
            System.out.print(new String(inflated));
        }
        return bi;
    }

    public static void addPageBarCode(PDDocument pdd, PDPage pdp, BufferedImage image) throws IOException {
        float x = 29.0f;
        float y = 14.0f;
        double scaling = 0.8041236818451243;
        TaxStatement.addPageBarCode(pdd, pdp, image, x, y, scaling);
    }

    public static void addPageBarCode(PDDocument pdd, PDPage pdp, BufferedImage image, float x, float y, double scaling) throws IOException {
        PDPageContentStream cs = new PDPageContentStream(pdd, pdp, PDPageContentStream.AppendMode.APPEND, true);
        PDImageXObject imx = LosslessFactory.createFromImage((PDDocument)pdd, (BufferedImage)image);
        if (pdp.getMediaBox().getWidth() > pdp.getMediaBox().getHeight()) {
            Matrix mx = new Matrix(0.0f, 1.0f, -1.0f, 0.0f, pdp.getMediaBox().getWidth(), 0.0f);
            cs.transform(mx);
            cs.transform(mx);
            cs.transform(mx);
            cs.drawImage(imx, x + (float)(imx.getWidth() * 2), y, imx.getWidth() > imx.getHeight() ? (float)imx.getWidth() : (float)((double)imx.getWidth() * scaling), imx.getWidth() > imx.getHeight() ? (float)((double)imx.getHeight() * scaling) : (float)imx.getHeight());
            cs.transform(mx);
        } else {
            cs.drawImage(imx, x, y, imx.getWidth() > imx.getHeight() ? (float)imx.getWidth() : (float)((double)imx.getWidth() * scaling), imx.getWidth() > imx.getHeight() ? (float)((double)imx.getHeight() * scaling) : (float)imx.getHeight());
        }
        cs.close();
    }

    public static void addBarCode(PDDocument pdd, PDPage pdp, BufferedImage[] images, int page) throws IOException {
        float x = 185.0f;
        double distanceCM = 1.0;
        double scaling = 0.97;
        TaxStatement.addBarCode(pdd, pdp, images, page, x, distanceCM, scaling);
    }

    public static void addBarCode(PDDocument pdd, PDPage pdp, BufferedImage[] images, int page, float x, double distanceCM, double scaling) throws IOException {
        float y = 0.0f;
        float w = 0.0f;
        float h = 0.0f;
        if (pdd != null && pdp != null && images != null) {
            for (int i = 0; i < images.length; ++i) {
                if (i < (page - 1) * BARCODE_SEGMENTS_PER_PAGE || i >= page * BARCODE_SEGMENTS_PER_PAGE) continue;
                PDPageContentStream cs = new PDPageContentStream(pdd, pdp, PDPageContentStream.AppendMode.APPEND, true);
                PDImageXObject imx = LosslessFactory.createFromImage((PDDocument)pdd, (BufferedImage)images[i]);
                y = i % BARCODE_SEGMENTS_PER_PAGE < BARCODE_SEGMENTS_PER_PAGE / 2 ? (images[i].getWidth() > BARCODE_SEGMENT_WIDTH_PX || images[i].getHeight() > BARCODE_SEGMENT_HEIGHT_PX ? (float)((double)(pdp.getBBox().getHeight() / 2.0f) + (double)pdp.getBBox().getHeight() * ((double)(BARCODE_SEGMENTS_PER_PAGE / 2 - i % BARCODE_SEGMENTS_PER_PAGE) * (BARCODE_SEGMENT_HEIGHT * (double)BARCODE_SEGMENT_HEIGHT_PX + distanceCM) - BARCODE_SEGMENT_HEIGHT * (double)BARCODE_SEGMENT_HEIGHT_PX) / 29.7 / scaling) : (float)((double)(pdp.getBBox().getHeight() / 2.0f) + (double)pdp.getBBox().getHeight() * ((double)(BARCODE_SEGMENTS_PER_PAGE / 2 - i % BARCODE_SEGMENTS_PER_PAGE) * (BARCODE_SEGMENT_HEIGHT * (double)images[0].getHeight() + distanceCM) - BARCODE_SEGMENT_HEIGHT * (double)images[i].getHeight()) / 29.7 / scaling)) : (images[i].getWidth() > BARCODE_SEGMENT_WIDTH_PX || images[i].getHeight() > BARCODE_SEGMENT_HEIGHT_PX ? (float)((double)(pdp.getBBox().getHeight() / 2.0f) - (double)pdp.getBBox().getHeight() * ((double)(i % BARCODE_SEGMENTS_PER_PAGE - BARCODE_SEGMENTS_PER_PAGE / 2) * (BARCODE_SEGMENT_HEIGHT * (double)BARCODE_SEGMENT_HEIGHT_PX + distanceCM) + BARCODE_SEGMENT_HEIGHT * (double)BARCODE_SEGMENT_HEIGHT_PX + distanceCM) / 29.7 / scaling) : (float)((double)(pdp.getBBox().getHeight() / 2.0f) - (double)pdp.getBBox().getHeight() * ((double)(i % BARCODE_SEGMENTS_PER_PAGE - BARCODE_SEGMENTS_PER_PAGE / 2) * (BARCODE_SEGMENT_HEIGHT * (double)images[0].getHeight() + distanceCM) + BARCODE_SEGMENT_HEIGHT * (double)images[i].getHeight() + distanceCM) / 29.7 / scaling));
                if (images[i].getWidth() > BARCODE_SEGMENT_WIDTH_PX || images[i].getHeight() > BARCODE_SEGMENT_HEIGHT_PX) {
                    w = (float)((double)BARCODE_SEGMENT_WIDTH_PX * BARCODE_SEGMENT_WIDTH / 21.0 * (double)pdp.getBBox().getWidth() / scaling);
                    h = (float)((double)BARCODE_SEGMENT_HEIGHT_PX * BARCODE_SEGMENT_HEIGHT / 29.7 * (double)pdp.getBBox().getHeight() / scaling);
                } else {
                    w = (float)((double)images[i].getWidth() * BARCODE_SEGMENT_WIDTH / 21.0 * (double)pdp.getBBox().getWidth() / scaling);
                    h = (float)((double)images[i].getHeight() * BARCODE_SEGMENT_HEIGHT / 29.7 * (double)pdp.getBBox().getHeight() / scaling);
                }
                cs.drawImage(imx, x, y, w, h);
                cs.close();
            }
        }
    }

    public static boolean contains1DBarcodeForECH0196(PDDocument pdd) {
        return TaxStatement.contains1DBarcodeForECH0196(pdd, System.getProperty("renderWithDPI") != null ? Integer.parseInt(System.getProperty("renderWithDPI")) : RENDER_WITH_DPI);
    }

    public static boolean contains1DBarcodeForECH0196(PDDocument pdd, int renderWithDPI) {
        Boolean contains = false;
        if (pdd != null) {
            PDPageTree tree = pdd.getPages();
            for (int p = 0; p < tree.getCount() && !contains.booleanValue(); ++p) {
                String id;
                if (System.getProperty("debug", "false").equals("true")) {
                    System.out.println("page: " + p);
                }
                if ((id = TaxStatement.extractId(pdd, p, renderWithDPI)) == null || id.length() != 13 && id.length() != 16 || !id.startsWith("196") && !id.startsWith("197")) continue;
                contains = true;
            }
        }
        return contains;
    }

    public static boolean contains2DBarcode(PDDocument pdd) throws IOException {
        Boolean contains;
        block1: {
            PDPage pdp;
            contains = false;
            if (pdd == null) break block1;
            Iterator iterator = pdd.getPages().iterator();
            while (iterator.hasNext() && !(contains = Boolean.valueOf(TaxStatement.contains2DBarcode(pdp = (PDPage)iterator.next()))).booleanValue()) {
            }
        }
        return contains;
    }

    public static boolean contains2DBarcode(PDPage pdp) throws IOException {
        PDResources resources;
        Boolean contains = false;
        if (pdp != null && (resources = pdp.getResources()) != null) {
            for (COSName cos : resources.getXObjectNames()) {
                PDXObject obj = resources.getXObject(cos);
                BufferedImage image = null;
                if (obj instanceof PDImageXObject) {
                    image = ((PDImageXObject)obj).getImage();
                }
                if (image == null || (image.getWidth() != BARCODE_SEGMENT_WIDTH_PX || image.getHeight() != BARCODE_SEGMENT_HEIGHT_PX) && (image.getWidth() != BARCODE_SEGMENT_HEIGHT_PX || image.getHeight() != BARCODE_SEGMENT_WIDTH_PX)) continue;
                contains = true;
                break;
            }
        }
        return contains;
    }

    public static boolean containsText(PDDocument pdd) {
        Boolean contains;
        block1: {
            PDPage pdp;
            contains = false;
            if (pdd == null) break block1;
            Iterator iterator = pdd.getPages().iterator();
            while (iterator.hasNext() && !(contains = Boolean.valueOf(TaxStatement.containsText(pdp = (PDPage)iterator.next()))).booleanValue()) {
            }
        }
        return contains;
    }

    public static boolean containsText(PDPage pdp) {
        Boolean contains;
        block0: {
            Iterator iterator;
            PDResources resources;
            contains = System.getProperty("scanned", "true").equals("true");
            if (pdp == null || (resources = pdp.getResources()) == null || !(iterator = resources.getFontNames().iterator()).hasNext()) break block0;
            COSName cos = (COSName)iterator.next();
            contains = true;
        }
        return contains;
    }

    public static String extractId(BufferedImage image) {
        return System.getProperty("j4l", "false").equals("true") ? TaxStatementJ4L.extractId(image) : TaxStatementZXing.extractId(image);
    }

    public static String extractId(PDDocument pdd, int p) {
        return TaxStatement.extractId(pdd, p, System.getProperty("renderWithDPI") != null ? Integer.parseInt(System.getProperty("renderWithDPI")) : RENDER_WITH_DPI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String extractId(PDDocument pdd, int p, int renderWithDPI) {
        String id = null;
        if (pdd != null && p >= 0) {
            for (int i = 0; i < 4 && id == null; ++i) {
                BufferedImage image = null;
                PrintStream stderr = System.err;
                try {
                    System.setErr(new PrintStream(new OutputStream(){

                        @Override
                        public void write(int b) {
                        }
                    }));
                    image = i == 0 ? TaxStatement.renderImageAreaWithDPILeft(pdd, p, renderWithDPI) : (i == 1 ? TaxStatement.renderImageAreaWithDPIRight(pdd, p, renderWithDPI) : (i == 2 ? TaxStatement.renderImageAreaWithDPITop(pdd, p, renderWithDPI) : TaxStatement.renderImageAreaWithDPIBottom(pdd, p, renderWithDPI)));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    System.setErr(stderr);
                }
                if (System.getProperty("debug", "false").equals("true")) {
                    TaxStatement.write(image);
                }
                id = TaxStatement.extractId(image);
            }
        }
        return id;
    }

    public static byte[] extractXML(PDDocument pdd) {
        return TaxStatement.extractXML(pdd, System.getProperty("render", "true").equals("true"), System.getProperty("resource", "true").equals("true"), System.getProperty("stream", "true").equals("true"), System.getProperty("cutout", "true").equals("true"));
    }

    public static byte[] extractXML(PDDocument pdd, PageProgressListenerInterface ppl) {
        return TaxStatement.extractXML(pdd, ppl, System.getProperty("render", "true").equals("true"), System.getProperty("resource", "true").equals("true"), System.getProperty("stream", "true").equals("true"), System.getProperty("cutout", "true").equals("true"));
    }

    public static byte[] extractXML(PDDocument pdd, PageProgressListenerInterface ppl, boolean render, boolean resource, boolean cutout) {
        return TaxStatement.extractXML(pdd, ppl, render, resource, System.getProperty("stream", "true").equals("true"), cutout);
    }

    public static byte[] extractXML(PDDocument pdd, boolean render, boolean resource, boolean stream, boolean cutout) {
        return TaxStatement.extractXML(pdd, null, render, resource, stream, cutout);
    }

    public static byte[] extractXML(PDDocument pdd, PageProgressListenerInterface ppl, boolean render, boolean resource, boolean stream, boolean cutout) {
        Object bytes = null;
        if (pdd != null) {
            PDPageTree tree = pdd.getPages();
            int segments = 0;
            for (int p = tree.getCount() - 1; p >= 0; --p) {
                if (System.getProperty("debug", "false").equals("true")) {
                    System.out.println("page: " + p);
                }
                if (bytes != null && ((byte[][])bytes).length <= segments) continue;
                byte[][] data = TaxStatement.extractXML(pdd, tree.get(p), p, render, resource, stream, cutout);
                if (data != null && data.length > 0) {
                    for (int i = 0; i < data.length; ++i) {
                        if (bytes == null) {
                            bytes = new byte[data.length][];
                        }
                        if (data[i] == null || data[i].length <= 0) continue;
                        bytes[i] = data[i];
                        ++segments;
                    }
                }
                if (ppl == null) continue;
                ppl.pagesProcessed(p, pdd.getNumberOfPages());
            }
        }
        return TaxStatement.extractXMLInflate(bytes);
    }

    protected static byte[][] extractXML(PDDocument pdd, PDPage pdp, int p, boolean render, boolean resource, boolean stream, boolean cutout) {
        byte[][] data = null;
        if (pdd != null && pdp != null && p >= 0) {
            try {
                if (resource && !pdd.isEncrypted()) {
                    data = TaxStatement.extractXMLResource(pdd, pdp, p, render, cutout);
                    if (stream && data == null) {
                        data = TaxStatement.extractXMLStream(pdd, pdp, p, render, cutout);
                    }
                } else if (stream) {
                    data = TaxStatement.extractXMLStream(pdd, pdp, p, render, cutout);
                }
            }
            catch (Exception e) {
                data = null;
            }
            if (render && data == null && (pdd.isEncrypted() || TaxStatement.containsText(pdp))) {
                try {
                    data = TaxStatement.extractXMLRender(pdd, pdp, p);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    data = null;
                }
            }
        }
        return data;
    }

    public static byte[][] extractXMLResource(PDDocument pdd, boolean render, boolean cutout) throws IOException {
        return TaxStatement.extractXMLResource(pdd, null, render, cutout);
    }

    public static byte[][] extractXMLResource(PDDocument pdd, PageProgressListenerInterface ppl, boolean render, boolean cutout) throws IOException {
        Object bytes = null;
        if (pdd != null) {
            PDPageTree tree = pdd.getPages();
            int segments = 0;
            for (int p = tree.getCount() - 1; p >= 0; --p) {
                if (System.getProperty("debug", "false").equals("true")) {
                    System.out.println("page: " + p);
                }
                if (bytes != null && ((byte[][])bytes).length <= segments) continue;
                byte[][] data = TaxStatement.extractXMLResource(pdd, tree.get(p), p, render, cutout);
                if (data != null && data.length > 0) {
                    for (int i = 0; i < data.length; ++i) {
                        if (bytes == null) {
                            bytes = new byte[data.length][];
                        }
                        if (data[i] == null || data[i].length <= 0) continue;
                        bytes[i] = data[i];
                        ++segments;
                    }
                }
                if (ppl == null) continue;
                ppl.pagesProcessed(p, pdd.getNumberOfPages());
            }
        }
        return bytes;
    }

    protected static byte[][] extractXMLResource(PDDocument pdd, PDPage pdp, int p, boolean render, boolean cutout) throws IOException {
        byte[][] data = null;
        if (pdd != null && pdp != null && p >= 0) {
            ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
            PDResources resources = pdp.getResources();
            for (COSName cos : resources.getXObjectNames()) {
                PDResources resForm;
                PDXObject obj = resources.getXObject(cos);
                BufferedImage image = null;
                if (obj instanceof PDImageXObject) {
                    image = ((PDImageXObject)obj).getImage();
                    if (System.getProperty("debug", "false").equals("true")) {
                        TaxStatement.write(image);
                    }
                    if (image != null && image.getHeight() > image.getWidth()) {
                        image = TaxStatement.rotate(image);
                    }
                } else if (obj instanceof PDFormXObject && (resForm = ((PDFormXObject)obj).getResources()) != null) {
                    for (COSName cosForm : resForm.getXObjectNames()) {
                        PDXObject objForm = resForm.getXObject(cosForm);
                        if (objForm instanceof PDImageXObject) {
                            image = ((PDImageXObject)objForm).getImage();
                            if (System.getProperty("debug", "false").equals("true")) {
                                TaxStatement.write(image);
                            }
                            if (image != null && image.getHeight() > image.getWidth()) {
                                image = TaxStatement.rotate(image);
                            }
                        }
                        if (image == null) continue;
                    }
                }
                if (cutout && image != null && image.getWidth() > BARCODE_SEGMENT_WIDTH_PX && image.getHeight() > BARCODE_SEGMENT_HEIGHT_PX && image.getWidth() % BARCODE_SEGMENT_WIDTH_PX > 0 && image.getHeight() % BARCODE_SEGMENT_HEIGHT_PX > 0) {
                    image = TaxStatement.cut(image, -1);
                }
                if (image != null && image.getWidth() > BARCODE_SEGMENT_WIDTH_PX && image.getHeight() > BARCODE_SEGMENT_HEIGHT_PX && image.getWidth() % BARCODE_SEGMENT_WIDTH_PX == 0 && image.getHeight() % BARCODE_SEGMENT_HEIGHT_PX == 0) {
                    image = TaxStatement.shrink(image, image.getWidth() / BARCODE_SEGMENT_WIDTH_PX, image.getHeight() / BARCODE_SEGMENT_HEIGHT_PX, 2, 2);
                }
                if (image != null && (image.getHeight() <= BARCODE_SEGMENT_HEIGHT_PX || image.getWidth() <= BARCODE_SEGMENT_WIDTH_PX)) {
                    image = image.getHeight() % BARCODE_SEGMENT_HEIGHT_PX == 0 && image.getWidth() % BARCODE_SEGMENT_WIDTH_PX == 0 ? TaxStatement.enlarge(image, 2, 2) : TaxStatement.enlarge(image, 4, 4);
                }
                if (render && image != null && image.getWidth() > BARCODE_SEGMENT_WIDTH_PX_FORCE && image.getHeight() > BARCODE_SEGMENT_HEIGHT_PX_FORCE) {
                    return null;
                }
                if (image == null) continue;
                images.add(image);
            }
            if (images != null && images.size() > 0) {
                data = TaxStatement.read(images);
            }
        }
        return data;
    }

    public static byte[][] extractXMLStream(PDDocument pdd, boolean render, boolean cutout) throws IOException {
        return TaxStatement.extractXMLStream(pdd, null, render, cutout);
    }

    public static byte[][] extractXMLStream(PDDocument pdd, PageProgressListenerInterface ppl, boolean render, boolean cutout) throws IOException {
        Object bytes = null;
        if (pdd != null) {
            PDPageTree tree = pdd.getPages();
            int segments = 0;
            for (int p = tree.getCount() - 1; p >= 0; --p) {
                if (System.getProperty("debug", "false").equals("true")) {
                    System.out.println("page: " + p);
                }
                if (bytes != null && ((byte[][])bytes).length <= segments) continue;
                byte[][] data = TaxStatement.extractXMLStream(pdd, tree.get(p), p, render, cutout);
                if (data != null && data.length > 0) {
                    for (int i = 0; i < data.length; ++i) {
                        if (bytes == null) {
                            bytes = new byte[data.length][];
                        }
                        if (data[i] == null || data[i].length <= 0) continue;
                        bytes[i] = data[i];
                        ++segments;
                    }
                }
                if (ppl == null) continue;
                ppl.pagesProcessed(p, pdd.getNumberOfPages());
            }
        }
        return bytes;
    }

    protected static byte[][] extractXMLStream(PDDocument pdd, PDPage pdp, int p, boolean render, boolean cutout) throws IOException {
        byte[][] data = null;
        if (pdd != null && pdp != null && p >= 0) {
            ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
            PDResources resources = pdp.getResources();
            PDPage contentStream = pdp;
            PDFStreamParser parser = new PDFStreamParser((PDContentStream)contentStream);
            Object token = parser.parseNextToken();
            ArrayList<COSBase> operands = new ArrayList<COSBase>();
            while (token != null) {
                if (token instanceof COSObject) {
                    operands.add(((COSObject)token).getObject());
                } else if (token instanceof Operator) {
                    Operator operator = (Operator)token;
                    if (System.getProperty("debug", "false").equals("true") && (operator.getName().equals("BI") || operator.getName().equals("cm"))) {
                        System.out.println("Token[Operator]=" + operator.getName());
                        for (int i = 0; i < operands.size(); ++i) {
                            System.out.println("Operand[" + i + "]=" + ((COSBase)operands.get(i)).toString());
                        }
                    }
                    if (operator.getName().equals("BI")) {
                        COSDictionary dict = operator.getImageParameters();
                        byte[] id = operator.getImageData();
                        if (dict != null && id != null) {
                            BufferedImage image;
                            PDInlineImage inline = new PDInlineImage(dict, id, pdp.getResources());
                            BufferedImage bufferedImage = image = inline != null ? inline.getImage() : null;
                            if (System.getProperty("debug", "false").equals("true")) {
                                TaxStatement.write(image);
                            }
                            if (image != null && image.getHeight() > image.getWidth()) {
                                image = TaxStatement.rotate(image);
                            }
                            if (cutout && image != null && image.getWidth() > BARCODE_SEGMENT_WIDTH_PX && image.getHeight() > BARCODE_SEGMENT_HEIGHT_PX && image.getWidth() % BARCODE_SEGMENT_WIDTH_PX > 0 && image.getHeight() % BARCODE_SEGMENT_HEIGHT_PX > 0) {
                                image = TaxStatement.cut(image, -1);
                            }
                            if (image != null && image.getWidth() > BARCODE_SEGMENT_WIDTH_PX && image.getHeight() > BARCODE_SEGMENT_HEIGHT_PX && image.getWidth() % BARCODE_SEGMENT_WIDTH_PX == 0 && image.getHeight() % BARCODE_SEGMENT_HEIGHT_PX == 0) {
                                image = TaxStatement.shrink(image, image.getWidth() / BARCODE_SEGMENT_WIDTH_PX, image.getHeight() / BARCODE_SEGMENT_HEIGHT_PX, 2, 2);
                            }
                            if (image != null && (image.getHeight() <= BARCODE_SEGMENT_HEIGHT_PX || image.getWidth() <= BARCODE_SEGMENT_WIDTH_PX)) {
                                image = image.getHeight() % BARCODE_SEGMENT_HEIGHT_PX == 0 && image.getWidth() % BARCODE_SEGMENT_WIDTH_PX == 0 ? TaxStatement.enlarge(image, 2, 2) : TaxStatement.enlarge(image, 4, 4);
                            }
                            if (render && image != null && image.getWidth() > BARCODE_SEGMENT_WIDTH_PX_FORCE && image.getHeight() > BARCODE_SEGMENT_HEIGHT_PX_FORCE) {
                                return null;
                            }
                            if (image != null) {
                                images.add(image);
                            }
                        }
                    }
                    operands = new ArrayList();
                } else {
                    operands.add((COSBase)token);
                }
                token = parser.parseNextToken();
            }
            if (images != null && images.size() > 0) {
                data = TaxStatement.read(images);
            }
        }
        return data;
    }

    public static byte[][] extractXMLRender(PDDocument pdd) {
        return TaxStatement.extractXMLRender(pdd, System.getProperty("renderWithDPI") != null ? Integer.parseInt(System.getProperty("renderWithDPI")) : RENDER_WITH_DPI);
    }

    public static byte[][] extractXMLRender(PDDocument pdd, int renderWithDPI) {
        return TaxStatement.extractXMLRender(pdd, renderWithDPI, System.getProperty("barcodeAreaDPIXA") != null ? Integer.parseInt(System.getProperty("barcodeAreaDPIXA")) : BARCODE_AREA_DPI_XA, System.getProperty("barcodeAreaDPIYA") != null ? Integer.parseInt(System.getProperty("barcodeAreaDPIYA")) : BARCODE_AREA_DPI_YA, System.getProperty("barcodeAreaDPIXB") != null ? Integer.parseInt(System.getProperty("barcodeAreaDPIXB")) : BARCODE_AREA_DPI_XB, System.getProperty("barcodeAreaDPIYB") != null ? Integer.parseInt(System.getProperty("barcodeAreaDPIYB")) : BARCODE_AREA_DPI_YB);
    }

    public static byte[][] extractXMLRender(PDDocument pdd, int renderWithDPI, int barcodeAreaDPIXA, int barcodeAreaDPIYA, int barcodeAreaDPIXB, int barcodeAreaDPIYB) {
        return TaxStatement.extractXMLRender(pdd, null, renderWithDPI, barcodeAreaDPIXA, barcodeAreaDPIYA, barcodeAreaDPIXB, barcodeAreaDPIYB);
    }

    public static byte[][] extractXMLRender(PDDocument pdd, PageProgressListenerInterface ppl, int renderWithDPI, int barcodeAreaDPIXA, int barcodeAreaDPIYA, int barcodeAreaDPIXB, int barcodeAreaDPIYB) {
        Object bytes = null;
        if (pdd != null) {
            PDPageTree tree = pdd.getPages();
            int segments = 0;
            for (int p = tree.getCount() - 1; p >= 0; --p) {
                if (System.getProperty("debug", "false").equals("true")) {
                    System.out.println("page: " + p);
                }
                if (bytes != null && ((byte[][])bytes).length <= segments) continue;
                byte[][] data = TaxStatement.extractXMLRender(pdd, tree.get(p), p, renderWithDPI, barcodeAreaDPIXA, barcodeAreaDPIYA, barcodeAreaDPIXB, barcodeAreaDPIYB);
                if (data != null && data.length > 0) {
                    for (int i = 0; i < data.length; ++i) {
                        if (bytes == null) {
                            bytes = new byte[data.length][];
                        }
                        if (data[i] == null || data[i].length <= 0) continue;
                        bytes[i] = data[i];
                        ++segments;
                    }
                }
                if (ppl == null) continue;
                ppl.pagesProcessed(p, pdd.getNumberOfPages());
            }
        }
        return bytes;
    }

    protected static byte[][] extractXMLRender(PDDocument pdd, PDPage pdp, int p) {
        return TaxStatement.extractXMLRender(pdd, pdp, p, System.getProperty("renderWithDPI") != null ? Integer.parseInt(System.getProperty("renderWithDPI")) : RENDER_WITH_DPI);
    }

    protected static byte[][] extractXMLRender(PDDocument pdd, PDPage pdp, int p, int renderWithDPI) {
        return TaxStatement.extractXMLRender(pdd, pdp, p, renderWithDPI, System.getProperty("barcodeAreaDPIXA") != null ? Integer.parseInt(System.getProperty("barcodeAreaDPIXA")) : BARCODE_AREA_DPI_XA, System.getProperty("barcodeAreaDPIYA") != null ? Integer.parseInt(System.getProperty("barcodeAreaDPIYA")) : BARCODE_AREA_DPI_YA, System.getProperty("barcodeAreaDPIXB") != null ? Integer.parseInt(System.getProperty("barcodeAreaDPIXB")) : BARCODE_AREA_DPI_XB, System.getProperty("barcodeAreaDPIYB") != null ? Integer.parseInt(System.getProperty("barcodeAreaDPIYB")) : BARCODE_AREA_DPI_YB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static byte[][] extractXMLRender(PDDocument pdd, PDPage pdp, int p, int renderWithDPI, int barcodeAreaDPIXA, int barcodeAreaDPIYA, int barcodeAreaDPIXB, int barcodeAreaDPIYB) {
        byte[][] data = null;
        if (pdd != null && pdp != null && p >= 0) {
            BufferedImage image = null;
            PrintStream stderr = System.err;
            try {
                System.setErr(new PrintStream(new OutputStream(){

                    @Override
                    public void write(int b) {
                    }
                }));
                image = TaxStatement.renderImageAreaWithDPIBarCode(pdd, p, barcodeAreaDPIXA, barcodeAreaDPIYA, barcodeAreaDPIXB - barcodeAreaDPIXA, barcodeAreaDPIYB - barcodeAreaDPIYA, renderWithDPI);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                System.setErr(stderr);
            }
            if (System.getProperty("debug", "false").equals("true")) {
                TaxStatement.write(image);
            }
            if (image != null && image.getWidth() > image.getHeight()) {
                image = TaxStatement.rotate(image);
                if (System.getProperty("debug", "false").equals("true")) {
                    TaxStatement.write(image);
                }
            }
            if (image != null) {
                data = TaxStatement.read(image);
            }
        }
        return data;
    }

    public static byte[] extractXMLInflate(byte[][] bytes) {
        byte[] compressed = null;
        byte[] inflated = null;
        if (bytes != null) {
            for (int i = 0; i < bytes.length; ++i) {
                if (bytes[i] == null) continue;
                compressed = compressed != null ? ByteBuffer.allocate(compressed.length + bytes[i].length).put(compressed).put(bytes[i]).array() : bytes[i];
            }
        }
        if (System.getProperty("debug", "false").equals("true")) {
            System.out.println("compressed: " + (compressed != null ? compressed.length : 0));
            TaxStatement.write(compressed);
        }
        if (compressed != null && inflated == null) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(compressed.length);
                byte[] buf = new byte[4096];
                Inflater inflater = new Inflater();
                int length = 1;
                inflater.setInput(compressed);
                while (!inflater.finished() && length != 0) {
                    length = inflater.inflate(buf);
                    baos.write(buf, 0, length);
                }
                baos.close();
                inflated = baos.toByteArray();
            }
            catch (Exception e1) {
                e1.printStackTrace();
                inflated = null;
            }
        }
        if (System.getProperty("debug", "false").equals("true")) {
            System.out.println("inflated: " + (inflated != null ? inflated.length : 0));
        }
        return inflated;
    }

    public static Date extractXMLReferenceDate(byte[] xml) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        dbf.setXIncludeAware(false);
        dbf.setNamespaceAware(false);
        Document doc = dbf.newDocumentBuilder().parse(new ByteArrayInputStream(xml));
        return TaxStatement.getAttributeXPathDate(doc, "/taxStatement/@periodTo");
    }

    public static List<String> extractXMLUniqueKeyList(byte[] xml) throws IOException, ParserConfigurationException, SAXException, XPathExpressionException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        dbf.setXIncludeAware(false);
        dbf.setNamespaceAware(false);
        Document doc = dbf.newDocumentBuilder().parse(new ByteArrayInputStream(xml));
        ArrayList<String> list = new ArrayList<String>();
        if (doc != null) {
            int depot = TaxStatement.getElementCount(doc, "count(/taxStatement/listOfSecurities/depot)");
            for (int d = 1; d <= depot; ++d) {
                int security = TaxStatement.getElementCount(doc, "count(/taxStatement/listOfSecurities/depot[" + d + "]/security)");
                for (int s = 1; s <= security; ++s) {
                    String valorNumber = TaxStatement.getAttributeXPath(doc, "/taxStatement/listOfSecurities/depot[" + d + "]/security[" + s + "]/@valorNumber");
                    if (valorNumber != null) {
                        if (list.contains(valorNumber)) continue;
                        list.add(valorNumber);
                        continue;
                    }
                    String isin = TaxStatement.getAttributeXPath(doc, "/taxStatement/listOfSecurities/depot[" + d + "]/security[" + s + "]/@isin");
                    if (isin == null || list.contains(isin)) continue;
                    list.add(isin);
                }
            }
        }
        return list;
    }

    public static byte[] signXML(byte[] xml, KeyStore ks, String password) throws CertificateException, InvalidAlgorithmParameterException, IOException, KeyStoreException, MarshalException, NoSuchAlgorithmException, NoSuchProviderException, ParserConfigurationException, SAXException, TransformerConfigurationException, TransformerException, UnrecoverableKeyException, XMLSignatureException {
        return TaxStatementSignature.signXML(xml, ks, password);
    }

    public static byte[] signXML(byte[] xml, String pkcs12, String password) throws CertificateException, InvalidAlgorithmParameterException, IOException, KeyStoreException, MarshalException, NoSuchAlgorithmException, NoSuchProviderException, ParserConfigurationException, SAXException, TransformerConfigurationException, TransformerException, UnrecoverableKeyException, XMLSignatureException {
        return TaxStatementSignature.signXML(xml, pkcs12, password);
    }

    public static boolean validateXML(Document doc) throws IOException, ParseException, ParserConfigurationException, SAXException, UnsupportedEncodingException, XPathExpressionException {
        String xml = TaxStatement.getElementXML(doc, "taxStatement", true);
        return TaxStatement.validateXML(xml != null && xml.length() > 0 ? xml.getBytes("UTF-8") : null);
    }

    public static boolean validateXML(byte[] xml) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        boolean valid = false;
        try {
            valid = TaxStatement.validateXML(xml, TaxStatement.getVersion(xml).equals(VERSION_10) ? SCHEMAS_10 : (TaxStatement.getVersion(xml).equals(VERSION_20) ? SCHEMAS_20 : (TaxStatement.getVersion(xml).equals(VERSION_21) ? SCHEMAS_21 : (TaxStatement.getVersion(xml).equals(VERSION_22) ? SCHEMAS_22 : SCHEMAS_21))));
        }
        catch (SAXParseException e) {
            valid = false;
        }
        return valid;
    }

    public static boolean validateXML(byte[] xml, String[] schemas) throws IOException, SAXException {
        boolean valid = true;
        Source[] ss = new StreamSource[schemas.length];
        for (int i = 0; i < ss.length; ++i) {
            ss[i] = new StreamSource(TaxStatement.class.getResourceAsStream("/resources/" + schemas[i]));
        }
        String lang = "http://www.w3.org/2001/XMLSchema";
        SchemaFactory sf = SchemaFactory.newInstance(lang);
        sf.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        sf.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        Schema sc = sf.newSchema(ss);
        Validator va = sc.newValidator();
        va.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        va.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        if (xml != null && xml.length > 0) {
            va.validate(new StreamSource(new ByteArrayInputStream(xml)));
        } else {
            valid = false;
        }
        return valid;
    }

    public static String validateXMLMessage(Document doc) throws UnsupportedEncodingException, XPathExpressionException {
        String xml = TaxStatement.getElementXML(doc, "taxStatement", true);
        return TaxStatement.validateXMLMessage(xml != null && xml.length() > 0 ? xml.getBytes("UTF-8") : null);
    }

    public static String validateXMLMessage(byte[] xml) {
        String message = "";
        try {
            if (xml != null && xml.length > 0) {
                TaxStatement.validateXML(xml, TaxStatement.getVersion(xml).equals(VERSION_10) ? SCHEMAS_10 : (TaxStatement.getVersion(xml).equals(VERSION_20) ? SCHEMAS_20 : (TaxStatement.getVersion(xml).equals(VERSION_21) ? SCHEMAS_21 : (TaxStatement.getVersion(xml).equals(VERSION_22) ? SCHEMAS_22 : SCHEMAS_21))));
            } else {
                message = "taxStatement not found!";
            }
        }
        catch (SAXParseException e) {
            message = e.getMessage() + "\nline:   " + e.getLineNumber() + "\ncolumn: " + e.getColumnNumber();
        }
        catch (Exception ex) {
            message = ex.getMessage();
        }
        return message;
    }

    public static boolean verifyXML(byte[] xml) throws IOException, MarshalException, ParserConfigurationException, SAXException, XMLSignatureException {
        return TaxStatementSignature.verifyXML(xml);
    }

    public static String verifyXMLMessage(byte[] xml) {
        return TaxStatementSignature.verifyXMLMessage(xml);
    }

    public static void addAttachment(PDDocument pdd, byte[] xml, String name) throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(xml);
        PDEmbeddedFile ef = new PDEmbeddedFile(pdd, (InputStream)bis, COSName.FLATE_DECODE);
        ef.setSubtype("text/plain");
        ef.setSize(xml.length);
        ef.setCreationDate((Calendar)new GregorianCalendar());
        PDEmbeddedFilesNameTreeNode efTree = new PDEmbeddedFilesNameTreeNode();
        PDComplexFileSpecification fs = new PDComplexFileSpecification();
        fs.setFile(name);
        fs.setEmbeddedFile(ef);
        efTree.setNames(Collections.singletonMap("attachment", fs));
        PDDocumentNameDictionary dic = new PDDocumentNameDictionary(pdd.getDocumentCatalog());
        dic.setEmbeddedFiles(efTree);
        pdd.getDocumentCatalog().setNames(dic);
    }

    public static List<String> extractAttachment(PDDocument pdd) throws IOException {
        PDDocumentNameDictionary dic = new PDDocumentNameDictionary(pdd.getDocumentCatalog());
        PDEmbeddedFilesNameTreeNode efTree = dic.getEmbeddedFiles();
        ArrayList<String> list = new ArrayList<String>();
        if (efTree != null) {
            Map names = efTree.getNames();
            for (Map.Entry entry : names.entrySet()) {
                PDComplexFileSpecification fs = (PDComplexFileSpecification)entry.getValue();
                if (fs == null || fs.getFilename() == null) continue;
                list.add(fs.getFilename());
            }
        }
        return list;
    }

    public static byte[] extractAttachment(PDDocument pdd, String name) throws IOException {
        PDDocumentNameDictionary dic = new PDDocumentNameDictionary(pdd.getDocumentCatalog());
        PDEmbeddedFilesNameTreeNode efTree = dic.getEmbeddedFiles();
        byte[] xml = null;
        if (efTree != null) {
            Map names = efTree.getNames();
            for (Map.Entry entry : names.entrySet()) {
                PDEmbeddedFile ef;
                PDComplexFileSpecification fs = (PDComplexFileSpecification)entry.getValue();
                if (fs == null || fs.getFilename() == null || !fs.getFilename().equals(name) || (ef = fs.getEmbeddedFile()) == null) continue;
                xml = ef.toByteArray();
            }
        }
        return xml;
    }

    public static BufferedImage renderImageAreaWithDPI(PDDocument pdd, int p, int x, int y, int width, int height, int renderWithDPI) throws IOException {
        double scale = (double)renderWithDPI / 72.0;
        BufferedImage image = new BufferedImage(width, height, 12);
        AffineTransform trans = AffineTransform.getScaleInstance(scale, scale);
        trans.concatenate(AffineTransform.getTranslateInstance((double)(-x) / scale, (double)(-y) / scale));
        Graphics2D g2d = image.createGraphics();
        g2d.setBackground(Color.WHITE);
        g2d.fillRect(0, 0, image.getWidth(), image.getHeight());
        g2d.setTransform(trans);
        PDFRenderer renderer = new PDFRenderer(pdd);
        renderer.renderPageToGraphics(p, g2d);
        g2d.dispose();
        return image;
    }

    public static BufferedImage renderImageAreaWithDPIBarCode(PDDocument pdd, int p, int renderWithDPI) throws IOException {
        return TaxStatement.renderImageAreaWithDPIBarCode(pdd, p, BARCODE_AREA_DPI_XA, BARCODE_AREA_DPI_YA, BARCODE_AREA_DPI_XB - BARCODE_AREA_DPI_XA, BARCODE_AREA_DPI_YB - BARCODE_AREA_DPI_YA, renderWithDPI);
    }

    public static BufferedImage renderImageAreaWithDPIBarCode(PDDocument pdd, int p, int x, int y, int width, int height, int renderWithDPI) throws IOException {
        PDPage page = pdd.getPage(p);
        int rotation = page.getRotation();
        if (rotation == 0 && page.getBBox().getWidth() > page.getBBox().getHeight()) {
            rotation = 90;
        }
        return TaxStatement.renderImageAreaWithDPI(pdd, p, rotation == 90 || rotation == 270 ? renderWithDPI * x / RENDER_WITH_DPI : renderWithDPI * y / RENDER_WITH_DPI, rotation == 90 || rotation == 270 ? renderWithDPI * y / RENDER_WITH_DPI : renderWithDPI * x / RENDER_WITH_DPI, rotation == 90 || rotation == 270 ? renderWithDPI * width / RENDER_WITH_DPI : renderWithDPI * height / RENDER_WITH_DPI, rotation == 90 || rotation == 270 ? renderWithDPI * height / RENDER_WITH_DPI : renderWithDPI * width / RENDER_WITH_DPI, renderWithDPI);
    }

    public static BufferedImage renderImageAreaWithDPIBottom(PDDocument pdd, int p, int renderWithDPI) throws IOException {
        return TaxStatement.renderImageAreaWithDPIBottom(pdd, p, BARCODE_AREA_DPI_BOTTOM, renderWithDPI);
    }

    public static BufferedImage renderImageAreaWithDPIBottom(PDDocument pdd, int p, int height, int renderWithDPI) throws IOException {
        PDPage page = pdd.getPage(p);
        int rotation = page.getRotation();
        if (rotation == 0 && page.getBBox().getWidth() > page.getBBox().getHeight()) {
            rotation = 90;
        }
        return TaxStatement.renderImageAreaWithDPI(pdd, p, rotation == 90 || rotation == 270 ? 0 : renderWithDPI * (RENDER_WITH_DPI_HEIGHT - height) / RENDER_WITH_DPI, rotation == 90 || rotation == 270 ? renderWithDPI * (RENDER_WITH_DPI_HEIGHT - height) / RENDER_WITH_DPI : 0, rotation == 90 || rotation == 270 ? renderWithDPI * RENDER_WITH_DPI_WIDTH / RENDER_WITH_DPI : renderWithDPI * height / RENDER_WITH_DPI, rotation == 90 || rotation == 270 ? renderWithDPI * height / RENDER_WITH_DPI : renderWithDPI * RENDER_WITH_DPI_WIDTH / RENDER_WITH_DPI, renderWithDPI);
    }

    public static BufferedImage renderImageAreaWithDPILeft(PDDocument pdd, int p, int renderWithDPI) throws IOException {
        return TaxStatement.renderImageAreaWithDPILeft(pdd, p, BARCODE_AREA_DPI_LEFT, renderWithDPI);
    }

    public static BufferedImage renderImageAreaWithDPILeft(PDDocument pdd, int p, int width, int renderWithDPI) throws IOException {
        PDPage page = pdd.getPage(p);
        int rotation = page.getRotation();
        if (rotation == 0 && page.getBBox().getWidth() > page.getBBox().getHeight()) {
            rotation = 90;
        }
        return TaxStatement.renderImageAreaWithDPI(pdd, p, 0, 0, rotation == 90 || rotation == 270 ? renderWithDPI * width / RENDER_WITH_DPI : renderWithDPI * RENDER_WITH_DPI_HEIGHT / RENDER_WITH_DPI, rotation == 90 || rotation == 270 ? renderWithDPI * RENDER_WITH_DPI_HEIGHT / RENDER_WITH_DPI : renderWithDPI * width / RENDER_WITH_DPI, renderWithDPI);
    }

    public static BufferedImage renderImageAreaWithDPIRight(PDDocument pdd, int p, int renderWithDPI) throws IOException {
        return TaxStatement.renderImageAreaWithDPIRight(pdd, p, BARCODE_AREA_DPI_RIGHT, renderWithDPI);
    }

    public static BufferedImage renderImageAreaWithDPIRight(PDDocument pdd, int p, int width, int renderWithDPI) throws IOException {
        PDPage page = pdd.getPage(p);
        int rotation = page.getRotation();
        if (rotation == 0 && page.getBBox().getWidth() > page.getBBox().getHeight()) {
            rotation = 90;
        }
        return TaxStatement.renderImageAreaWithDPI(pdd, p, rotation == 90 || rotation == 270 ? renderWithDPI * (RENDER_WITH_DPI_WIDTH - width) / RENDER_WITH_DPI : 0, rotation == 90 || rotation == 270 ? 0 : renderWithDPI * (RENDER_WITH_DPI_WIDTH - width) / RENDER_WITH_DPI, rotation == 90 || rotation == 270 ? renderWithDPI * width / RENDER_WITH_DPI : renderWithDPI * RENDER_WITH_DPI_HEIGHT / RENDER_WITH_DPI, rotation == 90 || rotation == 270 ? renderWithDPI * RENDER_WITH_DPI_HEIGHT / RENDER_WITH_DPI : renderWithDPI * width / RENDER_WITH_DPI, renderWithDPI);
    }

    public static BufferedImage renderImageAreaWithDPITop(PDDocument pdd, int p, int renderWithDPI) throws IOException {
        return TaxStatement.renderImageAreaWithDPITop(pdd, p, BARCODE_AREA_DPI_TOP, renderWithDPI);
    }

    public static BufferedImage renderImageAreaWithDPITop(PDDocument pdd, int p, int height, int renderWithDPI) throws IOException {
        PDPage page = pdd.getPage(p);
        int rotation = page.getRotation();
        if (rotation == 0 && page.getBBox().getWidth() > page.getBBox().getHeight()) {
            rotation = 90;
        }
        return TaxStatement.renderImageAreaWithDPI(pdd, p, 0, 0, rotation == 90 || rotation == 270 ? renderWithDPI * RENDER_WITH_DPI_WIDTH / RENDER_WITH_DPI : renderWithDPI * height / RENDER_WITH_DPI, rotation == 90 || rotation == 270 ? renderWithDPI * height / RENDER_WITH_DPI : renderWithDPI * RENDER_WITH_DPI_WIDTH / RENDER_WITH_DPI, renderWithDPI);
    }
}

