/*
 * Decompiled with CFR 0.152.
 */
package org.codemonkey.simplejavamail;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataSource;
import javax.mail.Message;
import javax.mail.util.ByteArrayDataSource;
import org.codemonkey.simplejavamail.AttachmentResource;
import org.codemonkey.simplejavamail.Recipient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Email {
    private Recipient fromRecipient;
    private Recipient replyToRecipient;
    private String text;
    private String textHTML;
    private String subject;
    private final List<Recipient> recipients = new ArrayList<Recipient>();
    private final List<AttachmentResource> embeddedImages = new ArrayList<AttachmentResource>();
    private final List<AttachmentResource> attachments = new ArrayList<AttachmentResource>();
    private final Map<String, String> headers = new HashMap<String, String>();

    public void setFromAddress(String name, String fromAddress) {
        this.fromRecipient = new Recipient(name, fromAddress, null);
    }

    public void setReplyToAddress(String name, String replyToAddress) {
        this.replyToRecipient = new Recipient(name, replyToAddress, null);
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setTextHTML(String textHTML) {
        this.textHTML = textHTML;
    }

    public void addRecipient(String name, String address, Message.RecipientType type) {
        this.recipients.add(new Recipient(name, address, type));
    }

    public void addEmbeddedImage(String name, byte[] data, String mimetype) {
        ByteArrayDataSource dataSource = new ByteArrayDataSource(data, mimetype);
        dataSource.setName(name);
        this.addEmbeddedImage(name, (DataSource)dataSource);
    }

    public void addEmbeddedImage(String name, DataSource imagedata) {
        this.embeddedImages.add(new AttachmentResource(name, imagedata));
    }

    public void addHeader(String name, Object value) {
        this.headers.put(name, String.valueOf(value));
    }

    public void addAttachment(String name, byte[] data, String mimetype) {
        ByteArrayDataSource dataSource = new ByteArrayDataSource(data, mimetype);
        dataSource.setName(name);
        this.addAttachment(name, (DataSource)dataSource);
    }

    public void addAttachment(String name, DataSource filedata) {
        this.attachments.add(new AttachmentResource(name, filedata));
    }

    public Recipient getFromRecipient() {
        return this.fromRecipient;
    }

    public Recipient getReplyToRecipient() {
        return this.replyToRecipient;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getText() {
        return this.text;
    }

    public String getTextHTML() {
        return this.textHTML;
    }

    public List<AttachmentResource> getAttachments() {
        return Collections.unmodifiableList(this.attachments);
    }

    public List<AttachmentResource> getEmbeddedImages() {
        return Collections.unmodifiableList(this.embeddedImages);
    }

    public List<Recipient> getRecipients() {
        return Collections.unmodifiableList(this.recipients);
    }

    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }
}

