/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.update;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.regex.Pattern;

public class VersionNumber
implements Comparable<VersionNumber> {
    private static final Pattern VALUE_PATTERN = Pattern.compile("(^\\d+)([^\\d]*)");
    private static final Pattern QUALIFIER_PATTERN = Pattern.compile("(^\\d+)([^\\d]*)");
    public static final Pattern VERSION_NUMBER_SPLIT_PTN = Pattern.compile("\\.");
    private static final String VALUE_INTEGER_PART = "0.";
    private final String text;
    private final VersionNumberToken[] tokens;
    private final int hashcode;

    private VersionNumber(VersionNumberToken[] tokens) {
        assert (tokens != null && tokens.length > 0);
        this.tokens = tokens;
        int hashcode = 0;
        for (VersionNumberToken token : tokens) {
            hashcode += token.hashCode();
        }
        this.hashcode = hashcode;
        StringBuilder sb = new StringBuilder();
        for (VersionNumberToken token : tokens) {
            if (sb.length() > 0) {
                sb.append('.');
            }
            token.toString(sb);
        }
        this.text = sb.toString();
    }

    public static VersionNumber parse(String versionNumber) {
        if (versionNumber == null) {
            throw new NullPointerException("Version number string cannot be null.");
        }
        String[] strTokens = VERSION_NUMBER_SPLIT_PTN.split(versionNumber);
        VersionNumberToken[] tokens1 = new VersionNumberToken[strTokens.length];
        for (int i = 0; i < strTokens.length; ++i) {
            BigDecimal value;
            String strToken = strTokens[i];
            String valueText = VALUE_PATTERN.matcher(strToken).replaceAll("$1");
            String qualifierPreRelease = QUALIFIER_PATTERN.matcher(strToken).replaceAll("$2");
            try {
                value = new BigDecimal(VALUE_INTEGER_PART + valueText);
            }
            catch (NumberFormatException ignored) {
                throw new IllegalArgumentException("Cannot parse token " + i + " as number in: " + versionNumber);
            }
            tokens1[i] = new VersionNumberToken(value, qualifierPreRelease);
        }
        return new VersionNumber(tokens1);
    }

    @Override
    public int compareTo(VersionNumber versionNumber) {
        if (versionNumber == null) {
            throw new NullPointerException("Version number cannot be null.");
        }
        Object[] thisTokens = this.tokens;
        Object[] thatTokens = versionNumber.tokens;
        if (Arrays.equals(thisTokens, thatTokens)) {
            return 0;
        }
        for (int i = 0; i < thisTokens.length; ++i) {
            if (i >= thatTokens.length) {
                return 1;
            }
            Object t1 = thisTokens[i];
            Object t2 = thatTokens[i];
            int cmpValue = ((VersionNumberToken)t1).value.compareTo(((VersionNumberToken)t2).value);
            if (cmpValue != 0) {
                return cmpValue;
            }
            int cmpScale = Integer.compare(((VersionNumberToken)t1).value.scale(), ((VersionNumberToken)t2).value.scale());
            if (cmpScale != 0) {
                return -cmpScale;
            }
            if (!((VersionNumberToken)t1).qualifierPreRelease.isEmpty() && ((VersionNumberToken)t2).qualifierPreRelease.isEmpty()) {
                return -1;
            }
            if (((VersionNumberToken)t1).qualifierPreRelease.isEmpty() && !((VersionNumberToken)t2).qualifierPreRelease.isEmpty()) {
                return 1;
            }
            if (((VersionNumberToken)t1).qualifierPreRelease.isEmpty() || ((VersionNumberToken)t2).qualifierPreRelease.isEmpty()) continue;
            return ((VersionNumberToken)t1).qualifierPreRelease.compareTo(((VersionNumberToken)t2).qualifierPreRelease);
        }
        if (thatTokens.length > thisTokens.length) {
            return -1;
        }
        assert (false) : "version equality has already been tested";
        return 0;
    }

    public String asText() {
        return this.text;
    }

    public String toString() {
        return this.text;
    }

    public boolean equals(Object obj) {
        return obj instanceof VersionNumber && Arrays.equals(this.tokens, ((VersionNumber)obj).tokens);
    }

    public int hashCode() {
        return this.hashcode;
    }

    private static class VersionNumberToken {
        private final BigDecimal value;
        private final String qualifierPreRelease;

        VersionNumberToken(BigDecimal value, String qualifierPreRelease) {
            assert (value.compareTo(BigDecimal.ZERO) >= 0);
            this.value = value;
            this.qualifierPreRelease = qualifierPreRelease;
        }

        public boolean equals(Object obj) {
            if (obj instanceof VersionNumberToken) {
                VersionNumberToken that = (VersionNumberToken)obj;
                return this.value.compareTo(that.value) == 0 && this.value.scale() == that.value.scale() && (this.qualifierPreRelease != null && this.qualifierPreRelease.equals(that.qualifierPreRelease) || this.qualifierPreRelease == null && that.qualifierPreRelease == null);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode() + this.qualifierPreRelease.hashCode();
        }

        void toString(StringBuilder sb) {
            sb.append(this.value.toString().substring(VersionNumber.VALUE_INTEGER_PART.length()));
            sb.append(this.qualifierPreRelease);
        }
    }
}

