/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.utils;

import ch.dvbern.tax.common.engine.util.FastStack;

public final class StackUtil {
    private static final Number ZERO = 0;

    private StackUtil() {
    }

    public static boolean getBoolean(FastStack stack) {
        return StackUtil.get(stack, Boolean.class, Boolean.FALSE);
    }

    public static long getLong(FastStack stack) {
        return StackUtil.getNumber(stack).longValue();
    }

    public static float getFloat(FastStack stack) {
        return StackUtil.getNumber(stack).floatValue();
    }

    public static Number getNumber(FastStack stack) {
        return StackUtil.get(stack, Number.class, ZERO);
    }

    public static String getString(FastStack stack) {
        return StackUtil.get(stack, String.class, "");
    }

    public static <T> T get(FastStack stack, Class<T> type, T defaultValue) {
        if (stack == null || type == null) {
            throw new NullPointerException();
        }
        Object obj = stack.pop();
        if (obj == null) {
            return defaultValue;
        }
        if (!type.isInstance(obj)) {
            throw new IllegalArgumentException("Wrong element type, expected: " + type.getCanonicalName() + " got: " + obj.getClass().getCanonicalName());
        }
        return type.cast(obj);
    }
}

