/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.utils;

import ch.dvbern.tax.common.ejb.util.CDIHelper;
import ch.dvbern.tax.common.presentation.bd.DvbTaxSession;
import ch.dvbern.tax.common.presentation.common.Mode;
import ch.dvbern.tax.common.presentation.common.print.FormKey;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.ge.pp.utils.GeConstants;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.MDC;

public final class SharedUtils {
    private static final String MDC_PP_REQUEST_ID = "idTransaction";
    private static final String MDC_PP_NO_CONTRIBUABLE = "noContribuable";
    private static final Set<String> UPLOAD_FORM_FILTER_SET = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("Barcode#", "acomptes#", "Justificatifs#")));

    private SharedUtils() {
    }

    public static void setupRequestIdMDC(@Nullable String requestId) {
        SharedUtils.setupMDC(MDC_PP_REQUEST_ID, requestId);
    }

    public static void setupNoContribuableMDC(@Nullable String noContribuable) {
        SharedUtils.setupMDC(MDC_PP_NO_CONTRIBUABLE, noContribuable);
    }

    private static void setupMDC(String key, @Nullable String data) {
        if (data == null) {
            MDC.remove((String)key);
        } else {
            MDC.put((String)key, (String)data);
        }
    }

    @Nonnull
    public static String translate(@Nonnull String key, Object ... args) {
        if (key == null) {
            throw new NullPointerException("Resource key cannot be null.");
        }
        return CDIHelper.getResourceBundleManager().translate(key, GeConstants.DEFAULT_LOCALE, args);
    }

    @Nonnull
    public static ModelItemDTO createTouchedItem(@Nullable Object value) {
        return SharedUtils.createTouchedItem(value, false);
    }

    @Nonnull
    public static ModelItemDTO createTouchedItem(@Nullable Object value, boolean stateOk) {
        ModelItemDTO item = stateOk ? new ModelItemDTO(value, 1) : new ModelItemDTO(value);
        item.setTouched();
        return item;
    }

    @Nonnull
    public static List<FormKey> getUploadFormKeys(@Nonnull DvbTaxSession session) {
        if (session == null) {
            throw new NullPointerException("Session cannot be null.");
        }
        List navItems = session.getExpertNavigationItems();
        ArrayList<FormKey> forms = new ArrayList<FormKey>(navItems.size());
        for (ExpertDisplayInfoDTO.NavigationDTO navItem : navItems) {
            if (navItem.getPrintState() == 12 || !navItem.isPrintGesamtausdruck()) continue;
            SharedUtils.addSubItems(navItem, forms, UPLOAD_FORM_FILTER_SET);
        }
        return forms;
    }

    private static void addSubItems(ExpertDisplayInfoDTO.NavigationDTO navItem, List<FormKey> forms, Set<String> filterSet) {
        assert (navItem != null && forms != null && filterSet != null);
        String key = navItem.getAccessKey();
        if (filterSet.contains(key)) {
            return;
        }
        if (navItem.getSubItems() != null) {
            for (ExpertDisplayInfoDTO.NavigationDTO childDTO : navItem.getSubItems()) {
                SharedUtils.addSubItems(childDTO, forms, filterSet);
            }
        } else {
            forms.add(new FormKey(key, Mode.EXPERT));
        }
    }

    @Nonnull
    public static String formatDigest(MessageDigest digest) {
        if (digest == null) {
            throw new NullPointerException("Digest cannot be null.");
        }
        int digestLength = digest.getDigestLength();
        String fmt = digestLength > 0 ? "%0" + digestLength * 2 + "x" : "%x";
        return String.format(fmt, new BigInteger(1, digest.digest()));
    }

    public static class Currency {
        final double unit;
        final double tauxFortune;
        final String currencyCode;

        Currency(double unit, double tauxFortune, String currencyCode) {
            this.unit = unit;
            this.tauxFortune = tauxFortune;
            this.currencyCode = currencyCode;
        }

        @Generated
        public double getUnit() {
            return this.unit;
        }

        @Generated
        public double getTauxFortune() {
            return this.tauxFortune;
        }
    }
}

