/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.utils;

import ch.dvbern.tax.ge.pp.utils.NoBackendException;
import ch.ge.afc.ael.bo.depotdeclaration.pp.metier.IAFCDeclaPP;
import java.util.Hashtable;
import java.util.concurrent.atomic.AtomicReference;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IAFCDeclaPPServiceLocator {
    private static final Logger LOG = LoggerFactory.getLogger(IAFCDeclaPPServiceLocator.class);
    public static final String IAFCDECLAPP_IMPL_SYSPROP_NAME = "afc.declapp.impl.jndi.name";
    public static final String PROVIDER_URL_JNDI_PATH = "java:/env/java/naming/provider/url";
    private static final AtomicReference<Hashtable<String, String>> IAFCDECLAP_JNDI_ENV = new AtomicReference();

    private IAFCDeclaPPServiceLocator() {
    }

    public static synchronized IAFCDeclaPP lookupIAFCDeclaPPImpl() {
        try {
            String jndiPath = System.getProperty(IAFCDECLAPP_IMPL_SYSPROP_NAME);
            if (jndiPath == null || jndiPath.trim().length() == 0) {
                throw new NoBackendException("Cannot retrieve IAFCDeclaPP implementation JNDI path, no value defined for afc.declapp.impl.jndi.name in system properties");
            }
            Hashtable<String, String> env = IAFCDECLAP_JNDI_ENV.get();
            if (env == null) {
                env = IAFCDeclaPPServiceLocator.retrieveIAFCDeclaPPJNDIEnv();
                IAFCDECLAP_JNDI_ENV.set(env);
            }
            assert (env != null);
            Object iafcDeclaPPImplObj = new InitialContext(env).lookup(jndiPath);
            if (!(iafcDeclaPPImplObj instanceof IAFCDeclaPP)) {
                throw new NoBackendException(iafcDeclaPPImplObj + " is not a valid IAFCDeclaPP implementation");
            }
            return (IAFCDeclaPP)iafcDeclaPPImplObj;
        }
        catch (NamingException e) {
            throw new NoBackendException("Cannot retrieve IAFCDeclaPP implementation JNDI path", e);
        }
    }

    private static Hashtable<String, String> retrieveIAFCDeclaPPJNDIEnv() {
        InitialContext initialContext;
        try {
            initialContext = new InitialContext();
        }
        catch (NamingException e) {
            LOG.warn("Failed to retrieve JNDI initial context", (Throwable)e);
            return null;
        }
        Hashtable<String, String> env = null;
        try {
            Object providerUrlObj = initialContext.lookup(PROVIDER_URL_JNDI_PATH);
            if (providerUrlObj instanceof String) {
                String providerUrl = (String)providerUrlObj;
                env = new Hashtable(1);
                env.put("java.naming.provider.url", providerUrl);
                LOG.info("IAFCDeclaPP will be retrieved using the JNDI provider {}", (Object)providerUrl);
            } else {
                LOG.error("Invalid system provider url ({}), expected String, got {}", (Object)PROVIDER_URL_JNDI_PATH, (Object)(providerUrlObj != null ? providerUrlObj.getClass().getName() : "null"));
            }
        }
        catch (NamingException e) {
            LOG.info("Cannot find provider URL from JNDI property {} ({})", (Object)PROVIDER_URL_JNDI_PATH, (Object)e.getMessage());
        }
        return env != null ? env : new Hashtable<String, String>(0);
    }
}

