/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.utils;

import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.DiagnosticModelVisitor;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.ge.pp.engine.dto.PKeyTemplate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GeDiagnosticModelVisitor
extends DiagnosticModelVisitor {
    private static final Map<String, ModelItemDTO> DUMMY_DATAMODEL = new HashMap<String, ModelItemDTO>();

    public GeDiagnosticModelVisitor() {
        super(false, true);
    }

    @Nullable
    protected Class<?> getLogicItemExpectedType(@Nonnull LogicModelItem item) {
        List pKeyTemplates = item.getPersistenceKeyTemplates();
        if (pKeyTemplates.isEmpty()) {
            return null;
        }
        if (pKeyTemplates.size() > 1) {
            this.notifyError("Item %s has multiple persistence keys associated: %s", new Object[]{item.getName(), pKeyTemplates});
            return null;
        }
        try {
            PKeyTemplate pKeyTemplate = PKeyTemplate.parse((String)pKeyTemplates.get(0));
            return pKeyTemplate.type.getTargetType();
        }
        catch (IllegalArgumentException e) {
            this.notifyError("Failed to parsed persistence key template: %s (%s).", new Object[]{pKeyTemplates.get(0), e.getMessage()});
            return null;
        }
    }

    protected Map<String, ModelItemDTO> getDummyDataModel() {
        return DUMMY_DATAMODEL;
    }

    static {
        DUMMY_DATAMODEL.put("Stammdaten.Declaration.CantonTaxation", new ModelItemDTO((Object)"GE"));
        DUMMY_DATAMODEL.put("Stammdaten.AdresseFinAnnee.Canton", new ModelItemDTO((Object)"GE"));
        DUMMY_DATAMODEL.put("Revenu.ActiviteDependantContribuable.Canton", new ModelItemDTO((Object)"GE"));
        DUMMY_DATAMODEL.put("Revenu.ActiviteDependantContribuable.ActiviteDependantContribuable.90000.Canton", new ModelItemDTO((Object)"GE"));
        DUMMY_DATAMODEL.put("Revenu.ActiviteIndependante.Independant.90000.CoordonneesEntreprise.Canton", new ModelItemDTO((Object)"GE"));
        DUMMY_DATAMODEL.put("Revenu.ActiviteDependantConjoint.Canton", new ModelItemDTO((Object)"GE"));
        DUMMY_DATAMODEL.put("Revenu.ActiviteDependantConjoint.ActiviteDependantConjoint.90000.Canton", new ModelItemDTO((Object)"GE"));
        DUMMY_DATAMODEL.put("Immeubles.ImmeublesOccupes.ImmeublesOccupes.90000.Canton", new ModelItemDTO((Object)"GE"));
        DUMMY_DATAMODEL.put("Immeubles.ImmeublesCommerciaux.ImmeublesCommerciaux.90000.Canton", new ModelItemDTO((Object)"GE"));
        DUMMY_DATAMODEL.put("Immeubles.ImmeublesPPE.ImmeublesPPE.90000.Canton", new ModelItemDTO((Object)"GE"));
        DUMMY_DATAMODEL.put("Immeubles.ImmeublesHLM.ImmeublesHLM.90000.Canton", new ModelItemDTO((Object)"GE"));
        DUMMY_DATAMODEL.put("Immeubles.ImmeublesLoues.ImmeublesLoues.90000.Canton", new ModelItemDTO((Object)"GE"));
    }
}

