/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.utils;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.ComplexCalcItem;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

public class CopyToValueSkipImport
implements Validator {
    private final Reference targetItemRef;
    private final CalcItem[] calcItemsForCondition;
    private LogicModelItem srcItem = null;
    private LogicModelItem targetItem = null;

    public CopyToValueSkipImport(Reference targetItemRef) {
        this(targetItemRef, null);
    }

    public CopyToValueSkipImport(Reference targetItemRef, CalcItem[] calcItemsForCondition) {
        this.targetItemRef = targetItemRef;
        this.calcItemsForCondition = calcItemsForCondition;
    }

    public void initializeReferences(@NonNull Map<String, LogicModelItem> logicModel, @NonNull LogicModelItem logicModelItem) throws InvalidModelException {
        this.targetItemRef.registerListenerOnReference(logicModel, logicModelItem, false);
        this.targetItem = logicModel.get(this.targetItemRef.getName());
        this.srcItem = logicModelItem;
        if (this.calcItemsForCondition != null) {
            for (CalcItem calcItem : this.calcItemsForCondition) {
                if (calcItem instanceof Reference) {
                    ((Reference)calcItem).registerListenerOnReference(logicModel, logicModelItem, false);
                    continue;
                }
                if (!(calcItem instanceof ComplexCalcItem)) continue;
                ((ComplexCalcItem)calcItem).initializeReferences(logicModel, logicModelItem);
            }
        }
    }

    public @NonNull ModelItemDTO validate(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @NonNull ModelItemDTO modelItemDTO) {
        Object oldSrcItemValue;
        String targetItemDmk = EngineUtil.mergeModelKey((String)this.targetItem.getName(), (String)dataModelKey);
        ModelItemDTO targetItemDTO = dataModel.get((Object)targetItemDmk);
        if (modelItemDTO.getState() == 12) {
            return modelItemDTO;
        }
        if (targetItemDTO == null) {
            targetItemDTO = new ModelItemDTO(null);
        }
        boolean doCopy = true;
        String thisItemDmk = EngineUtil.mergeModelKey((String)this.srcItem.getName(), (String)dataModelKey);
        ModelItemDTO oldSrcItemDTO = dataModel.get((Object)thisItemDmk);
        Object object = oldSrcItemValue = oldSrcItemDTO != null ? oldSrcItemDTO.getValue() : Integer.valueOf(0);
        if (this.calcItemsForCondition != null) {
            Object calcItemsResult;
            FastStack stack = new FastStack();
            for (CalcItem calcItem : this.calcItemsForCondition) {
                try {
                    calcItem.evaluate(dataModel, stack, dataModelKey);
                }
                catch (RuntimeException rte) {
                    throw new IllegalArgumentException("Error evaluating CalcItem: " + dataModelKey, rte);
                }
            }
            doCopy = !stack.isEmpty() ? ((calcItemsResult = stack.pop()) != null ? (Boolean)calcItemsResult : false) : false;
        }
        Map asyncUpdateMap = dataModel.getAsyncUpdates();
        if (dataModel.isRecalculating()) {
            doCopy = false;
        }
        if (doCopy) {
            Object targetItemValue = targetItemDTO.getValue();
            if (targetItemValue == null) {
                doCopy = true;
            } else {
                ModelItemDTO asyncUpdate = (ModelItemDTO)asyncUpdateMap.get(targetItemDmk);
                if (asyncUpdate != null) {
                    targetItemValue = asyncUpdate.getValue();
                }
                doCopy = this.areMeaningfullyEquals(targetItemValue, oldSrcItemValue);
            }
            if (doCopy) {
                asyncUpdateMap.put(targetItemDmk, targetItemDTO.clone(modelItemDTO.getValue()));
            }
        }
        if (!doCopy && dataModel.isRecalculating()) {
            asyncUpdateMap.remove(targetItemDmk);
        }
        return modelItemDTO;
    }

    private boolean areMeaningfullyEquals(Object left, Object right) {
        if (right == null) {
            return left == null;
        }
        if (left == null) {
            return false;
        }
        if (left instanceof Number && right instanceof Number) {
            int cmp = Double.valueOf(((Number)left).doubleValue()).compareTo(((Number)right).doubleValue());
            return cmp == 0;
        }
        return left.equals(right);
    }
}

