/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.transfer.utils;

import ch.dvbern.tax.ge.pp.transfer.utils.BarcodeProfile;
import ch.dvbern.tax.ge.pp.upload.ReleaseMode;
import javax.annotation.Nonnull;

public class BarcodeConfiguration {
    private final BarcodeProfile profile;
    private final ReleaseMode releaseMode;
    private final long timestamp = System.currentTimeMillis();
    private boolean withAttachments;
    private int osIdentifier = -1;
    private int jvmIdentifier = -1;

    public BarcodeConfiguration(@Nonnull BarcodeProfile profile, @Nonnull ReleaseMode releaseMode) {
        if (profile == null) {
            throw new NullPointerException("Barcode profile cannot be null.");
        }
        if (releaseMode == null) {
            throw new NullPointerException("Release mode cannot be null.");
        }
        this.profile = profile;
        this.releaseMode = releaseMode;
    }

    @Nonnull
    public BarcodeConfiguration withAttachments(boolean withAttachments) {
        this.withAttachments = withAttachments;
        return this;
    }

    @Nonnull
    public BarcodeConfiguration withSystemIdentifiers(int os, int jvm) {
        this.osIdentifier = os;
        this.jvmIdentifier = jvm;
        return this;
    }

    @Nonnull
    public BarcodeProfile getProfile() {
        return this.profile;
    }

    @Nonnull
    public ReleaseMode getReleaseMode() {
        return this.releaseMode;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean isWithAttachments() {
        return this.withAttachments;
    }

    public int getOsIdentifier() {
        return this.osIdentifier;
    }

    public int getJvmIdentifier() {
        return this.jvmIdentifier;
    }
}

