/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.transfer.utils;

import ch.dvbern.tax.common.engine.expertdisplay.Barcode2DDataDTO;
import ch.dvbern.tax.common.engine.util.DataModelUtil;
import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.presentation.common.imports.ImportContext;
import ch.dvbern.tax.common.presentation.common.imports.ImportException;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.ge.pp.engine.dto.PKey;
import ch.dvbern.tax.ge.pp.engine.dto.PKeyTemplate;
import ch.dvbern.tax.ge.pp.engine.dto.PKeyTuple;
import ch.dvbern.tax.ge.pp.engine.dto.PKeyType;
import ch.dvbern.tax.ge.pp.presentation.common.imports.GeTaxFileImporter;
import ch.dvbern.tax.ge.pp.transfer.utils.BarcodeConfiguration;
import ch.dvbern.tax.ge.pp.transfer.utils.BarcodeValueMarshaller;
import ch.dvbern.tax.ge.pp.transfer.utils.InvalidBarcodeException;
import ch.dvbern.tax.ge.pp.transfer.utils.PersistenceKeysRegistry;
import ch.dvbern.tax.ge.pp.transfer.utils.UTF8NormalizingWriter;
import ch.dvbern.tax.ge.pp.upload.ReleaseMode;
import ch.dvbern.tax.ge.pp.utils.GeConstants;
import ch.dvbern.tax.ge.pp.utils.InternalFailureException;
import ch.dvbern.tax.ge.pp.utils.SharedUtils;
import com.ctc.wstx.stax.WstxInputFactory;
import com.ctc.wstx.stax.WstxOutputFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.bind.DatatypeConverter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.IOUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.codehaus.stax2.XMLStreamReader2;
import org.codehaus.stax2.validation.XMLValidationSchema;
import org.codehaus.stax2.validation.XMLValidationSchemaFactory;
import org.codehaus.staxmate.SMOutputFactory;
import org.codehaus.staxmate.out.SMNamespace;
import org.codehaus.staxmate.out.SMOutputDocument;
import org.codehaus.staxmate.out.SMOutputElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Barcode {
    public static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final Logger LOG = LoggerFactory.getLogger(Barcode.class);
    private static final String TARGET_NAMESPACE = "http://www.dvbern.ch/taxme/GeTax/pp/barcode";
    private static final XMLValidationSchema BARCODE_SCHEMA;
    private static final String RELEVE_FISCAL = "RF";
    public static final String NAMESPACE_NOT_DV = "Error by namespace: not a DV barcode";
    private static final PKey OS_IDENTIFIER_KEY;
    private static final PKey JVM_IDENTIFIER_PKEY;
    private final PersistenceKeysRegistry pKeyRegistry;
    private final MetaData md;
    private final Map<PKey, Object> valuesMap;
    private final BarcodeValueMarshaller marshaller = new BarcodeValueMarshaller();

    private Barcode(PersistenceKeysRegistry pKeyRegistry, MetaData md, Map<PKey, Object> valuesMap) {
        assert (pKeyRegistry != null && md != null && valuesMap != null);
        this.pKeyRegistry = pKeyRegistry;
        this.md = md;
        this.valuesMap = valuesMap;
    }

    public static @NonNull Barcode newInstance(@NonNull PersistenceKeysRegistry registry, @NonNull Map<String, ModelItemDTO> dataModel) {
        Objects.requireNonNull(registry, "Persistence key registry cannot be null.");
        Objects.requireNonNull(dataModel, "Data model cannot be null.");
        Map<PKey, Object> valuesMap = registry.buildPersistenceMap(dataModel);
        MetaData md = new MetaData();
        md.year = ((Number)DataModelUtil.getRequiredValue(dataModel, Number.class, (String)"Stammdaten.Declaration.PeriodeTaxation")).intValue();
        md.firstName = Barcode.removeCtrlChar((String)DataModelUtil.getRequiredValue(dataModel, String.class, (String)"Stammdaten.Contribuable.Prenom"));
        md.name = Barcode.removeCtrlChar((String)DataModelUtil.getRequiredValue(dataModel, String.class, (String)"Stammdaten.Contribuable.Nom"));
        md.address = Barcode.removeCtrlChar((String)DataModelUtil.getRequiredValue(dataModel, String.class, (String)"Stammdaten.Declaration.RueNo"));
        md.city = Barcode.removeCtrlChar((String)DataModelUtil.getRequiredValue(dataModel, String.class, (String)"Stammdaten.Declaration.Localite"));
        md.zip = Barcode.removeCtrlChar((String)DataModelUtil.getRequiredValue(dataModel, String.class, (String)"Stammdaten.Declaration.Npa"));
        md.numeroContribuable = Barcode.removeCtrlChar((String)DataModelUtil.getRequiredValue(dataModel, String.class, (String)"Stammdaten.Declaration.NoContribuableBarcode"));
        @Nullable String codeDI = (String)DataModelUtil.getValue(dataModel, String.class, (String)"Stammdaten.Declaration.CodeDeclarationBarcode");
        if (codeDI != null) {
            md.codeDeclaration = Barcode.removeCtrlChar(codeDI);
        }
        md.departDeces = Objects.requireNonNull((Boolean)DataModelUtil.getValue(dataModel, Boolean.class, (String)"Stammdaten.Declaration.DepartDeces"));
        return new Barcode(registry, md, new HashMap<PKey, Object>(valuesMap));
    }

    private static String removeCtrlChar(String source) {
        return source.replaceAll("[\u0000-\u001f]", "");
    }

    public static @NonNull Barcode readBarcode(@NonNull PersistenceKeysRegistry registry, @NonNull InputStream stream) throws InvalidBarcodeException {
        Objects.requireNonNull(registry, "Persistence key registry cannot be null.");
        Objects.requireNonNull(stream, "Barcode stream cannot be null.");
        return Barcode.readBarcode(registry, new InputStreamReader(stream, CHARSET));
    }

    public static @NonNull Barcode readBarcode(@NonNull PersistenceKeysRegistry registry, @NonNull Reader reader) throws InvalidBarcodeException {
        Objects.requireNonNull(registry, "Persistence key registry cannot be null.");
        Objects.requireNonNull(reader, "Barcode reader cannot be null.");
        try {
            return Barcode.doRead(registry, reader);
        }
        catch (Exception e) {
            throw new InvalidBarcodeException("Cannot parse barcode.", e);
        }
    }

    private static Barcode doRead(@NonNull PersistenceKeysRegistry registry, @NonNull Reader reader) throws XMLStreamException, InvalidBarcodeException {
        Objects.requireNonNull(registry);
        Objects.requireNonNull(reader);
        WstxInputFactory inputFactory = new WstxInputFactory();
        XMLStreamReader2 xmlReader = (XMLStreamReader2)inputFactory.createXMLStreamReader(reader);
        xmlReader.validateAgainst(BARCODE_SCHEMA);
        MetaData md = new MetaData();
        HashMap<PKey, Object> valuesMap = new HashMap<PKey, Object>(500);
        String formId = null;
        BarcodeValueMarshaller marshaller = new BarcodeValueMarshaller();
        LinkedList<String> tablesIds = new LinkedList<String>();
        LinkedList<TableContext> tables = new LinkedList<TableContext>();
        HashMap<String, TableContext> tableIndexes = new HashMap<String, TableContext>();
        xmlReader.nextTag();
        try {
            xmlReader.require(1, TARGET_NAMESPACE, "doc");
        }
        catch (Exception e) {
            throw new InvalidBarcodeException(NAMESPACE_NOT_DV);
        }
        xmlReader.nextTag();
        xmlReader.require(1, TARGET_NAMESPACE, "ii");
        md.year = xmlReader.getAttributeAsInt(xmlReader.getAttributeIndex(null, "period"));
        xmlReader.nextTag();
        xmlReader.require(2, TARGET_NAMESPACE, "ii");
        xmlReader.nextTag();
        xmlReader.require(1, TARGET_NAMESPACE, "id");
        md.firstName = xmlReader.getAttributeValue(null, "firstname");
        md.lastname = xmlReader.getAttributeValue(null, "lastname");
        md.address = xmlReader.getAttributeValue(null, "addr");
        md.city = xmlReader.getAttributeValue(null, "city");
        md.zip = xmlReader.getAttributeValue(null, "zip");
        md.codeDeclaration = xmlReader.getAttributeValue(null, "iddecla");
        md.numeroContribuable = xmlReader.getAttributeValue(null, "sno");
        xmlReader.nextTag();
        xmlReader.require(2, TARGET_NAMESPACE, "id");
        while (xmlReader.hasNext()) {
            String localName;
            int event = xmlReader.next();
            if (event == 1) {
                switch (localName = xmlReader.getLocalName()) {
                    case "fh": {
                        formId = xmlReader.getAttributeValue(null, "id");
                        if (formId != null) break;
                        throw new IllegalArgumentException();
                    }
                    case "tb": {
                        assert (formId != null);
                        String tableId = xmlReader.getAttributeValue(null, "id");
                        if (tableId == null) {
                            throw new IllegalArgumentException();
                        }
                        tablesIds.addLast(tableId);
                        if (tablesIds.size() > 2) {
                            throw new IllegalArgumentException();
                        }
                        String tableLMK = registry.getTableLMK(formId, tablesIds);
                        TableContext table = (TableContext)tableIndexes.get(tableLMK);
                        if (table == null) {
                            table = new TableContext();
                            tableIndexes.put(tableLMK, table);
                        }
                        tables.addLast(table);
                        break;
                    }
                    case "td": {
                        if (tablesIds.isEmpty()) {
                            throw new IllegalArgumentException();
                        }
                        ++((TableContext)tables.peekLast()).currentIndex;
                        break;
                    }
                    case "dr": {
                        if (tables.size() > 2) {
                            throw new XMLStreamException("");
                        }
                        PKeyTuple pKeyTuple = new PKeyTuple(formId, xmlReader.getAttributeValue(null, "f"), xmlReader.getAttributeValue(null, "c"), tablesIds);
                        PKeyTemplate pKeyTemplate = registry.getTemplateForTuple(pKeyTuple);
                        if (pKeyTemplate == null) {
                            LOG.debug("Ignoring unknown pKey tuple: {}", (Object)pKeyTuple);
                            break;
                        }
                        LOG.info("Processing:  Document {} Zelle {} Ziffer {} tableId {}", new Object[]{pKeyTuple.dokument, pKeyTuple.zelle, pKeyTuple.ziffer, pKeyTuple.tableIds});
                        ArrayList<Integer> indexes = new ArrayList<Integer>();
                        Iterator itr = tables.iterator();
                        if (itr.hasNext()) {
                            indexes.add(((TableContext)itr.next()).currentIndex);
                            if (itr.hasNext()) {
                                indexes.add(((TableContext)itr.next()).currentIndex);
                                assert (!itr.hasNext());
                            }
                        }
                        PKey pKey = pKeyTemplate.generatePKey(indexes);
                        try {
                            Serializable value = marshaller.unMarshall(xmlReader.getAttributeValue(null, "v"), pKey.pkType);
                            valuesMap.put(pKey, value);
                            break;
                        }
                        catch (Exception e) {
                            LOG.info("Ignoring unknown pKey tuple: {}", (Object)pKey.pkTuple);
                        }
                    }
                }
                continue;
            }
            if (event != 2 || !(localName = xmlReader.getLocalName()).equals("tb")) continue;
            tables.removeLast();
            tablesIds.removeLast();
        }
        return new Barcode(registry, md, valuesMap);
    }

    public @NonNull Barcode2DDataDTO generateDTO(@NonNull BarcodeConfiguration configuration) {
        Objects.requireNonNull(configuration, "Barcode configuration cannot be null.");
        if (configuration.getReleaseMode() != ReleaseMode.PRINT) {
            throw new IllegalArgumentException("Generating the barcode DTO can only be done for printed releases.");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(61440);
        ZipOutputStream zipStream = new ZipOutputStream(baos);
        OutputStreamWriter writer = null;
        try {
            zipStream.putNextEntry(new ZipEntry("xml"));
            writer = new OutputStreamWriter((OutputStream)zipStream, CHARSET);
            this.writeBarcode(configuration, writer);
            ((Writer)writer).flush();
            zipStream.closeEntry();
        }
        catch (Exception e) {
            try {
                throw new InternalFailureException("I/O Exception while writing to a in-memory buffer.", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
        Random random = new Random();
        byte[] id = new byte[4];
        id[0] = 3;
        id[1] = 1;
        byte[] rand = new byte[2];
        random.nextBytes(rand);
        id[2] = rand[0];
        id[3] = rand[1];
        return new Barcode2DDataDTO(baos.toByteArray(), id, 0);
    }

    public void writeBarcode(@NonNull BarcodeConfiguration configuration, @NonNull Writer writer) throws IOException, InvalidBarcodeException {
        Objects.requireNonNull(configuration, "Barcode configuration cannot be null.");
        Objects.requireNonNull(writer, "Target writer cannot be null.");
        try {
            this.doWrite(configuration, writer);
        }
        catch (XMLStreamException e) {
            throw new IOException("Failed to generate XML content.", e);
        }
    }

    private void doWrite(@NonNull BarcodeConfiguration configuration, @NonNull Writer writer) throws XMLStreamException, InvalidBarcodeException {
        Objects.requireNonNull(configuration);
        Objects.requireNonNull(writer);
        WstxOutputFactory outputFactory = new WstxOutputFactory();
        UTF8NormalizingWriter normalizingWriter = new UTF8NormalizingWriter(writer);
        SMOutputDocument root = new SMOutputFactory((XMLOutputFactory)outputFactory).createOutputDocument((Writer)normalizingWriter);
        root.getContext().getWriter().validateAgainst(BARCODE_SCHEMA);
        root.getContext().setIndentation("\n      ", 1, 1);
        SMNamespace ns = root.getNamespace(TARGET_NAMESPACE);
        Calendar cal = Calendar.getInstance(ApplicationConfig.TIMEZONE, GeConstants.DEFAULT_LOCALE);
        cal.setTimeInMillis(configuration.getTimestamp());
        String dategeneration = DatatypeConverter.printDateTime((Calendar)cal);
        SMOutputElement doc = root.addElement(ns, "doc");
        SMOutputElement ii = doc.addElement(ns, "ii");
        ii.addAttribute(null, "period", this.md.year);
        ii.addAttribute("dategeneration", dategeneration);
        ii.addAttribute("provider", configuration.getProfile().getProviderString());
        ii.addAttribute("version", configuration.getReleaseMode().getAppVersion(configuration.isWithAttachments()));
        ii.addAttribute("departdeces", this.md.departDeces != false ? "1" : "0");
        SMOutputElement id = doc.addElement(ns, "id");
        id.addAttribute("firstname", this.md.firstName);
        id.addAttribute("lastname", this.md.name);
        id.addAttribute("addr", this.md.address);
        id.addAttribute("city", this.md.city);
        id.addAttribute("zip", this.md.zip);
        id.addAttribute("sno", this.md.numeroContribuable);
        id.addAttribute("iddecla", this.md.codeDeclaration != null ? this.md.codeDeclaration : "");
        TreeMap<String, DataSet> formsMap = new TreeMap<String, DataSet>();
        this.prepareFormMap(formsMap, this.valuesMap);
        HashMap<PKey, Object> extraValuesMap = new HashMap<PKey, Object>();
        int osIdentifier = configuration.getOsIdentifier();
        int jvmIdentifier = configuration.getJvmIdentifier();
        if (osIdentifier != -1) {
            extraValuesMap.put(OS_IDENTIFIER_KEY, osIdentifier);
        }
        if (jvmIdentifier != -1) {
            extraValuesMap.put(JVM_IDENTIFIER_PKEY, jvmIdentifier);
        }
        this.prepareFormMap(formsMap, extraValuesMap);
        this.processPensionsVerseesEnfant(formsMap);
        this.processPensionsRecuesEnfant(formsMap);
        this.processComptesDebiteurs(formsMap);
        this.processRelevesDebiteurs(formsMap);
        this.processAppartenanceBank(formsMap);
        for (Map.Entry entry : formsMap.entrySet()) {
            SMOutputElement form = doc.addElement(ns, "fh");
            form.addAttribute("id", (String)entry.getKey());
            DataSet dataSet = (DataSet)entry.getValue();
            this.printDataSet(ns, form, dataSet);
        }
        root.closeRoot();
    }

    private void prepareFormMap(Map<String, DataSet> formsMap, Map<PKey, Object> valuesMap) throws InvalidBarcodeException {
        assert (formsMap != null && valuesMap != null);
        for (Map.Entry<PKey, Object> entry : valuesMap.entrySet()) {
            String txtValue;
            PKey pKey = entry.getKey();
            Object value = entry.getValue();
            if (value == null) continue;
            try {
                txtValue = this.marshaller.marshall(value, pKey.pkType);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidBarcodeException(String.format("Failed to marshall value %s (pKey: %s).", value, pKey));
            }
            if (txtValue == null || txtValue.trim().isEmpty()) continue;
            DataSet form = formsMap.get(pKey.pkTuple.dokument);
            if (form == null) {
                form = new DataSet();
                formsMap.put(pKey.pkTuple.dokument, form);
            }
            DataSet targetDataSet = form;
            for (int i = 0; i < pKey.pkTuple.tableIds.size(); ++i) {
                int lineIndex;
                DataSet line;
                String tableId = pKey.pkTuple.tableIds.get(i);
                Table table = targetDataSet.tables.get(tableId);
                if (table == null) {
                    table = new Table();
                    targetDataSet.tables.put(tableId, table);
                }
                if ((line = table.lines.get(lineIndex = pKey.indexes.get(i).intValue())) == null) {
                    line = new DataSet();
                    table.lines.put(lineIndex, line);
                }
                targetDataSet = line;
            }
            targetDataSet.values.add(new PKeyValuePair(pKey, txtValue));
        }
    }

    private void processComptesDebiteurs(Map<String, DataSet> formsMap) {
        String NEW_TABLE_ID = "1";
        HashSet<Integer> titreTableDebiteurLineIndexes = new HashSet<Integer>();
        for (Map.Entry<PKey, Object> entry : this.valuesMap.entrySet()) {
            String txtValue;
            PKey pKey = entry.getKey();
            Object value = entry.getValue();
            if (value == null || !pKey.toExternalForm().startsWith("F;[1]-1-030;B;") && !pKey.toExternalForm().startsWith("F;[1]-1-031;B;") && !pKey.toExternalForm().startsWith("F;[3]-3-030;B;") && !pKey.toExternalForm().startsWith("F;[3]-3-031;B;") || !(txtValue = this.marshaller.marshall(value, pKey.pkType)).equals("true")) continue;
            titreTableDebiteurLineIndexes.addAll(pKey.indexes);
        }
        if (titreTableDebiteurLineIndexes.isEmpty()) {
            return;
        }
        ArrayList<Map.Entry<PKey, Object>> cellesDebiteur = this.getEntriesFromTable("F;[1]-1-", titreTableDebiteurLineIndexes);
        ArrayList<Map.Entry<PKey, Object>> cellesDebiteur2 = this.getEntriesFromTable("F;[3]-3-", titreTableDebiteurLineIndexes);
        cellesDebiteur.addAll(cellesDebiteur2);
        int maxLineIndex = Collections.max(titreTableDebiteurLineIndexes);
        for (int index = 0; index < titreTableDebiteurLineIndexes.size(); ++index) {
            int currentLineNumberTitreTabelle = (Integer)titreTableDebiteurLineIndexes.toArray()[index];
            Object value = this.getStringFormCode(cellesDebiteur, currentLineNumberTitreTabelle, "01");
            String newValue = "0";
            if (((String)value).equals("1")) {
                newValue = "100";
            }
            PKeyTuple tuple = new PKeyTuple("E", "55.10", "01", "1");
            PKey dettePkey = new PKey(tuple, PKeyType.NUMBER, maxLineIndex + index + 1);
            this.addCellToTable(formsMap, index, dettePkey, newValue);
            value = this.getStringFormCode(cellesDebiteur, currentLineNumberTitreTabelle, "01");
            newValue = "0";
            if (((String)value).equals("2")) {
                newValue = "100";
            }
            tuple = new PKeyTuple("E", "55.10", "02", "1");
            dettePkey = new PKey(tuple, PKeyType.NUMBER, maxLineIndex + index + 1);
            this.addCellToTable(formsMap, index, dettePkey, newValue);
            value = this.getStringFormCode(cellesDebiteur, currentLineNumberTitreTabelle, "01");
            newValue = "0";
            if (((String)value).equals("3")) {
                newValue = "100";
            }
            tuple = new PKeyTuple("E", "55.10", "03", "1");
            dettePkey = new PKey(tuple, PKeyType.NUMBER, maxLineIndex + index + 1);
            this.addCellToTable(formsMap, index, dettePkey, newValue);
            value = this.getStringFormCode(cellesDebiteur, currentLineNumberTitreTabelle, "30");
            tuple = new PKeyTuple("E", "55.10", "04", "1");
            dettePkey = new PKey(tuple, PKeyType.NUMBER, maxLineIndex + index + 1);
            this.addCellToTable(formsMap, index, dettePkey, (String)value);
            value = this.getStringFormCode(cellesDebiteur, currentLineNumberTitreTabelle, "31");
            tuple = new PKeyTuple("E", "55.10", "05", "1");
            dettePkey = new PKey(tuple, PKeyType.NUMBER, maxLineIndex + index + 1);
            this.addCellToTable(formsMap, index, dettePkey, (String)value);
            String type = this.getStringFormCode(cellesDebiteur, currentLineNumberTitreTabelle, "00");
            Boolean isRF = false;
            if (RELEVE_FISCAL.equals(type)) {
                isRF = true;
            }
            value = this.getStringFormCode(cellesDebiteur, currentLineNumberTitreTabelle, isRF != false ? "02" : "03");
            tuple = new PKeyTuple("E", "55.10", "06", "1");
            dettePkey = new PKey(tuple, PKeyType.NUMBER, maxLineIndex + index + 1);
            this.addCellToTable(formsMap, index, dettePkey, (String)value);
            value = this.getStringFormCode(cellesDebiteur, currentLineNumberTitreTabelle, isRF != false ? "10" : "02");
            tuple = new PKeyTuple("E", "55.10", "07", "1");
            dettePkey = new PKey(tuple, PKeyType.NUMBER, maxLineIndex + index + 1);
            this.addCellToTable(formsMap, index, dettePkey, (String)value);
            value = this.md.getYear() + "1231";
            tuple = new PKeyTuple("E", "55.10", "08", "1");
            dettePkey = new PKey(tuple, PKeyType.NUMBER, maxLineIndex + index + 1);
            this.addCellToTable(formsMap, index, dettePkey, (String)value);
            value = "cbdt";
            tuple = new PKeyTuple("E", "55.10", "09", "1");
            dettePkey = new PKey(tuple, PKeyType.NUMBER, maxLineIndex + index + 1);
            this.addCellToTable(formsMap, index, dettePkey, (String)value);
        }
    }

    private void processPensionsRecuesEnfant(Map<String, DataSet> formsMap) {
        String NEW_TABLE_ID = "1";
        HashSet<Integer> pensionsReceivedForChild = new HashSet<Integer>();
        for (Map.Entry<PKey, Object> entry : this.valuesMap.entrySet()) {
            String txtValue;
            PKey pKey = entry.getKey();
            Object value = entry.getValue();
            if (value == null || !pKey.toExternalForm().startsWith("G;[1]-1-0022;N;") || !(txtValue = this.marshaller.marshall(value, pKey.pkType)).equals("1")) continue;
            pensionsReceivedForChild.addAll(pKey.indexes);
        }
        if (pensionsReceivedForChild.isEmpty()) {
            return;
        }
        ArrayList<Map.Entry<PKey, Object>> cellesEnfant = this.getEntriesFromTable("G;[1]-5-", pensionsReceivedForChild);
        int maxLineIndex = Collections.max(pensionsReceivedForChild);
        for (int index = 0; index < pensionsReceivedForChild.size(); ++index) {
            int currentLineNumberTitreTabelle = (Integer)pensionsReceivedForChild.toArray()[index];
            String value = this.getStringFormCode(cellesEnfant, currentLineNumberTitreTabelle, "13");
            PKeyTuple tuple = new PKeyTuple("C1", "13.10", "01", "1");
            PKey dettePkey = new PKey(tuple, PKeyType.NUMBER, maxLineIndex + index + 1);
            this.addCellToTable(formsMap, index, dettePkey, value);
            value = this.getStringFormCode(cellesEnfant, currentLineNumberTitreTabelle, "11");
            tuple = new PKeyTuple("C1", "13.10", "02", "1");
            dettePkey = new PKey(tuple, PKeyType.NUMBER, maxLineIndex + index + 1);
            this.addCellToTable(formsMap, index, dettePkey, value);
            value = this.getStringFormCode(cellesEnfant, currentLineNumberTitreTabelle, "12");
            tuple = new PKeyTuple("C1", "13.10", "03", "1");
            dettePkey = new PKey(tuple, PKeyType.NUMBER, maxLineIndex + index + 1);
            this.addCellToTable(formsMap, index, dettePkey, value);
            value = this.getStringFormCode(cellesEnfant, currentLineNumberTitreTabelle, "101");
            tuple = new PKeyTuple("C1", "13.10", "06", "1");
            dettePkey = new PKey(tuple, PKeyType.NUMBER, maxLineIndex + index + 1);
            this.addCellToTable(formsMap, index, dettePkey, value);
            value = this.getStringFormCode(cellesEnfant, currentLineNumberTitreTabelle, "001");
            tuple = new PKeyTuple("C1", "13.10", "031", "1");
            dettePkey = new PKey(tuple, PKeyType.NUMBER, maxLineIndex + index + 1);
            this.addCellToTable(formsMap, index, dettePkey, value);
            value = this.getStringFormCode(cellesEnfant, currentLineNumberTitreTabelle, "002");
            tuple = new PKeyTuple("C1", "13.10", "08", "1");
            dettePkey = new PKey(tuple, PKeyType.NUMBER, maxLineIndex + index + 1);
            this.addCellToTable(formsMap, index, dettePkey, value);
            value = this.getStringFormCode(cellesEnfant, currentLineNumberTitreTabelle, "10");
            tuple = new PKeyTuple("C1", "13.10", "032", "1");
            dettePkey = new PKey(tuple, PKeyType.NUMBER, maxLineIndex + index + 1);
            this.addCellToTable(formsMap, index, dettePkey, value);
        }
    }

    private void processPensionsVerseesEnfant(Map<String, DataSet> formsMap) {
        String NEW_TABLE_ID = "1";
        HashSet<Integer> pensionsPaiedForChild = new HashSet<Integer>();
        for (Map.Entry<PKey, Object> entry : this.valuesMap.entrySet()) {
            String txtValue;
            PKey pKey = entry.getKey();
            Object value = entry.getValue();
            if (value == null || !pKey.toExternalForm().startsWith("G;[1]-1-0023;N;") || !(txtValue = this.marshaller.marshall(value, pKey.pkType)).equals("1")) continue;
            pensionsPaiedForChild.addAll(pKey.indexes);
        }
        if (pensionsPaiedForChild.isEmpty()) {
            return;
        }
        ArrayList<Map.Entry<PKey, Object>> cellesEnfant = this.getEntriesFromTable("G;[1]-5-", pensionsPaiedForChild);
        int maxLineIndex = Collections.max(pensionsPaiedForChild);
        for (int index = 0; index < pensionsPaiedForChild.size(); ++index) {
            int currentLineNumberTitreTabelle = (Integer)pensionsPaiedForChild.toArray()[index];
            String value = this.getStringFormCode(cellesEnfant, currentLineNumberTitreTabelle, "102");
            if (value == null || value.isEmpty() || Long.parseLong(value) == 0L) {
                return;
            }
            PKeyTuple tuple = new PKeyTuple("C4", "53.10", "07", "1");
            PKey dettePkey = new PKey(tuple, PKeyType.NUMBER, maxLineIndex + index + 1);
            this.addCellToTable(formsMap, index, dettePkey, value);
            value = this.getStringFormCode(cellesEnfant, currentLineNumberTitreTabelle, "13");
            tuple = new PKeyTuple("C4", "53.10", "03", "1");
            dettePkey = new PKey(tuple, PKeyType.NUMBER, maxLineIndex + index + 1);
            this.addCellToTable(formsMap, index, dettePkey, value);
            value = this.getStringFormCode(cellesEnfant, currentLineNumberTitreTabelle, "131");
            tuple = new PKeyTuple("C4", "53.10", "031", "1");
            dettePkey = new PKey(tuple, PKeyType.NUMBER, maxLineIndex + index + 1);
            this.addCellToTable(formsMap, index, dettePkey, value);
            value = this.getStringFormCode(cellesEnfant, currentLineNumberTitreTabelle, "11");
            tuple = new PKeyTuple("C4", "53.10", "01", "1");
            dettePkey = new PKey(tuple, PKeyType.NUMBER, maxLineIndex + index + 1);
            this.addCellToTable(formsMap, index, dettePkey, value);
            value = this.getStringFormCode(cellesEnfant, currentLineNumberTitreTabelle, "12");
            tuple = new PKeyTuple("C4", "53.10", "04", "1");
            dettePkey = new PKey(tuple, PKeyType.NUMBER, maxLineIndex + index + 1);
            this.addCellToTable(formsMap, index, dettePkey, value);
            value = this.getStringFormCode(cellesEnfant, currentLineNumberTitreTabelle, "001");
            tuple = new PKeyTuple("C4", "53.10", "06", "1");
            dettePkey = new PKey(tuple, PKeyType.NUMBER, maxLineIndex + index + 1);
            this.addCellToTable(formsMap, index, dettePkey, value);
            value = this.getStringFormCode(cellesEnfant, currentLineNumberTitreTabelle, "002");
            tuple = new PKeyTuple("C4", "53.10", "08", "1");
            dettePkey = new PKey(tuple, PKeyType.NUMBER, maxLineIndex + index + 1);
            this.addCellToTable(formsMap, index, dettePkey, value);
        }
    }

    private void processAppartenanceBank(Map<String, DataSet> formsMap) {
        Object value;
        String NEW_TABLE_ID = "1";
        HashSet<Integer> bankAccount = new HashSet<Integer>();
        for (Map.Entry<PKey, Object> entry : this.valuesMap.entrySet()) {
            String txtValue;
            PKey pKey = entry.getKey();
            value = entry.getValue();
            if (value == null || !pKey.toExternalForm().startsWith("F;[1]") || !(txtValue = this.marshaller.marshall(value, pKey.pkType)).equals("1")) continue;
            bankAccount.addAll(pKey.indexes);
        }
        if (bankAccount.isEmpty()) {
            return;
        }
        ArrayList<Map.Entry<PKey, Object>> cellesBank = this.getEntriesFromTable("F;[1]-1-", bankAccount);
        for (int index = 0; index < bankAccount.size(); ++index) {
            int currentLineNumberTitreTabelle = (Integer)bankAccount.toArray()[index];
            value = this.getStringFormCode(cellesBank, currentLineNumberTitreTabelle, "01");
            if (!((String)value).isEmpty()) continue;
            PKeyTuple tuple = new PKeyTuple("F", "1", "01", "1");
            PKey appartenancePkey = new PKey(tuple, PKeyType.NUMBER, currentLineNumberTitreTabelle);
            this.addCellToTable2(formsMap, appartenancePkey, "1", currentLineNumberTitreTabelle);
        }
    }

    private void processRelevesDebiteurs(Map<String, DataSet> formsMap) {
        String NEW_TABLE_ID = "1";
        HashSet<Integer> titreTableDebiteurLineIndexes = new HashSet<Integer>();
        for (Map.Entry<PKey, Object> entry : this.valuesMap.entrySet()) {
            String txtValue;
            PKey pKey = entry.getKey();
            Object value = entry.getValue();
            if (value == null || !pKey.toExternalForm().startsWith("F;[2]-2-030;B;") && !pKey.toExternalForm().startsWith("F;[2]-2-031;B;") || !(txtValue = this.marshaller.marshall(value, pKey.pkType)).equals("true")) continue;
            titreTableDebiteurLineIndexes.addAll(pKey.indexes);
        }
        if (titreTableDebiteurLineIndexes.isEmpty()) {
            return;
        }
        ArrayList<Map.Entry<PKey, Object>> cellesDebiteur = this.getEntriesFromTable("F;[2]-2-", titreTableDebiteurLineIndexes);
        int maxLineIndex = Collections.max(titreTableDebiteurLineIndexes);
        for (int index = 0; index < titreTableDebiteurLineIndexes.size(); ++index) {
            int currentLineNumberTitreTabelle = (Integer)titreTableDebiteurLineIndexes.toArray()[index];
            Object value = this.getStringFormCode(cellesDebiteur, currentLineNumberTitreTabelle, "01");
            String newValue = "0";
            if (((String)value).equals("1")) {
                newValue = "100";
            }
            PKeyTuple tuple = new PKeyTuple("E", "55.10", "01", "1");
            PKey dettePkey = new PKey(tuple, PKeyType.NUMBER, maxLineIndex + index + 1);
            this.addCellToTable(formsMap, index, dettePkey, newValue);
            value = this.getStringFormCode(cellesDebiteur, currentLineNumberTitreTabelle, "01");
            newValue = "0";
            if (((String)value).equals("2")) {
                newValue = "100";
            }
            tuple = new PKeyTuple("E", "55.10", "02", "1");
            dettePkey = new PKey(tuple, PKeyType.NUMBER, maxLineIndex + index + 1);
            this.addCellToTable(formsMap, index, dettePkey, newValue);
            value = this.getStringFormCode(cellesDebiteur, currentLineNumberTitreTabelle, "01");
            newValue = "0";
            if (((String)value).equals("3")) {
                newValue = "100";
            }
            tuple = new PKeyTuple("E", "55.10", "03", "1");
            dettePkey = new PKey(tuple, PKeyType.NUMBER, maxLineIndex + index + 1);
            this.addCellToTable(formsMap, index, dettePkey, newValue);
            value = this.getStringFormCode(cellesDebiteur, currentLineNumberTitreTabelle, "30");
            tuple = new PKeyTuple("E", "55.10", "04", "1");
            dettePkey = new PKey(tuple, PKeyType.NUMBER, maxLineIndex + index + 1);
            this.addCellToTable(formsMap, index, dettePkey, (String)value);
            value = this.getStringFormCode(cellesDebiteur, currentLineNumberTitreTabelle, "31");
            tuple = new PKeyTuple("E", "55.10", "05", "1");
            dettePkey = new PKey(tuple, PKeyType.NUMBER, maxLineIndex + index + 1);
            this.addCellToTable(formsMap, index, dettePkey, (String)value);
            value = this.getStringFormCode(cellesDebiteur, currentLineNumberTitreTabelle, "02");
            tuple = new PKeyTuple("E", "55.10", "06", "1");
            dettePkey = new PKey(tuple, PKeyType.NUMBER, maxLineIndex + index + 1);
            this.addCellToTable(formsMap, index, dettePkey, (String)value);
            value = this.getStringFormCode(cellesDebiteur, currentLineNumberTitreTabelle, "10");
            tuple = new PKeyTuple("E", "55.10", "07", "1");
            dettePkey = new PKey(tuple, PKeyType.NUMBER, maxLineIndex + index + 1);
            this.addCellToTable(formsMap, index, dettePkey, (String)value);
            value = this.md.getYear() + "1231";
            tuple = new PKeyTuple("E", "55.10", "08", "1");
            dettePkey = new PKey(tuple, PKeyType.NUMBER, maxLineIndex + index + 1);
            this.addCellToTable(formsMap, index, dettePkey, (String)value);
            value = "cbdb";
            tuple = new PKeyTuple("E", "55.10", "09", "1");
            dettePkey = new PKey(tuple, PKeyType.NUMBER, maxLineIndex + index + 1);
            this.addCellToTable(formsMap, index, dettePkey, (String)value);
        }
    }

    private ArrayList<Map.Entry<PKey, Object>> getEntriesFromTable(String tableCode, Set<Integer> titreTableDebiteurLineIndexes) {
        ArrayList<Map.Entry<PKey, Object>> cellesDebiteur = new ArrayList<Map.Entry<PKey, Object>>();
        for (Map.Entry<PKey, Object> entry : this.valuesMap.entrySet()) {
            PKey pKey = entry.getKey();
            Object value = entry.getValue();
            if (value == null || !pKey.toExternalForm().startsWith(tableCode)) continue;
            for (int titreTableDebiteurLineIndex : titreTableDebiteurLineIndexes) {
                if (pKey.indexes.get(0) != titreTableDebiteurLineIndex) continue;
                cellesDebiteur.add(entry);
            }
        }
        return cellesDebiteur;
    }

    private String getStringFormCode(ArrayList<Map.Entry<PKey, Object>> cellesDebiteur, int titreTableDebiteurLineIndexes, String cellToSearch) {
        String value = "";
        for (Map.Entry<PKey, Object> cellDebiteur : cellesDebiteur) {
            PKey pkeyDebiteur = cellDebiteur.getKey();
            int cellDebituerLineNumber = pkeyDebiteur.indexes.get(0);
            if (cellDebituerLineNumber != titreTableDebiteurLineIndexes || !pkeyDebiteur.pkTuple.zelle.equals(cellToSearch)) continue;
            Object cellValue = cellDebiteur.getValue();
            value = cellDebiteur.getValue().toString();
            if (!(cellValue instanceof Date)) continue;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            value = sdf.format(cellValue);
        }
        return value;
    }

    private void addCellToTable(Map<String, DataSet> formsMap, int lineIndex, PKey dettePkey, String value) {
        if (value.equals("")) {
            return;
        }
        DataSet form = formsMap.get(dettePkey.pkTuple.dokument);
        if (form == null) {
            form = new DataSet();
            formsMap.put(dettePkey.pkTuple.dokument, form);
        }
        for (int i = 0; i < dettePkey.pkTuple.tableIds.size(); ++i) {
            DataSet line;
            String tableId = dettePkey.pkTuple.tableIds.get(i);
            Table table = form.tables.get(tableId);
            if (table == null) {
                table = new Table();
                form.tables.put(tableId, table);
            }
            if ((line = table.lines.get(lineIndex)) == null) {
                line = new DataSet();
                table.lines.put(lineIndex, line);
            }
            form = line;
        }
        form.values.add(new PKeyValuePair(dettePkey, value));
    }

    private void addCellToTable2(Map<String, DataSet> formsMap, PKey pKey, String value, int index) {
        if (value.equals("")) {
            return;
        }
        DataSet form = formsMap.get(pKey.pkTuple.dokument);
        if (form == null) {
            form = new DataSet();
            formsMap.put(pKey.pkTuple.dokument, form);
        }
        for (int i = 0; i < pKey.pkTuple.tableIds.size(); ++i) {
            DataSet line;
            String tableId = pKey.pkTuple.tableIds.get(i);
            Table table = form.tables.get(tableId);
            if (table == null) {
                table = new Table();
                form.tables.put(tableId, table);
            }
            if ((line = table.lines.get(index)) == null) {
                line = new DataSet();
                table.lines.put(index, line);
            }
            form = line;
        }
        form.values.add(new PKeyValuePair(pKey, value));
    }

    private void printDataSet(SMNamespace ns, SMOutputElement parentElt, DataSet dataSet) throws XMLStreamException {
        assert (parentElt != null && dataSet != null);
        Collections.sort(dataSet.values, new Comparator<PKeyValuePair>(){

            @Override
            public int compare(PKeyValuePair pair1, PKeyValuePair pair2) {
                int cmp = this.compare(pair1.pkey.pkTuple.ziffer, pair2.pkey.pkTuple.ziffer);
                if (cmp == 0) {
                    cmp = this.compare(pair1.pkey.pkTuple.zelle, pair2.pkey.pkTuple.zelle);
                }
                return cmp;
            }

            @Override
            private int compare(String s1, String s2) {
                String[] tokens1 = s1.split("\\.");
                String[] tokens2 = s2.split("\\.");
                for (int i = 0; i < tokens1.length && i < tokens2.length; ++i) {
                    int cmp = Integer.valueOf(tokens1[i]).compareTo(Integer.valueOf(tokens2[i]));
                    if (cmp == 0) continue;
                    return cmp;
                }
                return Integer.valueOf(tokens1.length).compareTo(tokens2.length);
            }
        });
        for (PKeyValuePair pKeyValuePair : dataSet.values) {
            SMOutputElement dr = parentElt.addElement(ns, "dr");
            dr.addAttribute("f", pKeyValuePair.pkey.pkTuple.ziffer);
            dr.addAttribute("c", pKeyValuePair.pkey.pkTuple.zelle);
            dr.addAttribute("v", pKeyValuePair.value);
        }
        for (Map.Entry entry : dataSet.tables.entrySet()) {
            SMOutputElement tableElt = parentElt.addElement(ns, "tb");
            tableElt.addAttribute("id", (String)entry.getKey());
            Table table = (Table)entry.getValue();
            for (DataSet line : table.lines.values()) {
                this.printDataSet(ns, tableElt.addElement(ns, "td"), line);
            }
        }
    }

    public @NonNull Map<PKey, Object> getValuesMap() {
        return this.valuesMap;
    }

    public void importWith(@NonNull GeTaxFileImporter taxFileImporter) throws ImportException {
        Objects.requireNonNull(taxFileImporter, "Importer cannot be null.");
        Map<String, ModelItemDTO> baseMap = this.pKeyRegistry.buildUpdateMap(this.valuesMap);
        baseMap.put("Stammdaten.Declaration.PeriodeTaxation", SharedUtils.createTouchedItem(this.md.getYear()));
        ImportContext ctx = taxFileImporter.getImportContext();
        ctx.getOldDataModel().putAll(baseMap);
        taxFileImporter.doImport("", true);
    }

    public @NonNull MetaData getMetaData() {
        return this.md;
    }

    static {
        XMLValidationSchemaFactory schemaFactory = XMLValidationSchemaFactory.newInstance((String)"http://www.w3.org/2001/XMLSchema");
        try {
            BARCODE_SCHEMA = schemaFactory.createSchema(Thread.currentThread().getContextClassLoader().getResourceAsStream("xml/getax_pp_barcode.xsd"));
        }
        catch (XMLStreamException e) {
            throw new InternalFailureException("Failed to read bundled schema.", e);
        }
        OS_IDENTIFIER_KEY = new PKey(new PKeyTuple("PG1", "8", "10", new String[0]), PKeyType.NUMBER, new Integer[0]);
        JVM_IDENTIFIER_PKEY = new PKey(new PKeyTuple("PG1", "8", "11", new String[0]), PKeyType.NUMBER, new Integer[0]);
    }

    public static class MetaData {
        private int year;
        private String name;
        private String firstName;
        private String lastname;
        private String address;
        private String city;
        private String zip;
        private String numeroContribuable;
        private @Nullable String codeDeclaration = null;
        private Boolean departDeces = false;

        public int getYear() {
            return this.year;
        }

        public @NonNull String getName() {
            return this.name;
        }

        public @NonNull String getFirstName() {
            return this.firstName;
        }

        public @NonNull String getLastname() {
            return this.lastname;
        }

        public @NonNull String getCity() {
            return this.city;
        }

        public @NonNull String getAddress() {
            return this.address;
        }

        public @NonNull String getZip() {
            return this.zip;
        }

        public @NonNull String getNumeroContribuable() {
            return this.numeroContribuable;
        }

        public @Nullable String getCodeDeclaration() {
            return this.codeDeclaration;
        }

        public Boolean getDepartDeces() {
            return this.departDeces;
        }
    }

    private static class TableContext {
        private int currentIndex = 1;

        private TableContext() {
        }
    }

    private static class DataSet {
        final List<PKeyValuePair> values = new ArrayList<PKeyValuePair>();
        final Map<String, Table> tables = new TreeMap<String, Table>();

        private DataSet() {
        }
    }

    private static class Table {
        final Map<Integer, DataSet> lines = new TreeMap<Integer, DataSet>();

        private Table() {
        }
    }

    private static class PKeyValuePair {
        final PKey pkey;
        final String value;

        private PKeyValuePair(PKey pkey, String value) {
            assert (pkey != null && !value.trim().isEmpty());
            this.pkey = pkey;
            this.value = value;
        }
    }
}

