/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.transfer.logic;

import ch.dvbern.tax.ge.pp.transfer.dto.DeducPersChargeDTO;
import ch.dvbern.tax.ge.pp.transfer.dto.EnfantDTO;
import ch.dvbern.tax.ge.pp.transfer.utils.DeductionPersChargeUtils;
import ch.dvbern.tax.ge.pp.transfer.utils.PersonneAChargeEnums;

public class DeductionEnfantUtils {
    public static DeducPersChargeDTO calculateDeductionForEnfant(EnfantDTO enfantDTO) {
        double chargeICC1 = DeductionPersChargeUtils.determineChargeICC1RevenuFortune(enfantDTO.getRevenu(), enfantDTO.getFortune());
        double chargeICC2 = chargeICC1 > 0.0 ? DeductionEnfantUtils.computeChargeICC2(enfantDTO) : 0.0;
        double chargeICC = chargeICC1 * chargeICC2;
        double chargeIFD = DeductionEnfantUtils.computeChargeIFD(enfantDTO);
        String baremeICC = DeductionEnfantUtils.computeBaremeICC(enfantDTO, chargeICC);
        String baremeIFD = DeductionEnfantUtils.computeBaremeIFD(enfantDTO);
        long ded6125ICC = DeductionEnfantUtils.compute6125ICC(enfantDTO, chargeICC);
        long ded5215ICC = DeductionEnfantUtils.compute5215ICC(chargeICC2);
        long ded5150ICC = DeductionEnfantUtils.compute5150ICC(enfantDTO, chargeICC2);
        long ded6120IFD = DeductionEnfantUtils.compute6120IFD(chargeIFD);
        long ded5200IFD = DeductionEnfantUtils.compute5200IFD(chargeIFD);
        long reducPourBaremeParental = DeductionEnfantUtils.computeReducPourBaremeParentalIFD(enfantDTO, chargeIFD);
        long nombreDeductionEntiere = DeductionPersChargeUtils.calculalteDeductionEntiere(chargeICC);
        long nombreDemiDeduction = DeductionPersChargeUtils.calculalteDeductionDemi(chargeICC);
        return new DeducPersChargeDTO(baremeICC, baremeIFD, chargeICC, chargeIFD, ded6125ICC, ded5215ICC, ded5150ICC, ded6120IFD, ded5200IFD, reducPourBaremeParental, nombreDeductionEntiere, nombreDemiDeduction);
    }

    private static String computeBaremeICC(EnfantDTO enfantDTO, double chargeICC) {
        if (chargeICC <= 0.0) {
            return "Sans splitting";
        }
        if (enfantDTO.isNotVisAvec()) {
            return "Sans splitting";
        }
        if (enfantDTO.getEnfantDe() == PersonneAChargeEnums.EnfantDe.COUPLE) {
            return "Splitting";
        }
        if (enfantDTO.getPensionAlimentaireRecueVerse() == PersonneAChargeEnums.PensionAlimentaire.PENSION_VERSE) {
            return "Sans splitting";
        }
        if (enfantDTO.getPensionAlimentaireRecueVerse() == PersonneAChargeEnums.PensionAlimentaire.PENSION_RECUE) {
            return "Splitting";
        }
        if (enfantDTO.isEnvoiArgentEtranger()) {
            return "Sans splitting";
        }
        if (enfantDTO.isNotGardeAlternee()) {
            return "Splitting";
        }
        if (enfantDTO.isPriseLegalCharge()) {
            return "Splitting partiel";
        }
        if (enfantDTO.isGardeAlternee().booleanValue() || enfantDTO.isParentViventEnsemble()) {
            return enfantDTO.isRevenuNetSuppAutreParent() ? "Splitting" : "Sans splitting";
        }
        if (enfantDTO.isRevenuBrutInfAmount()) {
            if (enfantDTO.isRevenuNetSuppAutreParent()) {
                return "Splitting";
            }
            return "Sans splitting";
        }
        return enfantDTO.isRevenuBrutInfAmountAutreParent() ? "Splitting" : "Sans splitting";
    }

    private static String computeBaremeIFD(EnfantDTO enfantDTO) {
        if (enfantDTO.isMajeur() && (enfantDTO.getProfession() == PersonneAChargeEnums.Activite.ETUDIANT_STOP || enfantDTO.getProfession() == PersonneAChargeEnums.Activite.EMPLOYE || enfantDTO.getProfession() == PersonneAChargeEnums.Activite.AUCUNE)) {
            return "C\u00e9libataire";
        }
        if (!enfantDTO.isVisAvec()) {
            return "C\u00e9libataire";
        }
        if (enfantDTO.getEnfantDe() == PersonneAChargeEnums.EnfantDe.COUPLE) {
            return "Mari\u00e9";
        }
        if (enfantDTO.getPensionAlimentaireRecueVerse() == PersonneAChargeEnums.PensionAlimentaire.PENSION_VERSE) {
            return "C\u00e9libataire";
        }
        if (enfantDTO.getPensionAlimentaireRecueVerse() == PersonneAChargeEnums.PensionAlimentaire.PENSION_RECUE) {
            return "Mari\u00e9";
        }
        if (enfantDTO.isEnvoiArgentEtranger()) {
            return "C\u00e9libataire";
        }
        if (enfantDTO.isNotGardeAlternee()) {
            return "Mari\u00e9";
        }
        if (enfantDTO.isPriseLegalCharge()) {
            return !enfantDTO.isRevenuNetSuppAutreParent() ? "Mari\u00e9" : "C\u00e9libataire";
        }
        if (enfantDTO.isGardeAlternee().booleanValue() || enfantDTO.isParentViventEnsemble()) {
            return enfantDTO.isRevenuNetSuppAutreParent() ? "Mari\u00e9" : "C\u00e9libataire";
        }
        if (enfantDTO.isRevenuBrutInfAmount()) {
            if (enfantDTO.isRevenuNetSuppAutreParent()) {
                return "Mari\u00e9";
            }
            return "C\u00e9libataire";
        }
        return enfantDTO.isRevenuBrutInfAmountAutreParent() ? "Mari\u00e9" : "C\u00e9libataire";
    }

    private static double computeChargeICC2(EnfantDTO enfantDTO) {
        if (enfantDTO.getAge() > 24L && (enfantDTO.getProfession() == PersonneAChargeEnums.Activite.EMPLOYE || enfantDTO.getProfession() == PersonneAChargeEnums.Activite.AUCUNE)) {
            return PersonneAChargeEnums.ChargeICC.PAS_DE_CHAGE.doubleValue;
        }
        if (enfantDTO.getEnfantDe() == PersonneAChargeEnums.EnfantDe.COUPLE) {
            return PersonneAChargeEnums.ChargeICC.CHARGE_ENTIERE.doubleValue;
        }
        if (enfantDTO.getPensionAlimentaireRecueVerse() == PersonneAChargeEnums.PensionAlimentaire.PENSION_VERSE) {
            if (enfantDTO.isMineur()) {
                return PersonneAChargeEnums.ChargeICC.PAS_DE_CHAGE.doubleValue;
            }
            if (enfantDTO.getAge() == 18L) {
                return enfantDTO.getMontantPension18() > 0L ? PersonneAChargeEnums.ChargeICC.DEMI_CHARGE.doubleValue : PersonneAChargeEnums.ChargeICC.PAS_DE_CHAGE.doubleValue;
            }
            return PersonneAChargeEnums.ChargeICC.DEMI_CHARGE.doubleValue;
        }
        if (enfantDTO.getPensionAlimentaireRecueVerse() == PersonneAChargeEnums.PensionAlimentaire.PENSION_RECUE) {
            if (enfantDTO.isMineur()) {
                return PersonneAChargeEnums.ChargeICC.CHARGE_ENTIERE.doubleValue;
            }
            return PersonneAChargeEnums.ChargeICC.DEMI_CHARGE.doubleValue;
        }
        if (enfantDTO.isEnvoiArgentEtranger()) {
            return PersonneAChargeEnums.ChargeICC.DEMI_CHARGE.doubleValue;
        }
        if (enfantDTO.getPensionAlimentaireRecueVerse() == PersonneAChargeEnums.PensionAlimentaire.AUCUNE_PENSION && enfantDTO.isNotVisAvec()) {
            return PersonneAChargeEnums.ChargeICC.PAS_DE_CHAGE.doubleValue;
        }
        if (enfantDTO.isNotGardeAlternee()) {
            return PersonneAChargeEnums.ChargeICC.CHARGE_ENTIERE.doubleValue;
        }
        if (enfantDTO.isPriseLegalCharge()) {
            return PersonneAChargeEnums.ChargeICC.DEMI_CHARGE.doubleValue;
        }
        if (enfantDTO.isRevenuBrutInfAmount()) {
            if (enfantDTO.isRevenuNetSuppAutreParent()) {
                return PersonneAChargeEnums.ChargeICC.DEMI_CHARGE.doubleValue;
            }
            return PersonneAChargeEnums.ChargeICC.PAS_DE_CHAGE.doubleValue;
        }
        if (enfantDTO.isRevenuBrutInfAmountAutreParent()) {
            return PersonneAChargeEnums.ChargeICC.CHARGE_ENTIERE.doubleValue;
        }
        if (enfantDTO.isGardeAlternee().booleanValue() || enfantDTO.isParentViventEnsemble()) {
            return PersonneAChargeEnums.ChargeICC.DEMI_CHARGE.doubleValue;
        }
        return PersonneAChargeEnums.ChargeICC.PAS_DE_CHAGE.doubleValue;
    }

    private static double computeChargeIFD(EnfantDTO enfantDTO) {
        if (enfantDTO.isMajeur() && (enfantDTO.getProfession() == PersonneAChargeEnums.Activite.ETUDIANT_STOP || enfantDTO.getProfession() == PersonneAChargeEnums.Activite.EMPLOYE || enfantDTO.getProfession() == PersonneAChargeEnums.Activite.AUCUNE)) {
            return PersonneAChargeEnums.ChargeICC.PAS_DE_CHAGE.doubleValue;
        }
        if (enfantDTO.getEnfantDe() == PersonneAChargeEnums.EnfantDe.COUPLE) {
            return PersonneAChargeEnums.ChargeICC.CHARGE_ENTIERE.doubleValue;
        }
        if (enfantDTO.getPensionAlimentaireRecueVerse() == PersonneAChargeEnums.PensionAlimentaire.PENSION_VERSE) {
            if (enfantDTO.isMineur()) {
                return PersonneAChargeEnums.ChargeICC.PAS_DE_CHAGE.doubleValue;
            }
            if (enfantDTO.getAge() == 18L) {
                return enfantDTO.getMontantPension18() >= 6800L ? PersonneAChargeEnums.ChargeICC.CHARGE_ENTIERE.doubleValue : PersonneAChargeEnums.ChargeICC.PAS_DE_CHAGE.doubleValue;
            }
            return enfantDTO.getMontantPension() >= 6800L ? PersonneAChargeEnums.ChargeICC.CHARGE_ENTIERE.doubleValue : PersonneAChargeEnums.ChargeICC.PAS_DE_CHAGE.doubleValue;
        }
        if (enfantDTO.getPensionAlimentaireRecueVerse() == PersonneAChargeEnums.PensionAlimentaire.PENSION_RECUE) {
            return PersonneAChargeEnums.ChargeICC.CHARGE_ENTIERE.doubleValue;
        }
        if (enfantDTO.isEnvoiArgentEtranger()) {
            if (enfantDTO.isMineur()) {
                return PersonneAChargeEnums.ChargeICC.DEMI_CHARGE.doubleValue;
            }
            return enfantDTO.getMontantEtranger() >= 6800L ? PersonneAChargeEnums.ChargeICC.CHARGE_ENTIERE.doubleValue : PersonneAChargeEnums.ChargeICC.PAS_DE_CHAGE.doubleValue;
        }
        if (enfantDTO.getPensionAlimentaireRecueVerse() == PersonneAChargeEnums.PensionAlimentaire.AUCUNE_PENSION && enfantDTO.isNotVisAvec()) {
            return PersonneAChargeEnums.ChargeICC.PAS_DE_CHAGE.doubleValue;
        }
        if (enfantDTO.isNotGardeAlternee()) {
            return PersonneAChargeEnums.ChargeICC.CHARGE_ENTIERE.doubleValue;
        }
        if (enfantDTO.isPriseLegalCharge()) {
            return enfantDTO.isMineur() ? PersonneAChargeEnums.ChargeICC.DEMI_CHARGE.doubleValue : PersonneAChargeEnums.ChargeICC.CHARGE_ENTIERE.doubleValue;
        }
        if (enfantDTO.isRevenuBrutInfAmount()) {
            if (enfantDTO.isRevenuNetSuppAutreParent()) {
                return enfantDTO.isMajeur() ? PersonneAChargeEnums.ChargeICC.CHARGE_ENTIERE.doubleValue : PersonneAChargeEnums.ChargeICC.DEMI_CHARGE.doubleValue;
            }
            return PersonneAChargeEnums.ChargeICC.PAS_DE_CHAGE.doubleValue;
        }
        if (enfantDTO.isRevenuBrutInfAmountAutreParent()) {
            return PersonneAChargeEnums.ChargeICC.CHARGE_ENTIERE.doubleValue;
        }
        if (enfantDTO.isGardeAlternee().booleanValue() || enfantDTO.isParentViventEnsemble()) {
            return enfantDTO.isMineur() ? PersonneAChargeEnums.ChargeICC.DEMI_CHARGE.doubleValue : PersonneAChargeEnums.ChargeICC.CHARGE_ENTIERE.doubleValue;
        }
        return PersonneAChargeEnums.ChargeICC.PAS_DE_CHAGE.doubleValue;
    }

    private static long compute6125ICC(EnfantDTO enfantDTO, double chargeICC) {
        long deduction = enfantDTO.getFraisDeGarde() > 0L ? 10508L : 13660L;
        return Math.round(chargeICC * (double)deduction);
    }

    private static long compute5215ICC(double chargeICC2) {
        return Math.round(959.0 * chargeICC2);
    }

    private static long compute5150ICC(EnfantDTO enfantDTO, double chargeICC2) {
        if (chargeICC2 <= 0.0 || enfantDTO.getFortune() > 43816L) {
            return 0L;
        }
        return Math.round(43816.0 * chargeICC2 - (double)enfantDTO.getFortune() * chargeICC2);
    }

    private static long compute6120IFD(double chargeIFD) {
        return Math.round(chargeIFD * 6800.0);
    }

    private static long compute5200IFD(double chargeIFD) {
        return Math.round(chargeIFD * 700.0);
    }

    private static long computeReducPourBaremeParentalIFD(EnfantDTO enfantDTO, double chargeIFD) {
        if (chargeIFD > 0.0 && enfantDTO.isVisAvec()) {
            if (enfantDTO.isParentViventEnsemble() || enfantDTO.isGardeAlternee().booleanValue()) {
                if (enfantDTO.isRevenuNetSuppAutreParent() ? enfantDTO.isParentViventEnsemble() || enfantDTO.isGardeAlternee() != false && !enfantDTO.isPriseLegalCharge() : enfantDTO.isGardeAlternee() != false && enfantDTO.isPriseLegalCharge()) {
                    return 263L;
                }
            } else {
                return 263L;
            }
        }
        return 0L;
    }
}

