/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import ch.dvbern.tax.common.transfer.dto.convert.IBANConverter;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class NoIBAN
extends IBANConverter {
    private static final String DUMMY_IBAN = "0";
    private static final Pattern NO_COUNTRY_PTN = Pattern.compile("[0-9]{2}.*");
    private final boolean allowDummy;

    public NoIBAN() {
        this(true);
    }

    public NoIBAN(boolean allowDummy) {
        this.allowDummy = allowDummy;
    }

    public String getObject(@Nullable String s, @Nullable OptionItemsDTO optionItems, @Nonnull AbstractConverter.ConverterContext ctx) throws AbstractConverter.ConvertException {
        if (s == null || s.length() <= 0) {
            return null;
        }
        s = s.replaceAll("\\s", "");
        s = s.toUpperCase();
        if (this.allowDummy && DUMMY_IBAN.equals(s)) {
            return s;
        }
        return super.getObject(s, optionItems, ctx);
    }

    public String getRenderedValue(@Nullable Object o, boolean readonly, @Nullable OptionItemsDTO optionItems, @Nonnull AbstractConverter.ConverterContext ctx) {
        if (DUMMY_IBAN.equals(o)) {
            return DUMMY_IBAN;
        }
        return super.getRenderedValue(o, readonly, optionItems, ctx);
    }
}

