/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import ch.dvbern.tax.ge.pp.transfer.dto.convert.NoContribuableConverter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class NoContribuableConverterSmall
extends NoContribuableConverter {
    private static final long serialVersionUID = 3258213941062574442L;
    private final Pattern patternValidate = Pattern.compile("(\\d\\d\\d)(\\.?)(\\d\\d)(\\.?)(\\d\\d\\d\\d)");
    private final Pattern patternRender = Pattern.compile("(\\d\\d\\d)(\\d\\d)(\\d\\d\\d\\d)");

    @Override
    public String getObject(@Nullable String s, @Nullable OptionItemsDTO optionItems, @Nonnull AbstractConverter.ConverterContext ctx) throws AbstractConverter.ConvertException {
        if (s == null || s.length() <= 0) {
            return null;
        }
        Matcher m = this.patternValidate.matcher(s);
        if (!m.matches()) {
            throw new AbstractConverter.ConvertException("error.format.noContribuable");
        }
        if (!super.isValid(s)) {
            throw new AbstractConverter.ConvertException("error.format.noContribuableAAA");
        }
        return s;
    }

    @Override
    public String getRenderedValue(@Nullable Object o, boolean readonly, @Nullable OptionItemsDTO optionItems, @Nonnull AbstractConverter.ConverterContext ctx) {
        Matcher m;
        if (o == null) {
            return "";
        }
        String s = o.toString();
        if (s.length() > 11) {
            s = s.substring(0, 11);
        }
        if ((m = this.patternRender.matcher(s)).matches()) {
            return m.group(1) + "." + m.group(2) + "." + m.group(3);
        }
        return s;
    }

    @Override
    @Nonnull
    public String getUserInputRegExpPattern() {
        return "[0-9]{1,3}(\\.?)[0-9]{0,2}(\\.?)[0-9]{0,4}";
    }
}

