/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class NoContribuableConverter
extends AbstractConverter<String> {
    private static final long serialVersionUID = 3258413941062578742L;
    private final Pattern patternValidate = Pattern.compile("(\\d\\d\\d)(\\.?)(\\d\\d)(\\.?)(\\d\\d\\d\\d)(\\-?)(\\d\\d?)");
    private final Pattern patternRender = Pattern.compile("(\\d\\d\\d)(\\d\\d)(\\d\\d\\d\\d)(\\d\\d?)");
    private final Pattern patternValidate2 = Pattern.compile("(\\d\\d\\d)(\\.?)(\\d\\d)(\\.?)(\\d\\d\\d\\d)");
    private final Pattern patternRender2 = Pattern.compile("(\\d\\d\\d)(\\d\\d)(\\d\\d\\d\\d)");

    public NoContribuableConverter() {
        super(String.class);
    }

    public String getObject(@Nullable String s, @Nullable OptionItemsDTO optionItems, @Nonnull AbstractConverter.ConverterContext ctx) throws AbstractConverter.ConvertException {
        if (s == null || s.length() <= 0) {
            return null;
        }
        Matcher m = this.patternValidate.matcher(s);
        Matcher m2 = this.patternValidate2.matcher(s);
        if (!m.matches() && !m2.matches()) {
            throw new AbstractConverter.ConvertException("error.format.noContribuable");
        }
        if (!this.isValid(s)) {
            throw new AbstractConverter.ConvertException("error.format.noContribuableAAA");
        }
        return s;
    }

    public String getRenderedValue(@Nullable Object o, boolean readonly, @Nullable OptionItemsDTO optionItems, @Nonnull AbstractConverter.ConverterContext ctx) {
        if (o == null) {
            return "";
        }
        Matcher m = this.patternRender.matcher(o.toString());
        if (m.matches()) {
            return m.group(1) + "." + m.group(2) + "." + m.group(3) + "-" + m.group(4);
        }
        Matcher m2 = this.patternRender2.matcher(o.toString());
        if (m2.matches()) {
            return m2.group(1) + "." + m2.group(2) + "." + m2.group(3);
        }
        return o.toString();
    }

    @Nonnull
    public String getUserInputRegExpPattern() {
        return "[0-9]{1,3}(\\.?)[0-9]{0,2}(\\.?)[0-9]{0,4}(\\-?)[0-9]{0,2}";
    }

    protected boolean isValid(String sZpv) {
        if (sZpv.trim().equals("")) {
            return true;
        }
        return !(sZpv = NoContribuableConverter.removeAllNonDigits(sZpv)).equals("000000000") && !sZpv.equals("0000000000");
    }

    private static String removeAllNonDigits(String sNoContr) {
        int stringLength = sNoContr.length();
        char[] characters = sNoContr.toCharArray();
        StringBuilder pureDigits = new StringBuilder();
        for (int i = 0; i < stringLength; ++i) {
            char character = characters[i];
            if (!Character.isDigit(character)) continue;
            pureDigits.append(character);
        }
        return pureDigits.toString();
    }
}

