/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import ch.dvbern.tax.common.transfer.dto.convert.IntConverter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LongMaxLengthConverter
extends AbstractConverter<Long> {
    private static final long serialVersionUID = 3763124887723475257L;
    private final Pattern pattern = Pattern.compile("[0-9]*");
    private final int maxLength;
    private String errorMax = "";

    public LongMaxLengthConverter(int maxLength) {
        super(Long.class);
        this.maxLength = maxLength;
        this.errorMax = Integer.toString(maxLength);
    }

    public Long getObject(@Nullable String s, @Nullable OptionItemsDTO optionItems, @Nonnull AbstractConverter.ConverterContext ctx) throws AbstractConverter.ConvertException {
        if (s == null || s.length() <= 0) {
            return null;
        }
        String digitonly = s.replaceAll("[^\\d]", "");
        if (digitonly.length() > this.maxLength) {
            throw new AbstractConverter.ConvertException("error.format.int-simple.max." + this.errorMax);
        }
        Matcher m = this.pattern.matcher(digitonly);
        if (!m.matches()) {
            throw new AbstractConverter.ConvertException("error.format.int-simple");
        }
        return Long.valueOf(digitonly);
    }

    public String getRenderedValue(@Nullable Object o, boolean readonly, @Nullable OptionItemsDTO optionItems, @Nonnull AbstractConverter.ConverterContext ctx) {
        return IntConverter.getRenderValue((Object)o, (boolean)readonly, (boolean)true);
    }

    @Nonnull
    public String getUserInputRegExpPattern() {
        return "[0-9'\u2019]*";
    }
}

