/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.repartition;

import ch.dvbern.tax.ge.pp.calculimpot.repartition.RepartitionCivilite;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.utils.enums.RepartitionMode;
import ch.dvbern.tax.ge.pp.repartition.RepartitionDataSourceHolder;
import ch.dvbern.tax.ge.pp.repartition.RepartitionVariable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepartitionVariableSelect {
    private static final Logger LOG = LoggerFactory.getLogger(RepartitionVariableSelect.class);
    private static final String AND = " AND ";
    private static final Map<String, List<RepartitionVariable>> CACHE = new ConcurrentHashMap<String, List<RepartitionVariable>>();
    private final DataSource dataSource = RepartitionDataSourceHolder.getDataSource();
    private Boolean whereSigne;
    private Boolean whereRevenuRendementFortune;
    private Boolean whereCalcule;
    private Boolean whereICCParticipeAssiette;
    private Boolean whereIFDParticipeAssiette;
    private boolean whereFortuneLibelleNotEmpty = false;
    private boolean whereRevenuLibelleNotEmpty = false;
    private List<String> whereCodeIn;
    private List<String> whereCodeNotIn;
    private List<String> whereRubriqueNotIn;
    private String whereFortuneRepartitionCommunale;
    private String whereFortuneRepartitionCommunaleNot;
    private String whereFortuneRepartitionCantonale;
    private String whereFortuneRepartitionCantonaleNot;
    private String whereRevenuRepartitionCommunale;
    private String whereRevenuRepartitionCommunaleNot;
    private String whereRevenuRepartitionCantonale;
    private String whereRevenuRepartitionCantonaleNot;
    private String whereRevenuRepartitionFederale;
    private String whereRevenuRepartitionFederaleNot;
    private String whereRevenuRepartitionFederaleQuasiResident;
    private String whereRevenuRepartitionFederaleQuasiResidentNot;
    private String whereRubrique;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RepartitionVariable> getVariable() throws SQLException {
        List<RepartitionVariable> variables;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultat = null;
        try {
            connection = this.dataSource.getConnection();
            statement = connection.createStatement();
            String whereString = this.getWhere().toString();
            StringBuilder sb = new StringBuilder(500);
            sb.append("SELECT * FROM REPARTITION a, REPARTITION_KEYS b WHERE ");
            sb.append(whereString);
            sb.append(" ORDER BY a.CODE ASC");
            String sql = sb.toString();
            variables = CACHE.get(sql);
            if (variables == null) {
                resultat = statement.executeQuery(sb.toString());
                variables = new ArrayList<RepartitionVariable>();
                while (resultat.next()) {
                    variables.add(this.getRepartitionVariable(resultat));
                }
                CACHE.put(sql, variables);
            }
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (resultat != null) {
                    resultat.close();
                }
            }
            catch (Exception e) {
                LOG.trace("Error shutting down HSQLDB");
            }
        }
        return variables;
    }

    private RepartitionVariable getRepartitionVariable(ResultSet resultat) throws SQLException {
        RepartitionVariable variable = new RepartitionVariable();
        variable.setCode(resultat.getString("CODE"));
        variable.setLibelle(resultat.getString("LIBELLE"));
        variable.setCivilite(RepartitionCivilite.fromString(resultat.getString("CIVILITE")));
        variable.setRubrique(resultat.getString("RUBRIQUE"));
        variable.setKeyCantonaleFortune(this.getString(resultat, "KEY_FORTUNE"));
        variable.setKeyCantonaleRevenu(this.getString(resultat, "KEY_REVENU"));
        variable.setKeyFortuneCommunale(resultat.getString("KEY_FORTUNE_COMMUNALE"));
        variable.setKeyRevenuCommunal(this.getString(resultat, "KEY_REVENU_COMMUNAL"));
        variable.setKeyFortuneInternationale(this.getString(resultat, "KEY_FORTUNE_INTERNATIONALE"));
        variable.setKeyRevenuInternational(this.getString(resultat, "KEY_REVENU_INTERNATIONAL"));
        variable.setLocalite(this.getString(resultat, "LOCALITE"));
        variable.setCanton(this.getString(resultat, "CANTON"));
        variable.setTable(this.getString(resultat, "KEY_TABLE"));
        variable.setModeRepartitionFortune(this.getString(resultat, "FT_REPART_CANTONALE"));
        variable.setModeRepartitionIntercantonaleRevenu(this.getString(resultat, "RV_REPART_CANTONALE"));
        variable.setModeRepartitionInternationaleRevenu(this.getString(resultat, "RV_REPART_FEDERALE"));
        variable.setModeRepartitionInternationaleRevenuQuasiResident(this.getString(resultat, "RV_REPART_FEDERALE_QR"));
        variable.setModeRepartitionFortuneCommunale(this.getString(resultat, "FT_REPART_COMMUNALE"));
        variable.setModeRepartitionRevenuCommunale(this.getString(resultat, "RV_REPART_COMMUNALE"));
        variable.setReferencedKey(this.getString(resultat, "REFERENCED_KEY"));
        variable.setSigne(resultat.getBoolean("SIGNE"));
        return variable;
    }

    private String getString(ResultSet rs, String name) throws SQLException {
        assert (rs != null && name != null);
        String val = rs.getString(name);
        return val == null ? "" : val;
    }

    private StringBuilder getWhere() {
        List<String> rubriqueNotInList;
        List<String> codeNotInList;
        StringBuilder where = new StringBuilder(400);
        where.append(" a.CODE = b.CODE ");
        this.appendBoolean(where, "a.SIGNE", this.getWhereSigne());
        if (this.isWhereFortuneLibelleNotEmpty()) {
            where.append(AND);
            where.append(" (a.FT_LIBELLE IS NOT NULL) ");
        }
        if (this.isWhereRevenuLibelleNotEmpty()) {
            where.append(AND);
            where.append(" (a.RV_LIBELLE IS NOT NULL) ");
        }
        this.appendBoolean(where, "a.ICC_PARTICIPE_ASSIETTE", this.getWhereICCParticipeAssiette());
        this.appendBoolean(where, "a.IFD_PARTICIPE_ASSIETTE", this.getWhereIFDParticipeAssiette());
        List<String> codeInList = this.getWhereCodeIn();
        if (codeInList != null && !codeInList.isEmpty()) {
            where.append(AND);
            where.append("b.CODE in (");
            this.appendCodesFromList(where, codeInList);
        }
        if ((codeNotInList = this.getWhereCodeNotIn()) != null && !codeNotInList.isEmpty()) {
            where.append(AND);
            where.append("b.CODE not in (");
            this.appendCodesFromList(where, codeNotInList);
        }
        if ((rubriqueNotInList = this.getWhereRubriqueNotIn()) != null && !rubriqueNotInList.isEmpty()) {
            where.append(AND);
            where.append("a.RUBRIQUE not in (");
            this.appendCodesFromList(where, rubriqueNotInList);
        }
        this.appendString(where, "FT_REPART_COMMUNALE", this.getWhereFortuneRepartitionCommunale());
        this.appendNotString(where, "FT_REPART_COMMUNALE", this.getWhereFortuneRepartitionCommunaleNot());
        this.appendString(where, "FT_REPART_CANTONALE", this.getWhereFortuneRepartitionCantonale());
        this.appendNotString(where, "FT_REPART_CANTONALE", this.getWhereFortuneRepartitionCantonaleNot());
        this.appendString(where, "RV_REPART_COMMUNALE", this.getWhereRevenuRepartitionCommunale());
        this.appendNotString(where, "RV_REPART_COMMUNALE", this.getWhereRevenuRepartitionCommunaleNot());
        this.appendString(where, "RV_REPART_CANTONALE", this.getWhereRevenuRepartitionCantonale());
        this.appendNotString(where, "RV_REPART_CANTONALE", this.getWhereRevenuRepartitionCantonaleNot());
        this.appendString(where, "RV_REPART_FEDERALE", this.getWhereRevenuRepartitionFederale());
        this.appendNotString(where, "RV_REPART_FEDERALE", this.getWhereRevenuRepartitionFederaleNot());
        if (this.getWhereRevenuRepartitionFederaleQuasiResident() != null && this.getWhereRevenuRepartitionFederaleQuasiResident().length() > 0) {
            where.append(" AND (");
            where.append("a.RV_REPART_FEDERALE = '").append(this.getWhereRevenuRepartitionFederaleQuasiResident()).append("' ");
            where.append(" OR ");
            where.append("a.RV_REPART_FEDERALE_QR = '").append(this.getWhereRevenuRepartitionFederaleQuasiResident()).append("' ");
            where.append(" ) ");
        }
        if (this.getWhereRevenuRepartitionFederaleQuasiResidentNot() != null && this.getWhereRevenuRepartitionFederaleQuasiResidentNot().length() > 0) {
            this.appendNotString(where, "a.RV_REPART_FEDERALE", this.getWhereRevenuRepartitionFederaleQuasiResidentNot());
            this.appendNotString(where, "a.RV_REPART_FEDERALE_QR", this.getWhereRevenuRepartitionFederaleQuasiResidentNot());
        }
        this.appendBoolean(where, "RV_RENDEMENT_FORTUNE", this.getWhereRevenuRendementFortune());
        this.appendBoolean(where, "a.CALCULE", this.getWhereCalcule());
        this.appendString(where, "a.RUBRIQUE", this.getWhereRubrique());
        return where;
    }

    private void appendString(StringBuilder where, String columnName, String value) {
        if (value != null && value.length() > 0) {
            where.append(AND);
            where.append(columnName).append(" = '").append(value).append("'");
        }
    }

    private void appendNotString(StringBuilder where, String columnName, String value) {
        if (value != null && value.length() > 0) {
            where.append(AND);
            where.append("( ").append(columnName).append(" IS NULL OR ").append(columnName).append(" != '").append(value).append("' )");
        }
    }

    private void appendBoolean(StringBuilder where, String columnName, Boolean value) {
        if (value != null) {
            where.append(AND);
            where.append(columnName).append(" = ").append(value != false ? 1 : 0);
        }
    }

    private void appendCodesFromList(StringBuilder where, List<String> codeInList) {
        for (int i = 0; i < codeInList.size(); ++i) {
            where.append("'").append(codeInList.get(i)).append("'");
            if (i >= codeInList.size() - 1) continue;
            where.append(", ");
        }
        where.append(")");
    }

    public Boolean getWhereSigne() {
        return this.whereSigne;
    }

    public void setWhereSigne(Boolean whereSigne) {
        this.whereSigne = whereSigne;
    }

    public boolean isWhereFortuneLibelleNotEmpty() {
        return this.whereFortuneLibelleNotEmpty;
    }

    public void setWhereFortuneLibelleNotEmpty(boolean whereFortuneLibelleNotEmpty) {
        this.whereFortuneLibelleNotEmpty = whereFortuneLibelleNotEmpty;
    }

    public Boolean getWhereICCParticipeAssiette() {
        return this.whereICCParticipeAssiette;
    }

    public void setWhereICCParticipeAssiette(Boolean whereICCParticipeAssiette) {
        this.whereICCParticipeAssiette = whereICCParticipeAssiette;
    }

    public List<String> getWhereCodeIn() {
        return this.whereCodeIn;
    }

    public void setWhereCodeIn(List<String> whereCodeIn) {
        this.whereCodeIn = whereCodeIn;
    }

    public String getWhereFortuneRepartitionCantonale() {
        return this.whereFortuneRepartitionCantonale;
    }

    public void setWhereFortuneRepartitionCantonale(RepartitionMode whereFortuneRepartitionCantonale) {
        this.whereFortuneRepartitionCantonale = whereFortuneRepartitionCantonale.toString();
    }

    public String getWhereFortuneRepartitionCantonaleNot() {
        return this.whereFortuneRepartitionCantonaleNot;
    }

    public void setWhereFortuneRepartitionCantonaleNot(RepartitionMode whereFortuneRepartitionCantonaleNot) {
        this.whereFortuneRepartitionCantonaleNot = whereFortuneRepartitionCantonaleNot.toString();
    }

    public Boolean getWhereRevenuRendementFortune() {
        return this.whereRevenuRendementFortune;
    }

    public void setWhereRevenuRendementFortune(Boolean whereRevenuRendementFortune) {
        this.whereRevenuRendementFortune = whereRevenuRendementFortune;
    }

    public boolean isWhereRevenuLibelleNotEmpty() {
        return this.whereRevenuLibelleNotEmpty;
    }

    public void setWhereRevenuLibelleNotEmpty(boolean whereRevenuLibelleNotEmpty) {
        this.whereRevenuLibelleNotEmpty = whereRevenuLibelleNotEmpty;
    }

    public String getWhereRevenuRepartitionCantonale() {
        return this.whereRevenuRepartitionCantonale;
    }

    public void setWhereRevenuRepartitionCantonale(RepartitionMode whereRevenuRepartitionCantonale) {
        this.whereRevenuRepartitionCantonale = whereRevenuRepartitionCantonale.toString();
    }

    public String getWhereRevenuRepartitionCantonaleNot() {
        return this.whereRevenuRepartitionCantonaleNot;
    }

    public void setWhereRevenuRepartitionCantonaleNot(RepartitionMode whereRevenuRepartitionCantonaleNot) {
        this.whereRevenuRepartitionCantonaleNot = whereRevenuRepartitionCantonaleNot.toString();
    }

    public Boolean getWhereCalcule() {
        return this.whereCalcule;
    }

    public void setWhereCalcule(Boolean whereCalcule) {
        this.whereCalcule = whereCalcule;
    }

    public String getWhereRubrique() {
        return this.whereRubrique;
    }

    public void setWhereRubrique(String whereRubrique) {
        this.whereRubrique = whereRubrique;
    }

    public List<String> getWhereRubriqueNotIn() {
        return this.whereRubriqueNotIn;
    }

    public void setWhereRubriqueNotIn(List<String> whereRubriqueNotIn) {
        this.whereRubriqueNotIn = whereRubriqueNotIn;
    }

    public Boolean getWhereIFDParticipeAssiette() {
        return this.whereIFDParticipeAssiette;
    }

    public void setWhereIFDParticipeAssiette(Boolean whereIFDParticipeAssiette) {
        this.whereIFDParticipeAssiette = whereIFDParticipeAssiette;
    }

    public String getWhereRevenuRepartitionFederale() {
        return this.whereRevenuRepartitionFederale;
    }

    public void setWhereRevenuRepartitionFederale(RepartitionMode whereRevenuRepartitionFederale) {
        this.whereRevenuRepartitionFederale = whereRevenuRepartitionFederale.toString();
    }

    public String getWhereRevenuRepartitionFederaleNot() {
        return this.whereRevenuRepartitionFederaleNot;
    }

    public void setWhereRevenuRepartitionFederaleNot(RepartitionMode whereRevenuRepartitionFederaleNot) {
        this.whereRevenuRepartitionFederaleNot = whereRevenuRepartitionFederaleNot.toString();
    }

    public List<String> getWhereCodeNotIn() {
        return this.whereCodeNotIn;
    }

    public void setWhereCodeNotIn(ArrayList<String> whereCodeNotIn) {
        this.whereCodeNotIn = whereCodeNotIn;
    }

    public String getWhereRevenuRepartitionFederaleQuasiResident() {
        return this.whereRevenuRepartitionFederaleQuasiResident;
    }

    public void setWhereRevenuRepartitionFederaleQuasiResident(RepartitionMode whereRevenuRepartitionFederaleQuasiResident) {
        this.whereRevenuRepartitionFederaleQuasiResident = whereRevenuRepartitionFederaleQuasiResident.toString();
    }

    public String getWhereRevenuRepartitionFederaleQuasiResidentNot() {
        return this.whereRevenuRepartitionFederaleQuasiResidentNot;
    }

    public void setWhereRevenuRepartitionFederaleQuasiResidentNot(RepartitionMode whereRevenuRepartitionFederaleQuasiResidentNot) {
        this.whereRevenuRepartitionFederaleQuasiResidentNot = whereRevenuRepartitionFederaleQuasiResidentNot.toString();
    }

    public String getWhereFortuneRepartitionCommunale() {
        return this.whereFortuneRepartitionCommunale;
    }

    public void setWhereFortuneRepartitionCommunale(RepartitionMode whereFortuneRepartitionCommunale) {
        this.whereFortuneRepartitionCommunale = whereFortuneRepartitionCommunale.toString();
    }

    public String getWhereFortuneRepartitionCommunaleNot() {
        return this.whereFortuneRepartitionCommunaleNot;
    }

    public void setWhereFortuneRepartitionCommunaleNot(RepartitionMode whereFortuneRepartitionCommunaleNot) {
        this.whereFortuneRepartitionCommunaleNot = whereFortuneRepartitionCommunaleNot.toString();
    }

    public String getWhereRevenuRepartitionCommunale() {
        return this.whereRevenuRepartitionCommunale;
    }

    public void setWhereRevenuRepartitionCommunale(RepartitionMode whereRevenuRepartitionCommunale) {
        this.whereRevenuRepartitionCommunale = whereRevenuRepartitionCommunale.toString();
    }

    public String getWhereRevenuRepartitionCommunaleNot() {
        return this.whereRevenuRepartitionCommunaleNot;
    }

    public void setWhereRevenuRepartitionCommunaleNot(RepartitionMode whereRevenuRepartitionCommunaleNot) {
        this.whereRevenuRepartitionCommunaleNot = whereRevenuRepartitionCommunaleNot.toString();
    }
}

