/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.repartition;

import ch.dvbern.tax.common.transfer.failure.ApplicationException;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.RepartitionCivilite;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.utils.enums.RepartitionType;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.utils.enums.RevenuFortune;

public class RepartitionVariable {
    private RepartitionCivilite civilite;
    private String code = null;
    private String libelle = null;
    private String rubrique = null;
    private String keyCantonaleFortune = null;
    private String keyCantonaleRevenu = null;
    private String keyFortuneInternationale = null;
    private String keyRevenuInternational = null;
    private String keyFortuneCommunale = null;
    private String keyRevenuCommunal = null;
    private String localite = null;
    private String canton = null;
    private String table = null;
    private String modeRepartitionFortune = null;
    private String modeRepartitionIntercantonaleRevenu = null;
    private String modeRepartitionInternationaleRevenu = null;
    private String modeRepartitionInternationaleRevenuQuasiResident = null;
    private String modeRepartitionFortuneCommunale = null;
    private String modeRepartitionRevenuCommunale = null;
    private String referencedKey = null;
    private boolean signe = true;

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getKeyCantonale(RevenuFortune keyType) {
        if (RevenuFortune.FORTUNE.equals((Object)keyType)) {
            return this.getKeyCantonaleFortune();
        }
        if (RevenuFortune.REVENU.equals((Object)keyType)) {
            return this.getKeyCantonaleRevenu();
        }
        throw new ApplicationException("Invalid key type: " + keyType);
    }

    public String getKeyInternationale(RevenuFortune keyType) {
        if (RevenuFortune.FORTUNE.equals((Object)keyType)) {
            return this.getKeyFortuneInternationale();
        }
        if (RevenuFortune.REVENU.equals((Object)keyType)) {
            return this.getKeyRevenuInternational();
        }
        throw new ApplicationException("Invalid key type: " + keyType);
    }

    public String getKeyCommunale(RevenuFortune keyType) {
        if (RevenuFortune.FORTUNE.equals((Object)keyType)) {
            return this.getKeyFortuneCommunale();
        }
        if (RevenuFortune.REVENU.equals((Object)keyType)) {
            return this.getKeyRevenuCommunal();
        }
        throw new ApplicationException("Invalid key type: " + keyType);
    }

    public String getModeRepartitionFromType(RepartitionType typeRepartition) {
        if (RepartitionType.FORTUNE.equals((Object)typeRepartition)) {
            return this.getModeRepartitionFortune();
        }
        if (RepartitionType.FORTUNE_COMMUNALE.equals((Object)typeRepartition)) {
            return this.getModeRepartitionFortuneCommunale();
        }
        if (RepartitionType.REVENU_COMMUNAL.equals((Object)typeRepartition)) {
            return this.getModeRepartitionRevenuCommunale();
        }
        if (RepartitionType.REVENU_CANTONAL.equals((Object)typeRepartition)) {
            return this.getModeRepartitionIntercantonaleRevenu();
        }
        if (RepartitionType.REVENU_NATIONAL.equals((Object)typeRepartition)) {
            return this.getModeRepartitionInternationaleRevenu();
        }
        if (RepartitionType.REVENU_NATIONAL_QUASI_RESIDENT.equals((Object)typeRepartition)) {
            if (this.getModeRepartitionInternationaleRevenuQuasiResident() != null && this.getModeRepartitionInternationaleRevenuQuasiResident().length() > 0) {
                return this.getModeRepartitionInternationaleRevenuQuasiResident();
            }
            return this.getModeRepartitionInternationaleRevenu();
        }
        throw new ApplicationException("Invalid type: " + typeRepartition);
    }

    public String getKeyCantonaleFortune() {
        return this.keyCantonaleFortune;
    }

    public void setKeyCantonaleFortune(String keyCantonaleFortune) {
        this.keyCantonaleFortune = keyCantonaleFortune;
    }

    public String getLocalite() {
        return this.localite;
    }

    public void setLocalite(String localite) {
        this.localite = localite;
    }

    public String getCanton() {
        return this.canton;
    }

    public void setCanton(String canton) {
        this.canton = canton;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public String getModeRepartitionFortune() {
        return this.modeRepartitionFortune;
    }

    public void setModeRepartitionFortune(String modeRepartitionFortune) {
        this.modeRepartitionFortune = modeRepartitionFortune;
    }

    public String getModeRepartitionIntercantonaleRevenu() {
        return this.modeRepartitionIntercantonaleRevenu;
    }

    public void setModeRepartitionIntercantonaleRevenu(String modeRepartitionRevenu) {
        this.modeRepartitionIntercantonaleRevenu = modeRepartitionRevenu;
    }

    public String getModeRepartitionInternationaleRevenu() {
        return this.modeRepartitionInternationaleRevenu;
    }

    public void setModeRepartitionInternationaleRevenu(String modeRepartitionRevenu) {
        this.modeRepartitionInternationaleRevenu = modeRepartitionRevenu;
    }

    public String getLibelle() {
        return this.libelle;
    }

    public void setLibelle(String libelle) {
        this.libelle = libelle;
    }

    public RepartitionCivilite getCivilite() {
        return this.civilite;
    }

    public void setCivilite(RepartitionCivilite civilite) {
        this.civilite = civilite;
    }

    public String toString() {
        return "RepartitionVariable [canton=" + this.canton + ", civilite=" + this.civilite.toString() + ", code=" + this.code + ", keyFortune=" + this.keyCantonaleFortune + ", keyFortuneInternationale=" + this.keyFortuneInternationale + ", keyRevenu=" + this.keyCantonaleRevenu + ", keyRevenuInternational=" + this.keyRevenuInternational + ", libelle=" + this.libelle + ", localite=" + this.localite + ", modeRepartitionFortune=" + this.modeRepartitionFortune + ", modeRepartitionRevenu=" + this.modeRepartitionIntercantonaleRevenu + ", referencedKey=" + this.referencedKey + ", rubrique=" + this.rubrique + ", signe=" + this.signe + ", table=" + this.table + "]";
    }

    public String getReferencedKey() {
        return this.referencedKey;
    }

    public void setReferencedKey(String referencedKey) {
        this.referencedKey = referencedKey;
    }

    public boolean hasReferencedKey() {
        return this.referencedKey != null && this.referencedKey.length() > 0;
    }

    public String getKeyCantonaleRevenu() {
        return this.keyCantonaleRevenu;
    }

    public void setKeyCantonaleRevenu(String keyCantonaleRevenu) {
        this.keyCantonaleRevenu = keyCantonaleRevenu;
    }

    public boolean isSigne() {
        return this.signe;
    }

    public void setSigne(boolean signe) {
        this.signe = signe;
    }

    public String getRubrique() {
        return this.rubrique;
    }

    public void setRubrique(String rubrique) {
        this.rubrique = rubrique;
    }

    public String getKeyFortuneInternationale() {
        return this.keyFortuneInternationale;
    }

    public void setKeyFortuneInternationale(String keyFortuneInternationale) {
        this.keyFortuneInternationale = keyFortuneInternationale;
    }

    public String getKeyRevenuInternational() {
        return this.keyRevenuInternational;
    }

    public void setKeyRevenuInternational(String keyRevenuInternational) {
        this.keyRevenuInternational = keyRevenuInternational;
    }

    public String getModeRepartitionInternationaleRevenuQuasiResident() {
        return this.modeRepartitionInternationaleRevenuQuasiResident;
    }

    public void setModeRepartitionInternationaleRevenuQuasiResident(String modeRepartitionInternationaleRevenuQuasiResident) {
        this.modeRepartitionInternationaleRevenuQuasiResident = modeRepartitionInternationaleRevenuQuasiResident;
    }

    public String getModeRepartitionFortuneCommunale() {
        return this.modeRepartitionFortuneCommunale;
    }

    public void setModeRepartitionFortuneCommunale(String modeRepartitionFortuneCommunale) {
        this.modeRepartitionFortuneCommunale = modeRepartitionFortuneCommunale;
    }

    public String getKeyFortuneCommunale() {
        return this.keyFortuneCommunale;
    }

    public void setKeyFortuneCommunale(String keyFortuneCommunale) {
        this.keyFortuneCommunale = keyFortuneCommunale;
    }

    public String getKeyRevenuCommunal() {
        return this.keyRevenuCommunal;
    }

    public void setKeyRevenuCommunal(String keyRevenuCommunal) {
        this.keyRevenuCommunal = keyRevenuCommunal;
    }

    public String getModeRepartitionRevenuCommunale() {
        return this.modeRepartitionRevenuCommunale;
    }

    public void setModeRepartitionRevenuCommunale(String modeRepartitionRevenuCommunale) {
        this.modeRepartitionRevenuCommunale = modeRepartitionRevenuCommunale;
    }
}

