/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.repartition;

import au.com.bytecode.opencsv.CSVReader;
import ch.dvbern.tax.ge.pp.repartition.RepartitionDataSourceProvider;
import ch.dvbern.tax.ge.pp.utils.InternalFailureException;
import ch.dvbern.tax.ge.pp.utils.ServiceFactory;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RepartitionDataSourceHolder {
    private static final Logger LOG = LoggerFactory.getLogger(RepartitionDataSourceHolder.class);
    private static final RepartitionDataSourceProvider PROVIDER = ServiceFactory.getInstance().newRepartitionDataSourceProvider();
    private static DataSource dataSource;

    private RepartitionDataSourceHolder() {
    }

    public static synchronized DataSource getDataSource() throws SQLException {
        DataSource ds = dataSource;
        if (ds == null) {
            ds = PROVIDER.getDataSource();
            RepartitionDataSourceProvider.InitializationMode initMode = PROVIDER.getInitializationMode();
            boolean initializeSchema = false;
            switch (initMode) {
                case SCHEMA_AND_DATA: {
                    initializeSchema = true;
                }
                case DATA: {
                    RepartitionDataSourceHolder.initialize(ds, initializeSchema);
                    break;
                }
                case NONE: {
                    break;
                }
                default: {
                    assert (false) : "Unknown initialization mode: " + initMode;
                    break;
                }
            }
            dataSource = ds;
        }
        return ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initialize(DataSource ds, boolean initializeSchema) throws SQLException {
        assert (ds != null);
        Connection con = ds.getConnection();
        long startTime = System.currentTimeMillis();
        try {
            RepartitionDataSourceHolder.loadTable(con, "REPARTITION", "repart_source.csv", initializeSchema);
            RepartitionDataSourceHolder.loadTable(con, "REPARTITION_KEYS", "repart_keys.csv", initializeSchema);
            LOG.info("Populated repartition tables in {} ms.", (Object)(System.currentTimeMillis() - startTime));
        }
        finally {
            RepartitionDataSourceHolder.closeQuietly(con);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void loadTable(Connection connection, String tableName, String tableResPath, boolean loadSchema) {
        if (!$assertionsDisabled) {
            if (tableName == null) throw new AssertionError();
            if (tableResPath == null) {
                throw new AssertionError();
            }
        }
        Integer updateCount = 0;
        InputStream in = RepartitionDataSourceHolder.class.getResourceAsStream(tableResPath);
        InputStreamReader isr = new InputStreamReader(in, Charset.forName("UTF-8"));
        CSVReader reader = new CSVReader((Reader)isr, ',', '\"');
        int lineNumber = 0;
        int colNumber = 0;
        Statement stmt = null;
        PreparedStatement insertStmt = null;
        int queryBufferSize = 2000;
        try {
            stmt = connection.createStatement();
            String[] tokens = reader.readNext();
            ++lineNumber;
            ColType[] colTypes = new ColType[tokens.length];
            StringBuilder schema = loadSchema ? new StringBuilder(2000) : null;
            StringBuilder insertTemplate = new StringBuilder(2000);
            insertTemplate.append("INSERT INTO ").append(tableName).append(" VALUES(");
            if (schema != null) {
                schema.append("CREATE TABLE ").append(tableName).append("(");
            }
            for (colNumber = 0; colNumber < tokens.length; ++colNumber) {
                String header = tokens[colNumber];
                if (colNumber != 0) {
                    insertTemplate.append(",");
                    if (schema != null) {
                        schema.append(",");
                    }
                }
                insertTemplate.append("?");
                if (schema != null) {
                    schema.append(header);
                }
                colTypes[colNumber] = ColType.parseColType(header);
            }
            if (schema != null) {
                schema.append(")");
                RepartitionDataSourceHolder.executeQuery(stmt, schema.toString());
            }
            insertTemplate.append(")");
            RepartitionDataSourceHolder.executeQuery(stmt, "DELETE FROM " + tableName);
            insertStmt = connection.prepareStatement(insertTemplate.toString());
            while ((tokens = reader.readNext()) != null) {
                ++lineNumber;
                for (colNumber = 0; colNumber < tokens.length; ++colNumber) {
                    Object value = RepartitionDataSourceHolder.unmarshall(tokens[colNumber], colTypes[colNumber]);
                    if (value != null) {
                        insertStmt.setObject(colNumber + 1, value);
                        continue;
                    }
                    insertStmt.setNull(colNumber + 1, 0);
                }
                updateCount = RepartitionDataSourceHolder.executeQuery(insertStmt, updateCount);
                insertStmt.clearParameters();
            }
            LOG.info("Table {} initialized (update count: {}).", (Object)tableName, updateCount != null ? updateCount : "unknown");
        }
        catch (IOException e) {
            try {
                throw new InternalFailureException("I/O failure while reading bundled resource.");
                catch (Exception e2) {
                    throw new InternalFailureException(String.format("Failed to parse bundled resource %s at position %d:%d: %s", tableResPath, lineNumber, colNumber, e2.getMessage()), e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((Closeable)reader);
                RepartitionDataSourceHolder.closeQuietly(stmt);
                RepartitionDataSourceHolder.closeQuietly(insertStmt);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)reader);
        RepartitionDataSourceHolder.closeQuietly(stmt);
        RepartitionDataSourceHolder.closeQuietly(insertStmt);
    }

    private static void closeQuietly(Statement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private static void closeQuietly(Connection con) {
        try {
            if (con != null) {
                con.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private static void executeQuery(Statement stmt, String sql) throws SQLException {
        int code = stmt.executeUpdate(sql);
        if (code == -3) {
            throw new IllegalArgumentException("Failed to execute query: " + sql);
        }
    }

    private static Integer executeQuery(PreparedStatement stmt, Integer updateCount) throws SQLException {
        int code = stmt.executeUpdate();
        switch (code) {
            case -3: {
                throw new IllegalArgumentException("Failed to execute prepared statement.");
            }
            case -2: {
                return null;
            }
        }
        return updateCount != null ? Integer.valueOf(updateCount + code) : null;
    }

    private static Object unmarshall(String text, ColType type) {
        if (text.isEmpty()) {
            if (type == ColType.BOOLEAN) {
                return false;
            }
            return null;
        }
        switch (type) {
            case BOOLEAN: {
                switch (text) {
                    case "V": 
                    case "X": {
                        return true;
                    }
                    case "F": {
                        return false;
                    }
                }
                throw new IllegalArgumentException("Not a boolean value: " + text);
            }
            case TEXT: {
                return text;
            }
            case NUMBER: {
                return Integer.valueOf(text);
            }
        }
        throw new AssertionError((Object)("Unknown enum member: " + type));
    }

    private static enum ColType {
        BOOLEAN,
        TEXT,
        NUMBER;


        private static ColType parseColType(String header) {
            if (header.contains("CHAR(1)")) {
                return BOOLEAN;
            }
            if (header.contains("VARCHAR")) {
                return TEXT;
            }
            if (header.contains("NUMBER")) {
                return NUMBER;
            }
            throw new AssertionError((Object)("Cannot parse header type: " + header));
        }
    }
}

