/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.presentation.common.imports;

import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.presentation.common.imports.ImportContext;
import ch.dvbern.tax.common.presentation.common.imports.ImportException;
import ch.dvbern.tax.common.presentation.common.imports.TaxFileImporter;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.ge.pp.utils.GeConstants;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeTaxFileImporter
extends TaxFileImporter {
    private static final Logger LOG = LoggerFactory.getLogger(GeTaxFileImporter.class);
    private static final Long TAX_YEAR_EXPECTED = ApplicationConfig.getInstance().getVorjahr();
    private static final Long TAX_YEAR_ACTUAL_YEAR = ApplicationConfig.getInstance().getJahr();
    private static final String TAX_YEAR_ERROR_CODE = "error.import.steuerjahr";
    private static final String IS_CD_KEY = "Stammdaten.IsOfflineSelected";
    private static final String ASSURANCE_VIE_TABLE_LMK = "Deductions.AssurancesVie.AssurancesVie";
    private static final String ASSURANCE_VIE_ECHANCE_LMK = "Deductions.AssurancesVie.AssurancesVie.AnneeEcheance";
    private boolean allowOpenCurrentYear = false;
    protected boolean currentYearImport;

    public GeTaxFileImporter(ImportContext ctx) {
        super(ctx);
    }

    public GeTaxFileImporter(ImportContext ctx, boolean allowOpenCurrentYear) {
        super(ctx);
        this.allowOpenCurrentYear = allowOpenCurrentYear;
    }

    protected void importOldModelItems() throws ImportException {
        this.setImportCurrentYear((ModelItemDTO)this.getImportContext().getOldDataModel().get("Stammdaten.Declaration.PeriodeTaxation"));
        super.importOldModelItems(this.isCurrentYearImport());
    }

    protected void setImportCurrentYear(ModelItemDTO taxYearItem) throws ImportException {
        if (TAX_YEAR_EXPECTED.equals(this.getTaxYear(taxYearItem))) {
            this.currentYearImport = false;
        } else if (TAX_YEAR_ACTUAL_YEAR.equals(this.getTaxYear(taxYearItem)) && this.allowOpenCurrentYear) {
            this.currentYearImport = true;
        } else {
            throw new ImportException(TAX_YEAR_ERROR_CODE);
        }
    }

    protected Long getTaxYear(ModelItemDTO taxYearItem) {
        Object value;
        Long taxYear = null;
        if (taxYearItem != null && (value = taxYearItem.getValue()) != null) {
            if (value instanceof Long) {
                taxYear = (Long)value;
            } else {
                try {
                    taxYear = Long.valueOf(value.toString());
                }
                catch (Exception e) {
                    LOG.warn("tax year conversion failed", (Throwable)e);
                }
            }
        }
        return taxYear;
    }

    protected void storeInNewModel(@NonNull String dmk, ModelItemDTO item) throws ImportException {
        String lmk = EngineUtil.removeTableIndices((String)dmk);
        item = this.importAssurancesVie(dmk, lmk, item);
        if (item != null) {
            if (IS_CD_KEY.equals(dmk)) {
                ModelItemDTO newValue = new ModelItemDTO((Object)Boolean.FALSE, 1);
                super.storeInNewModel(dmk, newValue);
            } else {
                super.storeInNewModel(dmk, item);
            }
        }
    }

    private ModelItemDTO importAssurancesVie(String dmk, String lmk, ModelItemDTO item) {
        if (item != null && lmk.startsWith(ASSURANCE_VIE_TABLE_LMK)) {
            Long echance;
            ModelItemDTO echanceItem = (ModelItemDTO)this.getImportContext().getOldDataModel().get(EngineUtil.mergeModelKey((String)ASSURANCE_VIE_ECHANCE_LMK, (String)dmk));
            Long l = echance = echanceItem != null ? (Long)echanceItem.getValue() : null;
            if (echance != null && echance >= TAX_YEAR_ACTUAL_YEAR) {
                return item;
            }
            return null;
        }
        return item;
    }

    public @NonNull ImportContext getImportContext() {
        return super.getImportContext();
    }

    public void doImport(@Nullable String password) throws ImportException {
        this.doImport(password, false);
    }

    public void doImport(@Nullable String password, boolean withDerivedValues) throws ImportException {
        if (withDerivedValues) {
            Map oldDataModel = this.getImportContext().getOldDataModel();
            HashMap<String, ModelItemDTO> derivedValues = new HashMap<String, ModelItemDTO>();
            HashMap<String, ModelItemDTO> doubledPkeyItems = new HashMap<String, ModelItemDTO>();
            for (Map.Entry entry : oldDataModel.entrySet()) {
                String dmk = this.findDoubledPKey(oldDataModel, (String)entry.getKey());
                if (dmk != null) {
                    ModelItemDTO newEntry = ((ModelItemDTO)entry.getValue()).cloneTouched();
                    doubledPkeyItems.put(dmk, newEntry);
                }
                this.processDerivedValues(dmk != null ? dmk : (String)entry.getKey(), (ModelItemDTO)entry.getValue(), derivedValues);
                ((ModelItemDTO)entry.getValue()).setTouched();
            }
            oldDataModel.putAll(doubledPkeyItems);
            oldDataModel.putAll(derivedValues);
        }
        this.filterTitre();
        this.filterDettesChrirographaires();
        this.filterRentes();
        this.filterPension();
        this.updateDateTypeDM();
        super.doImport(password);
    }

    private void updateDateTypeDM() {
        Map oldDataModel = this.getImportContext().getOldDataModel();
        HashMap<String, Date> listDateToUpdate = new HashMap<String, Date>();
        oldDataModel.entrySet().removeIf(entry -> {
            ModelItemDTO value = (ModelItemDTO)entry.getValue();
            if (this.keyShouldBefilter((String)entry.getKey(), value.toString())) {
                Date oldDate = (Date)value.getValue();
                if (oldDate != null) {
                    LocalDate newDate = oldDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().withYear(ApplicationConfig.getInstance().getJahr());
                    Date updatedDate = Date.from(newDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
                    listDateToUpdate.put((String)entry.getKey(), updatedDate);
                }
                return true;
            }
            return false;
        });
        listDateToUpdate.forEach((key, value) -> oldDataModel.put(key, new ModelItemDTO(value)));
    }

    private boolean keyShouldBefilter(String key, String value) {
        return !value.isEmpty() && key.startsWith("Titres.Divers.DiversTable") && (key.endsWith(".Date") || key.endsWith(".DateOperation")) || key.startsWith("Immeubles.") && key.endsWith(".Date");
    }

    private void filterDettesChrirographaires() {
        Map oldDataModel = this.getImportContext().getOldDataModel();
        ArrayList listDettesCbdt = new ArrayList();
        String typeDebtToRemove = "cbdt";
        oldDataModel.entrySet().stream().filter(entry -> typeDebtToRemove.equals(((ModelItemDTO)entry.getValue()).toString()) && ((String)entry.getKey()).endsWith("TypeDeDette")).forEach(entry -> {
            String subKey = ((String)entry.getKey()).substring(0, ((String)entry.getKey()).indexOf("TypeDeDette"));
            listDettesCbdt.add(subKey);
        });
        listDettesCbdt.forEach(key -> oldDataModel.entrySet().removeIf(entry -> ((String)entry.getKey()).startsWith((String)key)));
    }

    private void filterTitre() {
        Map oldDataModel = this.getImportContext().getOldDataModel();
        String titreToModify = "AUT";
        HashMap<String, String> updates = new HashMap<String, String>();
        oldDataModel.entrySet().removeIf(entry -> {
            String key = (String)entry.getKey();
            ModelItemDTO value = (ModelItemDTO)entry.getValue();
            if (titreToModify.equals(value.toString()) && key.endsWith("TypeDeFortune")) {
                String subKey = key.replace("TypeDeFortune", "Titres.TypeDeParticipation");
                if (oldDataModel.containsKey(subKey) && oldDataModel.get(subKey) != null && !((ModelItemDTO)oldDataModel.get(subKey)).getValue().toString().isEmpty()) {
                    updates.put(key, "PAR");
                } else {
                    updates.put(key, "CRY");
                }
                return true;
            }
            return false;
        });
        updates.forEach((key, value) -> oldDataModel.put(key, new ModelItemDTO(value)));
    }

    private void filterRentes() {
        Map oldDataModel = this.getImportContext().getOldDataModel();
        ArrayList listRenteEnfant = new ArrayList();
        oldDataModel.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("Revenu.RentesPensions.PensionsAlimentaires.") && ((String)entry.getKey()).endsWith(".NomPrenom") && !((ModelItemDTO)entry.getValue()).toString().isEmpty()).forEach(entry -> {
            String subKey = ((String)entry.getKey()).substring(0, ((String)entry.getKey()).indexOf("NomPrenom"));
            listRenteEnfant.add(subKey);
        });
        listRenteEnfant.forEach(key -> oldDataModel.entrySet().removeIf(entry -> ((String)entry.getKey()).startsWith((String)key)));
    }

    private void filterPension() {
        Map oldDataModel = this.getImportContext().getOldDataModel();
        ArrayList listPensionEnfant = new ArrayList();
        oldDataModel.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("Deductions.Pensions.Pensions.") && ((String)entry.getKey()).endsWith(".NomPrenom") && !((ModelItemDTO)entry.getValue()).toString().isEmpty()).forEach(entry -> {
            String subKey = ((String)entry.getKey()).substring(0, ((String)entry.getKey()).indexOf("NomPrenom"));
            listPensionEnfant.add(subKey);
        });
        listPensionEnfant.forEach(key -> oldDataModel.entrySet().removeIf(entry -> ((String)entry.getKey()).startsWith((String)key)));
    }

    private void processDerivedValues(String dmk, ModelItemDTO item, Map<String, ModelItemDTO> derivedValues) throws ImportException {
        String derivedLmk = (String)DerivedLMKMap.getDerivedLMK(EngineUtil.removeTableIndices((String)dmk));
        if (derivedLmk != null) {
            ModelItemDTO derivedItem = new ModelItemDTO(item.getValue());
            String derivedDmk = EngineUtil.mergeModelKey((String)derivedLmk, (String)dmk);
            derivedItem.setTouched();
            derivedValues.put(derivedDmk, derivedItem);
        }
        if ("Titres.Divers.DiversTable.RelevesFiscaux.Appartenance".equals(EngineUtil.removeTableIndices((String)dmk))) {
            String typeFortuneDMK = EngineUtil.mergeModelKey((String)"Titres.Divers.DiversTable.TypeDeFortune", (String)dmk);
            if (this.getImportContext().getOldDataModel().get(typeFortuneDMK) == null) {
                String typeTitre = GeConstants.TypeDeFortune.RF.name();
                ModelItemDTO typeItem = new ModelItemDTO((Object)typeTitre);
                typeItem.setTouched();
                derivedValues.put(typeFortuneDMK, typeItem);
            }
        }
    }

    private @Nullable String findDoubledPKey(Map<String, ModelItemDTO> oldData, String dmk) {
        String lmk = EngineUtil.removeTableIndices((String)dmk);
        String erfTypeFortuneDmk = EngineUtil.mergeModelKey((String)"Titres.Divers.DiversTable.EReleves.TypeDeFortuneBarcode", (String)dmk);
        ModelItemDTO erfTypeFortuneDTO = oldData.get(erfTypeFortuneDmk);
        if (erfTypeFortuneDTO == null) {
            return null;
        }
        lmk = erfTypeFortuneDTO.getValue() != null && !erfTypeFortuneDTO.getValue().equals(GeConstants.TypeDeFortune.ERF.name()) ? (String)DoubledPkeyMap.getTitreLMK(lmk) : (String)DoubledPkeyMap.getEReleveLMK(lmk);
        return lmk == null ? null : EngineUtil.mergeModelKey((String)lmk, (String)dmk);
    }

    public boolean isCurrentYearImport() {
        return this.currentYearImport;
    }

    static final class DerivedLMKMap {
        private static final ImmutableMap<Object, Object> DERIVED_LMK_MAP = ImmutableMap.builder().put((Object)"Titres.Divers.DiversTable.Comptes.TypeDeFortuneBarcode", (Object)"Titres.Divers.DiversTable.TypeDeFortune").put((Object)"Titres.Divers.DiversTable.Titres.TypeDeFortuneBarcode", (Object)"Titres.Divers.DiversTable.TypeDeFortune").put((Object)"Titres.Divers.DiversTable.EReleves.TypeDeFortuneBarcode", (Object)"Titres.Divers.DiversTable.TypeDeFortune").put((Object)"Titres.Divers.DiversTable.RelevesFiscaux.TypeDeFortuneBarcode", (Object)"Titres.Divers.DiversTable.TypeDeFortune").put((Object)"Titres.Divers.DiversTable.EReleves.GroupNoPrint", (Object)"Titres.Divers.DiversTable.EReleves.GroupNo").put((Object)"Titres.Divers.DiversTable.Comptes.RevenusAvecIA", (Object)"Titres.Divers.DiversTable.Comptes.RevenusAvecIAInput").put((Object)"Titres.Divers.DiversTable.Comptes.RevenusSansIA", (Object)"Titres.Divers.DiversTable.Comptes.RevenusSansIAInput").put((Object)"Titres.Divers.DiversTable.Comptes.FortuneImposable", (Object)"Titres.Divers.DiversTable.Comptes.FortuneImposableInput").put((Object)"Titres.Divers.DiversTable.Comptes.InteretsEchus", (Object)"Titres.Divers.DiversTable.Comptes.InteretsEchusInput").put((Object)"Titres.Divers.DiversTable.Comptes.InteretsDebiteurValue", (Object)"Titres.Divers.DiversTable.Comptes.InteretsDebiteurValueInput").put((Object)"Titres.Divers.DiversTable.Comptes.SoldeDebiteurValue", (Object)"Titres.Divers.DiversTable.Comptes.SoldeDebiteurValueInput").put((Object)"Titres.Divers.DiversTable.Titres.RevenusAvecIA", (Object)"Titres.Divers.DiversTable.Titres.RevenusAvecIAInput").put((Object)"Titres.Divers.DiversTable.Titres.RevenusSansIA", (Object)"Titres.Divers.DiversTable.Titres.RevenusSansIAInput").put((Object)"Titres.Divers.DiversTable.Titres.FortuneImposable", (Object)"Titres.Divers.DiversTable.Titres.FortuneImposableInput").put((Object)"Titres.Divers.DiversTable.Titres.InteretsEchus", (Object)"Titres.Divers.DiversTable.Titres.InteretsEchusInput").put((Object)"Titres.Divers.DiversTable.EReleves.FraisBancaires", (Object)"Titres.Divers.DiversTable.EReleves.FraisBancairesInput").put((Object)"Titres.Divers.DiversTable.EReleves.PourcentagePossessionPrint", (Object)"Titres.Divers.DiversTable.EReleves.PourcentagePossession").put((Object)"Titres.Divers.DiversTable.EReleves.AvoirCommerciauxCheckPrint", (Object)"Titres.Divers.DiversTable.EReleves.AvoirCommerciauxCheck").build();

        private DerivedLMKMap() {
        }

        public static @Nullable Object getDerivedLMK(@NonNull String lmk) {
            return DERIVED_LMK_MAP.get((Object)lmk);
        }
    }

    static final class DoubledPkeyMap {
        private static final ImmutableBiMap<Object, Object> DOUBLED_PKEY_MAP = ImmutableBiMap.builder().put((Object)"Titres.Divers.DiversTable.EReleves.TypeDeFortuneBarcode", (Object)"Titres.Divers.DiversTable.Titres.TypeDeFortuneBarcode").put((Object)"Titres.Divers.DiversTable.EReleves.Appartenance", (Object)"Titres.Divers.DiversTable.Titres.Appartenance").put((Object)"Titres.Divers.DiversTable.EReleves.Designation", (Object)"Titres.Divers.DiversTable.Titres.Designation").put((Object)"Titres.Divers.DiversTable.EReleves.GroupNoPrint", (Object)"Titres.Divers.DiversTable.Titres.GroupNo").put((Object)"Titres.Divers.DiversTable.EReleves.NoDepot", (Object)"Titres.Divers.DiversTable.Titres.NoValeur").build();

        private DoubledPkeyMap() {
        }

        public static @Nullable Object getTitreLMK(@NonNull String erfLmk) {
            return DOUBLED_PKEY_MAP.get((Object)erfLmk);
        }

        public static @Nullable Object getEReleveLMK(String titreLmk) {
            return DOUBLED_PKEY_MAP.inverse().get((Object)titreLmk);
        }
    }
}

