/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.justificatifs;

import ch.dvbern.tax.ge.pp.justificatifs.Category;
import ch.dvbern.tax.ge.pp.justificatifs.Justificatif;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CategoryTreeEntry
implements Serializable {
    private static final long serialVersionUID = 6051526585911044435L;
    @Nonnull
    private final Category category;
    @Nonnull
    private final Set<CategoryTreeEntry> children;
    @Nonnull
    private final Set<Justificatif> justificatifs;
    @Nonnull
    private static final Set<CategoryTreeEntry> ROOT;

    @Nonnull
    private static LinkedHashSet<Justificatif> findJustificatifs(@Nonnull Category category) {
        LinkedHashSet<Justificatif> justificatifs = new LinkedHashSet<Justificatif>();
        for (Justificatif justificatif : Justificatif.values()) {
            if (justificatif.getCategory() != category) continue;
            justificatifs.add(justificatif);
        }
        return justificatifs;
    }

    private CategoryTreeEntry(@Nonnull Category category, CategoryTreeEntry ... children) {
        this.category = category;
        LinkedHashSet<CategoryTreeEntry> c = new LinkedHashSet<CategoryTreeEntry>();
        c.addAll(Arrays.asList(children));
        this.children = c;
        this.justificatifs = Collections.unmodifiableSet(CategoryTreeEntry.findJustificatifs(category));
    }

    @Nonnull
    public static Set<CategoryTreeEntry> getCategoryTree() {
        return ROOT;
    }

    @Nonnull
    public Category getCategory() {
        return this.category;
    }

    @Nonnull
    public Set<CategoryTreeEntry> getChildren() {
        return this.children;
    }

    @Nonnull
    public Set<Justificatif> getJustificatifs() {
        return this.justificatifs;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CategoryTreeEntry)) {
            return false;
        }
        CategoryTreeEntry that = (CategoryTreeEntry)o;
        return this.category == that.category;
    }

    public int hashCode() {
        return this.category.hashCode();
    }

    static {
        LinkedHashSet<CategoryTreeEntry> rootCategories = new LinkedHashSet<CategoryTreeEntry>();
        rootCategories.add(new CategoryTreeEntry(Category.TITRES, new CategoryTreeEntry[0]));
        rootCategories.add(new CategoryTreeEntry(Category.INDEPENDANT, new CategoryTreeEntry[0]));
        rootCategories.add(new CategoryTreeEntry(Category.IMMOBILIER, new CategoryTreeEntry[0]));
        rootCategories.add(new CategoryTreeEntry(Category.AUTRES, new CategoryTreeEntry(Category.REVENU_DEPENDANT, new CategoryTreeEntry[0]), new CategoryTreeEntry(Category.AUTRES_REVENUS_FORTUNES, new CategoryTreeEntry[0]), new CategoryTreeEntry(Category.INTERES_DETTES, new CategoryTreeEntry[0])));
        ROOT = Collections.unmodifiableSet(rootCategories);
    }
}

